/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.transform;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.SingleCellIndexIT;
import org.apache.phoenix.end2end.transform.TransformMonitorIT;
import org.apache.phoenix.end2end.transform.TransformToolIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.InstanceResolver;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class TransformMonitorExtendedIT
extends BaseTest {
    private static RegionCoprocessorEnvironment taskRegionEnvironment;
    protected String dataTableDdl = "";
    private Properties propsNamespace = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        TransformMonitorExtendedIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return new Configuration(config);
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(config);
                copy.addResource(confToClone);
                return copy;
            }
        });
    }

    public TransformMonitorExtendedIT() throws IOException, InterruptedException {
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" COLUMN_ENCODED_BYTES=0,IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN");
        this.dataTableDdl = optionBuilder.toString();
        this.propsNamespace.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        TableName taskTable = TableName.valueOf((String)"SYSTEM:TASK");
        taskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)TransformMonitorExtendedIT.getUtility().getRSForFirstRegionInTable(taskTable).getRegions(taskTable).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    @Before
    public void setupTest() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME);
            conn.createStatement().execute("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
        }
    }

    @Test
    public void testTransformIndexWithNamespaceEnabled() throws Exception {
        String schemaName = "S_" + TransformMonitorExtendedIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorExtendedIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexName = "IDX_" + TransformMonitorExtendedIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        String createIndexStmt = "CREATE INDEX %s ON " + fullDataTableName + " (NAME) INCLUDE (ZIP) ";
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            TransformToolIT.createTableAndUpsertRows(conn, fullDataTableName, numOfRows, this.dataTableDdl);
            conn.createStatement().execute(String.format(createIndexStmt, indexName));
            Assert.assertEquals((long)numOfRows, (long)TransformMonitorIT.countRows(conn, fullIndexName));
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullIndexName);
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + fullDataTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)indexName, (String)fullDataTableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            TransformToolIT.upsertRows(conn, fullDataTableName, 2, 1);
            ResultSet rs = conn.createStatement().executeQuery("SELECT \":ID\", \"0:ZIP\" FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)95051L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((long)95052L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTransformTableWithNamespaceEnabled() throws Exception {
        String schemaName = "S_" + TransformMonitorExtendedIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorExtendedIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            TransformToolIT.createTableAndUpsertRows(conn, fullDataTableName, numOfRows, this.dataTableDdl);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullDataTableName);
            conn.createStatement().execute("ALTER TABLE " + fullDataTableName + " SET COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            TransformToolIT.upsertRows(conn, fullDataTableName, 2, 1);
            Assert.assertEquals((long)(numOfRows + 1), (long)TransformMonitorIT.countRows(conn, fullDataTableName));
            ResultSet rs = conn.createStatement().executeQuery("SELECT ID, ZIP FROM " + fullDataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)95051L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((long)95052L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTransformImmutableTableWithNamespaceEnabled() throws Exception {
        String schemaName = "S_" + TransformMonitorExtendedIT.generateUniqueName();
        String dataTableName = "TBL_" + TransformMonitorExtendedIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        this.dataTableDdl = this.dataTableDdl + ", IMMUTABLE_ROWS=true";
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            TransformToolIT.createTableAndUpsertRows(conn, fullDataTableName, numOfRows, this.dataTableDdl);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullDataTableName);
            conn.createStatement().execute("ALTER TABLE " + fullDataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            TransformToolIT.upsertRows(conn, fullDataTableName, 2, 1);
            Assert.assertEquals((long)(numOfRows + 1), (long)TransformMonitorIT.countRows(conn, fullDataTableName));
            ResultSet rs = conn.createStatement().executeQuery("SELECT ID, ZIP FROM " + fullDataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((long)95051L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"2", (Object)rs.getString(1));
            Assert.assertEquals((long)95052L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testTransformWithGlobalAndTenantViews() throws Exception {
        Object stmt1;
        String schemaName = TransformMonitorExtendedIT.generateUniqueName();
        String dataTableName1 = TransformMonitorExtendedIT.generateUniqueName();
        String dataTableFullName1 = SchemaUtil.getTableName((String)schemaName, (String)dataTableName1);
        String namespaceMappedDataTableName1 = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)dataTableName1, (boolean)true).getString();
        String view1Name = SchemaUtil.getTableName((String)schemaName, (String)("VW1_" + TransformMonitorExtendedIT.generateUniqueName()));
        String view2Name = SchemaUtil.getTableName((String)schemaName, (String)("VW2_" + TransformMonitorExtendedIT.generateUniqueName()));
        String tenantView = SchemaUtil.getTableName((String)schemaName, (String)("VWT_" + TransformMonitorExtendedIT.generateUniqueName()));
        String readOnlyTenantView = SchemaUtil.getTableName((String)schemaName, (String)("ROVWT_" + TransformMonitorExtendedIT.generateUniqueName()));
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName1, numOfRows, "TABLE_ONLY", this.dataTableDdl);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName1);
            String createViewSql = "CREATE VIEW " + view1Name + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='GLOBAL_VIEW' ";
            conn.createStatement().execute(createViewSql);
            stmt1 = conn.prepareStatement(String.format("UPSERT INTO %s VALUES(?, ? , ?, ?, ?,?)", view1Name));
            stmt1.setInt(1, 2);
            stmt1.setString(2, "uname2");
            stmt1.setInt(3, 95053);
            stmt1.setString(4, "GLOBAL_VIEW");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewcol2");
            stmt1.executeUpdate();
            createViewSql = "CREATE VIEW " + view2Name + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='GLOBAL_VIEW' AND ZIP=95053";
            conn.createStatement().execute(createViewSql);
            stmt1 = conn.prepareStatement(String.format("UPSERT INTO %s VALUES(?, ? , ?, ?, ?,?)", view1Name));
            stmt1.setInt(1, 20);
            stmt1.setString(2, "uname22");
            stmt1.setInt(3, 95053);
            stmt1.setString(4, "GLOBAL_VIEW");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewcol22");
            stmt1.executeUpdate();
        }
        var10_10 = null;
        try (Connection tenantConn1 = TransformToolIT.getTenantConnection("tenant1");){
            tenantConn1.setAutoCommit(true);
            String createViewSql = "CREATE VIEW " + tenantView + " ( VIEW_TCOL1 INTEGER, VIEW_TCOL2 VARCHAR )  AS SELECT * FROM " + dataTableFullName1 + " where DATA='TENANT_VIEW'";
            tenantConn1.createStatement().execute(createViewSql);
            PreparedStatement stmt12 = tenantConn1.prepareStatement(String.format("UPSERT INTO %s (ID, NAME, ZIP, DATA, VIEW_TCOL1, VIEW_TCOL2) VALUES(?, ? , ?, ?, ?, ?)", tenantView));
            stmt12.setInt(1, 4);
            stmt12.setString(2, "uname4");
            stmt12.setInt(3, 95054);
            stmt12.setString(4, "TENANT_VIEW");
            stmt12.setInt(5, 2001);
            stmt12.setString(6, "tenantviewcol");
            stmt12.executeUpdate();
            createViewSql = "CREATE VIEW " + readOnlyTenantView + " ( VIEW_TCOL1 INTEGER, VIEW_TCOL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='TENANT_VIEW' AND ZIP > 95050";
            tenantConn1.createStatement().execute(createViewSql);
        }
        catch (Throwable createViewSql) {
            var10_10 = createViewSql;
            throw createViewSql;
        }
        conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);
        var10_10 = null;
        try {
            conn.setAutoCommit(true);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName1 + " SET COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName1, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorExtendedIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            stmt1 = null;
            try {
                admin.disableTable(TableName.valueOf((String)namespaceMappedDataTableName1));
                admin.truncateTable(TableName.valueOf((String)namespaceMappedDataTableName1), true);
            }
            catch (Throwable throwable) {
                stmt1 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (stmt1 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)stmt1).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
            SingleCellIndexIT.dumpTable(schemaName + ":" + dataTableName1 + "_1");
            String sql = "SELECT VIEW_COL1, VIEW_COL2 FROM %s WHERE DATA='GLOBAL_VIEW' ";
            ResultSet rs1 = conn.createStatement().executeQuery(String.format(sql, view1Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewcol2", (Object)rs1.getString(2));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"viewcol22", (Object)rs1.getString(2));
            Assert.assertFalse((boolean)rs1.next());
            rs1 = conn.createStatement().executeQuery(String.format(sql, view2Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewcol2", (Object)rs1.getString(2));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"viewcol22", (Object)rs1.getString(2));
            Assert.assertFalse((boolean)rs1.next());
            sql = "SELECT DATA FROM %s WHERE ID=1";
            rs1 = conn.createStatement().executeQuery(String.format(sql, dataTableFullName1));
            Assert.assertFalse((boolean)rs1.next());
        }
        catch (Throwable record) {
            var10_10 = record;
            throw record;
        }
        finally {
            if (conn != null) {
                if (var10_10 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable record) {
                        var10_10.addSuppressed(record);
                    }
                } else {
                    conn.close();
                }
            }
        }
        tenantConn1 = TransformToolIT.getTenantConnection("tenant1");
        var10_10 = null;
        try {
            String sql = "SELECT VIEW_TCOL1, VIEW_TCOL2 FROM %s ";
            ResultSet rs1 = tenantConn1.createStatement().executeQuery(String.format(sql, tenantView));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)2001L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"tenantviewcol", (Object)rs1.getString(2));
            ResultSet rs2 = tenantConn1.createStatement().executeQuery(String.format(sql, readOnlyTenantView));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((long)2001L, (long)rs2.getInt(1));
            Assert.assertEquals((Object)"tenantviewcol", (Object)rs2.getString(2));
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (tenantConn1 != null) {
                if (var10_10 != null) {
                    try {
                        tenantConn1.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    tenantConn1.close();
                }
            }
        }
    }

    @Test
    public void testTransformWithGlobalAndTenantViewsImmutable() throws Exception {
        Object stmt1;
        String schemaName = TransformMonitorExtendedIT.generateUniqueName();
        String dataTableName1 = TransformMonitorExtendedIT.generateUniqueName();
        String dataTableFullName1 = SchemaUtil.getTableName((String)schemaName, (String)dataTableName1);
        String namespaceMappedDataTableName1 = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)dataTableName1, (boolean)true).getString();
        String view1Name = SchemaUtil.getTableName((String)schemaName, (String)("VW1_" + TransformMonitorExtendedIT.generateUniqueName()));
        String view2Name = SchemaUtil.getTableName((String)schemaName, (String)("VW2_" + TransformMonitorExtendedIT.generateUniqueName()));
        String tenantView = SchemaUtil.getTableName((String)schemaName, (String)("VWT_" + TransformMonitorExtendedIT.generateUniqueName()));
        String readOnlyTenantView = SchemaUtil.getTableName((String)schemaName, (String)("ROVWT_" + TransformMonitorExtendedIT.generateUniqueName()));
        this.dataTableDdl = this.dataTableDdl + ", IMMUTABLE_ROWS=true";
        try (Connection conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
            TransformToolIT.createTableAndUpsertRows(conn, dataTableFullName1, numOfRows, "TABLE_ONLY", this.dataTableDdl);
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableFullName1);
            String createViewSql = "CREATE VIEW " + view1Name + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='GLOBAL_VIEW' ";
            conn.createStatement().execute(createViewSql);
            stmt1 = conn.prepareStatement(String.format("UPSERT INTO %s VALUES(?, ? , ?, ?, ?,?)", view1Name));
            stmt1.setInt(1, 2);
            stmt1.setString(2, "uname2");
            stmt1.setInt(3, 95053);
            stmt1.setString(4, "GLOBAL_VIEW");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewcol2");
            stmt1.executeUpdate();
            createViewSql = "CREATE VIEW " + view2Name + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='GLOBAL_VIEW' AND ZIP=95053";
            conn.createStatement().execute(createViewSql);
            stmt1 = conn.prepareStatement(String.format("UPSERT INTO %s VALUES(?, ? , ?, ?, ?,?)", view1Name));
            stmt1.setInt(1, 20);
            stmt1.setString(2, "uname22");
            stmt1.setInt(3, 95053);
            stmt1.setString(4, "GLOBAL_VIEW");
            stmt1.setInt(5, 111);
            stmt1.setString(6, "viewcol22");
            stmt1.executeUpdate();
        }
        var10_10 = null;
        try (Connection tenantConn1 = TransformToolIT.getTenantConnection("tenant1");){
            tenantConn1.setAutoCommit(true);
            String createViewSql = "CREATE VIEW " + tenantView + " ( VIEW_TCOL1 INTEGER, VIEW_TCOL2 VARCHAR )  AS SELECT * FROM " + dataTableFullName1 + " where DATA='TENANT_VIEW'";
            tenantConn1.createStatement().execute(createViewSql);
            PreparedStatement stmt12 = tenantConn1.prepareStatement(String.format("UPSERT INTO %s (ID, NAME, ZIP, DATA, VIEW_TCOL1, VIEW_TCOL2) VALUES(?, ? , ?, ?, ?, ?)", tenantView));
            stmt12.setInt(1, 4);
            stmt12.setString(2, "uname4");
            stmt12.setInt(3, 95054);
            stmt12.setString(4, "TENANT_VIEW");
            stmt12.setInt(5, 2001);
            stmt12.setString(6, "tenantviewcol");
            stmt12.executeUpdate();
            createViewSql = "CREATE VIEW " + readOnlyTenantView + " ( VIEW_TCOL1 INTEGER, VIEW_TCOL2 VARCHAR ) AS SELECT * FROM " + dataTableFullName1 + " where DATA='TENANT_VIEW' AND ZIP > 95050";
            tenantConn1.createStatement().execute(createViewSql);
        }
        catch (Throwable createViewSql) {
            var10_10 = createViewSql;
            throw createViewSql;
        }
        conn = DriverManager.getConnection(TransformMonitorExtendedIT.getUrl(), this.propsNamespace);
        var10_10 = null;
        try {
            conn.setAutoCommit(true);
            conn.createStatement().execute("ALTER TABLE " + dataTableFullName1 + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schemaName, (String)dataTableName1, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformMonitorIT.waitForTransformToGetToState(conn.unwrap(PhoenixConnection.class), record, PTable.TransformStatus.COMPLETED);
            TransformMonitorExtendedIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
            stmt1 = null;
            try {
                admin.disableTable(TableName.valueOf((String)namespaceMappedDataTableName1));
                admin.truncateTable(TableName.valueOf((String)namespaceMappedDataTableName1), true);
            }
            catch (Throwable throwable) {
                stmt1 = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (stmt1 != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)stmt1).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
            SingleCellIndexIT.dumpTable(schemaName + ":" + dataTableName1 + "_1");
            String sql = "SELECT VIEW_COL1, VIEW_COL2 FROM %s WHERE DATA='GLOBAL_VIEW' ";
            ResultSet rs1 = conn.createStatement().executeQuery(String.format(sql, view1Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewcol2", (Object)rs1.getString(2));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"viewcol22", (Object)rs1.getString(2));
            Assert.assertFalse((boolean)rs1.next());
            rs1 = conn.createStatement().executeQuery(String.format(sql, view2Name));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)111L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"viewcol2", (Object)rs1.getString(2));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"viewcol22", (Object)rs1.getString(2));
            Assert.assertFalse((boolean)rs1.next());
            sql = "SELECT DATA FROM %s WHERE ID=1";
            rs1 = conn.createStatement().executeQuery(String.format(sql, dataTableFullName1));
            Assert.assertFalse((boolean)rs1.next());
        }
        catch (Throwable record) {
            var10_10 = record;
            throw record;
        }
        finally {
            if (conn != null) {
                if (var10_10 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable record) {
                        var10_10.addSuppressed(record);
                    }
                } else {
                    conn.close();
                }
            }
        }
        tenantConn1 = TransformToolIT.getTenantConnection("tenant1");
        var10_10 = null;
        try {
            String sql = "SELECT VIEW_TCOL1, VIEW_TCOL2 FROM %s ";
            ResultSet rs1 = tenantConn1.createStatement().executeQuery(String.format(sql, tenantView));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((long)2001L, (long)rs1.getInt(1));
            Assert.assertEquals((Object)"tenantviewcol", (Object)rs1.getString(2));
            ResultSet rs2 = tenantConn1.createStatement().executeQuery(String.format(sql, readOnlyTenantView));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((long)2001L, (long)rs2.getInt(1));
            Assert.assertEquals((Object)"tenantviewcol", (Object)rs2.getString(2));
        }
        catch (Throwable throwable) {
            var10_10 = throwable;
            throw throwable;
        }
        finally {
            if (tenantConn1 != null) {
                if (var10_10 != null) {
                    try {
                        tenantConn1.close();
                    }
                    catch (Throwable throwable) {
                        var10_10.addSuppressed(throwable);
                    }
                } else {
                    tenantConn1.close();
                }
            }
        }
    }
}

