/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.transform;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.index.SingleCellIndexIT;
import org.apache.phoenix.end2end.transform.TransformToolIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.transform.SystemTransformRecord;
import org.apache.phoenix.schema.transform.Transform;
import org.apache.phoenix.thirdparty.com.google.common.base.Strings;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TransformIT
extends ParallelStatsDisabledIT {
    private Properties testProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);

    public TransformIT() {
        this.testProps.put("phoenix.default.immutable.storage.scheme", "ONE_CELL_PER_COLUMN");
        this.testProps.put("phoenix.default.column.encoded.bytes.attrib", "0");
        this.testProps.put("phoenix.transform.monitor.enabled", Boolean.toString(false));
    }

    @Before
    public void setupTest() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("DELETE FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME);
        }
    }

    @Test
    public void testSystemTransformTablePopulatedForIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String idxName = "IND_" + TransformIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER, V4 VARCHAR, V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            String createIndexSql = "CREATE INDEX " + idxName + " ON " + tableName + " (PK1, INT_PK) include (V1,V2,V4) ";
            conn.createStatement().execute(createIndexSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, idxName);
            this.assertSystemTransform(conn, 0, null, idxName, null);
            conn.createStatement().execute("ALTER INDEX " + idxName + " ON " + tableName + " ACTIVE ");
            this.assertSystemTransform(conn, 0, null, idxName, null);
            conn.createStatement().execute("ALTER INDEX " + idxName + " ON " + tableName + " ACTIVE  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            this.assertSystemTransform(conn, 1, null, idxName, null);
            try {
                conn.createStatement().execute("ALTER INDEX " + idxName + " ON " + tableName + " ACTIVE  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"This transform needs to fail");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_ALREADY_TRANSFORMING_TABLE.getErrorCode(), (long)ex.getErrorCode());
            }
            this.assertSystemTransform(conn, 1, null, idxName, null);
            String idxName2 = "IND2_" + TransformIT.generateUniqueName();
            conn.createStatement().execute("CREATE INDEX " + idxName2 + " ON " + tableName + " (V2) include (V1) ");
            conn.createStatement().execute("ALTER INDEX " + idxName2 + " ON " + tableName + " ACTIVE COLUMN_ENCODED_BYTES=4");
            this.assertSystemTransform(conn, 2, null, idxName2, null);
        }
    }

    @Test
    public void testSystemTransformTablePopulatedForTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + tableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER, V4 VARCHAR, V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, tableName);
            this.assertSystemTransform(conn, 0, null, tableName, null);
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET TTL=300");
            this.assertSystemTransform(conn, 0, null, tableName, null);
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS");
                Assert.fail((String)"IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=0 is not compatible");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=0");
                Assert.fail((String)"IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=0 is not compatible");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.INVALID_IMMUTABLE_STORAGE_SCHEME_AND_COLUMN_QUALIFIER_BYTES.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("ALTER TABLE " + tableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            this.assertSystemTransform(conn, 1, null, tableName, null);
            try {
                conn.createStatement().execute("ALTER TABLE " + tableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"Transform should fail");
            }
            catch (SQLException ex) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_ALREADY_TRANSFORMING_TABLE.getErrorCode(), (long)ex.getErrorCode());
            }
            this.assertSystemTransform(conn, 1, null, tableName, null);
            String tableName2 = "TBL_" + TransformIT.generateUniqueName();
            createTableSql = "CREATE TABLE " + tableName2 + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER, V4 VARCHAR, V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            conn.createStatement().execute("ALTER TABLE " + tableName2 + " SET COLUMN_ENCODED_BYTES=4");
            this.assertSystemTransform(conn, 2, null, tableName2, null);
        }
    }

    @Test
    public void testTransformFailsForViewIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String viewName = "VW_" + TransformIT.generateUniqueName();
            String viewIdxName = "VWIDX_" + TransformIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullTableName);
            String createViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(createViewSql);
            String createViewIdxSql = "CREATE INDEX " + viewIdxName + " ON " + viewName + " (VIEW_COL1) include (VIEW_COL2) ";
            conn.createStatement().execute(createViewIdxSql);
            try {
                conn.createStatement().execute("ALTER INDEX " + viewIdxName + " ON " + viewName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_LOCAL_OR_VIEW_INDEX.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testTransform_tableWithLocalIndex() throws Exception {
        String dataTableName = "TBL_" + TransformIT.generateUniqueName();
        String indexName = "LCLIDX_" + TransformIT.generateUniqueName();
        String createIndexStmt = "CREATE LOCAL INDEX %s ON " + dataTableName + " (NAME) INCLUDE (ZIP) ";
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            int numOfRows = 1;
            TransformToolIT.createTableAndUpsertRows(conn, dataTableName, numOfRows, "");
            conn.createStatement().execute(String.format(createIndexStmt, indexName));
            SingleCellIndexIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, dataTableName);
            try {
                conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + dataTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"Cannot transform local index");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_LOCAL_OR_VIEW_INDEX.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + dataTableName + " SET IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"Cannot transform table with local index");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_TRANSFORM_TABLE_WITH_LOCAL_INDEX.getErrorCode(), (long)e.getErrorCode());
            }
        }
    }

    @Test
    public void testTransformForLiveMutations_mutatingImmutableTable() throws Exception {
        this.testTransformForLiveMutations_mutatingTable(" IMMUTABLE_ROWS=TRUE");
    }

    @Test
    public void testTransformForLiveMutations_mutatingMutableTable() throws Exception {
        this.testTransformForLiveMutations_mutatingTable("");
    }

    private void testTransformForLiveMutations_mutatingTable(String tableDDL) throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String idxName = "IND_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String fullIdxName = SchemaUtil.getTableName((String)schema, (String)idxName);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) " + tableDDL;
            conn.createStatement().execute(createTableSql);
            String upsertStmt = "UPSERT INTO " + fullTableName + " (PK1, INT_PK, V1, V2) VALUES ('%s', %d, '%s', %d)";
            conn.createStatement().execute(String.format(upsertStmt, "a", 1, "val1", 1));
            String createIndexSql = "CREATE INDEX " + idxName + " ON " + fullTableName + " (PK1, INT_PK) include (V1) ASYNC";
            conn.createStatement().execute(createIndexSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullTableName);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullIdxName);
            String idxName2 = "IND2_" + TransformIT.generateUniqueName();
            String fullIdxName2 = SchemaUtil.getTableName((String)schema, (String)idxName2);
            conn.createStatement().execute("CREATE INDEX " + idxName2 + " ON " + fullTableName + " (V1) include (V2) ASYNC");
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, fullIdxName));
            Assert.assertEquals((long)0L, (long)TestUtil.getRowCount(conn, fullIdxName2));
            conn.createStatement().execute(String.format(upsertStmt, "b", 2, "val2", 2));
            conn.commit();
            conn.createStatement().execute(String.format(upsertStmt, "c", 3, "val3", 3));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullIdxName));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullIdxName2));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE PK1='b'");
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIdxName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIdxName2));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
        }
    }

    @Test
    public void testTransformForLiveMutations_mutatingBaseTableNoIndex() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullTableName);
            String upsertStmt = "UPSERT INTO " + fullTableName + " (PK1, INT_PK, V1, V2) VALUES ('%s', %d, '%s', %d)";
            conn.createStatement().execute(String.format(upsertStmt, "a", 1, "val1", 1));
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            conn.createStatement().execute(String.format(upsertStmt, "b", 2, "val2", 2));
            conn.commit();
            conn.createStatement().execute(String.format(upsertStmt, "c", 3, "val3", 3));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE PK1='b'");
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
        }
    }

    @Test
    public void testTransformForLiveMutations_mutatingMutableIndex() throws Exception {
        this.testTransformForLiveMutations_mutatingIndex("");
    }

    @Test
    public void testTransformForLiveMutations_mutatingImmutableIndex() throws Exception {
        this.testTransformForLiveMutations_mutatingIndex(" IMMUTABLE_ROWS=true");
    }

    private void testTransformForLiveMutations_mutatingIndex(String tableDDL) throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String idxName = "IND_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String fullIdxName = SchemaUtil.getTableName((String)schema, (String)idxName);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) " + tableDDL;
            conn.createStatement().execute(createTableSql);
            String createIndexSql = "CREATE INDEX " + idxName + " ON " + fullTableName + " (PK1, INT_PK) include (V1) ASYNC";
            conn.createStatement().execute(createIndexSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullIdxName);
            conn.createStatement().execute("ALTER INDEX " + idxName + " ON " + fullTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)idxName, (String)fullTableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            String upsertStmt = "UPSERT INTO " + fullTableName + " (PK1, INT_PK, V1, V2) VALUES ('%s', %d, '%s', %d)";
            conn.createStatement().execute(String.format(upsertStmt, "b", 2, "val2", 2));
            conn.createStatement().execute(String.format(upsertStmt, "c", 3, "val3", 3));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, fullIdxName));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            conn.createStatement().execute("DELETE FROM " + fullTableName + " WHERE PK1='b'");
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, fullIdxName));
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
        }
    }

    @Test
    public void testTransformForLiveMutations_mutatingMutableBaseTableForView() throws Exception {
        this.testTransformForLiveMutations_mutatingBaseTableForView("");
    }

    @Test
    public void testTransformForLiveMutations_mutatingImmutableBaseTableForView() throws Exception {
        this.testTransformForLiveMutations_mutatingBaseTableForView(" IMMUTABLE_ROWS=true");
    }

    private void testTransformForLiveMutations_mutatingBaseTableForView(String tableDDL) throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String parentViewName = "VWP_" + TransformIT.generateUniqueName();
            String viewName = "VW_" + TransformIT.generateUniqueName();
            String viewIdxName = "VWIDX_" + TransformIT.generateUniqueName();
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) " + tableDDL;
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullTableName);
            String createParentViewSql = "CREATE VIEW " + parentViewName + " ( PARENT_VIEW_COL1 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(createParentViewSql);
            String createViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 INTEGER, VIEW_COL2 VARCHAR ) AS SELECT * FROM " + parentViewName;
            conn.createStatement().execute(createViewSql);
            String createViewIdxSql = "CREATE INDEX " + viewIdxName + " ON " + viewName + " (VIEW_COL1) include (VIEW_COL2) ";
            conn.createStatement().execute(createViewIdxSql);
            String upsertStmt = "UPSERT INTO " + viewName + " (PK1, INT_PK, V1, VIEW_COL1, VIEW_COL2) VALUES ('%s', %d, '%s', %d, '%s')";
            conn.createStatement().execute(String.format(upsertStmt, "a", 1, "val1", 1, "col2_1"));
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, record.getNewPhysicalTableName());
            conn.createStatement().execute(String.format(upsertStmt, "b", 2, "val2", 2, "col2_2"));
            conn.createStatement().execute(String.format(upsertStmt, "c", 3, "val3", 3, "col2_3"));
            Assert.assertEquals((long)3L, (long)TestUtil.getRowCount(conn, viewName));
            Assert.assertEquals((long)3L, (long)TestUtil.getRowCount(conn, viewIdxName));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            conn.createStatement().execute("DELETE FROM " + viewName + " WHERE VIEW_COL1=2");
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(conn, record.getNewPhysicalTableName()));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, viewName));
            Assert.assertEquals((long)2L, (long)TestUtil.getRowCount(conn, viewIdxName));
        }
    }

    @Test
    public void testTransformForView() throws Exception {
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String schema = "S_" + TransformIT.generateUniqueName();
            String tableName = "TBL_" + TransformIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
            String viewName = "VW_" + TransformIT.generateUniqueName();
            String fullViewName = SchemaUtil.getTableName((String)schema, (String)viewName);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            String createParentViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(createParentViewSql);
            try {
                conn.createStatement().execute("ALTER TABLE " + viewName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
                Assert.fail((String)"View transform should fail");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.VIEW_WITH_PROPERTIES.getErrorCode());
            }
        }
    }

    @Test
    public void testAlterNotNeedsToTransformDueToSameProps() throws Exception {
        String schema = "S_" + TransformIT.generateUniqueName();
        String tableName = "TBL_" + TransformIT.generateUniqueName();
        String indexName = "IDX_" + TransformIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
        String fullIdxName = SchemaUtil.getTableName((String)schema, (String)tableName);
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER, V3 INTEGER, V4 VARCHAR, V5 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2";
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, fullTableName);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNull((Object)record);
            String createIndexSql = "CREATE INDEX " + indexName + " ON " + fullTableName + " (PK1, INT_PK) include (V1) ASYNC";
            conn.createStatement().execute(createIndexSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS, PTable.QualifierEncodingScheme.TWO_BYTE_QUALIFIERS, fullIdxName);
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + fullTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            record = Transform.getTransformRecord((String)schema, (String)indexName, (String)tableName, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNull((Object)record);
        }
    }

    @Test
    public void testDropAfterTransform() throws Exception {
        String schema = "S_" + TransformIT.generateUniqueName();
        String tableName = "TBL_" + TransformIT.generateUniqueName();
        String viewName = "VW_" + TransformIT.generateUniqueName();
        String indexName = "IDX_" + TransformIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schema, (String)tableName);
        try (Connection conn = DriverManager.getConnection(TransformIT.getUrl(), this.testProps);){
            conn.setAutoCommit(true);
            String createTableSql = "CREATE TABLE " + fullTableName + " (PK1 VARCHAR NOT NULL, INT_PK INTEGER NOT NULL, V1 VARCHAR, V2 INTEGER CONSTRAINT NAME_PK PRIMARY KEY(PK1, INT_PK)) ";
            conn.createStatement().execute(createTableSql);
            TransformIT.assertMetadata(conn, PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN, PTable.QualifierEncodingScheme.NON_ENCODED_QUALIFIERS, fullTableName);
            String upsertStmt = "UPSERT INTO " + fullTableName + " (PK1, INT_PK, V1, V2) VALUES ('%s', %d, '%s', %d)";
            conn.createStatement().execute(String.format(upsertStmt, "a", 1, "val1", 1));
            String createParentViewSql = "CREATE VIEW " + viewName + " ( VIEW_COL1 VARCHAR ) AS SELECT * FROM " + fullTableName;
            conn.createStatement().execute(createParentViewSql);
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + " (V2) include (V1) ");
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + fullTableName + " ACTIVE IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            this.assertSystemTransform((Connection)conn.unwrap(PhoenixConnection.class), 1, schema, indexName, null);
            conn.createStatement().execute("DROP INDEX " + indexName + " ON " + fullTableName);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET  IMMUTABLE_STORAGE_SCHEME=SINGLE_CELL_ARRAY_WITH_OFFSETS, COLUMN_ENCODED_BYTES=2");
            SystemTransformRecord record = Transform.getTransformRecord((String)schema, (String)tableName, null, null, (PhoenixConnection)conn.unwrap(PhoenixConnection.class));
            Assert.assertNotNull((Object)record);
            conn.createStatement().execute("DROP VIEW " + viewName);
            conn.createStatement().execute("DROP TABLE " + fullTableName);
        }
    }

    private void assertSystemTransform(Connection conn, int rowCount, String schema, String logicalTableName, String tenantId) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ count(*) FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)rowCount, (long)rs.getInt(1));
        if (rowCount > 0) {
            rs = conn.createStatement().executeQuery("SELECT TABLE_SCHEM, TRANSFORM_TYPE FROM " + PhoenixDatabaseMetaData.SYSTEM_TRANSFORM_NAME + " WHERE LOGICAL_TABLE_NAME='" + logicalTableName + "'" + (Strings.isNullOrEmpty((String)schema) ? "" : " AND TABLE_SCHEM='" + schema + "' ") + (Strings.isNullOrEmpty((String)tenantId) ? "" : " AND TENANT_ID='" + tenantId + "' "));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)schema, (Object)rs.getString(1));
            Assert.assertEquals((long)PTable.TransformType.METADATA_TRANSFORM.getSerializedValue(), (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

