/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PDecimal;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Sets;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class SaltedTableMergeBucketsIT
extends ParallelStatsEnabledIT {
    @Test
    public void testWithVariousPKTypes() throws Exception {
        int[] variousSaltBuckets = new int[]{11, 23, 31};
        SortOrder[][] sortOrdersCase1 = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}};
        SortOrder[][] sortOrdersCase2 = new SortOrder[][]{{SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.ASC, SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.ASC, SortOrder.DESC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.ASC, SortOrder.DESC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC, SortOrder.ASC}, {SortOrder.DESC, SortOrder.DESC, SortOrder.DESC, SortOrder.DESC}};
        for (int index = 0; index < sortOrdersCase1.length; ++index) {
            String baseTableNameCase1 = SaltedTableMergeBucketsIT.generateUniqueName();
            PDataType[] testIntDecIntPKTypes = new PDataType[]{PLong.INSTANCE, PDecimal.INSTANCE, PLong.INSTANCE};
            long nowTime1 = this.createTableCase1(baseTableNameCase1, variousSaltBuckets[0], testIntDecIntPKTypes[0], sortOrdersCase1[index][0], testIntDecIntPKTypes[1], sortOrdersCase1[index][1], testIntDecIntPKTypes[2], sortOrdersCase1[index][2]);
            this.testIntDecIntPK(baseTableNameCase1, nowTime1, sortOrdersCase1[index]);
            this.mergeRegions(baseTableNameCase1);
            this.testIntDecIntPK(baseTableNameCase1, nowTime1, sortOrdersCase1[index]);
            String baseTableNameCase2 = SaltedTableMergeBucketsIT.generateUniqueName();
            PDataType[] testIntIntIntIntPKTypes = new PDataType[]{PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE, PInteger.INSTANCE};
            this.createTableCase2(baseTableNameCase2, variousSaltBuckets[0], testIntIntIntIntPKTypes[0], sortOrdersCase2[index][0], testIntIntIntIntPKTypes[1], sortOrdersCase2[index][1], testIntIntIntIntPKTypes[2], sortOrdersCase2[index][2], testIntIntIntIntPKTypes[3], sortOrdersCase2[index][3]);
            this.doTestGroupByOrderMatchPkColumnOrderBug4690(baseTableNameCase2);
            this.mergeRegions(baseTableNameCase2);
            this.doTestGroupByOrderMatchPkColumnOrderBug4690(baseTableNameCase2);
        }
    }

    private void testIntDecIntPK(String tableName, long nowTime, SortOrder[] sortOrder) throws SQLException {
        String testName = "testIntDecIntPK";
        String testSQL1 = String.format("SELECT ROW_ID FROM %s WHERE (ID1, ID2, ID3) IN ((%d, 21, 1),(%d, 2, 31))", tableName, nowTime, nowTime);
        String testSQL2 = String.format("SELECT ROW_ID FROM %s WHERE (ID2, ID3) IN ((21.0, 1),(2.0, 3))", tableName);
        String testSQL3 = String.format("SELECT ROW_ID FROM %s WHERE (ID1, ID2) IN ((%d, 21.0),(%d, 2.0))", tableName, nowTime + 1L, nowTime + 1L);
        String testSQL4 = String.format("SELECT ROW_ID FROM %s WHERE (ID3, ID2, ID1) IN ((3, 21.0, %d),(3, 2.0, %d))", tableName, nowTime + 1L, nowTime + 1L);
        String testSQL5 = String.format("SELECT ROW_ID FROM %s WHERE (ID1, ID2, ID3) IN ((%d, 21.0, 3),(%d, 2.0, 3))", tableName, nowTime + 1L, nowTime + 1L);
        String testSQL6 = String.format("SELECT ROW_ID FROM %s WHERE ID1 = %d AND ID2 = 2.0", tableName, nowTime);
        String testSQL7 = String.format("SELECT ROW_ID FROM %s WHERE ID1 >= %d AND ID1 < %d", tableName, nowTime, nowTime + 3L);
        String testSQL8 = String.format("SELECT ROW_ID FROM %s WHERE (ID1 = %d OR ID1 = %d OR ID1 = %d) AND (ID3 = %d)", tableName, nowTime, nowTime + 3L, nowTime + 2L, 5);
        Set<String> expecteds1 = Collections.emptySet();
        HashSet expecteds2 = Sets.newHashSet((Object[])new String[]{"row0", "row1"});
        HashSet expecteds3 = Sets.newHashSet((Object[])new String[]{"row1", "row2"});
        HashSet expecteds4 = Sets.newHashSet((Object[])new String[]{"row1"});
        HashSet expecteds5 = Sets.newHashSet((Object[])new String[]{"row1"});
        HashSet expecteds6 = Sets.newHashSet((Object[])new String[]{"row0"});
        HashSet expecteds7 = Sets.newHashSet((Object[])new String[]{"row0", "row1", "row2", "row3"});
        HashSet expecteds8 = Sets.newHashSet((Object[])new String[]{"row3"});
        this.assertExpectedWithWhere(testName, testSQL1, expecteds1, expecteds1.size());
        this.assertExpectedWithWhere(testName, testSQL2, expecteds2, expecteds2.size());
        this.assertExpectedWithWhere(testName, testSQL3, expecteds3, expecteds3.size());
        this.assertExpectedWithWhere(testName, testSQL4, expecteds4, expecteds4.size());
        this.assertExpectedWithWhere(testName, testSQL5, expecteds5, expecteds5.size());
        this.assertExpectedWithWhere(testName, testSQL6, expecteds6, expecteds6.size());
        this.assertExpectedWithWhere(testName, testSQL7, expecteds7, expecteds7.size());
        this.assertExpectedWithWhere(testName, testSQL8, expecteds8, expecteds8.size());
    }

    private void assertExpectedWithWhere(String testType, String testSQL, Set<String> expectedSet, int expectedCount) throws SQLException {
        String context = "sql: " + testSQL + ", type: " + testType;
        try (Connection tenantConnection = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());){
            ResultSet rs = tenantConnection.createStatement().executeQuery(testSQL);
            for (int i = 0; i < expectedCount; ++i) {
                Assert.assertTrue((String)("did not include result '" + expectedSet.toString() + "' (" + context + ")"), (boolean)rs.next());
                String actual = rs.getString(1);
                Assert.assertTrue((String)context, (boolean)expectedSet.contains(actual));
            }
            Assert.assertFalse((String)context, (boolean)rs.next());
        }
    }

    private void doTestGroupByOrderMatchPkColumnOrderBug4690(String tableName) throws Exception {
        try (Connection conn = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());){
            QueryBuilder queryBuilder = new QueryBuilder().setSelectExpression("PK2,PK1,COUNT(V)").setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "V"})).setFullTableName(tableName).setGroupByClause("PK2, PK1").setOrderByClause("PK2, PK1");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{2, 3, 2L}, {3, 2, 1L}, {7, 2, 2L}, {8, 1, 2L}, {9, 1, 4L}});
            queryBuilder.setSelectExpression("PK1, PK2, COUNT(V)");
            queryBuilder.setOrderByClause("PK1, PK2");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 8, 2L}, {1, 9, 4L}, {2, 3, 1L}, {2, 7, 2L}, {3, 2, 2L}});
            queryBuilder.setSelectExpression("PK2,PK1,COUNT(V)");
            queryBuilder.setOrderByClause("PK2 DESC,PK1 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{9, 1, 4L}, {8, 1, 2L}, {7, 2, 2L}, {3, 2, 1L}, {2, 3, 2L}});
            queryBuilder.setSelectExpression("PK1,PK2,COUNT(V)");
            queryBuilder.setOrderByClause("PK1 DESC,PK2 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{3, 2, 2L}, {2, 7, 2L}, {2, 3, 1L}, {1, 9, 4L}, {1, 8, 2L}});
            queryBuilder.setSelectExpression("PK3,PK2,COUNT(V)");
            queryBuilder.setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "PK3", "V"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setGroupByClause("PK3,PK2");
            queryBuilder.setOrderByClause("PK3,PK2");
            queryBuilder.setWhereClause("PK1=1");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{5, 9, 1L}, {6, 9, 2L}, {7, 9, 1L}, {10, 8, 1L}, {11, 8, 1L}});
            queryBuilder.setSelectExpression("PK2,PK3,COUNT(V)");
            queryBuilder.setOrderByClause("PK2,PK3");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{8, 10, 1L}, {8, 11, 1L}, {9, 5, 1L}, {9, 6, 2L}, {9, 7, 1L}});
            queryBuilder.setSelectExpression("PK3,PK2,COUNT(V)");
            queryBuilder.setOrderByClause("PK3 DESC,PK2 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{11, 8, 1L}, {10, 8, 1L}, {7, 9, 1L}, {6, 9, 2L}, {5, 9, 1L}});
            queryBuilder.setSelectExpression("PK2,PK3,COUNT(V)");
            queryBuilder.setOrderByClause("PK2 DESC,PK3 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{9, 7, 1L}, {9, 6, 2L}, {9, 5, 1L}, {8, 11, 1L}, {8, 10, 1L}});
            queryBuilder.setSelectExpression("PK4,PK3,PK1,COUNT(V)");
            queryBuilder.setSelectExpressionColumns((List)Lists.newArrayList((Object[])new String[]{"PK1", "PK2", "PK3", "PK4", "V"}));
            queryBuilder.setFullTableName(tableName);
            queryBuilder.setWhereClause("PK2=9 ");
            queryBuilder.setGroupByClause("PK4,PK3,PK1");
            queryBuilder.setOrderByClause("PK4,PK3,PK1");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{8, 7, 1, 1L}, {12, 6, 1, 1L}, {13, 6, 1, 1L}, {22, 5, 1, 1L}});
            queryBuilder.setSelectExpression("PK1,PK3,PK4,COUNT(V)");
            queryBuilder.setOrderByClause("PK1,PK3,PK4");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 5, 22, 1L}, {1, 6, 12, 1L}, {1, 6, 13, 1L}, {1, 7, 8, 1L}});
            queryBuilder.setSelectExpression("PK4,PK3,PK1,COUNT(V)");
            queryBuilder.setOrderByClause("PK4 DESC,PK3 DESC,PK1 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{22, 5, 1, 1L}, {13, 6, 1, 1L}, {12, 6, 1, 1L}, {8, 7, 1, 1L}});
            queryBuilder.setSelectExpression("PK1,PK3,PK4,COUNT(V)");
            queryBuilder.setOrderByClause("PK1 DESC,PK3 DESC,PK4 DESC");
            rs = this.executeQuery(conn, queryBuilder);
            TestUtil.assertResultSet(rs, new Object[][]{{1, 7, 8, 1L}, {1, 6, 13, 1L}, {1, 6, 12, 1L}, {1, 5, 22, 1L}});
        }
    }

    public void mergeRegions(String testTableName) throws Exception {
        Admin admin = driver.getConnectionQueryServices(SaltedTableMergeBucketsIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        List regions = admin.getRegions(TableName.valueOf((String)testTableName));
        for (int i = 0; i < regions.size() - 1; i += 2) {
            byte[][] regionsToMerge = new byte[][]{((RegionInfo)regions.get(i)).getEncodedNameAsBytes(), ((RegionInfo)regions.get(i + 1)).getEncodedNameAsBytes()};
            admin.mergeRegionsAsync((byte[][])regionsToMerge, false).get();
        }
    }

    private long createTableCase1(String baseTable, int saltBuckets, PDataType pkType1, SortOrder pk1Order, PDataType pkType2, SortOrder pk2Order, PDataType pkType3, SortOrder pk3Order) throws SQLException {
        String pkType1Str = this.getType(pkType1);
        String pkType2Str = this.getType(pkType2);
        String pkType3Str = this.getType(pkType3);
        try (Connection tenantConnection = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());
             Statement cstmt = tenantConnection.createStatement();){
            String TABLE_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s(ID1 %s not null,ID2 %s not null, ID3 %s not null, ROW_ID VARCHAR, V VARCHAR CONSTRAINT pk  PRIMARY KEY (ID1 %s, ID2 %s, ID3 %s)) SALT_BUCKETS=%d ";
            cstmt.execute(String.format(TABLE_TEMPLATE, baseTable, pkType1Str, pkType2Str, pkType3Str, pk1Order.name(), pk2Order.name(), pk3Order.name(), saltBuckets));
        }
        long nowTime = System.currentTimeMillis();
        ArrayList<String> UPSERT_SQLS = new ArrayList<String>();
        UPSERT_SQLS.addAll(Arrays.asList(String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime, 2.0, 3, "row0", "v1"), String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime + 1L, 2.0, 3, "row1", "v2"), String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime + 1L, 2.0, 5, "row2", "v3"), String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime + 2L, 4.0, 5, "row3", "v4"), String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime + 3L, 6.0, 7, "row4", "v5")));
        for (int i = 5; i < 100; ++i) {
            UPSERT_SQLS.add(String.format("UPSERT INTO %s(ID1, ID2, ID3, ROW_ID, V) VALUES (%d, %f, %d, '%s', '%s')", baseTable, nowTime + (long)i, 10.0, 13, "row" + i, "v" + i));
        }
        try (Connection tenantConnection = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());){
            tenantConnection.setAutoCommit(true);
            try (Statement ustmt = tenantConnection.createStatement();){
                for (String upsertSql : UPSERT_SQLS) {
                    ustmt.execute(upsertSql);
                }
            }
        }
        return nowTime;
    }

    private void createTableCase2(String baseTable, int saltBuckets, PDataType pkType1, SortOrder pk1Order, PDataType pkType2, SortOrder pk2Order, PDataType pkType3, SortOrder pk3Order, PDataType pkType4, SortOrder pk4Order) throws SQLException {
        String pkType1Str = this.getType(pkType1);
        String pkType2Str = this.getType(pkType2);
        String pkType3Str = this.getType(pkType3);
        String pkType4Str = this.getType(pkType4);
        try (Connection globalConnection = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());
             Statement cstmt = globalConnection.createStatement();){
            String TABLE_TEMPLATE = "CREATE TABLE IF NOT EXISTS %s(PK1 %s not null,PK2 %s not null,  PK3 %s not null,PK4 %s not null, V INTEGER CONSTRAINT  pk PRIMARY KEY (PK1 %s, PK2 %s, PK3 %s, PK4 %s)) SALT_BUCKETS=%d ";
            cstmt.execute(String.format(TABLE_TEMPLATE, baseTable, pkType1Str, pkType2Str, pkType3Str, pkType4Str, pk1Order.name(), pk2Order.name(), pk3Order.name(), pk4Order.name(), saltBuckets));
        }
        var16_16 = null;
        try (Connection conn = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl());){
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,8,10,20,30)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,8,11,21,31)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,9,5 ,22,32)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,9,6 ,12,33)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,9,6 ,13,34)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (1,9,7 ,8,35)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (2,3,15,25,35)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (2,7,16,26,36)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (2,7,17,27,37)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (3,2,18,28,38)");
            conn.createStatement().execute("UPSERT INTO " + baseTable + " VALUES (3,2,19,29,39)");
            conn.commit();
        }
        catch (Throwable throwable) {
            var16_16 = throwable;
            throw throwable;
        }
    }

    private String getType(PDataType pkType) {
        String pkTypeStr = "VARCHAR(25)";
        switch (pkType.getSqlType()) {
            case 12: {
                pkTypeStr = "VARCHAR(25)";
                break;
            }
            case 1: {
                pkTypeStr = "CHAR(15)";
                break;
            }
            case 3: {
                pkTypeStr = "DECIMAL(8,2)";
                break;
            }
            case 4: {
                pkTypeStr = "INTEGER";
                break;
            }
            case -5: {
                pkTypeStr = "BIGINT";
                break;
            }
            case 91: {
                pkTypeStr = "DATE";
                break;
            }
            case 93: {
                pkTypeStr = "TIMESTAMP";
                break;
            }
            default: {
                pkTypeStr = "VARCHAR(25)";
            }
        }
        return pkTypeStr;
    }

    @Test
    public void testMergesWithWideGuidepostsAndWithStatsForParallelization() throws Exception {
        this.testMerges(true, true);
    }

    @Test
    public void testMergesWithWideGuidepostsAndWithoutStatsForParallelization() throws Exception {
        this.testMerges(true, false);
    }

    @Test
    public void testMergesWithoutWideGuidepostsAndWithStatsForParallelization() throws Exception {
        this.testMerges(false, true);
    }

    @Test
    public void testMergesWithoutWideGuidepostsAndWithoutStatsForParallelization() throws Exception {
        this.testMerges(false, false);
    }

    public void testMerges(boolean withWideGuideposts, boolean withStatsForParallelization) throws Exception {
        String tableName = SaltedTableMergeBucketsIT.generateUniqueName();
        List range = IntStream.range(0, 100).boxed().map(s -> String.format("201912%03d", s)).collect(Collectors.toList());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.force.rowkeyorder", Boolean.FALSE.toString());
        if (!withStatsForParallelization) {
            props.put("phoenix.use.stats.parallelization", Boolean.FALSE.toString());
        }
        try (Connection connection = DriverManager.getConnection(SaltedTableMergeBucketsIT.getUrl(), props);
             Statement statement = connection.createStatement();){
            statement.execute("CREATE TABLE " + tableName + " (c1 VARCHAR NOT NULL, c2 VARCHAR NOT NULL, c3 VARCHAR NOT NULL, v1 VARCHAR  CONSTRAINT pk PRIMARY KEY(c1,c2,c3)) SALT_BUCKETS=11");
            for (String c1 : range) {
                statement.execute(" upsert into " + tableName + " values('" + c1 + "','HORTONWORKS_WEEKLY_TEST','v3','" + c1 + "')");
            }
            connection.commit();
            if (withWideGuideposts) {
                statement.execute("UPDATE STATISTICS " + tableName + " SET GUIDE_POSTS_WIDTH = 1000000");
            } else {
                statement.execute("UPDATE STATISTICS " + tableName);
            }
            this.mergeRegions(tableName);
            for (String c1 : range) {
                ResultSet rs = statement.executeQuery("select c1, c2, c3, v1 from " + tableName + " where c1='" + c1 + "' and c2 like '%HORTONWORKS_WEEKLY_TEST%'");
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)c1, (Object)rs.getString("c1"));
                Assert.assertEquals((Object)c1, (Object)rs.getString("v1"));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

