/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.salted.BaseSaltedTableIT;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class SaltedTableIT
extends BaseSaltedTableIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableWithInvalidBucketNumber() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SaltedTableIT.getUrl(), props);){
            String query = "create table " + SaltedTableIT.generateUniqueName() + " (a_integer integer not null CONSTRAINT pk PRIMARY KEY (a_integer)) SALT_BUCKETS = 257";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.execute();
            Assert.fail((String)"Should have caught exception");
        }
    }

    @Test
    public void testPointLookupOnSaltedTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SaltedTableIT.getUrl(), props);){
            String tableName = SaltedTableIT.generateUniqueName();
            String query = "create table " + tableName + " (a_integer integer not null CONSTRAINT pk PRIMARY KEY (a_integer)) SALT_BUCKETS = 10";
            conn.createStatement().execute(query);
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + " values(?)");
            stmt.setInt(1, 1);
            stmt.execute();
            stmt.setInt(1, 2);
            stmt.execute();
            stmt.setInt(1, 3);
            stmt.execute();
            conn.commit();
            query = "select * from " + tableName + " where a_integer = 1";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("a_integer"));
            query = "explain " + query;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains("POINT LOOKUP ON 1 KEY"));
        }
    }

    @Test
    public void testPointLookupOnSaltedTable2() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(SaltedTableIT.getUrl(), props);){
            int i;
            String tableName = SaltedTableIT.generateUniqueName();
            String query = "CREATE TABLE " + tableName + " (A integer not null, B integer CONSTRAINT pk PRIMARY KEY (A)) SALT_BUCKETS = 10";
            conn.createStatement().execute(query);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " values(?, ?)");
            for (i = 0; i < 1000; ++i) {
                stmt.setInt(1, i);
                stmt.setInt(2, i + 10);
                stmt.execute();
            }
            conn.commit();
            for (i = 0; i < 1000; ++i) {
                query = "SELECT * FROM " + tableName + " WHERE A = " + i;
                ResultSet rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)i, (long)rs.getInt("A"));
                Assert.assertEquals((long)(i + 10), (long)rs.getInt("B"));
                Assert.assertFalse((boolean)rs.next());
                query = "explain " + query;
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains("CLIENT PARALLEL 1-WAY POINT LOOKUP ON 1 KEY OVER"));
            }
        }
    }

    @Test
    public void testTableWithSplit() throws Exception {
        try {
            SaltedTableIT.createTestTable(SaltedTableIT.getUrl(), "create table " + SaltedTableIT.generateUniqueName() + " (a_integer integer not null primary key) SALT_BUCKETS = 4", new byte[][]{{1}, {2, 3}, {2, 5}, {3}}, null);
            Assert.fail((String)"Should have caught exception");
        }
        catch (SQLException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("ERROR 1022 (42Y81): Should not specify split points on salted table with default row key order."));
        }
    }
}

