/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.salted;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryBuilder;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseSaltedTableIT
extends ParallelStatsDisabledIT {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String initTableValues(byte[][] splits) throws Exception {
        String tableName = BaseSaltedTableIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            BaseSaltedTableIT.ensureTableCreated(BaseSaltedTableIT.getUrl(), tableName, "TABLE_WITH_SALTING", splits, null, null);
            String query = "UPSERT INTO " + tableName + " VALUES(?,?,?,?,?)";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setInt(1, 1);
            stmt.setString(2, "ab");
            stmt.setString(3, "123");
            stmt.setString(4, "abc");
            stmt.setInt(5, 111);
            stmt.execute();
            conn.commit();
            stmt.setInt(1, 1);
            stmt.setString(2, "abc");
            stmt.setString(3, "456");
            stmt.setString(4, "abc");
            stmt.setInt(5, 111);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + tableName + " (a_integer, a_string, a_id, b_string, b_integer)  VALUES(?,?,?,?,?)";
            stmt = conn.prepareStatement(query);
            stmt.setInt(1, 1);
            stmt.setString(2, "de");
            stmt.setString(3, "123");
            stmt.setString(4, "abc");
            stmt.setInt(5, 111);
            stmt.execute();
            conn.commit();
            stmt.setInt(1, 2);
            stmt.setString(2, "abc");
            stmt.setString(3, "123");
            stmt.setString(4, "def");
            stmt.setInt(5, 222);
            stmt.execute();
            conn.commit();
            query = "UPSERT INTO " + tableName + " (a_string, a_integer, a_id, b_string, b_integer)  VALUES(?,?,?,?,?)";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, "abc");
            stmt.setInt(2, 3);
            stmt.setString(3, "123");
            stmt.setString(4, "ghi");
            stmt.setInt(5, 333);
            stmt.execute();
            conn.commit();
            stmt.setString(1, "abc");
            stmt.setInt(2, 4);
            stmt.setString(3, "123");
            stmt.setString(4, "jkl");
            stmt.setInt(5, 444);
            stmt.execute();
            conn.commit();
        }
        return tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectValueNoWhereClause() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_INTEGER", "A_STRING", "A_ID", "B_STRING", "B_INTEGER"})).setFullTableName(tableName);
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"456", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"def", (Object)rs.getString(4));
            Assert.assertEquals((long)222L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"ghi", (Object)rs.getString(4));
            Assert.assertEquals((long)333L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"jkl", (Object)rs.getString(4));
            Assert.assertEquals((long)444L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectValueWithFullyQualifiedWhereClause() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            QueryBuilder queryBuilder = new QueryBuilder().setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_INTEGER", "A_STRING", "A_ID", "B_STRING", "B_INTEGER"})).setFullTableName(tableName).setWhereClause("A_INTEGER = 1 AND A_STRING >= 'ab' AND A_STRING < 'de' AND A_ID = '123'");
            ResultSet rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER = 1 AND A_STRING = 'ab' AND A_ID = '123'");
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER in (2, 4) AND A_STRING = 'abc' AND A_ID = '123'");
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"def", (Object)rs.getString(4));
            Assert.assertEquals((long)222L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"jkl", (Object)rs.getString(4));
            Assert.assertEquals((long)444L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER in (1,2,3,4) AND A_STRING in ('a', 'abc', 'de') AND A_ID = '123'");
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_INTEGER", "A_STRING", "A_ID"}));
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER > 1 AND A_INTEGER < 4 AND A_STRING = 'abc' AND A_ID = '123'");
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_STRING", "A_ID", "A_INTEGER"}));
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"123", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"123", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER > 1 AND A_STRING = 'abc' AND A_ID = '123'");
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"B_STRING", "B_INTEGER", "A_INTEGER", "A_STRING", "A_ID"}));
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"def", (Object)rs.getString(1));
            Assert.assertEquals((long)222L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ghi", (Object)rs.getString(1));
            Assert.assertEquals((long)333L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"jkl", (Object)rs.getString(1));
            Assert.assertEquals((long)444L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            queryBuilder.setWhereClause("A_INTEGER = 1 AND A_STRING > 'ab' AND A_ID = '123'");
            queryBuilder.setSelectColumns((List)Lists.newArrayList((Object[])new String[]{"A_INTEGER", "A_STRING", "A_ID", "B_STRING", "B_INTEGER"}));
            rs = this.executeQuery(conn, queryBuilder);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectValueWithNotFullyQualifiedWhereClause() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            String query = "SELECT * FROM " + tableName + " WHERE a_integer = ? AND a_string = ?";
            PreparedStatement stmt = conn.prepareStatement(query);
            stmt.setInt(1, 1);
            stmt.setString(2, "abc");
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"456", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + tableName + " WHERE a_integer >= 2";
            stmt = conn.prepareStatement(query);
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"def", (Object)rs.getString(4));
            Assert.assertEquals((long)222L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"ghi", (Object)rs.getString(4));
            Assert.assertEquals((long)333L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"jkl", (Object)rs.getString(4));
            Assert.assertEquals((long)444L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a_string FROM " + tableName + " WHERE a_string = ?";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, "de");
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT a_id FROM " + tableName + " WHERE a_id = ?";
            stmt = conn.prepareStatement(query);
            stmt.setString(1, "456");
            rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"456", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithGroupBy() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            String query = "SELECT a_integer FROM " + tableName + " GROUP BY a_integer";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                ++count;
            }
            Assert.assertEquals((String)"Group by does not return the right count.", (long)count, (long)4L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLimitScan() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            String query = "SELECT a_integer FROM " + tableName + " WHERE a_string='abc' LIMIT 1";
            PreparedStatement stmt = conn.prepareStatement(query);
            ResultSet rs = stmt.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectWithOrderByRowKey() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(BaseSaltedTableIT.getUrl(), props);){
            String tableName = BaseSaltedTableIT.initTableValues(null);
            String query = "SELECT * FROM " + tableName + " ORDER  BY  a_integer, a_string, a_id";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet explainPlan = statement.executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 4-WAY FULL SCAN OVER " + tableName + "\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)explainPlan));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"456", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(4));
            Assert.assertEquals((long)111L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"def", (Object)rs.getString(4));
            Assert.assertEquals((long)222L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"ghi", (Object)rs.getString(4));
            Assert.assertEquals((long)333L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"123", (Object)rs.getString(3));
            Assert.assertEquals((Object)"jkl", (Object)rs.getString(4));
            Assert.assertEquals((long)444L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

