/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class JsonFunctionsIT
extends ParallelStatsDisabledIT {
    public static String BASIC_JSON = "json/json_functions_basic.json";
    public static String DATA_TYPES_JSON = "json/json_datatypes.json";
    String basicJson = "";
    String dataTypesJson = "";

    @Before
    public void setup() throws IOException {
        this.basicJson = JsonFunctionsIT.getJsonString(BASIC_JSON, "$[0]");
        this.dataTypesJson = JsonFunctionsIT.getJsonString(DATA_TYPES_JSON);
    }

    @Test
    public void testSimpleJsonValue() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, randomVal integer ,col integer, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 123);
            stmt.setInt(3, 2);
            stmt.setString(4, this.basicJson);
            stmt.execute();
            conn.commit();
            String queryTemplate = "SELECT pk, randomVal, JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[0]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info'), JSON_VALUE(jsoncol, '$.info.tags[1]')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s'";
            String query = String.format(queryTemplate, "AndersenFamily");
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"123", (Object)rs.getString(2));
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(3));
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(4));
            Assert.assertEquals((Object)"Sport", (Object)rs.getString(5));
            this.compareJson(rs.getString(6), this.basicJson, "$.info.tags");
            this.compareJson(rs.getString(7), this.basicJson, "$.info");
            Assert.assertEquals((Object)"Water polo", (Object)rs.getString(8));
            Assert.assertFalse((boolean)rs.next());
            query = String.format(queryTemplate, "Windsors");
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains("    SERVER JSON FUNCTION PROJECTION"));
        }
    }

    private void compareJson(String result, String json, String path) throws JsonProcessingException {
        Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new GsonJsonProvider()).build();
        Object read = JsonPath.using((Configuration)conf).parse(json).read(path, new Predicate[0]);
        ObjectMapper mapper = new ObjectMapper();
        Assert.assertEquals((Object)mapper.readTree(read.toString()), (Object)mapper.readTree(result));
    }

    @Test
    public void testAtomicUpsertJsonModifyWithAutoCommit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json)  COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            stmt.execute();
            String upsert = "UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')";
            conn.createStatement().execute(upsert);
            String query = "SELECT JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(1));
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.tags[1]', '\"alto1\"')");
            query = "SELECT JSON_VALUE(jsoncol, '$.info.tags[1]') FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(1));
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.tags', '[\"Sport\", \"alto1\", \"Books\"]')");
            String queryTemplate = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s'";
            query = String.format(queryTemplate, "AndersenFamily");
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(2));
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"[\"Sport\", \"alto1\", \"Books\"]", (Object)rs.getString(4));
            Assert.assertEquals((Object)"{\"type\": 1, \"address\": {\"town\": \"Manchester\", \"county\": \"Avon\", \"country\": \"England\", \"exists\": true}, \"tags\": [\"Sport\", \"alto1\", \"Books\"]}", (Object)rs.getString(5));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(2,1, JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ON DUPLICATE KEY IGNORE";
            conn.createStatement().execute(upsert);
            query = "SELECT pk, col, jsoncol FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
        }
    }

    @Test
    public void testAtomicUpsertJsonModifyWithoutAutoCommit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json)  COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            stmt.execute();
            conn.commit();
            String upsert = "UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')";
            conn.createStatement().execute(upsert);
            String query = "SELECT JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(1));
            query = "SELECT BSON_VALUE(jsoncol, 'info.address.town', 'VARCHAR') FROM " + tableName + " WHERE BSON_VALUE(jsoncol, 'infox.type', 'VARCHAR') IS NULL";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(1));
            query = "SELECT BSON_VALUE(jsoncol, 'info.type', 'DOUBLE') FROM " + tableName + " WHERE BSON_VALUE(jsoncol, 'info.type', 'VARCHAR') IS NOT NULL";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)1.0, (double)rs.getDouble(1), (double)0.0);
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.tags[1]', '\"alto1\"')");
            query = "SELECT JSON_VALUE(jsoncol, '$.info.tags[1]') FROM " + tableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Water polo", (Object)rs.getString(1));
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col) VALUES(1,2) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.tags', '[\"Sport\", \"alto1\", \"Books\"]')");
            conn.commit();
            String queryTemplate = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s'";
            query = String.format(queryTemplate, "AndersenFamily");
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(2));
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"[\"Sport\", \"alto1\", \"Books\"]", (Object)rs.getString(4));
            Assert.assertEquals((Object)"{\"type\": 1, \"address\": {\"town\": \"Manchester\", \"county\": \"Avon\", \"country\": \"England\", \"exists\": true}, \"tags\": [\"Sport\", \"alto1\", \"Books\"]}", (Object)rs.getString(5));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(2,1, JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ON DUPLICATE KEY IGNORE";
            conn.createStatement().execute(upsert);
            conn.commit();
            query = "SELECT pk, col, jsoncol FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
        }
    }

    @Test
    public void testSimpleJsonDatatypes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table if not exists " + tableName + " (pk integer primary key, col integer, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.dataTypesJson);
            stmt.execute();
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT JSON_VALUE(JSONCOL,'$.datatypes.stringtype'), JSON_VALUE(JSONCOL, '$.datatypes.inttype'), JSON_VALUE(JSONCOL, '$.datatypes.booltype'), JSON_VALUE(JSONCOL, '$.datatypes.booltypef'), JSON_VALUE(JSONCOL, '$.datatypes.doubletype'),JSON_VALUE(JSONCOL, '$.datatypes.longtype'),JSON_VALUE(JSONCOL, '$.datatypes.intArray[0]'),JSON_VALUE(JSONCOL, '$.datatypes.intArray'),JSON_VALUE(JSONCOL, '$'),JSON_VALUE(JSONCOL, '$.datatypes.nullcheck'),JSON_VALUE(JSONCOL, '$.datatypes.noKey'),JSON_VALUE(JSONCOL, '$.datatypes.noKey.subkey')  FROM " + tableName + " WHERE JSON_VALUE(JSONCOL, '$.datatypes.stringtype')='someString'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"someString", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"true", (Object)rs.getString(3));
            Assert.assertEquals((Object)"false", (Object)rs.getString(4));
            Assert.assertEquals((Object)"2.5", (Object)rs.getString(5));
            Assert.assertEquals((Object)"1490020778457845", (Object)rs.getString(6));
            Assert.assertEquals((Object)"1", (Object)rs.getString(7));
            Assert.assertEquals(null, (Object)rs.getString(8));
            Assert.assertEquals(null, (Object)rs.getString(9));
            Assert.assertEquals(null, (Object)rs.getString(10));
            Assert.assertEquals(null, (Object)rs.getString(11));
            Assert.assertEquals(null, (Object)rs.getString(12));
        }
    }

    @Test
    public void testJsonQuery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table if not exists " + tableName + " (pk integer primary key, col integer, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.dataTypesJson);
            stmt.execute();
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT JSON_QUERY(JSONCOL, '$.datatypes.intArray'),JSON_QUERY(JSONCOL, '$.datatypes.boolArray'),JSON_QUERY(JSONCOL, '$.datatypes.doubleArray'),JSON_QUERY(JSONCOL, '$.datatypes.stringArray'),JSON_QUERY(JSONCOL, '$.datatypes.mixedArray')  FROM " + tableName + " WHERE JSON_VALUE(JSONCOL, '$.datatypes.stringtype')='someString'");
            Assert.assertTrue((boolean)rs.next());
            this.compareJson(rs.getString(1), this.dataTypesJson, "$.datatypes.intArray");
            this.compareJson(rs.getString(2), this.dataTypesJson, "$.datatypes.boolArray");
            this.compareJson(rs.getString(3), this.dataTypesJson, "$.datatypes.doubleArray");
            this.compareJson(rs.getString(4), this.dataTypesJson, "$.datatypes.stringArray");
            this.compareJson(rs.getString(5), this.dataTypesJson, "$.datatypes.mixedArray");
        }
    }

    @Test
    public void testJsonExpressionIndex() throws IOException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        String indexName = "IDX_" + JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table if not exists " + tableName + " (pk integer primary key, col integer, jsoncol.jsoncol json) COLUMN_ENCODED_BYTES=0";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (1,2, '" + this.basicJson + "')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (2,3, '" + JsonFunctionsIT.getJsonString(BASIC_JSON, "$[1]") + "')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (3,4, '" + JsonFunctionsIT.getJsonString(BASIC_JSON, "$[2]") + "')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (4,5, '" + JsonFunctionsIT.getJsonString(BASIC_JSON, "$[3]") + "')");
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (5,6, '" + JsonFunctionsIT.getJsonString(BASIC_JSON, "$[4]") + "')");
            conn.commit();
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + " (JSON_VALUE(JSONCOL,'$.type'), JSON_VALUE(JSONCOL,'$.info.address.town')) include (col)");
            String selectSql = "SELECT JSON_VALUE(JSONCOL,'$.type'), JSON_VALUE(JSONCOL,'$.info.address.town') FROM " + tableName + " WHERE JSON_VALUE(JSONCOL,'$.type') = 'Basic'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + selectSql);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            IndexToolIT.assertExplainPlan(false, actualExplainPlan, tableName, indexName);
            String countSql = "SELECT COUNT(1) FROM " + tableName;
            rs = conn.createStatement().executeQuery(countSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5L, (long)rs.getInt(1));
            String deleteQuery = "DELETE FROM " + tableName + " WHERE JSON_VALUE(JSONCOL,'$.type') = 'Normal'";
            conn.createStatement().execute(deleteQuery);
            conn.commit();
            rs = conn.createStatement().executeQuery(countSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            selectSql = "SELECT COUNT(1) FROM " + tableName + " WHERE JSON_VALUE(JSONCOL,'$.type') = 'Normal'";
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            conn.createStatement().execute("ALTER TABLE " + tableName + " DROP COLUMN jsoncol ");
            conn.createStatement().execute("SELECT * FROM " + tableName);
            try {
                conn.createStatement().execute("SELECT * FROM " + indexName);
                Assert.fail((String)"Index should have been dropped");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
            PTable dataTable = pconn.getTable(new PTableKey(null, tableName));
            pconn = conn.unwrap(PhoenixConnection.class);
            dataTable = pconn.getTable(new PTableKey(null, tableName));
            try {
                pconn.getTable(new PTableKey(null, indexName));
                Assert.fail((String)"index should have been dropped");
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            Assert.assertEquals((String)"Unexpected number of indexes ", (long)0L, (long)dataTable.getIndexes().size());
        }
        catch (SQLException e) {
            Assert.assertFalse((String)"Failed to execute test", (boolean)true);
        }
    }

    @Test
    public void testJsonExpressionIndexInvalid() {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        String indexName = "IDX_" + JsonFunctionsIT.generateUniqueName();
        this.checkInvalidJsonIndexExpression(props, tableName, indexName, " (JSON_QUERY(JSONCOL,'$.info.address')) include (col)");
    }

    @Test
    public void testJsonExists() throws SQLException, IOException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            stmt.execute();
            stmt.setInt(1, 2);
            stmt.setInt(2, 3);
            stmt.setString(3, JsonFunctionsIT.getJsonString(BASIC_JSON, "$[1]"));
            stmt.execute();
            conn.commit();
            String query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE JSON_EXISTS(jsoncol, '$.info.address.town')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Normal", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Bristol2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE JSON_EXISTS(jsoncol, '$.info.address.exists')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE NOT JSON_EXISTS(jsoncol, '$.info.address.exists')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Bristol2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE JSON_EXISTS(jsoncol, '$.info.address.name')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE JSON_EXISTS(jsoncol, '$.existsFail')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town')  FROM " + tableName + " WHERE JSON_EXISTS(jsoncol, '$.existsFail[*]')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void checkInvalidJsonIndexExpression(Properties props, String tableName, String indexName, String indexExpression) {
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table if not exists " + tableName + " (pk integer primary key, col integer, jsoncol.jsoncol json)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES (1,2, '" + this.basicJson + "')");
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + indexExpression);
            conn.commit();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.JSON_FRAGMENT_NOT_ALLOWED_IN_INDEX_EXPRESSION.getErrorCode(), (long)e.getErrorCode());
        }
    }

    private static String getJsonString(String jsonFilePath) throws IOException {
        return JsonFunctionsIT.getJsonString(jsonFilePath, "$");
    }

    private static String getJsonString(String jsonFilePath, String jsonPath) throws IOException {
        URL fileUrl = JsonFunctionsIT.class.getClassLoader().getResource(jsonFilePath);
        String json = FileUtils.readFileToString((File)new File(fileUrl.getFile()));
        Configuration conf = Configuration.builder().jsonProvider((JsonProvider)new GsonJsonProvider()).build();
        Object read = JsonPath.using((Configuration)conf).parse(json).read(jsonPath, new Predicate[0]);
        return read.toString();
    }

    @Test
    public void testJsonFunctionOptimization() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            stmt.execute();
            conn.commit();
            String queryTemplate = "SELECT jsoncol, JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s'";
            String query = String.format(queryTemplate, "AndersenFamily");
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertFalse((boolean)QueryUtil.getExplainPlan((ResultSet)rs).contains("    SERVER JSON FUNCTION PROJECTION"));
        }
    }

    @Test
    public void testArrayIndexAndJsonFunctionExpressions() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json, arr INTEGER ARRAY)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            Array array = conn.createArrayOf("INTEGER", new Integer[]{1, 2});
            stmt.setArray(4, array);
            stmt.execute();
            conn.commit();
            String query = "SELECT arr, arr[1], jsoncol, JSON_VALUE(jsoncol, '$.type') FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertFalse((boolean)explainPlan.contains("    SERVER JSON FUNCTION PROJECTION"));
            Assert.assertFalse((boolean)explainPlan.contains("    SERVER ARRAY ELEMENT PROJECTION"));
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)conn.createArrayOf("INTEGER", new Integer[]{1, 2}), (Object)rs.getArray(1));
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getString(4), (Object)"Basic");
            query = "SELECT arr[1], JSON_VALUE(jsoncol, '$.type') FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("    SERVER JSON FUNCTION PROJECTION"));
            Assert.assertTrue((boolean)explainPlan.contains("    SERVER ARRAY ELEMENT PROJECTION"));
            query = "SELECT arr[1], jsoncol, JSON_VALUE(jsoncol, '$.type') FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertFalse((boolean)explainPlan.contains("    SERVER JSON FUNCTION PROJECTION"));
            Assert.assertTrue((boolean)explainPlan.contains("    SERVER ARRAY ELEMENT PROJECTION"));
            query = "SELECT arr, arr[1], JSON_VALUE(jsoncol, '$.type') FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("    SERVER JSON FUNCTION PROJECTION"));
            Assert.assertFalse((boolean)explainPlan.contains("    SERVER ARRAY ELEMENT PROJECTION"));
        }
    }

    @Test
    public void testServerFunctionsInDifferentOrders() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, jsoncol json, arr INTEGER ARRAY, arr2 INTEGER ARRAY)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, this.basicJson);
            Array array = conn.createArrayOf("INTEGER", new Integer[]{1, 2});
            stmt.setArray(4, array);
            Array array2 = conn.createArrayOf("INTEGER", new Integer[]{3, 4});
            stmt.setArray(5, array2);
            stmt.execute();
            conn.commit();
            String query = "SELECT arr, arr[1], arr2, arr2[1], jsoncol, JSON_VALUE(jsoncol, '$.type'), JSON_QUERY(jsoncol, '$.info')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getArray(1), (Object)conn.createArrayOf("INTEGER", new Integer[]{1, 2}));
            Assert.assertEquals((long)rs.getInt(2), (long)1L);
            Assert.assertEquals((Object)rs.getArray(3), (Object)conn.createArrayOf("INTEGER", new Integer[]{3, 4}));
            Assert.assertEquals((long)rs.getInt(4), (long)3L);
            this.compareJson(rs.getString(5), this.basicJson, "$");
            Assert.assertEquals((Object)rs.getString(6), (Object)"Basic");
            this.compareJson(rs.getString(7), this.basicJson, "$.info");
            query = "SELECT jsoncol, JSON_VALUE(jsoncol, '$.type'), JSON_QUERY(jsoncol, '$.info'), arr, arr[1], arr2, arr2[1]  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            this.compareJson(rs.getString(1), this.basicJson, "$");
            Assert.assertEquals((Object)rs.getString(2), (Object)"Basic");
            this.compareJson(rs.getString(3), this.basicJson, "$.info");
            Assert.assertEquals((Object)rs.getArray(4), (Object)conn.createArrayOf("INTEGER", new Integer[]{1, 2}));
            Assert.assertEquals((long)rs.getInt(5), (long)1L);
            Assert.assertEquals((Object)rs.getArray(6), (Object)conn.createArrayOf("INTEGER", new Integer[]{3, 4}));
            Assert.assertEquals((long)rs.getInt(7), (long)3L);
            query = "SELECT JSON_QUERY(jsoncol, '$.info'), arr, arr[1], arr2, arr2[1], jsoncol, JSON_VALUE(jsoncol, '$.type')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            this.compareJson(rs.getString(1), this.basicJson, "$.info");
            Assert.assertEquals((Object)rs.getArray(2), (Object)conn.createArrayOf("INTEGER", new Integer[]{1, 2}));
            Assert.assertEquals((long)rs.getInt(3), (long)1L);
            Assert.assertEquals((Object)rs.getArray(4), (Object)conn.createArrayOf("INTEGER", new Integer[]{3, 4}));
            Assert.assertEquals((long)rs.getInt(5), (long)3L);
            this.compareJson(rs.getString(6), this.basicJson, "$");
            Assert.assertEquals((Object)rs.getString(7), (Object)"Basic");
            query = "SELECT JSON_QUERY(jsoncol, '$.info.tags'), JSON_VALUE(jsoncol, '$.info.address.town'), arr,  arr[1], JSON_QUERY(jsoncol, '$.info'), arr2, JSON_VALUE(jsoncol, '$.info.tags[0]'), arr2[1], jsoncol, JSON_VALUE(jsoncol, '$.type')  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = 'AndersenFamily'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            this.compareJson(rs.getString(1), this.basicJson, "$.info.tags");
            Assert.assertEquals((Object)rs.getString(2), (Object)"Bristol");
            Assert.assertEquals((Object)rs.getArray(3), (Object)conn.createArrayOf("INTEGER", new Integer[]{1, 2}));
            Assert.assertEquals((long)rs.getInt(4), (long)1L);
            this.compareJson(rs.getString(5), this.basicJson, "$.info");
            Assert.assertEquals((Object)rs.getArray(6), (Object)conn.createArrayOf("INTEGER", new Integer[]{3, 4}));
            Assert.assertEquals((Object)rs.getString(7), (Object)"Sport");
            Assert.assertEquals((long)rs.getInt(8), (long)3L);
            this.compareJson(rs.getString(9), this.basicJson, "$");
            Assert.assertEquals((Object)rs.getString(10), (Object)"Basic");
        }
    }

    @Test
    public void testJsonWithSetGetObjectAPI() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)");
            stmt.setInt(1, 1);
            stmt.setString(2, this.basicJson);
            stmt.execute();
            conn.commit();
            String query = "SELECT * FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            RawBsonDocument rawBson = (RawBsonDocument)rs.getObject(2);
            this.compareJson(rawBson.toJson(), this.basicJson, "$");
            Assert.assertFalse((boolean)rs.next());
            Document info = new Document().append("info", (Object)new Document().append("type", (Object)1).append("address", (Object)new Document().append("town", (Object)"Bristol").append("county", (Object)"Avon").append("country", (Object)"England").append("exists", (Object)true)).append("tags", Arrays.asList("Sport", "Water polo"))).append("type", (Object)"Basic").append("name", (Object)"AndersenFamily");
            RawBsonDocument document = RawBsonDocument.parse((String)info.toJson());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)");
            stmt.setInt(1, 2);
            stmt.setObject(2, document);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            RawBsonDocument rawBsonDocument = (RawBsonDocument)rs.getObject(2);
            this.compareJson(rawBsonDocument.toJson(), info.toJson(), "$");
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?,?)");
            stmt.setInt(1, 3);
            stmt.setObject(2, document);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + tableName + " WHERE pk = 3";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            String jsonStr = rs.getString(2);
            this.compareJson(jsonStr, info.toJson(), "$");
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertJsonModifyWithAutoCommit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, strcol varchar, strcol1 varchar, strcol2 varchar, strcol3 varchar, strcol4 varchar, strcol5 varchar, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (pk,col,strcol,jsoncol) VALUES (?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, "");
            stmt.setString(4, this.basicJson);
            stmt.execute();
            String upsert = "UPSERT INTO " + tableName + "(pk,col,strcol,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.address.town'),JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ";
            conn.createStatement().execute(upsert);
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol1,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.tags[1]'),JSON_MODIFY(jsoncol, '$.info.tags[1]', '\"alto1\"')) ");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,strcol2,jsoncol,col) VALUES(1,JSON_VALUE(jsoncol, '$.type'),JSON_MODIFY(jsoncol, '$.info.tags', '[\"Sport\", \"alto1\", \"Books\"]'),3) ");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol3,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]') ,JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal\"') from " + tableName + " WHERE pk = 1");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol4,strcol5,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal2\"') from " + tableName + " WHERE pk = 1");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol1,jsoncol) VALUES(2,1,'Hello',JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ");
            String queryTemplate = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info'), JSON_VALUE(jsoncol, '$.info.tags[2]'), col, strcol, strcol1, strcol2,strcol3, strcol4, strcol5  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s' AND pk = 1";
            String query = String.format(queryTemplate, "AndersenFamily");
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(2));
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"UpsertSelectVal2", (Object)rs.getString(6));
            Assert.assertEquals((long)3L, (long)rs.getInt(7));
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(8));
            Assert.assertEquals((Object)"Water polo", (Object)rs.getString(9));
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(10));
            Assert.assertEquals((Object)"Books", (Object)rs.getString(11));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(12));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(13));
            query = "SELECT pk, col, strcol1, jsoncol FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"Hello", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldUpdate\"')";
            conn.createStatement().execute(upsert);
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY IGNORE";
            conn.createStatement().execute(upsert);
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
        }
    }

    @Test
    public void testUpsertJsonModifyWithOutAutoCommit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, strcol varchar, strcol1 varchar, strcol2 varchar, strcol3 varchar, strcol4 varchar, strcol5 varchar, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (pk,col,strcol,jsoncol) VALUES (?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, "");
            stmt.setString(4, this.basicJson);
            stmt.execute();
            conn.commit();
            String upsert = "UPSERT INTO " + tableName + "(pk,col,strcol,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.address.town'),JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ";
            conn.createStatement().execute(upsert);
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol1,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.tags[1]'),JSON_MODIFY(jsoncol, '$.info.tags[1]', '\"alto1\"')) ");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,strcol2,jsoncol,col) VALUES(1,JSON_VALUE(jsoncol, '$.type'),JSON_MODIFY(jsoncol, '$.info.tags', '[\"Sport\", \"alto1\", \"Books\"]'),3) ");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol3,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]') ,JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal\"') from " + tableName + " WHERE pk = 1");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol4,strcol5,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal2\"') from " + tableName + " WHERE pk = 1");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol1,jsoncol) VALUES(2,1,'Hello',JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ");
            conn.commit();
            String queryTemplate = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info'), JSON_VALUE(jsoncol, '$.info.tags[2]'), col, strcol, strcol1, strcol2,strcol3, strcol4, strcol5  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s' AND pk = 1";
            String query = String.format(queryTemplate, "AndersenFamily");
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(2));
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"UpsertSelectVal2", (Object)rs.getString(6));
            Assert.assertEquals((long)3L, (long)rs.getInt(7));
            Assert.assertEquals((Object)"Bristol", (Object)rs.getString(8));
            Assert.assertEquals((Object)"Water polo", (Object)rs.getString(9));
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(10));
            Assert.assertEquals((Object)"Books", (Object)rs.getString(11));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(12));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(13));
            query = "SELECT pk, col, strcol1, jsoncol FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"Hello", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldUpdate\"')";
            conn.createStatement().execute(upsert);
            conn.commit();
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY IGNORE";
            conn.createStatement().execute(upsert);
            conn.commit();
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
        }
    }

    @Test
    public void testUpsertJsonModifyMultipleCF() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = JsonFunctionsIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(JsonFunctionsIT.getUrl(), props);){
            String ddl = "create table " + tableName + " (pk integer primary key, col integer, a.strcol varchar, a.strcol1 varchar, b.strcol varchar, b.strcol1 varchar, strcol4 varchar, strcol5 varchar, jsoncol json)";
            conn.createStatement().execute(ddl);
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " (pk,col,a.strcol,jsoncol) VALUES (?,?,?,?)");
            stmt.setInt(1, 1);
            stmt.setInt(2, 2);
            stmt.setString(3, "");
            stmt.setString(4, this.basicJson);
            stmt.execute();
            conn.commit();
            String upsert = "UPSERT INTO " + tableName + "(pk,col,a.strcol,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.address.town') || 'City',JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ";
            conn.createStatement().execute(upsert);
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,a.strcol1,jsoncol) VALUES(1,2,JSON_VALUE(jsoncol, '$.info.tags[1]'),JSON_MODIFY(jsoncol, '$.info.tags[1]', '\"alto1\"')) ");
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,b.strcol,jsoncol,col) VALUES(1,JSON_VALUE(jsoncol, '$.type'),JSON_MODIFY(jsoncol, '$.info.tags', '[\"Sport\", \"alto1\", \"Books\"]'),3) ");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,b.strcol1,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]') ,JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal\"') from " + tableName + " WHERE pk = 1");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,strcol4,strcol5,jsoncol) SELECT pk, col, JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_VALUE(jsoncol, '$.info.tags[2]'),JSON_MODIFY(jsoncol, '$.info.tags[2]', '\"UpsertSelectVal2\"') from " + tableName + " WHERE pk = 1");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + "(pk,col,a.strcol1,jsoncol) VALUES(2,1,'Hello',JSON_MODIFY(jsoncol, '$.info.address.town', '\"Manchester\"')) ");
            conn.commit();
            String queryTemplate = "SELECT JSON_VALUE(jsoncol, '$.type'), JSON_VALUE(jsoncol, '$.info.address.town'), JSON_VALUE(jsoncol, '$.info.tags[1]'), JSON_QUERY(jsoncol, '$.info.tags'), JSON_QUERY(jsoncol, '$.info'), JSON_VALUE(jsoncol, '$.info.tags[2]'), col, a.strcol, a.strcol1, b.strcol,b.strcol1, strcol4, strcol5  FROM " + tableName + " WHERE JSON_VALUE(jsoncol, '$.name') = '%s' AND pk = 1";
            String query = String.format(queryTemplate, "AndersenFamily");
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(1));
            Assert.assertEquals((Object)"Manchester", (Object)rs.getString(2));
            Assert.assertEquals((Object)"alto1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"UpsertSelectVal2", (Object)rs.getString(6));
            Assert.assertEquals((long)3L, (long)rs.getInt(7));
            Assert.assertEquals((Object)"BristolCity", (Object)rs.getString(8));
            Assert.assertEquals((Object)"Water polo", (Object)rs.getString(9));
            Assert.assertEquals((Object)"Basic", (Object)rs.getString(10));
            Assert.assertEquals((Object)"Books", (Object)rs.getString(11));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(12));
            Assert.assertEquals((Object)"UpsertSelectVal", (Object)rs.getString(13));
            query = "SELECT pk, col, a.strcol1, jsoncol FROM " + tableName + " WHERE pk = 2";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"Hello", (Object)rs.getString(3));
            Assert.assertEquals(null, (Object)rs.getString(4));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY UPDATE jsoncol = JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldUpdate\"')";
            conn.createStatement().execute(upsert);
            conn.commit();
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
            upsert = "UPSERT INTO " + tableName + " (pk, col, jsoncol) VALUES(1,4, JSON_MODIFY(jsoncol, '$.info.address.town', '\"ShouldBeIgnore\"')) ON DUPLICATE KEY IGNORE";
            conn.createStatement().execute(upsert);
            conn.commit();
            query = "SELECT pk, col, JSON_VALUE(jsoncol, '$.info.address.town') FROM " + tableName + " WHERE pk = 1";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"ShouldUpdate", (Object)rs.getString(3));
        }
    }
}

