/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.join.BaseJoinIT;
import org.apache.phoenix.execute.ClientAggregatePlan;
import org.apache.phoenix.execute.ClientScanPlan;
import org.apache.phoenix.execute.SortMergeJoinPlan;
import org.apache.phoenix.execute.TupleProjectionPlan;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class SubqueryUsingSortMergeJoinIT
extends BaseJoinIT {
    public SubqueryUsingSortMergeJoinIT(String[] indexDDL, String[] plans) {
        super(indexDDL, plans);
    }

    @Parameterized.Parameters
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new String[][]{new String[0], {"SORT-MERGE-JOIN (SEMI) TABLES\n    SORT-MERGE-JOIN (INNER) TABLES\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n            SERVER SORTED BY [\"I.supplier_id\"]\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"\n    CLIENT SORTED BY [\"I.item_id\"]\nAND (SKIP MERGE)\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER \"Join\".\"OrderTable\" ['000000000000001'] - [*]\n        SERVER AGGREGATE INTO DISTINCT ROWS BY [\"item_id\"]\n    CLIENT MERGE SORT\nCLIENT SORTED BY [I.NAME]", "SORT-MERGE-JOIN \\(LEFT\\) TABLES\n    SORT-MERGE-JOIN \\(LEFT\\) TABLES\n        CLIENT PARALLEL 4-WAY FULL SCAN OVER \"Join\".\"CoitemTable\"\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n            SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\".+.item_id\", .+.NAME\\]\n        CLIENT MERGE SORT\n            PARALLEL ANTI-JOIN TABLE 0 \\(SKIP MERGE\\)\n                CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                    SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"]\\\n                CLIENT MERGE SORT\n    CLIENT SORTED BY \\[.*.CO_ITEM_ID, .*.CO_ITEM_NAME\\]\nAND\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n        SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\".+.item_id\", .+.NAME\\]\n    CLIENT MERGE SORT\n        SKIP-SCAN-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\n        DYNAMIC SERVER FILTER BY \"\"Join\".\"ItemTable\".item_id\" IN \\(\\$\\d+.\\$\\d+\\)\nCLIENT FILTER BY \\(\\$\\d+.\\$\\d+ IS NOT NULL OR \\$\\d+.\\$\\d+ IS NOT NULL\\)", "SORT-MERGE-JOIN \\(SEMI\\) TABLES\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"CustomerTable\"\nAND \\(SKIP MERGE\\)\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n        SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"O.customer_id\"\\]\n    CLIENT MERGE SORT\n        PARALLEL INNER-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n        PARALLEL LEFT-JOIN TABLE 1\\(DELAYED EVALUATION\\)\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\n        DYNAMIC SERVER FILTER BY \"I.item_id\" IN \\(\"O.item_id\"\\)\n        AFTER-JOIN SERVER FILTER BY \\(I.NAME = 'T2' OR O.QUANTITY > \\$\\d+.\\$\\d+\\)"}});
        testCases.add(new String[][]{{"CREATE INDEX \"idx_customer\" ON \"Join\".\"CustomerTable\" (name)", "CREATE INDEX \"idx_item\" ON \"Join\".\"ItemTable\" (name) INCLUDE (price, discount1, discount2, \"supplier_id\", description)", "CREATE INDEX \"idx_supplier\" ON \"Join\".\"SupplierTable\" (name)"}, {"SORT-MERGE-JOIN (SEMI) TABLES\n    SORT-MERGE-JOIN (INNER) TABLES\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_item\n            SERVER SORTED BY [\"I.0:supplier_id\"]\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_supplier\n            SERVER FILTER BY FIRST KEY ONLY\n            SERVER SORTED BY [\"S.:supplier_id\"]\n        CLIENT MERGE SORT\n    CLIENT SORTED BY [\"I.:item_id\"]\nAND (SKIP MERGE)\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER \"Join\".\"OrderTable\" ['000000000000001'] - [*]\n        SERVER AGGREGATE INTO DISTINCT ROWS BY [\"item_id\"]\n    CLIENT MERGE SORT\nCLIENT SORTED BY [\"I.0:NAME\"]", "SORT-MERGE-JOIN \\(LEFT\\) TABLES\n    SORT-MERGE-JOIN \\(LEFT\\) TABLES\n        CLIENT PARALLEL 4-WAY FULL SCAN OVER \"Join\".\"CoitemTable\"\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_item\n            SERVER FILTER BY FIRST KEY ONLY\n            SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY \\[\".+.0:NAME\", \".+.:item_id\"\\]\n        CLIENT SORTED BY \\[\".+.:item_id\", \".+.0:NAME\"\\]\n            PARALLEL ANTI-JOIN TABLE 0 \\(SKIP MERGE\\)\n                CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                    SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n                CLIENT MERGE SORT\n    CLIENT SORTED BY \\[.*.CO_ITEM_ID, .*.CO_ITEM_NAME\\]\nAND\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_item\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY \\[\".+.0:NAME\", \".+.:item_id\"\\]\n    CLIENT SORTED BY \\[\".+.:item_id\", \".+.0:NAME\"\\]\n        PARALLEL SEMI-JOIN TABLE 0 \\(SKIP MERGE\\)\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\nCLIENT FILTER BY \\(\\$\\d+.\\$\\d+ IS NOT NULL OR \\$\\d+.\\$\\d+ IS NOT NULL\\)", "SORT-MERGE-JOIN \\(SEMI\\) TABLES\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_customer\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY \\[\"Join.idx_customer.:customer_id\"\\]\n    CLIENT MERGE SORT\nAND \\(SKIP MERGE\\)\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER Join.idx_item\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"O.customer_id\"\\]\n    CLIENT MERGE SORT\n        PARALLEL INNER-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n        PARALLEL LEFT-JOIN TABLE 1\\(DELAYED EVALUATION\\)\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\n        AFTER-JOIN SERVER FILTER BY \\(\"I.0:NAME\" = 'T2' OR O.QUANTITY > \\$\\d+.\\$\\d+\\)"}});
        testCases.add(new String[][]{{"CREATE LOCAL INDEX IDX_CUSTOMER ON \"Join\".\"CustomerTable\" (name)", "CREATE LOCAL INDEX IDX_ITEM ON \"Join\".\"ItemTable\" (name) INCLUDE (price, discount1, discount2, \"supplier_id\", description)", "CREATE LOCAL INDEX IDX_SUPPLIER ON \"Join\".\"SupplierTable\" (name)"}, {"SORT-MERGE-JOIN (SEMI) TABLES\n    SORT-MERGE-JOIN (INNER) TABLES\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER SORTED BY [\"I.0:supplier_id\"]\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n            SERVER SORTED BY [\"S.:supplier_id\"]\n        CLIENT MERGE SORT\n    CLIENT SORTED BY [\"I.:item_id\"]\nAND (SKIP MERGE)\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + "\"Join\".\"OrderTable\"" + " ['000000000000001'] - [*]\n        SERVER AGGREGATE INTO DISTINCT ROWS BY [\"item_id\"]\n    CLIENT MERGE SORT\nCLIENT SORTED BY [\"I.0:NAME\"]", "SORT-MERGE-JOIN \\(LEFT\\) TABLES\n    SORT-MERGE-JOIN \\(LEFT\\) TABLES\n        CLIENT PARALLEL 4-WAY FULL SCAN OVER \"Join\".\"CoitemTable\"\n        CLIENT MERGE SORT\n    AND\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "\\(" + "\"Join\".\"ItemTable\"" + "\\) \\[1\\]\n            SERVER FILTER BY FIRST KEY ONLY\n            SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY \\[\".+.0:NAME\", \".+.:item_id\"\\]\n        CLIENT MERGE SORT\n        CLIENT SORTED BY \\[\".+.:item_id\", \".+.0:NAME\"\\]\n            PARALLEL ANTI-JOIN TABLE 0 \\(SKIP MERGE\\)\n                CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n                    SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n                CLIENT MERGE SORT\n    CLIENT SORTED BY \\[.*.CO_ITEM_ID, .*.CO_ITEM_NAME\\]\nAND\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "\\(" + "\"Join\".\"ItemTable\"" + "\\) \\[1\\]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY \\[\".+.0:NAME\", \".+.:item_id\"\\]\n    CLIENT MERGE SORT\n    CLIENT SORTED BY \\[\".+.:item_id\", \".+.0:NAME\"\\]\n        PARALLEL SEMI-JOIN TABLE 0 \\(SKIP MERGE\\)\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\n        DYNAMIC SERVER FILTER BY \"" + JOIN_ITEM_INDEX_FULL_NAME + ".:item_id\" IN \\(\\$\\d+.\\$\\d+\\)\nCLIENT FILTER BY \\(\\$\\d+.\\$\\d+ IS NOT NULL OR \\$\\d+.\\$\\d+ IS NOT NULL\\)", "SORT-MERGE-JOIN \\(SEMI\\) TABLES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_CUSTOMER_INDEX_FULL_NAME + "\\(" + "\"Join\".\"CustomerTable\"" + "\\) \\[1\\]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY \\[\"" + JOIN_CUSTOMER_INDEX_FULL_NAME + ".:customer_id\"\\]\n    CLIENT MERGE SORT\nAND \\(SKIP MERGE\\)\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "\\(" + "\"Join\".\"ItemTable\"" + "\\) \\[1\\]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"O.customer_id\"\\]\n    CLIENT MERGE SORT\n        PARALLEL INNER-JOIN TABLE 0\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n        PARALLEL LEFT-JOIN TABLE 1\\(DELAYED EVALUATION\\)\n            CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n                SERVER AGGREGATE INTO DISTINCT ROWS BY \\[\"item_id\"\\]\n            CLIENT MERGE SORT\n        DYNAMIC SERVER FILTER BY \"I.:item_id\" IN \\(\"O.item_id\"\\)\n        AFTER-JOIN SERVER FILTER BY \\(\"I.0:NAME\" = 'T2' OR O.QUANTITY > \\$\\d+.\\$\\d+\\)"}});
        return testCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInSubquery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String tableName5 = this.getTableName(conn, "\"Join\".\"CoitemTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"item_id\", name FROM " + tableName1 + " WHERE \"item_id\" IN (SELECT \"item_id\" FROM " + tableName4 + ") ORDER BY name";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"item_id\", name FROM " + tableName1 + " WHERE \"item_id\" NOT IN (SELECT \"item_id\" FROM " + tableName4 + ") ORDER BY name";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.\"item_id\", s.name FROM " + tableName1 + " i JOIN " + tableName2 + " s ON i.\"supplier_id\" = s.\"supplier_id\" WHERE i.\"item_id\" IN (SELECT \"item_id\" FROM " + tableName4 + " WHERE \"order_id\" > '000000000000001') ORDER BY i.name";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S6");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            this.assertPlansEqual(this.plans[0], QueryUtil.getExplainPlan((ResultSet)rs));
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ i.\"item_id\", s.name FROM " + tableName2 + " s LEFT JOIN " + tableName1 + " i ON i.\"supplier_id\" = s.\"supplier_id\" WHERE i.\"item_id\" IN (SELECT \"item_id\" FROM " + tableName4 + ") ORDER BY i.name";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"S6");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ * FROM " + tableName5 + " WHERE (item_id, item_name) IN (SELECT \"item_id\", name FROM " + tableName1 + " WHERE \"item_id\" NOT IN (SELECT \"item_id\" FROM " + tableName4 + ")) OR (co_item_id, co_item_name) IN (SELECT \"item_id\", name FROM " + tableName1 + " WHERE \"item_id\" IN (SELECT \"item_id\" FROM " + tableName4 + "))";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(4), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String plan = QueryUtil.getExplainPlan((ResultSet)rs);
            this.assertPlansMatch(this.plans[1], plan);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsSubquery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        String tableName5 = this.getTableName(conn, "\"Join\".\"CoitemTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"item_id\", name FROM " + tableName1 + " i WHERE NOT EXISTS (SELECT 1 FROM " + tableName4 + " o WHERE o.\"item_id\" = i.\"item_id\") ORDER BY name";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"invalid001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"INVALID-1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T5");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ * FROM " + tableName5 + " co WHERE EXISTS (SELECT 1 FROM " + tableName1 + " i WHERE NOT EXISTS (SELECT 1 FROM " + tableName4 + " WHERE \"item_id\" = i.\"item_id\") AND co.item_id = \"item_id\" AND name = co.item_name) OR EXISTS (SELECT 1 FROM " + tableName1 + " WHERE \"item_id\" IN (SELECT \"item_id\" FROM " + tableName4 + ") AND co.co_item_id = \"item_id\" AND name = co.co_item_name)";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000006");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000001");
            Assert.assertEquals((Object)rs.getString(4), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"0000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertEquals((Object)rs.getString(3), (Object)"0000000003");
            Assert.assertEquals((Object)rs.getString(4), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String plan = QueryUtil.getExplainPlan((ResultSet)rs);
            this.assertPlansMatch(this.plans[1], plan);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testComparisonSubquery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE quantity = (SELECT max(quantity) FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\")";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ name from " + tableName3 + " WHERE \"customer_id\" IN (SELECT \"customer_id\" FROM " + tableName1 + " i JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" WHERE i.name = 'T2' OR quantity > (SELECT avg(quantity) FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\"))";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C4");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String plan = QueryUtil.getExplainPlan((ResultSet)rs);
            this.assertPlansMatch(this.plans[2], plan);
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity = (SELECT quantity FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000004')";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity = (SELECT quantity FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003')";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            try {
                while (rs.next()) {
                }
                Assert.fail((String)"Should have got exception.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity = (SELECT max(quantity) FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000004' GROUP BY \"order_id\")";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity = (SELECT max(quantity) FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003' GROUP BY \"order_id\")";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            try {
                while (rs.next()) {
                }
                Assert.fail((String)"Should have got exception.");
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrelatedInSubqueryBug6224() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName3 = this.getTableName(conn, "\"Join\".\"CustomerTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE quantity in (SELECT max(quantity) FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\") order by \"order_id\"";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ name from " + tableName3 + " WHERE \"customer_id\" IN (SELECT \"customer_id\" FROM " + tableName1 + " i JOIN " + tableName4 + " o ON o.\"item_id\" = i.\"item_id\" WHERE i.name = 'T2' OR quantity in (SELECT max(quantity) FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\" and q.\"item_id\" = '0000000006')) order by name";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"C4");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity in (SELECT quantity FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000004') order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity in (SELECT quantity FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003') order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity in (SELECT max(quantity) FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000004' GROUP BY \"order_id\") order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE quantity in (SELECT max(quantity) FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003' GROUP BY \"order_id\") order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrelatedExistsSubqueryBug6498() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE exists (SELECT 1 FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\" group by q.\"customer_id\" having count(\"order_id\") > 1)";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE exists (SELECT 1 FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\" group by q.\"customer_id\" having count(\"order_id\") >= 1) order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE exists (SELECT 1 FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\" and q.price <= 150 group by q.\"customer_id\" having count(\"order_id\") >= 1) or o.quantity = 5000 order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE exists (SELECT 1 FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000004' GROUP BY \"order_id\" having count(\"customer_id\") >= 1) order by  \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE exists (SELECT 1 FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003' GROUP BY \"order_id\" having count(\"customer_id\") >= 1) order by  \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\" FROM " + tableName4 + " o WHERE exists (SELECT 1 FROM " + tableName4 + " WHERE o.\"item_id\" = \"item_id\" AND \"order_id\" != '000000000000003' GROUP BY \"order_id\" having count(\"customer_id\") > 1) order by  \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAnyAllComparisonSubquery() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE quantity = ALL(SELECT quantity FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\")";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000001");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000003");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000005");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T3");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE quantity != ALL(SELECT max(quantity) FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\")";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ \"order_id\", name FROM " + tableName4 + " o JOIN " + tableName1 + " i ON o.\"item_id\" = i.\"item_id\" WHERE quantity != ANY(SELECT quantity FROM " + tableName4 + " q WHERE o.\"item_id\" = q.\"item_id\" GROUP BY quantity) order by \"order_id\"";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000002");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"000000000000004");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T6");
            Assert.assertFalse((boolean)rs.next());
            PhoenixPreparedStatement phoenixPreparedStatement = statement.unwrap(PhoenixPreparedStatement.class);
            ClientScanPlan clientScanPlan = (ClientScanPlan)phoenixPreparedStatement.optimizeQuery(query);
            SortMergeJoinPlan sortMergeJoin = (SortMergeJoinPlan)clientScanPlan.getDelegate();
            ClientScanPlan lhsQueryPlan = (ClientScanPlan)sortMergeJoin.getLhsPlan();
            Assert.assertTrue((lhsQueryPlan.getOrderBy() == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY ? 1 : 0) != 0);
            TupleProjectionPlan rhsQueryPlan = (TupleProjectionPlan)sortMergeJoin.getRhsPlan();
            ClientAggregatePlan clientAggregatePlan = (ClientAggregatePlan)rhsQueryPlan.getDelegate();
            Assert.assertTrue((boolean)clientAggregatePlan.getGroupBy().isOrderPreserving());
            Assert.assertTrue((clientAggregatePlan.getOrderBy() == OrderByCompiler.OrderBy.FWD_ROW_KEY_ORDER_BY ? 1 : 0) != 0);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubqueryWithUpsert() throws Exception {
        String tempTable = SubqueryUsingSortMergeJoinIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(SubqueryUsingSortMergeJoinIT.getUrl(), props);
        conn.setAutoCommit(true);
        String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
        String tableName4 = this.getTableName(conn, "\"Join\".\"OrderTable\"");
        try {
            conn.createStatement().execute("CREATE TABLE " + tempTable + "   (item_id varchar not null primary key,     name varchar)");
            conn.createStatement().execute("UPSERT /*+ USE_SORT_MERGE_JOIN*/ INTO " + tempTable + "(item_id, name)   SELECT \"item_id\", name FROM " + tableName1 + "   WHERE \"item_id\" NOT IN (SELECT \"item_id\" FROM " + tableName4 + ")");
            String query = "SELECT name FROM " + tempTable + " ORDER BY item_id";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T4");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"T5");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"INVALID-1");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }
}

