/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.join.SortMergeJoinNoIndexIT;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
public class SortMergeJoinNoSpoolingIT
extends SortMergeJoinNoIndexIT {
    public SortMergeJoinNoSpoolingIT(String[] indexDDL, String[] plans) {
        super(indexDDL, plans);
    }

    @Parameterized.Parameters(name="SortMergeJoinNoSpoolingIT_{index}")
    public static synchronized Collection<Object> data() {
        return SortMergeJoinNoIndexIT.data();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.query.client.join.spooling.enabled", Boolean.toString(Boolean.FALSE));
        props.put("phoenix.query.client.spoolThresholdBytes", Integer.toString(10000000));
        SortMergeJoinNoSpoolingIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testJoinWithMemoryLimit() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.query.client.spoolThresholdBytes", Integer.toString(1));
        try (Connection conn = DriverManager.getConnection(SortMergeJoinNoSpoolingIT.getUrl(), props);){
            String tableName1 = this.getTableName(conn, "\"Join\".\"ItemTable\"");
            String tableName2 = this.getTableName(conn, "\"Join\".\"SupplierTable\"");
            String query = "SELECT /*+ USE_SORT_MERGE_JOIN*/ item.\"item_id\", item.name, supp.\"supplier_id\", supp.name FROM " + tableName1 + " item JOIN " + tableName2 + " supp ON item.\"supplier_id\" = supp.\"supplier_id\" ORDER BY \"item_id\"";
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            try {
                rs.next();
                Assert.fail((String)"Expected PhoenixIOException due to IllegalStateException");
            }
            catch (PhoenixIOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Queue full. Consider increasing memory threshold or spooling to disk"));
            }
        }
    }
}

