/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.join.SortMergeJoinIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
public class SortMergeJoinLocalIndexIT
extends SortMergeJoinIT {
    private static final Map<String, String> virtualNameToRealNameMap = Maps.newHashMap();
    private static final String schemaName = "S_" + SortMergeJoinLocalIndexIT.generateUniqueName();

    @Override
    protected String getSchemaName() {
        return schemaName;
    }

    @Override
    protected Map<String, String> getTableNameMap() {
        return virtualNameToRealNameMap;
    }

    public SortMergeJoinLocalIndexIT(String[] indexDDL, String[] plans) {
        super(indexDDL, plans);
    }

    @Parameterized.Parameters(name="SortMergeJoinLocalIndexIT_{index}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new String[][]{{"CREATE LOCAL INDEX IDX_CUSTOMER ON \"Join\".\"CustomerTable\"(name)", "CREATE LOCAL INDEX IDX_ITEM ON \"Join\".\"ItemTable\"(name) INCLUDE (price, discount1, discount2, \"supplier_id\", description)", "CREATE LOCAL INDEX IDX_SUPPLIER ON \"Join\".\"SupplierTable\" (name)"}, {"SORT-MERGE-JOIN (LEFT) TABLES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY [\"S.:supplier_id\"]\n    CLIENT MERGE SORT\nAND\n    SORT-MERGE-JOIN (INNER) TABLES\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER SORTED BY [\"I.:item_id\"]\n        CLIENT MERGE SORT\n    AND (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n            SERVER FILTER BY QUANTITY < 5000\n            SERVER SORTED BY [\"O.item_id\"]\n        CLIENT MERGE SORT\n    CLIENT SORTED BY [\"I.0:supplier_id\"]", "SORT-MERGE-JOIN (INNER) TABLES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY [\"I.:item_id\"]\n    CLIENT MERGE SORT\nAND\n    CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n        SERVER SORTED BY [\"O.item_id\"]\n    CLIENT MERGE SORT\nCLIENT 4 ROW LIMIT", "SORT-MERGE-JOIN (INNER) TABLES\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY [\"I1.:item_id\"]\n    CLIENT MERGE SORT\nAND\n    CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        SERVER FILTER BY FIRST KEY ONLY\n        SERVER SORTED BY [\"I2.:item_id\"]\n    CLIENT MERGE SORT"}});
        return testCases;
    }
}

