/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.join.BaseJoinIT;
import org.apache.phoenix.end2end.join.HashJoinCacheIT;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class HashJoinPersistentCacheIT
extends BaseJoinIT {
    @Override
    protected String getTableName(Connection conn, String virtualName) throws Exception {
        String realName = super.getTableName(conn, virtualName);
        TestUtil.addCoprocessor(conn, SchemaUtil.normalizeFullTableName((String)realName), HashJoinCacheIT.InvalidateHashCache.class);
        return realName;
    }

    @Test
    public void testPersistentCache() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(HashJoinPersistentCacheIT.getUrl(), props);
        HashJoinPersistentCacheIT.createTestTable(HashJoinPersistentCacheIT.getUrl(), "CREATE TABLE IF NOT EXISTS states (state CHAR(2) NOT NULL, name VARCHAR NOT NULL CONSTRAINT my_pk PRIMARY KEY (state, name))");
        HashJoinPersistentCacheIT.createTestTable(HashJoinPersistentCacheIT.getUrl(), "CREATE TABLE IF NOT EXISTS cities (state CHAR(2) NOT NULL, city VARCHAR NOT NULL, population BIGINT CONSTRAINT my_pk PRIMARY KEY (state, city))");
        conn.prepareStatement("UPSERT INTO states VALUES ('CA', 'California')").executeUpdate();
        conn.prepareStatement("UPSERT INTO states VALUES ('AZ', 'Arizona')").executeUpdate();
        conn.prepareStatement("UPSERT INTO cities VALUES ('CA', 'San Francisco', 50000)").executeUpdate();
        conn.prepareStatement("UPSERT INTO cities VALUES ('CA', 'Sacramento', 3000)").executeUpdate();
        conn.prepareStatement("UPSERT INTO cities VALUES ('AZ', 'Phoenix', 20000)").executeUpdate();
        conn.commit();
        ResultSet rs = conn.prepareStatement("SELECT SUM(population) FROM states s JOIN cities c ON c.state = s.state").executeQuery();
        rs.next();
        int population1 = rs.getInt(1);
        conn.prepareStatement("UPSERT INTO cities VALUES ('CA', 'Mt View', 1500)").executeUpdate();
        conn.commit();
        rs = conn.prepareStatement("SELECT SUM(population) FROM states s JOIN cities c ON c.state = s.state").executeQuery();
        rs.next();
        int population2 = rs.getInt(1);
        Assert.assertEquals((long)73000L, (long)population1);
        Assert.assertEquals((long)74500L, (long)population2);
        rs = conn.prepareStatement("SELECT /*+ USE_PERSISTENT_CACHE */ SUM(population) FROM states s JOIN cities c ON c.state = s.state").executeQuery();
        rs.next();
        int population3 = rs.getInt(1);
        conn.prepareStatement("UPSERT INTO cities VALUES ('CA', 'Palo Alto', 2000)").executeUpdate();
        conn.commit();
        rs = conn.prepareStatement("SELECT /*+ USE_PERSISTENT_CACHE */ SUM(population) FROM states s JOIN cities c ON c.state = s.state").executeQuery();
        rs.next();
        int population4 = rs.getInt(1);
        rs = conn.prepareStatement("SELECT SUM(population) FROM states s JOIN cities c ON c.state = s.state").executeQuery();
        rs.next();
        int population5 = rs.getInt(1);
        Assert.assertEquals((long)74500L, (long)population3);
        Assert.assertEquals((long)74500L, (long)population4);
        Assert.assertEquals((long)76500L, (long)population5);
        String sumQueryCached = "SELECT /*+ USE_PERSISTENT_CACHE */ SUM(population) FROM cities c JOIN (SELECT state FROM states WHERE state LIKE 'C%') sq ON sq.state = c.state";
        String distinctQueryCached = "SELECT /*+ USE_PERSISTENT_CACHE */ COUNT(DISTINCT(c.city)) FROM cities c JOIN (SELECT state FROM states WHERE state LIKE 'C%') sq ON sq.state = c.state";
        String sumQueryUncached = sumQueryCached.replace("/*+ USE_PERSISTENT_CACHE */", "");
        String distinctQueryUncached = distinctQueryCached.replace("/*+ USE_PERSISTENT_CACHE */", "");
        rs = conn.prepareStatement(sumQueryCached).executeQuery();
        rs.next();
        int population6 = rs.getInt(1);
        rs = conn.prepareStatement(distinctQueryCached).executeQuery();
        rs.next();
        int distinct1 = rs.getInt(1);
        Assert.assertEquals((long)4L, (long)distinct1);
        conn.prepareStatement("UPSERT INTO states VALUES ('CO', 'Colorado')").executeUpdate();
        conn.prepareStatement("UPSERT INTO cities VALUES ('CO', 'Denver', 6000)").executeUpdate();
        conn.commit();
        rs = conn.prepareStatement(sumQueryCached).executeQuery();
        rs.next();
        int population7 = rs.getInt(1);
        Assert.assertEquals((long)population6, (long)population7);
        rs = conn.prepareStatement(distinctQueryCached).executeQuery();
        rs.next();
        int distinct2 = rs.getInt(1);
        Assert.assertEquals((long)distinct1, (long)distinct2);
        rs = conn.prepareStatement(sumQueryUncached).executeQuery();
        rs.next();
        int population8 = rs.getInt(1);
        Assert.assertEquals((long)population8, (long)62500L);
        rs = conn.prepareStatement(distinctQueryUncached).executeQuery();
        rs.next();
        int distinct3 = rs.getInt(1);
        Assert.assertEquals((long)5L, (long)distinct3);
    }
}

