/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.join;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.join.HashJoinIT;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class HashJoinLocalIndexIT
extends HashJoinIT {
    private static final Map<String, String> virtualNameToRealNameMap = Maps.newHashMap();
    private static final String schemaName = "S_" + HashJoinLocalIndexIT.generateUniqueName();

    @Override
    protected String getSchemaName() {
        return schemaName;
    }

    @Override
    protected Map<String, String> getTableNameMap() {
        return virtualNameToRealNameMap;
    }

    public HashJoinLocalIndexIT(String[] indexDDL, String[] plans) {
        super(indexDDL, plans);
    }

    @Parameterized.Parameters(name="HashJoinLocalIndexIT_{index}")
    public static synchronized Collection<Object> data() {
        ArrayList testCases = Lists.newArrayList();
        testCases.add(new String[][]{{"CREATE LOCAL INDEX IDX_CUSTOMER ON \"Join\".\"CustomerTable\" (name)", "CREATE LOCAL INDEX IDX_ITEM ON \"Join\".\"ItemTable\" (name) INCLUDE (price, discount1, discount2, \"supplier_id\", description)", "CREATE LOCAL INDEX IDX_SUPPLIER ON \"Join\".\"SupplierTable\" (name)"}, {"CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"I.0:NAME\"]\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"I.:item_id\"]\nCLIENT MERGE SORT\nCLIENT SORTED BY [SUM(O.QUANTITY) DESC]\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"I.item_id\"]\nCLIENT SORTED BY [SUM(O.QUANTITY) DESC NULLS LAST, \"I.item_id\"]\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"I.0:NAME\"]\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"I.item_id\"]\nCLIENT SORTED BY [SUM(O.QUANTITY) DESC NULLS LAST, \"I.item_id\"]\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1,'T1'] - [1,'T5']\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1,'S1'] - [1,'S5']\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY SKIP SCAN ON 2 KEYS OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1,'T1'] - [1,'T5']\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY SKIP SCAN ON 2 KEYS OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1,'S1'] - [1,'S5']\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0 (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n            SERVER FILTER BY QUANTITY < 5000\n    PARALLEL INNER-JOIN TABLE 1\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"I.:item_id\" IN (\"O.item_id\")", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"ItemTable\"\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"I1.item_id\" IN (\"I2.:item_id\")", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER SORTED BY [\"I1.0:NAME\", \"I2.0:NAME\"]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"I1.:item_id\" IN (\"I2.0:supplier_id\")", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_CUSTOMER_INDEX_FULL_NAME + "(" + "\"Join\".\"CustomerTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 1\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER SORTED BY [\"O.order_id\"]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n            PARALLEL INNER-JOIN TABLE 0\n                CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_CUSTOMER_INDEX_FULL_NAME + "(" + "\"Join\".\"CustomerTable\"" + ") [1]\n                    SERVER FILTER BY FIRST KEY ONLY\n                CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"I.:item_id\" IN (\"O.item_id\")", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER \"Join\".\"CustomerTable\" [*] - ['0000000005']\n    SERVER SORTED BY [\"C.customer_id\", \"I.0:NAME\"]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n            SERVER FILTER BY \"order_id\" != '000000000000003'\n            PARALLEL INNER-JOIN TABLE 0\n                CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n                    SERVER FILTER BY \"NAME\" != 'T3'\n                CLIENT MERGE SORT\n                    PARALLEL LEFT-JOIN TABLE 0\n                        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"SupplierTable\"" + "\n    DYNAMIC SERVER FILTER BY \"C.customer_id\" IN (\"O.customer_id\")", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [I.NAME]\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [O.IID]\nCLIENT MERGE SORT\nCLIENT SORTED BY [SUM(O.QUANTITY) DESC]\n    PARALLEL LEFT-JOIN TABLE 0 (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER SORTED BY [O.Q DESC NULLS LAST, I.IID]\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n            SERVER AGGREGATE INTO DISTINCT ROWS BY [\"item_id\"]\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER SORTED BY [O.Q DESC, I.IID]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n            SERVER AGGREGATE INTO DISTINCT ROWS BY [\"item_id\"]\n        CLIENT MERGE SORT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER \"Join\".\"CustomerTable\" [*] - ['0000000005']\n    SERVER SORTED BY [C.CID, QO.INAME]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"OrderTable\"\n            SERVER FILTER BY \"order_id\" != '000000000000003'\n            PARALLEL INNER-JOIN TABLE 0\n                CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n                    SERVER FILTER BY \"NAME\" != 'T3'\n                CLIENT MERGE SORT\n                    PARALLEL LEFT-JOIN TABLE 0\n                        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"SupplierTable\"", "CLIENT SERIAL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"\n    SERVER 4 ROW LIMIT\nCLIENT 4 ROW LIMIT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        CLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 1(DELAYED EVALUATION)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n    JOIN-SCANNER 4 ROW LIMIT", "CLIENT PARALLEL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"\nCLIENT 4 ROW LIMIT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        CLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 1(DELAYED EVALUATION)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n    DYNAMIC SERVER FILTER BY \"S.supplier_id\" IN (\"I.0:supplier_id\")\n    JOIN-SCANNER 4 ROW LIMIT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT\nCLIENT 4 ROW LIMIT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n    DYNAMIC SERVER FILTER BY \"I.:item_id\" IN (\"O.item_id\")\n    JOIN-SCANNER 4 ROW LIMIT", "CLIENT SERIAL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"\n    SERVER OFFSET 2\n    SERVER 3 ROW LIMIT\nCLIENT 1 ROW LIMIT\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        CLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 1(DELAYED EVALUATION)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n    JOIN-SCANNER 3 ROW LIMIT", "CLIENT SERIAL 1-WAY FULL SCAN OVER \"Join\".\"SupplierTable\"\n    SERVER OFFSET 2\nCLIENT 1 ROW LIMIT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1]\n        CLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 1(DELAYED EVALUATION)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + "\"Join\".\"OrderTable\"" + "\n    DYNAMIC SERVER FILTER BY \"S.supplier_id\" IN (\"I.0:supplier_id\")\n    JOIN-SCANNER 3 ROW LIMIT", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1,'S1']\n    SERVER MERGE [0.PHONE]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1,*] - [1,'T6']\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"S.:supplier_id\" IN (\"I.0:supplier_id\")", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1,'S1']\n    SERVER MERGE [0.PHONE]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"S.PHONE\"]\nCLIENT MERGE SORT\n    PARALLEL INNER-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1,*] - [1,'T6']\n        CLIENT MERGE SORT\n    DYNAMIC SERVER FILTER BY \"S.:supplier_id\" IN (\"I.0:supplier_id\")", "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_SUPPLIER_INDEX_FULL_NAME + "(" + "\"Join\".\"SupplierTable\"" + ") [1,*] - [1,'S3']\n    SERVER MERGE [0.PHONE]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW\n    PARALLEL LEFT-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + JOIN_ITEM_INDEX_FULL_NAME + "(" + "\"Join\".\"ItemTable\"" + ") [1,*] - [1,'T6']\n        CLIENT MERGE SORT"}});
        return testCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJoinWithLocalIndex() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(HashJoinLocalIndexIT.getUrl(), props);){
            String query = "select phone, i.name from " + this.getTableName(conn, "\"Join\".\"SupplierTable\"") + " s join " + this.getTableName(conn, "\"Join\".\"ItemTable\"") + " i on s.\"supplier_id\" = i.\"supplier_id\" where s.name = 'S1' and i.name < 'T6'";
            System.out.println("1)\n" + query);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"888-888-1111");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"888-888-1111");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            this.assertPlansEqual(this.plans[24], QueryUtil.getExplainPlan((ResultSet)rs));
            query = "select phone, max(i.name) from " + this.getTableName(conn, "\"Join\".\"SupplierTable\"") + " s join " + this.getTableName(conn, "\"Join\".\"ItemTable\"") + " i on s.\"supplier_id\" = i.\"supplier_id\" where s.name = 'S1' and i.name < 'T6' group by phone";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"888-888-1111");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T2");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            this.assertPlansEqual(this.plans[25], QueryUtil.getExplainPlan((ResultSet)rs));
            query = "select max(phone), max(i.name) from " + this.getTableName(conn, "\"Join\".\"SupplierTable\"") + " s left join " + this.getTableName(conn, "\"Join\".\"ItemTable\"") + " i on s.\"supplier_id\" = i.\"supplier_id\" and i.name < 'T6' where s.name <= 'S3'";
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)rs.getString(1), (Object)"888-888-3333");
            Assert.assertEquals((Object)rs.getString(2), (Object)"T4");
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            this.assertPlansEqual(this.plans[26], QueryUtil.getExplainPlan((ResultSet)rs));
        }
    }
}

