/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index.txn;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class RollbackIT
extends ParallelStatsDisabledIT {
    private final boolean localIndex;
    private final String tableDDLOptions;

    public RollbackIT(boolean localIndex, boolean mutable, String transactionProvider) {
        this.localIndex = localIndex;
        StringBuilder optionBuilder = new StringBuilder();
        optionBuilder.append(" TRANSACTION_PROVIDER='" + transactionProvider + "'");
        if (!mutable) {
            optionBuilder.append(",IMMUTABLE_ROWS=true");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.table.istransactional.default", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(RollbackIT.getUrl(), props);
        return conn;
    }

    @Parameterized.Parameters(name="RollbackIT_localIndex={0},mutable={1},transactionProvider={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, "OMID"}, {false, true, "OMID"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackOfUncommittedKeyValueIndexInsert() throws Exception {
        String tableName = "TBL_" + RollbackIT.generateUniqueName();
        String indexName = "IDX_" + RollbackIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        conn.setAutoCommit(false);
        try (Connection conn = RollbackIT.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE(v2)");
            stmt.executeUpdate("upsert into " + fullTableName + " values('x', 'y', 'a')");
            ResultSet rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName + ")*/ k, v1, v2  from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName + ")*/ k, v1, v2 from " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackOfUncommittedRowKeyIndexInsert() throws Exception {
        Connection conn = RollbackIT.getConnection();
        conn.setAutoCommit(false);
        String tableName = "TBL_" + RollbackIT.generateUniqueName();
        String indexName = "IDX_" + RollbackIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + "(k VARCHAR, v1 VARCHAR, v2 VARCHAR, CONSTRAINT pk PRIMARY KEY (v1, v2))" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? "LOCAL " : "") + "INDEX " + indexName + " ON " + fullTableName + "(v1, k)");
            stmt.executeUpdate("upsert into " + fullTableName + " values('x', 'y', 'a')");
            ResultSet rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName + ")*/ k, v1 from " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName + ")*/ k, v1 from " + fullTableName);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }
}

