/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index.txn;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class MutableRollbackIT
extends ParallelStatsDisabledIT {
    private final boolean localIndex;
    private final String tableDDLOptions;

    public MutableRollbackIT(boolean localIndex, String transactionProvider) {
        this.localIndex = localIndex;
        this.tableDDLOptions = " TRANSACTION_PROVIDER='" + transactionProvider + "'";
    }

    @Parameterized.Parameters(name="MutableRollbackIT_localIndex={0},transactionProvider={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{false, "OMID"}});
    }

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.put("phoenix.table.istransactional.default", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(MutableRollbackIT.getUrl(), props);
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRollbackOfUncommittedExistingKeyValueIndexUpdate() throws Exception {
        Connection conn = MutableRollbackIT.getConnection();
        String tableName1 = "TBL1_" + MutableRollbackIT.generateUniqueName();
        String indexName1 = "IDX1_" + MutableRollbackIT.generateUniqueName();
        String fullTableName1 = SchemaUtil.getTableName((String)"S", (String)tableName1);
        String tableName2 = "TBL2_" + MutableRollbackIT.generateUniqueName();
        String indexName2 = "IDX2_" + MutableRollbackIT.generateUniqueName();
        String fullTableName2 = SchemaUtil.getTableName((String)"S", (String)tableName2);
        conn.setAutoCommit(false);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName1 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE TABLE " + fullTableName2 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) IMMUTABLE_ROWS=true," + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName1 + " ON " + fullTableName1 + " (v1) INCLUDE(v2)");
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName2 + " ON " + fullTableName2 + " (v1) INCLUDE(v2)");
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'y', 'a')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'y', 'b')");
            stmt.executeUpdate("upsert into " + fullTableName2 + " values('a', 'b', 'c')");
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((Object)"c", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'z', 'a')");
            stmt.executeUpdate("upsert into " + fullTableName2 + " values('a', 'b', 'c')");
            conn.commit();
            this.assertDataAndIndexRows(stmt, fullTableName1, fullTableName2, indexName1);
            stmt.executeUpdate("delete from " + fullTableName1 + " where  k='x'");
            stmt.executeUpdate("delete from " + fullTableName2 + " where  v1='b'");
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName1);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            this.assertDataAndIndexRows(stmt, fullTableName1, fullTableName2, indexName1);
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRollbackOfUncommittedExistingRowKeyIndexUpdate() throws Exception {
        String tableName1 = "TBL1_" + MutableRollbackIT.generateUniqueName();
        String indexName1 = "IDX1_" + MutableRollbackIT.generateUniqueName();
        String fullTableName1 = SchemaUtil.getTableName((String)"S", (String)tableName1);
        String tableName2 = "TBL2_" + MutableRollbackIT.generateUniqueName();
        String indexName2 = "IDX2_" + MutableRollbackIT.generateUniqueName();
        String fullTableName2 = SchemaUtil.getTableName((String)"S", (String)tableName2);
        conn.setAutoCommit(false);
        try (Connection conn = MutableRollbackIT.getConnection();){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName1 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE TABLE " + fullTableName2 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) IMMUTABLE_ROWS=true," + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName1 + " ON " + fullTableName1 + " (v1, k)");
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName2 + " ON " + fullTableName2 + " (v1, k)");
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'y', 'a')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'z', 'a')");
            stmt.executeUpdate("upsert into " + fullTableName2 + " values('a', 'b', 'c')");
            this.assertDataAndIndexRows(stmt, fullTableName1, fullTableName2, indexName1);
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'z', 'a')");
            stmt.executeUpdate("upsert into " + fullTableName2 + " values('a', 'b', 'c')");
            conn.commit();
            this.assertDataAndIndexRows(stmt, fullTableName1, fullTableName2, indexName1);
            stmt.executeUpdate("delete from " + fullTableName1 + " where  k='x'");
            stmt.executeUpdate("delete from " + fullTableName2 + " where  v1='b'");
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName2 + ")*/ k, v1 from " + fullTableName2);
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            this.assertDataAndIndexRows(stmt, fullTableName1, fullTableName2, indexName1);
        }
    }

    private void assertDataAndIndexRows(Statement stmt, String fullTableName1, String fullTableName2, String indexName1) throws SQLException, IOException {
        ResultSet rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        Assert.assertEquals((Object)"z", (Object)rs.getString(2));
        Assert.assertEquals((Object)"a", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1, v2 from " + fullTableName1);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        Assert.assertEquals((Object)"z", (Object)rs.getString(2));
        Assert.assertEquals((Object)"a", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select /*+ NO_INDEX */ k, v1, v2 from " + fullTableName2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertEquals((Object)"c", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName2);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"b", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiRollbackOfUncommittedExistingRowKeyIndexUpdate() throws Exception {
        Connection conn = MutableRollbackIT.getConnection();
        String tableName1 = "TBL1_" + MutableRollbackIT.generateUniqueName();
        String indexName1 = "IDX1_" + MutableRollbackIT.generateUniqueName();
        String fullTableName1 = SchemaUtil.getTableName((String)"S", (String)tableName1);
        conn.setAutoCommit(false);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName1 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName1 + " ON " + fullTableName1 + " (v1, k)");
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'yyyy', 'a')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'zzz', 'a')");
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"zzz", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"zzz", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'zz', 'a')");
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"zz", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"zz", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"yyyy", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointAndRollback() throws Exception {
        Connection conn = MutableRollbackIT.getConnection();
        String tableName1 = "TBL1_" + MutableRollbackIT.generateUniqueName();
        String indexName1 = "IDX1_" + MutableRollbackIT.generateUniqueName();
        String fullTableName1 = SchemaUtil.getTableName((String)"S", (String)tableName1);
        conn.setAutoCommit(false);
        try {
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName1 + "(k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? " LOCAL " : "") + "INDEX " + indexName1 + " ON " + fullTableName1 + " (v1)");
            stmt.executeUpdate("upsert into " + fullTableName1 + " values('x', 'a', 'a')");
            conn.commit();
            stmt.executeUpdate("upsert into " + fullTableName1 + "(k,v1) SELECT k,v1||'a' FROM " + fullTableName1);
            ResultSet rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aa", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aa", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + fullTableName1 + "(k,v1) SELECT k,v1||'a' FROM " + fullTableName1);
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"aaa", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.rollback();
            rs = stmt.executeQuery("select k, v1, v2 from " + fullTableName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select /*+ INDEX(" + indexName1 + ")*/ k, v1 from " + fullTableName1 + " ORDER BY v1");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    private void dropTable(Admin admin, Connection conn, String tableName) throws SQLException, IOException {
        conn.createStatement().execute("DROP TABLE IF EXISTS " + tableName);
        if (admin.tableExists(TableName.valueOf((String)tableName))) {
            admin.disableTable(TableName.valueOf((String)tableName));
            admin.deleteTable(TableName.valueOf((String)tableName));
        }
    }
}

