/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ViewIndexIT
extends SplitSystemCatalogIT {
    private boolean isNamespaceMapped;

    @Parameterized.Parameters(name="ViewIndexIT_isNamespaceMapped={0}")
    public static synchronized Collection<Boolean> data() {
        return Arrays.asList(true, false);
    }

    public ViewIndexIT(boolean isNamespaceMapped) {
        this.isNamespaceMapped = isNamespaceMapped;
    }

    @Test
    public void testDroppingColumnWhileCreatingIndex() throws Exception {
        String schemaName = "S1";
        String tableName = ViewIndexIT.generateUniqueName();
        String viewSchemaName = "S1";
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String indexName = "IND_" + ViewIndexIT.generateUniqueName();
        String viewName = "VIEW_" + ViewIndexIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)viewSchemaName, (String)viewName);
        try (PhoenixConnection conn = this.getConnection();){
            conn.setAutoCommit(true);
            this.createBaseTable((Connection)conn, schemaName, tableName, false, null, null, true);
            conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName);
            conn.commit();
            AtomicInteger exceptionCode = new AtomicInteger();
            CountDownLatch doneSignal = new CountDownLatch(2);
            Runnable r1 = new Runnable((Connection)conn, indexName, fullViewName, exceptionCode, doneSignal){
                final /* synthetic */ Connection val$conn;
                final /* synthetic */ String val$indexName;
                final /* synthetic */ String val$fullViewName;
                final /* synthetic */ AtomicInteger val$exceptionCode;
                final /* synthetic */ CountDownLatch val$doneSignal;
                {
                    this.val$conn = connection;
                    this.val$indexName = string;
                    this.val$fullViewName = string2;
                    this.val$exceptionCode = atomicInteger;
                    this.val$doneSignal = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        this.val$conn.createStatement().execute("CREATE INDEX " + this.val$indexName + " ON " + this.val$fullViewName + " (v1)");
                    }
                    catch (SQLException e) {
                        this.val$exceptionCode.set(e.getErrorCode());
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.val$doneSignal.countDown();
                    }
                }
            };
            Runnable r2 = new Runnable((Connection)conn, fullTableName, exceptionCode, doneSignal){
                final /* synthetic */ Connection val$conn;
                final /* synthetic */ String val$fullTableName;
                final /* synthetic */ AtomicInteger val$exceptionCode;
                final /* synthetic */ CountDownLatch val$doneSignal;
                {
                    this.val$conn = connection;
                    this.val$fullTableName = string;
                    this.val$exceptionCode = atomicInteger;
                    this.val$doneSignal = countDownLatch;
                }

                @Override
                public void run() {
                    try {
                        this.val$conn.createStatement().execute("ALTER TABLE " + this.val$fullTableName + " DROP COLUMN v1");
                    }
                    catch (SQLException e) {
                        this.val$exceptionCode.set(e.getErrorCode());
                        throw new RuntimeException(e);
                    }
                    finally {
                        this.val$doneSignal.countDown();
                    }
                }
            };
            Thread t1 = new Thread(r1);
            t1.start();
            Thread t2 = new Thread(r2);
            t2.start();
            t1.join();
            t2.join();
            doneSignal.await(60L, TimeUnit.SECONDS);
            Assert.assertEquals((long)exceptionCode.get(), (long)301L);
        }
    }

    private PhoenixConnection getConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        return (PhoenixConnection)DriverManager.getConnection(ViewIndexIT.getUrl(), props);
    }

    private Connection getTenantConnection(String tenant) throws SQLException {
        Properties props = new Properties();
        props.setProperty("TenantId", tenant);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        return DriverManager.getConnection(ViewIndexIT.getUrl(), props);
    }

    @Test
    public void testDeleteViewIndexSequences() throws Exception {
        String schemaName = ViewIndexIT.generateUniqueName();
        String tableName = ViewIndexIT.generateUniqueName();
        String viewSchemaName = ViewIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String indexName = "IND_" + ViewIndexIT.generateUniqueName();
        String viewName = "VIEW_" + ViewIndexIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)viewSchemaName, (String)viewName);
        try (PhoenixConnection conn1 = this.getConnection();
             PhoenixConnection conn2 = this.getConnection();){
            this.createBaseTable((Connection)conn1, schemaName, tableName, false, null, null, true);
            if (this.isNamespaceMapped) {
                conn1.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + viewSchemaName);
            }
            conn1.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName);
            conn1.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullViewName + " (v1)");
            conn2.createStatement().executeQuery("SELECT * FROM " + fullTableName).next();
            String sequenceName = MetaDataUtil.getViewIndexSequenceName((PName)PNameFactory.newName((String)fullTableName), null, (boolean)this.isNamespaceMapped);
            String sequenceSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName((PName)PNameFactory.newName((String)fullTableName), (boolean)this.isNamespaceMapped);
            ViewIndexIT.verifySequenceValue(null, sequenceName, sequenceSchemaName, -32767L);
            conn1.createStatement().execute("CREATE INDEX " + indexName + "_2 ON " + fullViewName + " (v1)");
            ViewIndexIT.verifySequenceValue(null, sequenceName, sequenceSchemaName, -32766L);
            conn1.createStatement().execute("DROP VIEW " + fullViewName);
            conn1.createStatement().execute("DROP TABLE " + fullTableName);
            ViewIndexIT.verifySequenceNotExists(null, sequenceName, sequenceSchemaName);
        }
    }

    @Test
    public void testMultiTenantViewLocalIndex() throws Exception {
        String tableName = ViewIndexIT.generateUniqueName();
        String indexName = "IND_" + ViewIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIndexIT.generateUniqueName());
        String fullIndexName = SchemaUtil.getTableName((String)SCHEMA2, (String)indexName);
        try (PhoenixConnection conn = this.getConnection();
             Connection conn1 = this.getTenantConnection("10");){
            this.createBaseTable((Connection)conn, SCHEMA1, tableName, true, null, null, true);
            if (this.isNamespaceMapped) {
                conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + SCHEMA2);
            }
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?,?,?)");
            stmt.setString(1, "10");
            stmt.setString(2, "a");
            stmt.setInt(3, 1);
            stmt.setString(4, "x1");
            stmt.setInt(5, 100);
            stmt.execute();
            stmt.setString(1, "10");
            stmt.setString(2, "b");
            stmt.setInt(3, 2);
            stmt.setString(4, "x2");
            stmt.setInt(5, 200);
            stmt.execute();
            stmt.setString(1, "10");
            stmt.setString(2, "c");
            stmt.setInt(3, 3);
            stmt.setString(4, "x3");
            stmt.setInt(5, 300);
            stmt.execute();
            stmt.setString(1, "20");
            stmt.setString(2, "d");
            stmt.setInt(3, 4);
            stmt.setString(4, "x4");
            stmt.setInt(5, 400);
            stmt.execute();
            conn.commit();
            conn1.createStatement().execute("CREATE VIEW " + fullViewName + " AS select * from " + fullTableName);
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + fullViewName + "(v2)");
            conn1.commit();
            String sql = "SELECT * FROM " + fullViewName + " WHERE v2 = 100";
            ResultSet rs = conn1.prepareStatement("EXPLAIN " + sql).executeQuery();
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)fullTableName), (boolean)this.isNamespaceMapped) + ") [1,'10',100]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.prepareStatement(sql).executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            TestUtil.analyzeTable((Connection)conn, fullTableName);
            List<KeyRange> guideposts = TestUtil.getAllSplits((Connection)conn, fullTableName);
            Assert.assertEquals((long)1L, (long)guideposts.size());
            Assert.assertEquals((Object)KeyRange.EVERYTHING_RANGE, (Object)guideposts.get(0));
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET " + "GUIDE_POSTS_WIDTH" + "=20");
            TestUtil.analyzeTable((Connection)conn, fullTableName);
            guideposts = TestUtil.getAllSplits((Connection)conn, fullTableName);
            Assert.assertEquals((long)5L, (long)guideposts.size());
            sql = "SELECT * FROM " + fullViewName + " WHERE v2 >= 100";
            rs = conn1.prepareStatement("EXPLAIN " + sql).executeQuery();
            stmt = conn1.prepareStatement(sql);
            stmt.executeQuery();
            QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((long)4L, (long)plan.getSplits().size());
        }
    }

    @Test
    public void testCoprocsOnGlobalMTImmutableViewIndex() throws Exception {
        this.testCoprocsOnGlobalViewIndexHelper(true, false);
    }

    @Test
    public void testCoprocsOnGlobalNonMTMutableViewIndex() throws Exception {
        this.testCoprocsOnGlobalViewIndexHelper(false, true);
    }

    @Test
    public void testCoprocsOnGlobalMTMutableViewIndex() throws Exception {
        this.testCoprocsOnGlobalViewIndexHelper(true, true);
    }

    @Test
    public void testCoprocsOnGlobalNonMTImmutableViewIndex() throws Exception {
        this.testCoprocsOnGlobalViewIndexHelper(false, false);
    }

    private void testCoprocsOnGlobalViewIndexHelper(boolean multiTenant, boolean mutable) throws SQLException, IOException {
        String schemaName = ViewIndexIT.generateUniqueName();
        String baseTable = ViewIndexIT.generateUniqueName();
        String globalView = ViewIndexIT.generateUniqueName();
        String globalViewIdx = ViewIndexIT.generateUniqueName();
        try (PhoenixConnection conn = this.getConnection();){
            this.createBaseTable((Connection)conn, schemaName, baseTable, multiTenant, null, null, mutable);
            this.createView((Connection)conn, schemaName, globalView, baseTable);
            this.createViewIndex((Connection)conn, schemaName, globalViewIdx, globalView, "K1");
            Admin admin = conn.getQueryServices().getAdmin();
            TableDescriptor td = admin.getDescriptor(TableName.valueOf((String)MetaDataUtil.getViewIndexPhysicalName((String)SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)baseTable, (boolean)this.isNamespaceMapped).getString())));
            Assert.assertTrue((boolean)td.hasCoprocessor(GlobalIndexChecker.class.getName()));
            Assert.assertFalse((boolean)td.hasCoprocessor(IndexRegionObserver.class.getName()));
            Assert.assertFalse((boolean)td.hasCoprocessor(Indexer.class.getName()));
        }
    }

    @Test
    public void testMultiTenantViewGlobalIndex() throws Exception {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIndexIT.generateUniqueName());
        String globalViewName = ViewIndexIT.generateUniqueName();
        String fullGlobalViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)globalViewName);
        String globalViewIdx = ViewIndexIT.generateUniqueName();
        String tenantView = ViewIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)SCHEMA2, (String)globalViewIdx);
        try (Connection conn = DriverManager.getConnection(ViewIndexIT.getUrl());){
            PreparedStatement stmt;
            conn.createStatement().execute("CREATE TABLE " + baseTable + " (TENANT_ID CHAR(15) NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR, KV2 VARCHAR, KV3 CHAR(15) CONSTRAINT PK PRIMARY KEY(TENANT_ID, PK2, PK3)) MULTI_TENANT=true");
            conn.createStatement().execute("CREATE VIEW " + fullGlobalViewName + " AS SELECT * FROM " + baseTable);
            conn.createStatement().execute("CREATE INDEX " + globalViewIdx + " ON " + fullGlobalViewName + " (PK3 DESC, KV3) INCLUDE (KV1) ASYNC");
            String tenantId = "tenantId";
            Properties tenantProps = new Properties();
            tenantProps.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(ViewIndexIT.getUrl(), tenantProps);){
                tenantConn.createStatement().execute("CREATE VIEW " + tenantView + " AS SELECT * FROM " + fullGlobalViewName);
                stmt = tenantConn.prepareStatement("UPSERT INTO  " + fullGlobalViewName + " (PK2, PK3, KV1, KV3) VALUES (?, ?, ?, ?)");
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 1);
                stmt.setString(3, "KV1");
                stmt.setString(4, "KV3");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 2);
                stmt.setString(3, "KV4");
                stmt.setString(4, "KV5");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 3);
                stmt.setString(3, "KV6");
                stmt.setString(4, "KV7");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 4);
                stmt.setString(3, "KV8");
                stmt.setString(4, "KV9");
                stmt.executeUpdate();
                stmt.setDate(1, new Date(100L));
                stmt.setInt(2, 5);
                stmt.setString(3, "KV10");
                stmt.setString(4, "KV11");
                stmt.executeUpdate();
                tenantConn.commit();
            }
            IndexToolIT.runIndexTool(false, SCHEMA2, globalViewName, globalViewIdx);
            tenantConn = DriverManager.getConnection(ViewIndexIT.getUrl(), tenantProps);
            var12_14 = null;
            try {
                stmt = tenantConn.prepareStatement("SELECT KV1 FROM  " + tenantView + " WHERE PK3 = ? AND KV3 = ?");
                stmt.setInt(1, 1);
                stmt.setString(2, "KV3");
                ResultSet rs = stmt.executeQuery();
                QueryPlan plan = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertEquals((Object)fullIndexName, (Object)plan.getTableRef().getTable().getName().getString());
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable stmt2) {
                var12_14 = stmt2;
                throw stmt2;
            }
            finally {
                if (tenantConn != null) {
                    if (var12_14 != null) {
                        try {
                            tenantConn.close();
                        }
                        catch (Throwable stmt2) {
                            var12_14.addSuppressed(stmt2);
                        }
                    } else {
                        tenantConn.close();
                    }
                }
            }
            PreparedStatement stmt3 = conn.prepareStatement("SELECT KV1 FROM  " + fullGlobalViewName + " WHERE PK3 = ? AND KV3 = ?");
            stmt3.setInt(1, 1);
            stmt3.setString(2, "KV3");
            ResultSet rs = stmt3.executeQuery();
            QueryPlan plan = stmt3.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((Object)fullIndexName, (Object)plan.getTableRef().getTable().getName().getString());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"KV1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            TestUtil.analyzeTable(conn, baseTable);
            List<KeyRange> guideposts = TestUtil.getAllSplits(conn, baseTable);
            Assert.assertEquals((long)1L, (long)guideposts.size());
            Assert.assertEquals((Object)KeyRange.EVERYTHING_RANGE, (Object)guideposts.get(0));
            conn.createStatement().execute("ALTER TABLE " + baseTable + " SET " + "GUIDE_POSTS_WIDTH" + "=20");
            TestUtil.analyzeTable(conn, baseTable);
            guideposts = TestUtil.getAllSplits(conn, baseTable);
            Assert.assertEquals((long)6L, (long)guideposts.size());
            stmt3 = conn.prepareStatement("SELECT KV1 FROM  " + fullGlobalViewName + " WHERE PK3 = ? AND KV3 >= ?");
            stmt3.setInt(1, 1);
            stmt3.setString(2, "KV3");
            rs = stmt3.executeQuery();
            plan = stmt3.unwrap(PhoenixStatement.class).getQueryPlan();
            Assert.assertEquals((Object)fullIndexName, (Object)plan.getTableRef().getTable().getName().getString());
            Assert.assertEquals((long)6L, (long)plan.getSplits().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRowKeyComposition() throws Exception {
        Long int1 = 1792L;
        String text2 = "text2";
        BigDecimal double1 = BigDecimal.valueOf(254.564);
        IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
        try (Connection conn = DriverManager.getConnection(ViewIndexIT.getUrl());){
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1", "TEXT1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1, TEXT4", "TEXT1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1", "DATE_TIME1, LAST_UPDATE, TEXT1, INT1, DATE_TIME2, INT2", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1", "DATE_TIME1, LAST_UPDATE, INT1, TEXT1, INT2, PHONE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT1, TEXT3, INT1", "TEXT1, TEXT4, EMAIL1 DESC, DATE_TIME1 DESC, DOUBLE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT1, TEXT3, INT1", "TEXT1, TEXT4, EMAIL1, DATE_TIME1 DESC, DOUBLE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT1, INT1", "TEXT1, DATE_TIME1 DESC, DOUBLE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT1, INT1", "TEXT1, DATE_TIME1 DESC, INT1, DOUBLE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1, EMAIL1", "TEXT1, DATE_TIME1 DESC, DOUBLE1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1", "TEXT1 DESC", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1 DESC", "TEXT1 DESC", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, INT1 DESC", "TEXT1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT3 DESC, INT1 DESC, TEXT2, TEXT4 DESC", "TEXT1, DOUBLE1 DESC", "TEXT2", text2);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1, TEXT3 DESC, INT1 DESC, TEXT2 DESC, TEXT4 DESC", "TEXT1 DESC, DOUBLE1 DESC", "TEXT2", text2);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1 DESC, TEXT3 DESC, INT1, DOUBLE1 DESC", "TEXT1", "DOUBLE1", double1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1 DESC, TEXT3 DESC, INT1, TEXT4, EMAIL1", "TEXT1", "INT1", int1);
            this.createTableForRowKeyTestsAndVerify(conn, "DATE_TIME1 DESC, TEXT3, INT1, EMAIL1", "TEXT1, TEXT4", "INT1", int1);
        }
        finally {
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    private void createTableForRowKeyTestsAndVerify(Connection conn, String viewPkColumns, String indexPKColumns, String lastViewPKCol, Object lastColExpectedVal) throws Exception {
        String fullTableName = "TBL_" + ViewIndexIT.generateUniqueName();
        String fullViewName = "VW_" + ViewIndexIT.generateUniqueName();
        String fullIndexName = "IDX_" + ViewIndexIT.generateUniqueName();
        String keyPrefix = "9Ab";
        String tableDdl = String.format("CREATE TABLE IF NOT EXISTS %s    (ORGANIZATION_ID CHAR(15) NOT NULL, KEY_PREFIX CHAR(3) NOT NULL, LAST_UPDATE DATE NOT NULL   CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, KEY_PREFIX, LAST_UPDATE) )VERSIONS=1, IMMUTABLE_ROWS=%s, MULTI_TENANT=%s, REPLICATION_SCOPE=1, IMMUTABLE_STORAGE_SCHEME=ONE_CELL_PER_COLUMN, COLUMN_ENCODED_BYTES=0", fullTableName, this.isNamespaceMapped ? "true" : "false", this.isNamespaceMapped ? "true" : "false");
        String viewDdl = String.format("CREATE VIEW IF NOT EXISTS %s (DATE_TIME1 DATE NOT NULL, TEXT1 VARCHAR, TEXT3 VARCHAR, INT1 BIGINT NOT NULL, DATE_TIME2 DATE, DATE_TIME3 DATE, INT2 BIGINT, INT3 INTEGER, DOUBLE1 DECIMAL(12, 3), DOUBLE2 DECIMAL(12, 3), DOUBLE3 DECIMAL(12, 3), TEXT2 VARCHAR, TEXT4 VARCHAR, EMAIL1 VARCHAR, PHONE1 CHAR(10), URL1 VARCHAR CONSTRAINT PKVIEW PRIMARY KEY (%s)) AS SELECT * FROM %s WHERE KEY_PREFIX = '%s'", fullViewName, viewPkColumns, fullTableName, keyPrefix);
        String indexDdl = String.format("CREATE INDEX IF NOT EXISTS %s ON %s (%s)\nINCLUDE (DOUBLE3, DOUBLE2, DATE_TIME3, TEXT2, URL1, INT3  )", fullIndexName, fullViewName, indexPKColumns);
        conn.createStatement().execute(tableDdl);
        conn.createStatement().execute(viewDdl);
        conn.createStatement().execute(indexDdl);
        String childViewNameSchema = String.format("S_%s", ViewIndexIT.generateUniqueName());
        String childViewName = String.format("%s.\"%s\"", childViewNameSchema, keyPrefix);
        String viewChildDDl = String.format("CREATE VIEW IF NOT EXISTS %s AS SELECT * FROM %s", childViewName, fullViewName);
        Connection conn2 = null;
        if (this.isNamespaceMapped) {
            conn2 = this.getTenantConnection(TENANT1);
            conn2.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + childViewNameSchema);
        } else {
            conn2 = conn;
        }
        conn2.createStatement().execute(viewChildDDl);
        int int1 = 1792;
        String upsert = "UPSERT INTO " + childViewName + "(DATE_TIME1, INT1, TEXT1, TEXT2, DOUBLE1, DATE_TIME2, DATE_TIME3, INT3, DOUBLE2, DOUBLE3, TEXT3, TEXT4, EMAIL1, PHONE1, URL1, INT2, LAST_UPDATE" + (this.isNamespaceMapped ? ") " : ",ORGANIZATION_ID) ") + " VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?" + (this.isNamespaceMapped ? ")" : ",?)");
        PreparedStatement upsertStmt = conn2.prepareStatement(upsert);
        Date date = Date.valueOf("2019-02-17");
        upsertStmt.setDate(1, date);
        upsertStmt.setInt(2, int1);
        upsertStmt.setString(3, "text1");
        upsertStmt.setString(4, "text2");
        upsertStmt.setDouble(5, 254.564);
        upsertStmt.setDate(6, null);
        upsertStmt.setDate(7, Date.valueOf("2019-07-16"));
        upsertStmt.setInt(8, int1);
        upsertStmt.setDouble(9, 4.09);
        upsertStmt.setDouble(10, 0.249);
        upsertStmt.setString(11, "text3");
        upsertStmt.setString(12, null);
        upsertStmt.setString(13, "VScZBIjkO3QyUCMtkUEgmvL9xH0KJjwKi1gpxRv1ghonWcUMoksTWFKR4SD2yUg9@gmail.com");
        upsertStmt.setString(14, null);
        upsertStmt.setString(15, "https://www.sssssss.com");
        upsertStmt.setNull(16, -5);
        upsertStmt.setDate(17, Date.valueOf("2019-07-16"));
        if (!this.isNamespaceMapped) {
            upsertStmt.setString(18, TENANT1);
        }
        upsertStmt.executeUpdate();
        conn2.commit();
        String select = "SELECT " + lastViewPKCol + " FROM " + childViewName + "  WHERE TEXT1='text1' LIMIT 10";
        ResultSet rs1 = conn2.createStatement().executeQuery("EXPLAIN " + select);
        String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs1);
        Assert.assertTrue((boolean)actualExplainPlan.contains("_IDX_" + fullTableName));
        ResultSet rs = conn2.createStatement().executeQuery(select);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)lastColExpectedVal, (Object)rs.getObject(1));
    }

    private void assertRowCount(Connection conn, String fullTableName, String fullBaseName, int expectedCount) throws SQLException {
        PhoenixStatement stmt = conn.createStatement().unwrap(PhoenixStatement.class);
        ResultSet rs = stmt.executeQuery("SELECT COUNT(*) FROM " + fullTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)expectedCount, (long)rs.getInt(1));
        rs = stmt.executeQuery("EXPLAIN SELECT COUNT(*) FROM " + fullTableName);
        if (fullBaseName != null) {
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)rs).startsWith("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName((byte[])Bytes.toBytes((String)fullBaseName)))));
        }
        rs = stmt.executeQuery("SELECT /*+ NO_INDEX */ * FROM " + fullTableName);
        int count = 0;
        while (rs.next()) {
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
        Assert.assertEquals((Object)fullTableName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
    }

    @Test
    public void testUpdateOnTenantViewWithGlobalView() throws Exception {
        try (PhoenixConnection conn = this.getConnection();){
            String baseSchemaName = ViewIndexIT.generateUniqueName();
            String viewSchemaName = ViewIndexIT.generateUniqueName();
            String tsViewSchemaName = ViewIndexIT.generateUniqueName();
            String baseTableName = ViewIndexIT.generateUniqueName();
            String baseFullName = SchemaUtil.getTableName((String)baseSchemaName, (String)baseTableName);
            String viewTableName = "V_" + ViewIndexIT.generateUniqueName();
            String viewFullName = SchemaUtil.getTableName((String)viewSchemaName, (String)viewTableName);
            String indexName = "I_" + ViewIndexIT.generateUniqueName();
            String tsViewTableName = "TSV_" + ViewIndexIT.generateUniqueName();
            String tsViewFullName = SchemaUtil.getTableName((String)tsViewSchemaName, (String)tsViewTableName);
            String tenantId = "tenant1";
            Properties tsProps = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            tsProps.setProperty("TenantId", tenantId);
            try (Connection tsConn = DriverManager.getConnection(ViewIndexIT.getUrl(), tsProps);
                 Connection tsConn2 = DriverManager.getConnection(ViewIndexIT.getUrl(), tsProps);
                 Connection tsConn3 = DriverManager.getConnection(ViewIndexIT.getUrl(), tsProps);){
                if (this.isNamespaceMapped) {
                    conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + baseSchemaName);
                    conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + viewSchemaName);
                    conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + tsViewSchemaName);
                }
                conn.createStatement().execute("CREATE TABLE " + baseFullName + "(\n    ORGANIZATION_ID CHAR(15) NOT NULL,\n    KEY_PREFIX CHAR(3) NOT NULL,\n    CREATED_DATE DATE,\n    CREATED_BY CHAR(15),\n    CONSTRAINT PK PRIMARY KEY (\n        ORGANIZATION_ID,\n        KEY_PREFIX\n    )\n) VERSIONS=1, IMMUTABLE_ROWS=true, MULTI_TENANT=true");
                conn.createStatement().execute("CREATE VIEW " + viewFullName + " (\nINT1 BIGINT NOT NULL,\nDOUBLE1 DECIMAL(12, 3),\nIS_BOOLEAN BOOLEAN,\nTEXT1 VARCHAR,\nCONSTRAINT PKVIEW PRIMARY KEY\n(\nINT1\n)) AS SELECT * FROM " + baseFullName + " WHERE KEY_PREFIX = '123'");
                conn.createStatement().execute("CREATE INDEX " + indexName + " \nON " + viewFullName + " (TEXT1 DESC, INT1)\nINCLUDE (CREATED_BY, DOUBLE1, IS_BOOLEAN, CREATED_DATE)");
                tsConn.createStatement().execute("CREATE VIEW " + tsViewFullName + " AS SELECT * FROM " + viewFullName);
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (1,1.0, true, 'a')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (2,2.0, true, 'b')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (3,3.0, true, 'c')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (4,4.0, true, 'd')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (5,5.0, true, 'e')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (6,6.0, true, 'f')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (7,7.0, true, 'g')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (8,8.0, true, 'h')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (9,9.0, true, 'i')");
                tsConn.createStatement().execute("UPSERT INTO " + tsViewFullName + "(INT1,DOUBLE1,IS_BOOLEAN,TEXT1) VALUES (10,10.0, true, 'j')");
                tsConn.commit();
                String basePhysicalName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)baseFullName), (boolean)this.isNamespaceMapped).toString();
                this.assertRowCount(tsConn, tsViewFullName, basePhysicalName, 10);
                tsConn.createStatement().execute("DELETE FROM " + tsViewFullName + " WHERE TEXT1='d'");
                tsConn.commit();
                this.assertRowCount(tsConn, tsViewFullName, basePhysicalName, 9);
                tsConn.createStatement().execute("DELETE FROM " + tsViewFullName + " WHERE INT1=2");
                tsConn.commit();
                this.assertRowCount(tsConn, tsViewFullName, basePhysicalName, 8);
                tsConn2.createStatement().execute("DELETE FROM " + tsViewFullName + " WHERE DOUBLE1 > 7.5 AND DOUBLE1 < 9.5");
                tsConn2.commit();
                this.assertRowCount(tsConn2, tsViewFullName, basePhysicalName, 6);
                tsConn2.createStatement().execute("DROP VIEW " + tsViewFullName);
                conn.createStatement().execute("DROP VIEW " + viewFullName);
                conn.setAutoCommit(true);
                conn.createStatement().execute("DELETE FROM " + baseFullName);
                try {
                    tsConn3.createStatement().execute("SELECT * FROM " + tsViewFullName + " LIMIT 1");
                    Assert.fail((String)"Expected table not to be found");
                }
                catch (TableNotFoundException tableNotFoundException) {
                    // empty catch block
                }
                conn.createStatement().execute("CREATE VIEW " + viewFullName + " (\nINT1 BIGINT NOT NULL,\nDOUBLE1 DECIMAL(12, 3),\nIS_BOOLEAN BOOLEAN,\nTEXT1 VARCHAR,\nCONSTRAINT PKVIEW PRIMARY KEY\n(\nINT1\n)) AS SELECT * FROM " + baseFullName + " WHERE KEY_PREFIX = '123'");
                tsConn3.createStatement().execute("CREATE VIEW " + tsViewFullName + " AS SELECT * FROM " + viewFullName);
                conn.createStatement().execute("CREATE INDEX " + indexName + " \nON " + viewFullName + " (TEXT1 DESC, INT1)\nINCLUDE (CREATED_BY, DOUBLE1, IS_BOOLEAN, CREATED_DATE)");
                this.assertRowCount(tsConn3, tsViewFullName, basePhysicalName, 0);
            }
        }
    }

    @Test
    public void testHintForIndexOnViewWithInclude() throws Exception {
        this.testHintForIndexOnView(true);
    }

    @Ignore(value="PHOENIX-4274 Hint query for index on view does not use include")
    @Test
    public void testHintForIndexOnViewWithoutInclude() throws Exception {
        this.testHintForIndexOnView(false);
    }

    private void testHintForIndexOnView(boolean includeColumns) throws Exception {
        Properties props = new Properties();
        try (Connection conn1 = DriverManager.getConnection(ViewIndexIT.getUrl(), props);){
            conn1.setAutoCommit(true);
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIndexIT.generateUniqueName());
            String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIndexIT.generateUniqueName());
            String indexName = ViewIndexIT.generateUniqueName();
            String fullIndexName = SchemaUtil.getTableName((String)SCHEMA2, (String)indexName);
            conn1.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000");
            conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
            conn1.createStatement().execute("CREATE VIEW " + viewName + " (v3 VARCHAR, v4 VARCHAR) AS SELECT * FROM " + tableName + " WHERE v1 = 'value1'");
            conn1.createStatement().execute("CREATE INDEX " + indexName + " ON " + viewName + "(v3)" + (includeColumns ? " INCLUDE(v4)" : ""));
            PhoenixStatement stmt = conn1.createStatement().unwrap(PhoenixStatement.class);
            ResultSet rs = stmt.executeQuery("SELECT /*+ INDEX(" + viewName + " " + fullIndexName + ") */ v1 FROM " + viewName + " WHERE v3 = 'foo' ORDER BY v4");
            Assert.assertFalse((boolean)rs.next());
            Assert.assertEquals((Object)fullIndexName, (Object)stmt.getQueryPlan().getContext().getCurrentTable().getTable().getName().getString());
        }
    }

    @Test
    public void testCreatingIndexOnViewBuiltOnTableWithOnlyNamedColumnFamilies() throws Exception {
        String viewName;
        String tableName2;
        Throwable throwable;
        Statement s;
        try (PhoenixConnection c = this.getConnection();){
            s = c.createStatement();
            throwable = null;
            try {
                tableName2 = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewIndexIT.generateUniqueName());
                viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewIndexIT.generateUniqueName());
                String indexName = ViewIndexIT.generateUniqueName();
                c.setAutoCommit(true);
                if (this.isNamespaceMapped) {
                    c.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + SCHEMA1);
                    c.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + SCHEMA2);
                }
                s.execute("CREATE TABLE " + tableName2 + " (COL1 VARCHAR PRIMARY KEY, CF.COL2 VARCHAR)");
                s.executeUpdate("UPSERT INTO " + tableName2 + " VALUES ('AAA', 'BBB')");
                s.execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + tableName2);
                s.execute("CREATE INDEX " + indexName + " ON " + viewName + " (CF.COL2)");
                try (ResultSet rs = s.executeQuery("SELECT * FROM " + viewName + " WHERE CF.COL2 = 'BBB'");){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"AAA", (Object)rs.getString("COL1"));
                    Assert.assertEquals((Object)"BBB", (Object)rs.getString("COL2"));
                }
            }
            catch (Throwable tableName2) {
                throwable = tableName2;
                throw tableName2;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable tableName2) {
                            throwable.addSuppressed(tableName2);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        c = this.getConnection();
        var2_2 = null;
        try {
            s = c.createStatement();
            throwable = null;
            try {
                tableName2 = ViewIndexIT.generateUniqueName();
                viewName = ViewIndexIT.generateUniqueName();
                String index1Name = ViewIndexIT.generateUniqueName();
                String index2Name = ViewIndexIT.generateUniqueName();
                c.setAutoCommit(true);
                s.execute("create table " + tableName2 + " (i1 integer primary key, c2.i2 integer, c3.i3 integer, c4.i4 integer)");
                s.execute("create view " + viewName + " as select * from " + tableName2 + " where c2.i2 = 1");
                s.executeUpdate("upsert into " + viewName + "(i1, c3.i3, c4.i4) VALUES (1, 1, 1)");
                s.execute("create index " + index1Name + " ON " + viewName + " (c3.i3)");
                s.execute("create index " + index2Name + " ON " + viewName + " (c3.i3) include (c4.i4)");
                s.executeUpdate("upsert into " + viewName + "(i1, c3.i3, c4.i4) VALUES (2, 2, 2)");
                try (ResultSet rs = s.executeQuery("select * from " + viewName + " WHERE c3.i3 = 1");){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt("i1"));
                    Assert.assertEquals((long)1L, (long)rs.getInt("i2"));
                    Assert.assertEquals((long)1L, (long)rs.getInt("i3"));
                    Assert.assertEquals((long)1L, (long)rs.getInt("i4"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (s != null) {
                    if (throwable != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var2_2 = throwable4;
            throw throwable4;
        }
        finally {
            if (c != null) {
                if (var2_2 != null) {
                    try {
                        c.close();
                    }
                    catch (Throwable throwable5) {
                        var2_2.addSuppressed(throwable5);
                    }
                } else {
                    c.close();
                }
            }
        }
    }

    @Test
    public void testGlobalAndTenantViewIndexesHaveDifferentIndexIds() throws Exception {
        String tableName = "T_" + ViewIndexIT.generateUniqueName();
        String globalViewName = "V_" + ViewIndexIT.generateUniqueName();
        String tenantViewName = "TV_" + ViewIndexIT.generateUniqueName();
        String globalViewIndexName = "GV_" + ViewIndexIT.generateUniqueName();
        String tenantViewIndexName = "TV_" + ViewIndexIT.generateUniqueName();
        try (PhoenixConnection globalConn = this.getConnection();
             PhoenixConnection tenantConn = (PhoenixConnection)this.getTenantConnection(TENANT1);){
            this.createBaseTable((Connection)globalConn, SCHEMA1, tableName, true, 0, null, true);
            this.createView((Connection)globalConn, SCHEMA1, globalViewName, tableName);
            this.createViewIndex((Connection)globalConn, SCHEMA1, globalViewIndexName, globalViewName, "v1");
            this.createView((Connection)tenantConn, SCHEMA1, tenantViewName, tableName);
            this.createViewIndex((Connection)tenantConn, SCHEMA1, tenantViewIndexName, tenantViewName, "v2");
            PTable globalViewIndexTable = globalConn.getTable(SCHEMA1 + "." + globalViewIndexName);
            PTable tenantViewIndexTable = tenantConn.getTable(SCHEMA1 + "." + tenantViewIndexName);
            Assert.assertNotNull((Object)globalViewIndexTable);
            Assert.assertNotNull((Object)tenantViewIndexName);
            Assert.assertNotEquals((Object)globalViewIndexTable.getViewIndexId(), (Object)tenantViewIndexTable.getViewIndexId());
            globalConn.createStatement().execute("UPSERT INTO " + SchemaUtil.getTableName((String)SCHEMA1, (String)globalViewName) + " (T_ID, K1, K2) VALUES ('GLOBAL', 'k1', 100)");
            tenantConn.createStatement().execute("UPSERT INTO " + SchemaUtil.getTableName((String)SCHEMA1, (String)tenantViewName) + " (T_ID, K1, K2) VALUES ('TENANT', 'k1', 101)");
            Assert.assertEquals((long)1L, (long)this.getRowCountOfView((Connection)globalConn, SCHEMA1, globalViewIndexName));
            Assert.assertEquals((long)1L, (long)this.getRowCountOfView((Connection)tenantConn, SCHEMA1, tenantViewName));
        }
    }

    private int getRowCountOfView(Connection conn, String schemaName, String viewName) throws SQLException {
        int size = 0;
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + SchemaUtil.getTableName((String)schemaName, (String)viewName));
        while (rs.next()) {
            ++size;
        }
        return size;
    }

    @Test
    public void testIndexIdDataTypeDefaultValue() throws Exception {
        String tableName = "T_" + ViewIndexIT.generateUniqueName();
        String globalViewName = "V_" + ViewIndexIT.generateUniqueName();
        String globalViewIndexName = "GV_" + ViewIndexIT.generateUniqueName();
        try (PhoenixConnection globalConn = this.getConnection();){
            this.createBaseTable((Connection)globalConn, SCHEMA1, tableName, true, 0, null, true);
            this.createView((Connection)globalConn, SCHEMA1, globalViewName, tableName);
            this.createViewIndex((Connection)globalConn, SCHEMA1, globalViewIndexName, globalViewName, "v1");
            String sql = "SELECT VIEW_INDEX_ID_DATA_TYPE FROM " + PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME + " WHERE " + "TABLE_SCHEM" + " = '%s' AND " + "TABLE_NAME" + " = '%s' AND " + "COLUMN_COUNT" + " IS NOT NULL";
            ResultSet rs = globalConn.createStatement().executeQuery(String.format(sql, SCHEMA1, tableName));
            if (rs.next()) {
                Assert.assertNull((Object)rs.getObject(1));
            } else {
                Assert.fail();
            }
            rs = globalConn.createStatement().executeQuery(String.format(sql, SCHEMA1, globalViewName));
            if (rs.next()) {
                Assert.assertNull((Object)rs.getObject(1));
            } else {
                Assert.fail();
            }
            rs = globalConn.createStatement().executeQuery(String.format(sql, SCHEMA1, globalViewIndexName));
            if (rs.next()) {
                Assert.assertEquals((long)-5L, (long)rs.getInt(1));
            } else {
                Assert.fail();
            }
        }
    }

    @Test
    public void testCreateViewSchemaVersion() throws Exception {
        Properties props = new Properties();
        String schemaName = ViewIndexIT.generateUniqueName();
        String tableName = ViewIndexIT.generateUniqueName();
        String viewName = ViewIndexIT.generateUniqueName();
        String viewIndexName = ViewIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewFullName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String viewIndexFullName = SchemaUtil.getTableName((String)schemaName, (String)viewIndexName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewIndexIT.getUrl(), props);){
            String version = "V1.0";
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper((Connection)conn, schemaName, tableName, version, null);
            String createViewSql = "CREATE VIEW " + viewFullName + " AS SELECT * FROM " + dataTableFullName + " SCHEMA_VERSION='" + version + "'";
            conn.createStatement().execute(createViewSql);
            String createViewIndexSql = "CREATE INDEX " + viewIndexName + " ON " + viewFullName + " (ID2) INCLUDE (ID1) SCHEMA_VERSION='" + version + "'";
            conn.createStatement().execute(createViewIndexSql);
            PTable viewIndex = conn.getTableNoCache(viewIndexFullName);
            Assert.assertEquals((Object)version, (Object)viewIndex.getSchemaVersion());
        }
    }

    public void createBaseTable(Connection conn, String schemaName, String tableName, boolean multiTenant, Integer saltBuckets, String splits, boolean immutable) throws SQLException {
        String ddlOptions;
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String ddl = "CREATE " + (immutable ? "IMMUTABLE" : "") + " TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + " (t_id VARCHAR NOT NULL,\nk1 VARCHAR NOT NULL,\nk2 INTEGER NOT NULL,\nv1 VARCHAR,\nv2 INTEGER,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n";
        String string = ddlOptions = multiTenant ? "MULTI_TENANT=true" : "";
        if (saltBuckets != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ", ") + "salt_buckets=" + saltBuckets;
        }
        if (splits != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ", ") + "splits=" + splits;
        }
        conn.createStatement().execute(ddl + ddlOptions);
    }

    public void createIndex(Connection conn, String schemaName, String indexName, String tableName, String indexedColumnName, boolean isLocal, boolean isAsync) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String local = isLocal ? " LOCAL " : "";
        String async = isAsync ? " ASYNC " : "";
        String sql = "CREATE " + local + " INDEX " + indexName + " ON " + fullTableName + "(" + indexedColumnName + ")" + async;
        conn.createStatement().execute(sql);
    }

    public void createView(Connection conn, String schemaName, String viewName, String baseTableName) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)baseTableName);
        String viewSql = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName;
        conn.createStatement().execute(viewSql);
    }

    public void createViewIndex(Connection conn, String schemaName, String indexName, String viewName, String indexColumn) throws SQLException {
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullViewName + "(" + indexColumn + ")");
    }
}

