/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.GlobalIndexCheckerIT;
import org.apache.phoenix.exception.PhoenixParserException;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.iterate.ScanningResultPostDummyResultCaller;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class UncoveredGlobalIndexRegionScanner2IT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UncoveredGlobalIndexRegionScanner2IT.class);
    private final boolean uncovered;
    private final boolean salted;
    protected static boolean hasTestStarted = false;
    protected static int countOfDummyResults = 0;
    protected static final Set<String> TABLE_NAMES = new HashSet<String>();

    public UncoveredGlobalIndexRegionScanner2IT(boolean uncovered, boolean salted) {
        this.uncovered = uncovered;
        this.salted = salted;
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.use.stats.parallelization", Boolean.toString(false));
        props.put("phoenix.server.page.size.ms", Long.toString(0L));
        props.put("phoenix.tests.minicluster.numregionservers", String.valueOf(2));
        props.put("hbase.client.scanner.max.result.size", String.valueOf(1));
        props.put("phoenix.global.index.row.age.threshold.to.delete.ms", Long.toString(0L));
        props.put("phoenix.scanning.result.post.dummy.process", TestScanningResultPostDummyResultCaller.class.getName());
        UncoveredGlobalIndexRegionScanner2IT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    protected static void moveRegionsOfTable(String tableName) throws IOException {
        try (AsyncConnection asyncConnection = (AsyncConnection)ConnectionFactory.createAsyncConnection((Configuration)UncoveredGlobalIndexRegionScanner2IT.getUtility().getConfiguration()).get();){
            AsyncAdmin admin = asyncConnection.getAdmin();
            ArrayList servers = new ArrayList((Collection)admin.getRegionServers().get());
            ServerName server1 = (ServerName)servers.get(0);
            ServerName server2 = (ServerName)servers.get(1);
            List regionsOnServer1 = (List)admin.getRegions(server1).get();
            List regionsOnServer2 = (List)admin.getRegions(server2).get();
            regionsOnServer1.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server2);
                                admin.move(regionInfo.getEncodedNameAsBytes(), server2).get(3L, TimeUnit.SECONDS);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
            regionsOnServer2.forEach(regionInfo -> {
                if (regionInfo.getTable().equals((Object)TableName.valueOf((String)tableName))) {
                    try {
                        for (int i = 0; i < 2; ++i) {
                            RegionStatesCount regionStatesCount = (RegionStatesCount)((ClusterMetrics)admin.getClusterMetrics().get()).getTableRegionStatesCount().get(TableName.valueOf((String)tableName));
                            if (regionStatesCount.getRegionsInTransition() == 0 && regionStatesCount.getOpenRegions() == regionStatesCount.getTotalRegions()) {
                                admin.move(regionInfo.getEncodedNameAsBytes(), server1).get(3L, TimeUnit.SECONDS);
                                LOGGER.info("Moving region {} to {}", (Object)regionInfo.getRegionNameAsString(), (Object)server1);
                                break;
                            }
                            LOGGER.info("Table {} has some region(s) in RIT or not online", (Object)tableName);
                        }
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        LOGGER.error("Something went wrong", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Something went wrong..", (Throwable)e);
        }
    }

    @Before
    public void setUp() throws Exception {
        hasTestStarted = true;
    }

    @After
    public void tearDown() throws Exception {
        countOfDummyResults = 0;
        TABLE_NAMES.clear();
        hasTestStarted = false;
    }

    @Parameterized.Parameters(name="uncovered={0},salted={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    private void populateTable(String tableName) throws Exception {
        Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
        conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
        conn.commit();
        conn.close();
    }

    @Test
    public void testDDL() throws Exception {
        block17: {
            try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
                String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
                String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
                conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
                if (this.uncovered) {
                    try {
                        conn.createStatement().execute("CREATE UNCOVERED INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2)");
                        Assert.fail();
                    }
                    catch (PhoenixParserException phoenixParserException) {
                        // empty catch block
                    }
                    try {
                        conn.createStatement().execute("CREATE UNCOVERED LOCAL INDEX " + indexTableName + " on " + dataTableName);
                        Assert.fail();
                    }
                    catch (PhoenixParserException phoenixParserException) {}
                    break block17;
                }
                conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) INCLUDE (val2)");
            }
        }
    }

    @Test
    public void testDDLWithPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            if (this.uncovered) {
                conn.createStatement().execute("CREATE UNCOVERED INDEX IDX_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
            } else {
                conn.createStatement().execute("CREATE INDEX IDX_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
                conn.createStatement().execute("CREATE LOCAL INDEX IDX_LOCAL_" + dataTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP())");
            }
        }
    }

    @Test
    public void testUncoveredQueryWithPhoenixRowTimestamp() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10),  val3 varchar(10))" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) ");
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains("FULL SCAN OVER " + dataTableName));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) ");
            conn.commit();
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " id, val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUncoveredQueryWithPhoenixRowTimestampAndAllPkCols() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + dataTableName + " (id varchar(10), val1 varchar(10), val2 varchar(10),  val3 varchar(10) constraint pk primary key(id, val1, val2, val3))" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, PHOENIX_ROW_TIMESTAMP()) ");
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            String noIndexQuery = "SELECT /*+ NO_INDEX */ val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery("EXPLAIN " + noIndexQuery);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains(this.salted ? "RANGE" : "FULL SCAN OVER " + dataTableName));
            rs = conn.createStatement().executeQuery(noIndexQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            after = rs.getTimestamp(3);
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('d', 'de', 'def', 'defg')");
            conn.commit();
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " val1, val2, PHOENIX_ROW_TIMESTAMP()  from " + dataTableName + " WHERE val1 = 'de'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"de", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (PHOENIX_ROW_TIMESTAMP()) ");
            conn.commit();
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('e', 'ae', 'efg', 'efgh')");
            conn.commit();
            query = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + " id, val1, val2, PHOENIX_ROW_TIMESTAMP() from " + dataTableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            GlobalIndexCheckerIT.assertExplainPlan(conn, query, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + dataTableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bc", (Object)rs.getString(2));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"d", (Object)rs.getString(1));
            Assert.assertEquals((Object)"de", (Object)rs.getString(2));
            Assert.assertEquals((Object)"def", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"e", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ae", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void assertIndexTableNotSelected(Connection conn, String dataTableName, String indexTableName, String sql) throws Exception {
        try {
            GlobalIndexCheckerIT.assertExplainPlan(conn, sql, dataTableName, indexTableName);
            throw new RuntimeException("The index table should not be selected without an index hint");
        }
        catch (AssertionError assertionError) {
            return;
        }
    }

    @Test
    public void testUncoveredQuery() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String selectSql;
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1) " + (this.uncovered ? "" : "INCLUDE (val2)"));
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            int limit = 10;
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT 10");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
                GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            } else {
                selectSql = "SELECT  val2, val3 from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde') LIMIT " + limit;
                GlobalIndexCheckerIT.assertExplainPlanWithLimit(conn, selectSql, dataTableName, indexTableName, limit);
            }
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("DROP INDEX " + indexTableName + " on " + dataTableName);
            conn.commit();
            indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')";
            } else {
                selectSql = "SELECT id from " + dataTableName + " WHERE val1 = 'bc' AND (val2 = 'bcd' OR val3 ='bcde')";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val1, val2, val3) values ('c', 'ab','cde', 'cdef')");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            } else {
                selectSql = "SELECT count(val3) from " + dataTableName + " where val1 > '0' GROUP BY val1";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            selectSql = !this.uncovered ? "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ count(val3) from " + dataTableName + " where val1 > '0'" : "SELECT count(val3) from " + dataTableName + " where val1 > '0'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            } else {
                selectSql = "SELECT val3 from " + dataTableName + " where val1 > '0' ORDER BY val1";
            }
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"cdef", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bcde", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testPartialIndexUpdate() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String selectSql;
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("create table " + dataTableName + " (id varchar not null primary key, val1 varchar, val2 varchar, val3 varchar, val4 varchar)" + (this.salted ? " SALT_BUCKETS=4" : ""));
            conn.createStatement().execute("upsert into " + dataTableName + " values ('b', 'bc', 'bcd', 'bcde', 'bcdef')");
            conn.commit();
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1, val2) " + (this.uncovered ? "" : "INCLUDE (val3)"));
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('b', 'bcdd')");
            conn.commit();
            if (!this.uncovered) {
                this.assertIndexTableNotSelected(conn, dataTableName, indexTableName, "SELECT val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'");
                selectSql = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'";
                GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            } else {
                selectSql = "SELECT  val4 from " + dataTableName + " WHERE val1 = 'bc' AND val2 = 'bcdd'";
                GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            }
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"bcdef", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSkipScanFilter() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + dataTableName + "(k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 INTEGER, v2 INTEGER, v3 INTEGER CONSTRAINT pk PRIMARY KEY (k1,k2))  COLUMN_ENCODED_BYTES = 0, VERSIONS=1" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            TestUtil.addCoprocessor(conn, dataTableName, ScanFilterRegionObserver.class);
            ScanFilterRegionObserver.resetCount();
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " ON " + dataTableName + "(v1)" + (this.uncovered ? "" : "include (v2)"));
            int nIndexValues = 97;
            Random RAND = new Random(7L);
            int batchSize = 100;
            for (int i = 0; i < 10000; ++i) {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES (" + i + ", 1, " + RAND.nextInt() % 97 + ", " + RAND.nextInt() + ", 1)");
                if (i % 100 != 0) continue;
                conn.commit();
            }
            conn.commit();
            String selectSql = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "SUM(v3) from " + dataTableName + " GROUP BY v1";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            int sum = 0;
            while (rs.next()) {
                if (sum % 1500 == 0) {
                    UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
                    UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
                }
                sum += rs.getInt(1);
            }
            Assert.assertEquals((long)10000L, (long)sum);
            Assert.assertTrue((ScanFilterRegionObserver.count.get() >= 10000 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCount() throws Exception {
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + dataTableName + "(k1 BIGINT NOT NULL, k2 BIGINT NOT NULL, v1 INTEGER, v2 INTEGER, v3 BIGINT CONSTRAINT pk PRIMARY KEY (k1,k2))  VERSIONS=1, IMMUTABLE_ROWS=TRUE" + (this.salted ? ", SALT_BUCKETS=4" : ""));
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " ON " + dataTableName + "(v1)");
            int nIndexValues = 9;
            Random RAND = new Random(7L);
            int batchSize = 1000;
            for (int i = 0; i < 100000; ++i) {
                conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES (" + i + ", 1, " + RAND.nextInt() % 9 + ", " + RAND.nextInt() + ", " + RAND.nextInt() + ")");
                if (i % 1000 != 0) continue;
                conn.commit();
            }
            conn.commit();
            String selectSql = "SELECT /*+ NO INDEX */  Count(v3) from " + dataTableName + " where v1 = 5";
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            long count = rs.getLong(1);
            selectSql = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "Count(v3) from " + dataTableName + " where v1 = 5";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)count, (long)rs.getInt(1));
        }
    }

    @Test
    public void testFailDataTableRowUpdate() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)true);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val2) values ('a', 'abcc')");
            try {
                conn.commit();
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IndexRegionObserver.setFailDataTableUpdatesForTesting((boolean)false);
            conn.createStatement().execute("upsert into " + dataTableName + " (id, val3) values ('a', 'abcdd')");
            conn.commit();
            String selectSql = "SELECT" + (this.uncovered ? " " : "/*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ ") + "val2, val3 from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(dataTableName);
            UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(indexTableName);
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abcdd", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testFailPostIndexDeleteUpdate() throws Exception {
        String dataTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
        this.populateTable(dataTableName);
        try (Connection conn = DriverManager.getConnection(UncoveredGlobalIndexRegionScanner2IT.getUrl());){
            String indexTableName = UncoveredGlobalIndexRegionScanner2IT.generateUniqueName();
            TABLE_NAMES.add(dataTableName);
            TABLE_NAMES.add(indexTableName);
            conn.createStatement().execute("CREATE " + (this.uncovered ? "UNCOVERED " : " ") + "INDEX " + indexTableName + " on " + dataTableName + " (val1)");
            String selectSql = "SELECT id from " + dataTableName + " WHERE val1  = 'ab'";
            GlobalIndexCheckerIT.assertExplainPlan(conn, selectSql, dataTableName, indexTableName);
            ResultSet rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)true);
            String dml = "DELETE from " + dataTableName + " WHERE id  = 'a'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            conn.commit();
            dml = "DELETE from " + dataTableName + " WHERE val1  = 'ab'";
            Assert.assertEquals((long)0L, (long)conn.createStatement().executeUpdate(dml));
            rs = conn.createStatement().executeQuery(selectSql);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT count(*) from " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            IndexRegionObserver.setFailPostIndexUpdatesForTesting((boolean)false);
        }
    }

    public static class ScanFilterRegionObserver
    extends SimpleRegionObserver {
        public static final AtomicInteger count = new AtomicInteger(0);

        public static void resetCount() {
            count.set(0);
        }

        public void preScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan) {
            if (scan.getFilter() instanceof SkipScanFilter) {
                List slots = ((SkipScanFilter)scan.getFilter()).getSlots();
                for (List ranges : slots) {
                    count.addAndGet(ranges.size());
                }
            }
        }
    }

    protected static class TestScanningResultPostDummyResultCaller
    extends ScanningResultPostDummyResultCaller {
        protected TestScanningResultPostDummyResultCaller() {
        }

        public void postDummyProcess() {
            if (hasTestStarted && countOfDummyResults++ % 3 == 0 && (countOfDummyResults < 17 || countOfDummyResults > 28 && countOfDummyResults < 40)) {
                LOGGER.info("Moving regions of tables {}. current count of dummy results: {}", TABLE_NAMES, (Object)countOfDummyResults);
                TABLE_NAMES.forEach(table -> {
                    try {
                        UncoveredGlobalIndexRegionScanner2IT.moveRegionsOfTable(table);
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to move regions of table: {}", table);
                    }
                });
            }
        }
    }
}

