/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ShortViewIndexIdIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("phoenix.index.longViewIndex.enabled", "false");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.index.longViewIndex.enabled", "false");
        ShortViewIndexIdIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Test
    public void testCreateLocalIndexWithData() throws Exception {
        String tableName = ShortViewIndexIdIT.generateUniqueName();
        String indexName = "IDX_" + ShortViewIndexIdIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ShortViewIndexIdIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v INTEGER)");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 1)");
            conn.commit();
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT v FROM " + tableName + " WHERE v < 2");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            rs.close();
        }
    }

    @Test
    public void testUpsertIntoLocalIndex() throws Exception {
        String tableName = ShortViewIndexIdIT.generateUniqueName();
        String index1 = "IDX_" + ShortViewIndexIdIT.generateUniqueName();
        String index2 = "IDX_" + ShortViewIndexIdIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ShortViewIndexIdIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + index1 + " ON " + tableName + "(v1)");
            conn.createStatement().execute("CREATE LOCAL INDEX " + index2 + " ON " + tableName + "(v2)");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 2, 3)");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + index1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
            rs = conn.createStatement().executeQuery("SELECT * FROM " + index2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
            rs.close();
        }
    }
}

