/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Map;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.mapreduce.index.automation.PhoenixAsyncIndex;
import org.apache.phoenix.mapreduce.index.automation.PhoenixMRJobSubmitter;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class PhoenixMRJobSubmitterIT
extends BaseTest {
    private static String REQUEST_INDEX_REBUILD_SQL = "ALTER INDEX %s ON %s REBUILD ASYNC";

    @BeforeClass
    public static synchronized void setUp() throws Exception {
        PhoenixMRJobSubmitterIT.setUpTestDriver(ReadOnlyProps.EMPTY_PROPS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetCandidateJobs() throws Exception {
        String tableName = "TBL_" + PhoenixMRJobSubmitterIT.generateUniqueName();
        String asyncIndexName = "IDX_" + PhoenixMRJobSubmitterIT.generateUniqueName();
        String needsRebuildIndexName = "IDX_" + PhoenixMRJobSubmitterIT.generateUniqueName();
        String tableDDL = "CREATE TABLE " + tableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
        String asyncIndexDDL = "CREATE INDEX " + asyncIndexName + " ON " + tableName + " (a.varchar_col1) ASYNC";
        String needsRebuildIndexDDL = "CREATE INDEX " + needsRebuildIndexName + " ON " + tableName + " (a.char_col1)";
        long rebuildTimestamp = 100L;
        PhoenixMRJobSubmitterIT.createTestTable(PhoenixMRJobSubmitterIT.getUrl(), tableDDL);
        PhoenixMRJobSubmitterIT.createTestTable(PhoenixMRJobSubmitterIT.getUrl(), needsRebuildIndexDDL);
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DriverManager.getConnection(PhoenixMRJobSubmitterIT.getUrl());
            TestUtil.assertIndexState(conn, needsRebuildIndexName, PIndexState.ACTIVE, 0L);
            PhoenixMRJobSubmitter submitter = new PhoenixMRJobSubmitter(PhoenixMRJobSubmitterIT.getUtility().getConfiguration());
            Map candidateMap = submitter.getCandidateJobs(conn);
            Assert.assertNotNull((Object)candidateMap);
            Assert.assertEquals((long)0L, (long)candidateMap.size());
            PhoenixMRJobSubmitterIT.createTestTable(PhoenixMRJobSubmitterIT.getUrl(), asyncIndexDDL);
            TestUtil.assertIndexState(conn, asyncIndexName, PIndexState.BUILDING, 0L);
            stmt = conn.prepareStatement(String.format(REQUEST_INDEX_REBUILD_SQL, needsRebuildIndexName, tableName));
            stmt.execute();
            conn.commit();
            TestUtil.assertIndexState(conn, asyncIndexName, PIndexState.BUILDING, 0L);
            candidateMap = submitter.getCandidateJobs(conn);
            Assert.assertNotNull((Object)candidateMap);
            Assert.assertEquals((long)2L, (long)candidateMap.size());
            boolean foundAsyncIndex = false;
            boolean foundNeedsRebuildIndex = false;
            for (PhoenixAsyncIndex indexInfo : candidateMap.values()) {
                if (indexInfo.getTableName().equals(asyncIndexName)) {
                    foundAsyncIndex = true;
                    continue;
                }
                if (!indexInfo.getTableName().equals(needsRebuildIndexName)) continue;
                foundNeedsRebuildIndex = true;
            }
            Assert.assertTrue((String)"Did not return index in BUILDING created with ASYNC!", (boolean)foundAsyncIndex);
            Assert.assertTrue((String)"Did not return index in REBUILD with an ASYNC_REBUILD_TIMESTAMP!", (boolean)foundNeedsRebuildIndex);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

