/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.schema.StaleRegionBoundaryCacheException;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class MutableIndexSplitIT
extends ParallelStatsDisabledIT {
    protected final boolean localIndex;
    protected final boolean multiTenant;

    public MutableIndexSplitIT(boolean localIndex, boolean multiTenant) {
        this.localIndex = localIndex;
        this.multiTenant = multiTenant;
    }

    private static java.sql.Connection getConnection(Properties props) throws SQLException {
        props.setProperty("phoenix.index.mutableBatchSizeThreshold", Integer.toString(1));
        java.sql.Connection conn = DriverManager.getConnection(MutableIndexSplitIT.getUrl(), props);
        return conn;
    }

    @Parameterized.Parameters(name="MutableIndexSplitIT_localIndex={0},multiTenant={1}")
    public static synchronized Collection<Boolean[]> data() {
        return Arrays.asList({false, false}, {false, true}, {true, false}, {true, true});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testSplitDuringIndexScan(boolean isReverse) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("hbase.client.scanner.caching", Integer.toString(2));
        props.setProperty("phoenix.query.force.rowkeyorder", Boolean.toString(false));
        java.sql.Connection conn1 = MutableIndexSplitIT.getConnection(props);
        String tableName = "TBL_" + MutableIndexSplitIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexSplitIT.generateUniqueName();
        Admin admin = driver.getConnectionQueryServices(MutableIndexSplitIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        try {
            String[] strings = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
            this.createTableAndLoadData(conn1, tableName, indexName, strings, isReverse);
            ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            try {
                this.splitDuringScan(conn1, tableName, indexName, strings, admin, isReverse);
                Assert.assertFalse((boolean)this.localIndex);
            }
            catch (StaleRegionBoundaryCacheException x) {
                Assert.assertTrue((boolean)this.localIndex);
            }
        }
        finally {
            if (conn1 != null) {
                conn1.close();
            }
            if (admin != null) {
                admin.close();
            }
        }
    }

    private void createTableAndLoadData(java.sql.Connection conn1, String tableName, String indexName, String[] strings, boolean isReverse) throws SQLException {
        this.createBaseTable(conn1, tableName, null);
        for (int i = 0; i < 26; ++i) {
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('" + strings[i] + "'," + i + "," + (i + 1) + "," + (i + 2) + ",'" + strings[25 - i] + "')");
        }
        conn1.commit();
        conn1.createStatement().execute("CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + tableName + "(v1" + (isReverse ? " DESC" : "") + ") include (k3)");
    }

    private List<RegionInfo> splitDuringScan(java.sql.Connection conn1, String tableName, String indexName, String[] strings, Admin admin, boolean isReverse) throws SQLException, IOException, InterruptedException {
        int i;
        String query = "SELECT t_id,k1,v1 FROM " + tableName;
        ResultSet rs = conn1.createStatement().executeQuery(query);
        Object[] tIdColumnValues = new String[26];
        Object[] v1ColumnValues = new String[26];
        int[] k1ColumnValue = new int[26];
        for (int j = 0; j < 5; ++j) {
            Assert.assertTrue((boolean)rs.next());
            tIdColumnValues[j] = rs.getString("t_id");
            k1ColumnValue[j] = rs.getInt("k1");
            v1ColumnValues[j] = rs.getString("V1");
        }
        String[] splitKeys = new String[]{strings[4], strings[12]};
        int[] splitInts = new int[]{22, 4};
        List regionsOfUserTable = null;
        for (i = 0; i <= 1; ++i) {
            boolean split = false;
            for (int j = 0; j < 150 && !split; ++j) {
                try {
                    if (this.localIndex) {
                        admin.split(TableName.valueOf((String)tableName), ByteUtil.concat((byte[])Bytes.toBytes((String)splitKeys[i]), (byte[][])new byte[0][]));
                    } else {
                        admin.split(TableName.valueOf((String)indexName), ByteUtil.concat((byte[])Bytes.toBytes((int)splitInts[i]), (byte[][])new byte[0][]));
                    }
                    split = true;
                    continue;
                }
                catch (IOException x) {
                    Thread.sleep(1000L);
                }
            }
            Assert.assertTrue((boolean)split);
            regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)TableName.valueOf((String)(this.localIndex ? tableName : indexName)), (boolean)false);
            while (regionsOfUserTable.size() < i + 2) {
                Thread.sleep(1000L);
                regionsOfUserTable = MetaTableAccessor.getTableRegions((Connection)admin.getConnection(), (TableName)TableName.valueOf((String)(this.localIndex ? tableName : indexName)), (boolean)false);
            }
            Assert.assertTrue((regionsOfUserTable.size() >= i + 2 ? 1 : 0) != 0);
        }
        for (int j = 5; j < 26; ++j) {
            Assert.assertTrue((boolean)rs.next());
            tIdColumnValues[j] = rs.getString("t_id");
            k1ColumnValue[j] = rs.getInt("k1");
            v1ColumnValues[j] = rs.getString("V1");
        }
        Arrays.sort(tIdColumnValues);
        Arrays.sort(v1ColumnValues);
        Arrays.sort(k1ColumnValue);
        Assert.assertTrue((boolean)Arrays.equals(strings, tIdColumnValues));
        Assert.assertTrue((boolean)Arrays.equals(strings, v1ColumnValues));
        for (i = 0; i < 26; ++i) {
            Assert.assertEquals((long)i, (long)k1ColumnValue[i]);
        }
        Assert.assertFalse((boolean)rs.next());
        return regionsOfUserTable;
    }

    private void createBaseTable(java.sql.Connection conn, String tableName, String splits) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))" + (this.multiTenant ? " MULTI_TENANT=true " : "") + "\n" + (splits != null ? " split on " + splits : "");
        conn.createStatement().execute(ddl);
    }
}

