/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.phoenix.end2end.CreateTableIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.thirdparty.com.google.common.primitives.Doubles;
import org.apache.phoenix.util.IndexScrutiny;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class MutableIndexIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(MutableIndexIT.class);
    protected final boolean localIndex;
    private final String tableDDLOptions;
    private final boolean columnEncoded;

    public MutableIndexIT(Boolean localIndex, String txProvider, Boolean columnEncoded) {
        this.localIndex = localIndex;
        this.columnEncoded = columnEncoded;
        StringBuilder optionBuilder = new StringBuilder();
        if (txProvider != null) {
            optionBuilder.append("TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + txProvider + "'");
        }
        if (!columnEncoded.booleanValue()) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    private static Connection getConnection(Properties props) throws SQLException {
        props.setProperty("phoenix.index.mutableBatchSizeThreshold", Integer.toString(1));
        Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl(), props);
        return conn;
    }

    private static Connection getConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        return MutableIndexIT.getConnection(props);
    }

    @Parameterized.Parameters(name="MutableIndexIT_localIndex={0},transactionProvider={1},columnEncoded={2}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, null, false}, {false, null, true}, {false, "OMID", false}, {true, null, false}, {true, null, true});
    }

    @Test
    public void testCoveredColumnUpdates() throws Exception {
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
            String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
            String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
            String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
            TestUtil.createMultiCFTestTable(conn, fullTableName, this.tableDDLOptions);
            MutableIndexIT.populateMultiCFTestTable(fullTableName);
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + " (char_col1 ASC, int_col1 ASC) INCLUDE (long_col1, long_col2)");
            String query = "SELECT char_col1, int_col1, long_col2 from " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((long)3L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)4L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertEquals((long)5L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk , decimal_pk, long_col2) SELECT varchar_pk, char_pk, int_pk, long_pk , decimal_pk, long_col2*2 FROM " + fullTableName + " WHERE long_col2=?");
            stmt.setLong(1, 4L);
            Assert.assertEquals((long)1L, (long)stmt.executeUpdate());
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((long)3L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)8L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertEquals((long)5L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(varchar_pk, char_pk, int_pk, long_pk , decimal_pk, long_col2) SELECT varchar_pk, char_pk, int_pk, long_pk , decimal_pk, CAST(null AS BIGINT) FROM " + fullTableName + " WHERE long_col2=?");
            stmt.setLong(1, 3L);
            Assert.assertEquals((long)1L, (long)stmt.executeUpdate());
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertEquals((long)0L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)3L, (long)rs.getInt(2));
            Assert.assertEquals((long)8L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"chara", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
            Assert.assertEquals((long)5L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
            if (this.localIndex) {
                query = "SELECT b.* from " + fullTableName + " where int_col1 = 4 AND char_col1 = 'chara'";
                rs = conn.createStatement().executeQuery("EXPLAIN " + query);
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1,'chara',4]\n    SERVER MERGE [B.VARCHAR_COL2, B.CHAR_COL2, B.INT_COL2, B.DECIMAL_COL2, B.DATE_COL]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
                rs = conn.createStatement().executeQuery(query);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"varchar_b", (Object)rs.getString(1));
                Assert.assertEquals((Object)"charb", (Object)rs.getString(2));
                Assert.assertEquals((long)5L, (long)rs.getInt(3));
                Assert.assertEquals((long)5L, (long)rs.getLong(4));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testUpsertIntoViewOnTableWithIndex() throws Exception {
        String baseTable = MutableIndexIT.generateUniqueName();
        String view = MutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl());){
            String baseTableDDL = "CREATE TABLE IF NOT EXISTS " + baseTable + " (ID VARCHAR PRIMARY KEY, V1 VARCHAR)";
            conn.createStatement().execute(baseTableDDL);
            String tableIndex = MutableIndexIT.generateUniqueName() + "_IDX";
            conn.createStatement().execute("CREATE INDEX " + tableIndex + " ON " + baseTable + " (V1)");
            String viewDDL = "CREATE VIEW IF NOT EXISTS " + view + " (V2 INTEGER) AS SELECT * FROM " + baseTable + " WHERE ID='a'";
            conn.createStatement().execute(viewDDL);
            String upsert = "UPSERT INTO " + view + " (ID, V1, V2) VALUES ('a' ,'ab', 7)";
            conn.createStatement().executeUpdate(upsert);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT ID, V1 from " + baseTable);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ab", (Object)rs.getString(2));
        }
    }

    @Test
    public void testCoveredColumns() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + " (v1) INCLUDE (v2)");
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k,v2) VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, null);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k,v2) VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "3");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"3", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k,v2) VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "4");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"4", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testCompoundIndexKey() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "y");
            stmt.setString(3, null);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\n    SERVER FILTER BY " + (this.columnEncoded ? "FIRST KEY" : "EMPTY COLUMN") + " ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName + "\n    SERVER FILTER BY " + (this.columnEncoded ? "FIRST KEY" : "EMPTY COLUMN") + " ONLY"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.setString(1, "b");
            stmt.setString(2, null);
            stmt.setString(3, "3");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"3", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?)");
            stmt.setString(1, "b");
            stmt.setString(2, "z");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString(1));
            Assert.assertEquals((Object)"3", (Object)rs.getString(2));
            Assert.assertEquals((Object)"b", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testMultipleUpdatesToSingleRow() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + " (v1, v2)");
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k, v1) VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "y");
            stmt.execute();
            stmt = conn.prepareStatement("UPSERT INTO " + fullTableName + "(k,v2) VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, null);
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + fullIndexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)"a", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + fullTableName;
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            if (this.localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + fullTableName + ") [1]\n    SERVER FILTER BY " + (this.columnEncoded ? "FIRST KEY" : "EMPTY COLUMN") + " ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + fullIndexName + "\n    SERVER FILTER BY " + (this.columnEncoded ? "FIRST KEY" : "EMPTY COLUMN") + " ONLY"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertingNullForIndexedColumns() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        String testTableName = SchemaUtil.getTableName((String)"S", (String)(tableName + "_" + System.currentTimeMillis()));
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + testTableName + "(v1 VARCHAR PRIMARY KEY, v2 DOUBLE, v3 VARCHAR) " + this.tableDDLOptions);
            stmt.execute("CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + testTableName + "  (v2) INCLUDE(v3)");
            stmt.executeUpdate("upsert into " + testTableName + " values('cc1', null, 'abc')");
            conn.commit();
            ResultSet rs = stmt.executeQuery("select * from " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)0.0, (double)rs.getDouble(1)));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select v1, v2, v3 from " + testTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(1));
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)0.0, (double)rs.getDouble(2)));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + testTableName + " values('cc1', 1.23, 'abc')");
            conn.commit();
            rs = stmt.executeQuery("select /*+ NO_INDEX */ v1, v2, v3 from " + testTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(1));
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.23, (double)rs.getDouble(2)));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select * from " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)1.23, (double)rs.getDouble(1)));
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.executeUpdate("upsert into " + testTableName + " values('cc1', null, 'abc')");
            conn.commit();
            rs = stmt.executeQuery("select * from " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)0.0, (double)rs.getDouble(1)));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("select v1, v2, v3 from " + testTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"cc1", (Object)rs.getString(1));
            Assert.assertEquals((long)0L, (long)Doubles.compare((double)0.0, (double)rs.getDouble(2)));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private void assertImmutableRows(Connection conn, String fullTableName, boolean expectedValue) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Assert.assertEquals((Object)expectedValue, (Object)pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).isImmutableRows());
    }

    @Test
    public void testAlterTableWithImmutability() throws Exception {
        if (this.localIndex) {
            return;
        }
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR) " + this.tableDDLOptions);
            String query = "SELECT * FROM " + fullTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            this.assertImmutableRows(conn, fullTableName, false);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET IMMUTABLE_ROWS=true");
            this.assertImmutableRows(conn, fullTableName, true);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " SET immutable_rows=false");
            this.assertImmutableRows(conn, fullTableName, false);
        }
    }

    private void createBaseTable(Connection conn, String tableName, String splits) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n" + (this.tableDDLOptions != null ? this.tableDDLOptions : "") + (splits != null ? " split on " + splits : "");
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testTenantSpecificConnection() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE IF NOT EXISTS " + fullTableName + "(TENANT_ID CHAR(15) NOT NULL,TYPE VARCHAR(25),ENTITY_ID CHAR(15) NOT NULL,CONSTRAINT PK_CONSTRAINT PRIMARY KEY (TENANT_ID, ENTITY_ID)) MULTI_TENANT=TRUE " + (!this.tableDDLOptions.isEmpty() ? "," + this.tableDDLOptions : ""));
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX IF NOT EXISTS " + indexName + " ON " + fullTableName + " (ENTITY_ID, TYPE)");
            String dml = "UPSERT INTO " + fullTableName + " (ENTITY_ID, TYPE) VALUES ( ?, ?)";
            props.setProperty("TenantId", "tenant1");
            try (Connection tenantConn = MutableIndexIT.getConnection(props);){
                this.upsertRow(dml, tenantConn, 0);
                tenantConn.commit();
                ResultSet rs = tenantConn.createStatement().executeQuery("SELECT ENTITY_ID FROM " + fullTableName + " ORDER BY TYPE LIMIT 5");
                Assert.assertTrue((boolean)rs.next());
                this.upsertRow(dml, tenantConn, 1);
                this.upsertRow(dml, tenantConn, 2);
                tenantConn.commit();
            }
        }
    }

    @Test
    public void testUpsertingDeletedRowShouldGiveProperDataWithIndexes() throws Exception {
        this.testUpsertingDeletedRowShouldGiveProperDataWithIndexes(false);
    }

    @Test
    public void testUpsertingDeletedRowShouldGiveProperDataWithMultiCFIndexes() throws Exception {
        this.testUpsertingDeletedRowShouldGiveProperDataWithIndexes(true);
    }

    private void testUpsertingDeletedRowShouldGiveProperDataWithIndexes(boolean multiCf) throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String columnFamily1 = "cf1";
        String columnFamily2 = "cf2";
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.createStatement().execute("create table " + fullTableName + " (id integer primary key, " + (multiCf ? columnFamily1 + "." : "") + "f float, " + (multiCf ? columnFamily2 + "." : "") + "s varchar)" + this.tableDDLOptions);
            conn.createStatement().execute("create " + (this.localIndex ? "LOCAL" : "") + " index " + indexName + " on " + fullTableName + " (" + (multiCf ? columnFamily1 + "." : "") + "f) include (" + (multiCf ? columnFamily2 + "." : "") + "s)");
            conn.createStatement().execute("upsert into " + fullTableName + " values (1, 0.5, 'foo')");
            conn.commit();
            conn.createStatement().execute("delete from  " + fullTableName + " where id = 1");
            conn.commit();
            conn.createStatement().execute("upsert into  " + fullTableName + " values (1, 0.5, 'foo')");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("select * from " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((double)0.5, (double)rs.getFloat(1), (double)0.0);
            Assert.assertEquals((Object)"foo", (Object)rs.getString(3));
        }
    }

    @Test
    public void testUpsertingDeletedRowWithNullCoveredColumn() throws Exception {
        this.testUpsertingDeletedRowWithNullCoveredColumn(false);
    }

    @Test
    public void testUpsertingDeletedRowWithNullCoveredColumnMultiCfs() throws Exception {
        this.testUpsertingDeletedRowWithNullCoveredColumn(true);
    }

    public void testUpsertingDeletedRowWithNullCoveredColumn(boolean multiCf) throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String columnFamily1 = "cf1";
        String columnFamily2 = "cf2";
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.createStatement().execute("create table " + fullTableName + " (id integer primary key, " + (multiCf ? columnFamily1 + "." : "") + "f varchar, " + (multiCf ? columnFamily2 + "." : "") + "s varchar)" + this.tableDDLOptions);
            conn.createStatement().execute("create " + (this.localIndex ? "LOCAL" : "") + " index " + indexName + " on " + fullTableName + " (" + (multiCf ? columnFamily1 + "." : "") + "f) include (" + (multiCf ? columnFamily2 + "." : "") + "s)");
            conn.createStatement().execute("upsert into " + fullTableName + " values (1, 'foo', 'bar')");
            conn.commit();
            conn.createStatement().execute("delete from  " + fullTableName + " where id = 1");
            conn.commit();
            conn.createStatement().execute("upsert into  " + fullTableName + " values (1, null, 'bar')");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("select * from " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals(null, (Object)rs.getString(1));
            Assert.assertEquals((Object)"bar", (Object)rs.getString(3));
        }
    }

    @Test
    public void testUpdateNonIndexedColumn() throws Exception {
        String tableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexName = "IDX_" + MutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = MutableIndexIT.getConnection();){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + this.tableDDLOptions);
            conn.createStatement().execute("CREATE " + (this.localIndex ? " LOCAL " : "") + " INDEX " + indexName + " ON " + fullTableName + " (v2)");
            conn.createStatement().executeUpdate("UPSERT INTO " + fullTableName + "(k,v1,v2) VALUES ('testKey','v1_1','v2_1')");
            conn.commit();
            conn.createStatement().executeUpdate("DELETE FROM " + fullTableName);
            conn.commit();
            conn.createStatement().executeUpdate("UPSERT INTO " + fullTableName + "(k,v1,v2) VALUES ('testKey','v1_2','v2_2')");
            conn.commit();
            conn.createStatement().executeUpdate("DELETE FROM " + fullTableName);
            conn.commit();
            conn.createStatement().executeUpdate("UPSERT INTO " + fullTableName + "(k,v1) VALUES ('testKey','v1_3')");
            conn.commit();
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
            MutableIndexIT.getUtility().getAdmin().flush(TableName.valueOf((String)fullTableName));
            conn.createStatement().executeUpdate("UPSERT INTO " + fullTableName + "(k,v1,v2) VALUES ('testKey','v1_4','v2_3')");
            conn.commit();
            IndexScrutiny.scrutinizeIndex(conn, fullTableName, fullIndexName);
        }
    }

    private void setupForDeleteCount(Connection conn, String schemaName, String dataTableName, String indexTableName1, String indexTableName2) throws SQLException {
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
        if (indexTableName1 != null) {
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName1, dataTableFullName));
        }
        if (indexTableName2 != null) {
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL2) INCLUDE (VAL1)", indexTableName2, dataTableFullName));
        }
        PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        for (int i = 1; i <= 10; ++i) {
            dataPreparedStatement.setInt(1, i);
            dataPreparedStatement.setInt(2, i + 1);
            dataPreparedStatement.setInt(3, i * 2);
            dataPreparedStatement.execute();
        }
        conn.commit();
    }

    @Test
    public void testDeleteCount_PK() throws Exception {
        String schemaName = MutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IND_" + MutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName, null);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE ID > 5");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_nonPK() throws Exception {
        String schemaName = MutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName1 = "IND_" + MutableIndexIT.generateUniqueName();
        String indexTableName2 = "IND_" + MutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName1, indexTableName2);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE VAL1 > 6");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_limit() throws Exception {
        String schemaName = MutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName1 = "IND_" + MutableIndexIT.generateUniqueName();
        String indexTableName2 = "IND_" + MutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName1, indexTableName2);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE VAL1 > 6 LIMIT 3");
            Assert.assertEquals((long)3L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_index() throws Exception {
        String schemaName = MutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + MutableIndexIT.generateUniqueName();
        String indexTableName = "IND_" + MutableIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        try (Connection conn = DriverManager.getConnection(MutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName, null);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + indexTableFullName + " WHERE \"0:VAL1\" > 6");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testCreateIndexSchemaVersion() throws Exception {
        Properties props = new Properties();
        String schemaName = MutableIndexIT.generateUniqueName();
        String tableName = MutableIndexIT.generateUniqueName();
        String indexName = MutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String indexFullName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(MutableIndexIT.getUrl(), props);){
            String version = "V1.0";
            CreateTableIT.testCreateTableSchemaVersionAndTopicNameHelper((Connection)conn, schemaName, tableName, version, null);
            String createIndexSql = "CREATE INDEX " + indexName + " ON " + dataTableFullName + " (ID2) INCLUDE (ID1) SCHEMA_VERSION='" + version + "'";
            conn.createStatement().execute(createIndexSql);
            PTable index = conn.getTableNoCache(indexFullName);
            Assert.assertEquals((Object)version, (Object)index.getSchemaVersion());
        }
    }

    private void upsertRow(String dml, Connection tenantConn, int i) throws SQLException {
        PreparedStatement stmt = tenantConn.prepareStatement(dml);
        stmt.setString(1, "00000000000000" + String.valueOf(i));
        stmt.setString(2, String.valueOf(i));
        Assert.assertEquals((long)1L, (long)stmt.executeUpdate());
    }
}

