/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.phoenix.coprocessor.MetaDataRegionObserver;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.MutableIndexFailureIT;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
public class MutableIndexFailureWithNamespaceIT
extends MutableIndexFailureIT {
    public MutableIndexFailureWithNamespaceIT(String transactionProvider, boolean localIndex, boolean isNamespaceMapped, Boolean disableIndexOnWriteFailure, boolean failRebuildTask, Boolean throwIndexWriteFailure) {
        super(transactionProvider, localIndex, isNamespaceMapped, disableIndexOnWriteFailure, failRebuildTask, throwIndexWriteFailure);
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        Map<String, String> serverProps = MutableIndexFailureWithNamespaceIT.getServerProps();
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)3);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        clientProps.put("hbase.client.retries.number", "2");
        clientProps.put("phoenix.index.region.observer.enabled", Boolean.FALSE.toString());
        NUM_SLAVES_BASE = 4;
        MutableIndexFailureWithNamespaceIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        TableName systemTable = SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (boolean)true);
        indexRebuildTaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)MutableIndexFailureWithNamespaceIT.getUtility().getRSForFirstRegionInTable(systemTable).getRegions(systemTable).get(0)).getCoprocessorHost().findCoprocessorEnvironment(MetaDataRegionObserver.class.getName());
        MetaDataRegionObserver.initRebuildIndexConnectionProps((Configuration)indexRebuildTaskRegionEnvironment.getConfiguration());
    }

    @Parameterized.Parameters(name="MutableIndexFailureIT_transactional={0},localIndex={1},isNamespaceMapped={2},disableIndexOnWriteFailure={3},failRebuildTask={4},throwIndexWriteFailure={5}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({null, false, true, true, false, null}, {null, false, true, true, false, true}, {"OMID", false, true, true, false, null}, {null, true, true, true, false, null}, {null, false, true, true, true, null}, {null, false, true, false, true, false});
    }
}

