/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ExplainPlanWithStatsEnabledIT;
import org.apache.phoenix.end2end.index.BaseLocalIndexIT;
import org.apache.phoenix.hbase.index.IndexRegionSplitPolicy;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;

public class LocalIndexIT
extends BaseLocalIndexIT {
    public LocalIndexIT(boolean isNamespaceMapped) {
        super(isNamespaceMapped);
    }

    @Test
    public void testPhoenixRowTimestamp() throws Exception {
        String tableName = LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(LocalIndexIT.getUrl());){
            Timestamp initial = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() - 1L);
            conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
            conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
            conn.commit();
            Timestamp before = new Timestamp(EnvironmentEdgeManager.currentTimeMillis());
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + tableName + " values ('b', 'bc', 'bcd', 'bcde')");
            conn.commit();
            Timestamp after = new Timestamp(EnvironmentEdgeManager.currentTimeMillis() + 1L);
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " on " + tableName + " (val1, PHOENIX_ROW_TIMESTAMP()) ");
            String timeZoneID = Calendar.getInstance().getTimeZone().getID();
            String query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + tableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + before.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "') AND PHOENIX_ROW_TIMESTAMP() < TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) from " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + tableName + " values ('c', 'bc', 'ccc', 'cccc')");
            conn.commit();
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(before));
            Assert.assertTrue((boolean)rs.getTimestamp(3).before(after));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + tableName + " WHERE val1 = 'bc' AND PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + after.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.getTimestamp(3).after(after));
            Assert.assertFalse((boolean)rs.next());
            indexName = LocalIndexIT.generateUniqueName();
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " on " + tableName + " (PHOENIX_ROW_TIMESTAMP()) include (val1, val2, val3) ");
            Thread.sleep(1L);
            conn.createStatement().execute("upsert into " + tableName + " values ('d', 'ad', 'def', 'defg')");
            conn.commit();
            query = "SELECT  val1, val2, PHOENIX_ROW_TIMESTAMP() from " + tableName + " WHERE PHOENIX_ROW_TIMESTAMP() > TO_DATE('" + initial.toString() + "','yyyy-MM-dd HH:mm:ss.SSS', '" + timeZoneID + "')";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ab", (Object)rs.getString(1));
            Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"bc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"ccc", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"ad", (Object)rs.getString(1));
            Assert.assertEquals((Object)"def", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectFromIndexWithUncoveredArrayIndex() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT, v2 FLOAT[])");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 2, ARRAY[3,4])");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        ResultSet rs = conn.createStatement().executeQuery("SELECT v2[1] FROM " + tableName + " WHERE v1 < 3");
        rs.next();
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        rs.close();
        conn.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v2[2])");
        rs = conn.createStatement().executeQuery("SELECT v2[1] FROM " + tableName + " WHERE v2[2] < 5");
        rs.next();
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        rs.close();
    }

    @Test
    public void testSelectFromIndexWithAdditionalWhereClause() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT, v2 FLOAT, v3 INTEGER)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, 2, 3, 4)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(2, 3, 4, 5)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(3, 4, 5, 6)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(4, 5, 6, 7)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        this.testExtraWhere(conn, tableName);
        conn.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) INCLUDE (v3)");
        this.testExtraWhere(conn, tableName);
        conn.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) INCLUDE (v2)");
        this.testExtraWhere(conn, tableName);
        conn.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) INCLUDE (v2,v3)");
        this.testExtraWhere(conn, tableName);
    }

    private void testExtraWhere(java.sql.Connection conn, String tableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v1 < 3 AND v2 < 4");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v1 < 3 AND v3 < 5");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v1 < 10 AND v2 < 0 AND v3 < 0");
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v1 <= 2 AND v2 > 0 AND v3 < 5");
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT pk FROM " + tableName + " WHERE v1 > 3 AND v2 > 0 AND v3 > 6");
        rs.next();
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT v1 FROM " + tableName + " WHERE v1 > 3 AND v2 > 0 AND v3 > 6");
        rs.next();
        Assert.assertEquals((long)5L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT pk FROM " + tableName + " WHERE (v1,v2) IN ((1,5),(4,5))");
        rs.next();
        Assert.assertEquals((long)3L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT v3 FROM " + tableName + " WHERE (v1,v2) IN ((1,5),(4,5))");
        rs.next();
        Assert.assertEquals((long)6L, (long)rs.getInt(1));
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE v1 > 0 AND v3 > 5 LIMIT 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE v1 > 0 AND v3 > 5 LIMIT 1");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        rs.close();
        rs = conn.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE v3 > 5 ORDER BY v1 LIMIT 2");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        rs.close();
    }

    @Test
    public void testDeleteFromLocalIndex() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT, v2 FLOAT)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v2)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(1, rand(), rand())");
        conn.createStatement().execute("DELETE FROM " + tableName + " WHERE v1 < 1");
        ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
        rs.next();
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        rs.close();
    }

    @Test
    public void testLocalIndexConsistency() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT) SPLIT ON (4000)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(rand() * 8000, rand())");
        for (int i = 0; i < 16; ++i) {
            conn.createStatement().execute("UPSERT INTO " + tableName + " SELECT rand() * 8000, rand() FROM " + tableName);
            Assert.assertEquals((long)this.getCountViaIndex(conn, tableName, null), (long)this.getCountViaIndex(conn, tableName, indexName));
        }
    }

    @Test
    public void testLocalIndexConsistencyWithGlobalMix() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String[] localIndexNames = new String[]{"L_" + LocalIndexIT.generateUniqueName(), "L_" + LocalIndexIT.generateUniqueName()};
        String[] globalIndexNames = new String[]{"G_" + LocalIndexIT.generateUniqueName(), "G_" + LocalIndexIT.generateUniqueName()};
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT, v2 FLOAT, v3 FLOAT, v4 FLOAT) SPLIT ON (4000)");
        int idx = 1;
        for (String indexName : localIndexNames) {
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v" + idx++ + ")");
        }
        for (String indexName : globalIndexNames) {
            conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + tableName + "(v" + idx++ + ")");
        }
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES(rand() * 8000, rand())");
        for (int i = 0; i < 16; ++i) {
            conn.createStatement().execute("UPSERT INTO " + tableName + " SELECT rand() * 8000, rand() FROM " + tableName);
            int count = this.getCountViaIndex(conn, tableName, null);
            for (String indexName : localIndexNames) {
                Assert.assertEquals((long)count, (long)this.getCountViaIndex(conn, tableName, indexName));
            }
            for (String indexName : globalIndexNames) {
                Assert.assertEquals((long)count, (long)this.getCountViaIndex(conn, tableName, indexName));
            }
        }
    }

    private int getCountViaIndex(java.sql.Connection conn, String tableName, String indexName) throws SQLException {
        String hint = indexName == null ? "NO_INDEX" : "INDEX(" + tableName + " " + indexName + ")";
        try (ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ " + hint + " */ COUNT(*) FROM " + tableName);){
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
    }

    @Test
    public void testUseUncoveredLocalIndexWithPrefix() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL, v1 FLOAT, v2 FLOAT, V3 INTEGER CONSTRAINT pk PRIMARY KEY(pk1,pk2,pk3))");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(pk1,pk2,v1,v2)");
        ExplainPlan explainPlan = conn.prepareStatement("SELECT * FROM " + tableName + " WHERE pk1 = 3 AND pk2 = 4").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)physicalTableName.toString(), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" [3,4]", (Object)explainPlanAttributes.getKeyRanges());
        explainPlan = conn.prepareStatement("SELECT v2 FROM " + tableName + " WHERE pk1 = 3 AND pk2 = 4").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)(fullIndexName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" [1,3,4]", (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
        explainPlan = conn.prepareStatement("SELECT v2 FROM " + tableName + " WHERE pk1 = 3 AND pk2 = 4 AND v3 = 1").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)physicalTableName.toString(), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" [3,4]", (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"SERVER FILTER BY V3 = 1", (Object)explainPlanAttributes.getServerWhereFilter());
        explainPlan = conn.prepareStatement("SELECT v2 FROM " + tableName + " WHERE pk1 = 3 AND pk2 = 4 AND v1 = 3 AND v3 = 1").unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
        Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
        Assert.assertEquals((Object)(fullIndexName + "(" + indexPhysicalTableName + ")"), (Object)explainPlanAttributes.getTableName());
        Assert.assertEquals((Object)" [1,3,4,3]", (Object)explainPlanAttributes.getKeyRanges());
        Assert.assertEquals((Object)"[0.V3]", (Object)explainPlanAttributes.getServerMergeColumns().toString());
        Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY AND \"V3\" = 1", (Object)explainPlanAttributes.getServerWhereFilter());
        Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
    }

    @Test
    public void testUseUncoveredLocalIndexWithSplitPrefix() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 INTEGER NOT NULL, pk3 INTEGER NOT NULL, v1 FLOAT, v2 FLOAT, V3 INTEGER CONSTRAINT pk PRIMARY KEY(pk1,pk2,pk3)) SALT_BUCKETS=16");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(pk1,pk3)");
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT pk1, pk2, pk3, v1 FROM " + tableName + " WHERE pk1 = 2 AND pk3 = 3");
        Assert.assertEquals((Object)("CLIENT PARALLEL 16-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,2,3]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
    }

    @Test
    public void testUseUncoveredLocalIndex() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        java.sql.Connection conn = this.getConnection();
        conn.setAutoCommit(true);
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, v1 FLOAT, v2 FLOAT, V3 INTEGER, V4 INTEGER)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v2, v3, v4)");
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT COUNT(*) FROM " + tableName);
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO SINGLE ROW"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName);
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + physicalTableName), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " ORDER BY v2");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " ORDER BY v3");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + physicalTableName + "\n    SERVER SORTED BY [V3]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v2 = 2 ORDER BY v3");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,2]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v1 = 3");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + physicalTableName + "\n    SERVER FILTER BY V1 = 3.0"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v3 = 1");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + physicalTableName + "\n    SERVER FILTER BY V3 = 1"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v2 = 2");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,2]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v2 = 2 AND v4 = 4");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,2]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY AND TO_INTEGER(\"V4\") = 4\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v2 = 2 AND v1 = 3");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,2]\n    SERVER MERGE [0.V1]\n    SERVER FILTER BY FIRST KEY ONLY AND \"V1\" = 3.0\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
        rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + tableName + " WHERE v1 = 3 AND v3 = 1 AND v4 = 1");
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + physicalTableName + "\n    SERVER FILTER BY (V1 = 3.0 AND V3 = 1 AND V4 = 1)"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
        rs.close();
    }

    @Test
    public void testLocalIndexRoundTrip() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        this.createBaseTable(tableName, null, null);
        java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        conn1.createStatement().executeQuery("SELECT * FROM " + tableName).next();
        PTable localIndex = conn1.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexTableName));
        Assert.assertEquals((Object)PTable.IndexType.LOCAL, (Object)localIndex.getIndexType());
        Assert.assertNotNull((Object)localIndex.getViewIndexId());
        String tableName2 = "test_table" + LocalIndexIT.generateUniqueName();
        String indexName2 = "idx_test_table" + LocalIndexIT.generateUniqueName();
        String createTable = "CREATE TABLE IF NOT EXISTS " + tableName2 + " (user_time UNSIGNED_TIMESTAMP NOT NULL,user_id varchar NOT NULL,col1 varchar,col2 double,CONSTRAINT pk PRIMARY KEY(user_time,user_id)) SALT_BUCKETS = 20";
        conn1.createStatement().execute(createTable);
        conn1.createStatement().execute("CREATE local INDEX IF NOT EXISTS " + indexName2 + " on " + tableName2 + "(\"HOUR\"(user_time))");
        conn1.createStatement().execute("upsert into " + tableName2 + " values(TO_TIME('2005-10-01 14:03:22.559'), 'foo')");
        conn1.commit();
        ResultSet rs = conn1.createStatement().executeQuery("select substr(to_char(user_time), 0, 10) as ddate, \"HOUR\"(user_time) as hhour, user_id, col1,col2 from " + tableName2 + " where \"HOUR\"(user_time)=14 group by user_id, col1, col2, ddate, hhour limit 1");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCreationOfTableWithLocalIndexColumnFamilyPrefixShouldFail() throws Exception {
        java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
        try {
            conn1.createStatement().execute("CREATE TABLE T(L#a varchar primary key, aL# integer)");
            Assert.fail((String)"Column families specified in the table creation should not have local colunm prefix.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalIndexCreationWithSplitsShouldFail() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, null);
        java.sql.Connection conn1 = this.getConnection();
        java.sql.Connection conn2 = this.getConnection();
        try {
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) split on (1,2,3)");
            Assert.fail((String)"Local index cannot be pre-split");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            conn2.createStatement().executeQuery("SELECT * FROM " + tableName).next();
            conn2.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexName));
            Assert.fail((String)"Local index should not be created.");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalIndexCreationWithSaltingShouldFail() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, null);
        java.sql.Connection conn1 = this.getConnection();
        java.sql.Connection conn2 = this.getConnection();
        try {
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) salt_buckets=16");
            Assert.fail((String)"Local index cannot be salted.");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            conn2.createStatement().executeQuery("SELECT * FROM " + tableName).next();
            conn2.unwrap(PhoenixConnection.class).getTable(new PTableKey(null, indexName));
            Assert.fail((String)"Local index should not be created.");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testLocalIndexTableRegionSplitPolicyAndSplitKeys() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        java.sql.Connection conn1 = this.getConnection();
        java.sql.Connection conn2 = this.getConnection();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        conn2.createStatement().executeQuery("SELECT * FROM " + tableName).next();
        Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        TableDescriptor htd = admin.getDescriptor(TableName.valueOf((String)indexPhysicalTableName));
        Assert.assertEquals((Object)IndexRegionSplitPolicy.class.getName(), (Object)htd.getValue("SPLIT_POLICY"));
        try (Connection c = ConnectionFactory.createConnection((Configuration)admin.getConfiguration());
             RegionLocator userTable = c.getRegionLocator(SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped));
             RegionLocator indxTable = c.getRegionLocator(TableName.valueOf((String)indexPhysicalTableName));){
            Assert.assertArrayEquals((String)"Both user table and index table should have same split keys.", (Object[])userTable.getStartKeys(), (Object[])indxTable.getStartKeys());
        }
    }

    @Test
    public void testDropLocalIndexTable() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, null);
        String sequenceName = MetaDataUtil.getViewIndexSequenceName((PName)PNameFactory.newName((String)tableName), null, (boolean)this.isNamespaceMapped);
        String sequenceSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName((PName)PNameFactory.newName((String)tableName), (boolean)this.isNamespaceMapped);
        java.sql.Connection conn1 = this.getConnection();
        java.sql.Connection conn2 = this.getConnection();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        LocalIndexIT.verifySequenceValue(null, sequenceName, sequenceSchemaName, -32767L);
        conn2.createStatement().executeQuery("SELECT * FROM " + tableName).next();
        conn1.createStatement().execute("DROP TABLE " + tableName);
        LocalIndexIT.verifySequenceNotExists(null, sequenceName, sequenceSchemaName);
    }

    @Test
    public void testPutsToLocalIndexTable() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        java.sql.Connection conn1 = this.getConnection();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
        conn1.commit();
        ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
        Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        Table indexTable = admin.getConnection().getTable(TableName.valueOf((String)indexPhysicalTableName));
        Pair startEndKeys = admin.getConnection().getRegionLocator(TableName.valueOf((String)indexPhysicalTableName)).getStartEndKeys();
        byte[][] startKeys = (byte[][])startEndKeys.getFirst();
        byte[][] endKeys = (byte[][])startEndKeys.getSecond();
        for (int i = 0; i < startKeys.length; ++i) {
            Scan s = new Scan();
            s.addFamily(QueryConstants.DEFAULT_LOCAL_INDEX_COLUMN_FAMILY_BYTES);
            s.withStartRow(startKeys[i]);
            s.withStopRow(endKeys[i]);
            ResultScanner scanner = indexTable.getScanner(s);
            int count = 0;
            for (Result r : scanner) {
                ++count;
            }
            scanner.close();
            Assert.assertEquals((long)1L, (long)count);
        }
        indexTable.close();
    }

    @Test
    public void testLocalIndexUsedForUncoveredOrderBy() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = this.getConnection();){
            String next;
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            String query = "SELECT * FROM " + tableName + " ORDER BY V1";
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
            int numRegions = admin.getRegions(physicalTableName).size();
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1]\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            String v = "";
            int i = 0;
            while (rs.next()) {
                next = rs.getString("v1");
                Assert.assertTrue((v.compareTo(next) <= 0 ? 1 : 0) != 0);
                v = next;
                ++i;
            }
            Assert.assertEquals((long)4L, (long)i);
            rs.close();
            query = "SELECT * FROM " + tableName + " ORDER BY V1 DESC NULLS LAST";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY REVERSE RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1]\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            v = "zz";
            i = 0;
            while (rs.next()) {
                next = rs.getString("v1");
                Assert.assertTrue((v.compareTo(next) >= 0 ? 1 : 0) != 0);
                v = next;
                ++i;
            }
            Assert.assertEquals((long)4L, (long)i);
            rs.close();
        }
    }

    @Test
    public void testLocalIndexReverseScanShouldReturnAllRows() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = this.getConnection();){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'b')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            String query = "SELECT V1 FROM " + tableName + " ORDER BY V1 DESC NULLS LAST";
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
            int numRegions = admin.getRegions(physicalTableName).size();
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY REVERSE RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            String v = "zz";
            int i = 0;
            while (rs.next()) {
                String next = rs.getString("v1");
                Assert.assertTrue((v.compareTo(next) >= 0 ? 1 : 0) != 0);
                v = next;
                ++i;
            }
            Assert.assertEquals((long)4L, (long)i);
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanJoinColumnsFromDataTable() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)this.schemaName, (String)indexName);
        String indexTableName = this.schemaName + "." + indexName;
        TableName physicalTableName = SchemaUtil.getPhysicalTableName((byte[])tableName.getBytes(), (boolean)this.isNamespaceMapped);
        String indexPhysicalTableName = physicalTableName.getNameAsString();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = this.getConnection();){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
            int numRegions = admin.getRegions(physicalTableName).size();
            String query = "SELECT t_id, k1, k2, k3, V1 FROM " + tableName + " where v1='a'";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,'a']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2, k3, V1 from " + tableName + "  where v1<='z' order by V1,t_id";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,*] - [1,'z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"q", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            query = "SELECT t_id, V1, k3 from " + tableName + "  where v1 <='z' group by v1,t_id, k3";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,*] - [1,'z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"V1\", \"T_ID\", \"K3\"]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"q", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            query = "SELECT v1,sum(k3) from " + tableName + " where v1 <='z'  group by v1 order by v1";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL " + numRegions + "-WAY RANGE SCAN OVER " + fullIndexName + "(" + indexPhysicalTableName + ") [1,*] - [1,'z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"V1\"]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            PhoenixStatement stmt = conn1.createStatement().unwrap(PhoenixStatement.class);
            rs = stmt.executeQuery(query);
            QueryPlan plan = stmt.getQueryPlan();
            Assert.assertEquals((Object)indexTableName, (Object)plan.getContext().getCurrentTable().getTable().getName().getString());
            Assert.assertEquals((Object)"_OrderedGroupByExpressions", (Object)plan.getGroupBy().getScanAttribName());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)5L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
        }
    }

    @Test
    public void testIndexPlanSelectionIfBothGlobalAndLocalIndexesHasSameColumnsAndOrder() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        this.createBaseTable(tableName, null, "('e','i','o')");
        java.sql.Connection conn1 = this.getConnection();
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,3,'a')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
        conn1.commit();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
        conn1.createStatement().execute("CREATE INDEX " + indexName + "2 ON " + tableName + "(v1)");
        String query = "SELECT t_id, k1, k2,V1 FROM " + tableName + " where v1='a'";
        ResultSet rs1 = conn1.createStatement().executeQuery("EXPLAIN " + query);
        Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)indexTableName), (boolean)this.isNamespaceMapped) + "2 ['a']\n    SERVER FILTER BY FIRST KEY ONLY"), (Object)QueryUtil.getExplainPlan((ResultSet)rs1));
        conn1.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropLocalIndexShouldDeleteDataFromLocalIndexTable() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("DROP INDEX " + indexName + " ON " + tableName);
            Admin admin = driver.getConnectionQueryServices(LocalIndexIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
            Table table = admin.getConnection().getTable(TableName.valueOf((String)tableName));
            Pair startEndKeys = admin.getConnection().getRegionLocator(TableName.valueOf((String)tableName)).getStartEndKeys();
            byte[][] startKeys = (byte[][])startEndKeys.getFirst();
            byte[][] endKeys = (byte[][])startEndKeys.getSecond();
            for (int i = 0; i < startKeys.length; ++i) {
                ColumnFamilyDescriptor[] families;
                Scan s = new Scan();
                s.withStartRow(startKeys[i]);
                s.withStopRow(endKeys[i]);
                for (ColumnFamilyDescriptor cf : families = table.getDescriptor().getColumnFamilies()) {
                    if (!cf.getNameAsString().startsWith("L#")) continue;
                    s.addFamily(cf.getName());
                }
                ResultScanner scanner = table.getScanner(s);
                int count = 0;
                for (Result r : scanner) {
                    ++count;
                }
                scanner.close();
                Assert.assertEquals((long)0L, (long)count);
            }
            table.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexRowsShouldBeDeletedWhenUserTableRowsDeleted() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("DELETE FROM " + tableName + " where v1='a'");
            conn1.commit();
            conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexesOnTableWithImmutableRows() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = this.getConnection();){
            conn1.createStatement().execute("ALTER TABLE " + tableName + " SET IMMUTABLE_ROWS=true");
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            conn1.createStatement().execute("CREATE INDEX " + indexName + "2 ON " + tableName + "(k3)");
            conn1.commit();
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            rs = conn1.createStatement().executeQuery("SELECT v1 FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString("v1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString("v1"));
            Assert.assertFalse((boolean)rs.next());
            rs = conn1.createStatement().executeQuery("SELECT k3 FROM " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexScanWithInList() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        String indexTableName = this.schemaName + "." + indexName;
        this.createBaseTable(tableName, null, "('e','i','o')");
        try (java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1) include (k3)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName);
            Assert.assertTrue((boolean)rs.next());
            String query = "SELECT t_id FROM " + tableName + " where (v1,k3) IN (('z',4),('a',2))";
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexCreationWithDefaultFamilyOption() throws Exception {
        try (java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());){
            Statement statement = conn1.createStatement();
            String tableName = LocalIndexIT.generateUniqueName();
            String indexName = LocalIndexIT.generateUniqueName();
            statement.execute("create table " + tableName + " (id integer not null,fn varchar,\"ln\" varchar constraint pk primary key(id)) DEFAULT_COLUMN_FAMILY='F'");
            statement.execute("upsert into " + tableName + "  values(1,'fn','ln')");
            statement.execute("create local index " + indexName + " on " + tableName + "  (fn)");
            statement.execute("upsert into " + tableName + "  values(2,'fn1','ln1')");
            ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
        }
    }

    @Test
    public void testLocalIndexAutomaticRepair() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        PhoenixConnection conn = DriverManager.getConnection(LocalIndexIT.getUrl()).unwrap(PhoenixConnection.class);
        try (Table metaTable = conn.getQueryServices().getTable(TableName.META_TABLE_NAME.getName());
             Admin admin = conn.getQueryServices().getAdmin();){
            Statement statement = conn.createStatement();
            String tableName = "T_AUTO_MATIC_REPAIR";
            String indexName = "IDX_T_AUTO_MATIC_REPAIR";
            String indexName1 = "IDX_T_AUTO_MATIC_REPAIR_1";
            statement.execute("create table T_AUTO_MATIC_REPAIR (id integer not null,fn varchar,cf1.ln varchar constraint pk primary key(id)) split on (400,800,1200,1600)");
            statement.execute("create local index " + indexName + " on " + "T_AUTO_MATIC_REPAIR" + "  (fn,cf1.ln)");
            statement.execute("create local index " + indexName1 + " on " + "T_AUTO_MATIC_REPAIR" + "  (fn)");
            for (int i = 0; i < 2000; ++i) {
                statement.execute("upsert into T_AUTO_MATIC_REPAIR  values(" + i + ",'fn" + i + "','ln" + i + "')");
            }
            conn.commit();
            ResultSet rs = statement.executeQuery("SELECT COUNT(*) FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2000L, (long)rs.getLong(1));
            List tableRegions = admin.getRegions(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            admin.disableTable(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            this.copyLocalIndexHFiles(config, (RegionInfo)tableRegions.get(0), (RegionInfo)tableRegions.get(1), false);
            this.copyLocalIndexHFiles(config, (RegionInfo)tableRegions.get(3), (RegionInfo)tableRegions.get(0), false);
            admin.enableTable(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            int count = this.getCount(conn, "T_AUTO_MATIC_REPAIR", "L#0");
            Assert.assertTrue((count > 4000 ? 1 : 0) != 0);
            admin.majorCompact(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            int tryCount = 5;
            while (tryCount-- > 0 && count != 4000) {
                Thread.sleep(15000L);
                count = this.getCount(conn, "T_AUTO_MATIC_REPAIR", "L#0");
            }
            Assert.assertEquals((long)4000L, (long)count);
            rs = statement.executeQuery("SELECT COUNT(*) FROM " + indexName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2000L, (long)rs.getLong(1));
            rs = statement.executeQuery("SELECT COUNT(*) FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2000L, (long)rs.getLong(1));
            statement.execute("DROP INDEX " + indexName1 + " ON " + "T_AUTO_MATIC_REPAIR");
            admin.majorCompact(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            statement.execute("DROP INDEX " + indexName + " ON " + "T_AUTO_MATIC_REPAIR");
            admin.majorCompact(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            Thread.sleep(15000L);
            admin.majorCompact(TableName.valueOf((String)"T_AUTO_MATIC_REPAIR"));
            Thread.sleep(15000L);
            rs = statement.executeQuery("SELECT COUNT(*) FROM T_AUTO_MATIC_REPAIR");
            Assert.assertTrue((boolean)rs.next());
        }
    }

    @Test
    public void testLocalGlobalIndexMix() throws Exception {
        if (this.isNamespaceMapped) {
            return;
        }
        String tableName = LocalIndexIT.generateUniqueName();
        java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nv2 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n";
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("CREATE LOCAL INDEX LV1 ON " + tableName + "(v1)");
        conn1.createStatement().execute("CREATE INDEX GV2 ON " + tableName + "(v2)");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,2,4,'z','3')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('f',1,2,3,'a','0')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('j',2,4,2,'a','2')");
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values('q',3,1,1,'c','1')");
        conn1.commit();
        ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v1 = 'c'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + tableName + " WHERE v2 = '2'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        conn1.close();
    }

    @Test
    public void testLocalIndexSelfJoin() throws Exception {
        String tableName = LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        java.sql.Connection conn1 = DriverManager.getConnection(LocalIndexIT.getUrl());
        if (this.isNamespaceMapped) {
            conn1.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
        }
        String ddl = "CREATE TABLE " + tableName + " (customer_id integer primary key, postal_code varchar, country_code varchar)";
        conn1.createStatement().execute(ddl);
        conn1.createStatement().execute("UPSERT INTO " + tableName + " values(1,'560103','IN')");
        conn1.commit();
        conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(postal_code)");
        ResultSet rs = conn1.createStatement().executeQuery("SELECT * from " + tableName + " c1, " + tableName + " c2 where c1.customer_id=c2.customer_id and c2.postal_code='560103'");
        Assert.assertTrue((boolean)rs.next());
        conn1.close();
    }

    private void copyLocalIndexHFiles(Configuration conf, RegionInfo fromRegion, RegionInfo toRegion, boolean move) throws IOException {
        Path root = CommonFSUtils.getRootDir((Configuration)conf);
        Path seondRegion = new Path(CommonFSUtils.getTableDir((Path)root, (TableName)fromRegion.getTable()) + "/" + fromRegion.getEncodedName() + "/" + "L#0/");
        Path hfilePath = ((LocatedFileStatus)CommonFSUtils.getCurrentFileSystem((Configuration)conf).listFiles(seondRegion, true).next()).getPath();
        Path firstRegionPath = new Path(CommonFSUtils.getTableDir((Path)root, (TableName)toRegion.getTable()) + "/" + toRegion.getEncodedName() + "/" + "L#0/");
        FileSystem currentFileSystem = CommonFSUtils.getCurrentFileSystem((Configuration)conf);
        Assert.assertTrue((boolean)FileUtil.copy((FileSystem)currentFileSystem, (Path)hfilePath, (FileSystem)currentFileSystem, (Path)firstRegionPath, (boolean)move, (Configuration)conf));
    }

    private int getCount(PhoenixConnection conn, String tableName, String columnFamily) throws IOException, SQLException {
        Iterator iterator = conn.getQueryServices().getTable(Bytes.toBytes((String)tableName)).getScanner(Bytes.toBytes((String)columnFamily)).iterator();
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLocalIndexForMultiTenantTable() throws Exception {
        String tableName = this.schemaName + "." + LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        try (java.sql.Connection conn1 = this.getConnection();){
            if (this.isNamespaceMapped) {
                conn1.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + this.schemaName);
            }
            String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nv1 VARCHAR,\nv2 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1)) MULTI_TENANT=true";
            conn1.createStatement().execute(ddl);
            conn1.createStatement().execute("UPSERT INTO " + tableName + " values('b',1,'x','y')");
            conn1.commit();
            conn1.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + "(v1)");
            ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE v1 = 'x'");
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("T_ID"));
            Assert.assertEquals((Object)"y", (Object)rs.getString("V2"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testEstimatesWithLocalIndexes() throws Exception {
        String tableName = LocalIndexIT.generateUniqueName();
        String indexName = "IDX_" + LocalIndexIT.generateUniqueName();
        try (java.sql.Connection conn = DriverManager.getConnection(LocalIndexIT.getUrl());){
            int guidePostWidth = 20;
            conn.createStatement().execute("CREATE TABLE " + tableName + " (k INTEGER PRIMARY KEY, a bigint, b bigint) GUIDE_POSTS_WIDTH=" + guidePostWidth);
            conn.createStatement().execute("upsert into " + tableName + " values (100,1,3)");
            conn.createStatement().execute("upsert into " + tableName + " values (101,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (102,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (103,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (104,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (105,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (106,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (107,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (108,2,4)");
            conn.createStatement().execute("upsert into " + tableName + " values (109,2,4)");
            conn.commit();
            conn.createStatement().execute("CREATE LOCAL INDEX " + indexName + " ON " + tableName + " (a) INCLUDE (b) ");
            String ddl = "ALTER TABLE " + tableName + " SET USE_STATS_FOR_PARALLELIZATION = false";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPDATE STATISTICS " + tableName + "");
        }
        ArrayList binds = Lists.newArrayList();
        try (java.sql.Connection conn = DriverManager.getConnection(LocalIndexIT.getUrl());){
            String sql = "SELECT COUNT(*)  FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((String)("Index " + indexName + " should have been used"), (boolean)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getTableRef().getTable().getName().getString().equals(indexName));
            ExplainPlanWithStatsEnabledIT.Estimate info = ExplainPlanWithStatsEnabledIT.getByteRowEstimates(conn, sql, binds);
            Assert.assertEquals((Object)10L, (Object)info.getEstimatedRows());
            Assert.assertTrue((info.getEstimateInfoTs() > 0L ? 1 : 0) != 0);
        }
    }
}

