/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Map;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.phoenix.compat.hbase.ByteStringer;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.coprocessorclient.MetaDataProtocol;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.Closeables;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={ParallelStatsDisabledTest.class})
public class InvalidIndexStateClientSideIT
extends ParallelStatsDisabledIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvalidIndexStateClientSideIT.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCachedConnections() throws Throwable {
        long tableResolvedTimestamp;
        String schemaName = InvalidIndexStateClientSideIT.generateUniqueName();
        String tableName = InvalidIndexStateClientSideIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String indexName = InvalidIndexStateClientSideIT.generateUniqueName();
        String fullIndexName = SchemaUtil.getTableName((String)schemaName, (String)indexName);
        Connection conn = DriverManager.getConnection(InvalidIndexStateClientSideIT.getUrl());
        String createTableSql = "CREATE TABLE " + fullTableName + "(org_id VARCHAR NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER, v3 INTEGER)";
        conn.createStatement().execute(createTableSql);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + "(v1)");
        conn.commit();
        PhoenixConnection phoenixConn = conn.unwrap(PhoenixConnection.class);
        ConnectionQueryServices queryServices = phoenixConn.getQueryServices();
        Table metaTable = phoenixConn.getQueryServices().getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        long ts = EnvironmentEdgeManager.currentTimeMillis();
        MetaDataProtocol.MutationCode code = IndexUtil.updateIndexState((String)fullIndexName, (long)ts, (Table)metaTable, (PIndexState)PIndexState.PENDING_DISABLE).getMutationCode();
        Assert.assertEquals((Object)MetaDataProtocol.MutationCode.TABLE_ALREADY_EXISTS, (Object)code);
        ts = EnvironmentEdgeManager.currentTimeMillis();
        final byte[] schemaBytes = PVarchar.INSTANCE.toBytes((Object)schemaName);
        final byte[] tableBytes = PVarchar.INSTANCE.toBytes((Object)tableName);
        PName tenantId = phoenixConn.getTenantId();
        long tableTimestamp = Long.MAX_VALUE;
        final long resolvedTimestamp = tableResolvedTimestamp = Long.MAX_VALUE;
        final byte[] tenantIdBytes = tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : tenantId.getBytes();
        byte[] tableKey = SchemaUtil.getTableKey((byte[])tenantIdBytes, (byte[])schemaBytes, (byte[])tableBytes);
        Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse> callable = new Batch.Call<MetaDataProtos.MetaDataService, MetaDataProtos.MetaDataResponse>(){

            public MetaDataProtos.MetaDataResponse call(MetaDataProtos.MetaDataService instance) throws IOException {
                ServerRpcController controller = new ServerRpcController();
                CoprocessorRpcUtils.BlockingRpcCallback rpcCallback = new CoprocessorRpcUtils.BlockingRpcCallback();
                MetaDataProtos.GetTableRequest.Builder builder = MetaDataProtos.GetTableRequest.newBuilder();
                builder.setTenantId(ByteStringer.wrap((byte[])tenantIdBytes));
                builder.setSchemaName(ByteStringer.wrap((byte[])schemaBytes));
                builder.setTableName(ByteStringer.wrap((byte[])tableBytes));
                builder.setTableTimestamp(Long.MAX_VALUE);
                builder.setClientTimestamp(resolvedTimestamp);
                builder.setClientVersion(VersionUtil.encodeVersion((int)5, (int)13, (int)0));
                instance.getTable((RpcController)controller, builder.build(), (RpcCallback)rpcCallback);
                if (controller.getFailedOn() != null) {
                    throw controller.getFailedOn();
                }
                return (MetaDataProtos.MetaDataResponse)rpcCallback.get();
            }
        };
        int version = VersionUtil.encodeVersion((int)5, (int)13, (int)0);
        LOGGER.info("Client version: " + version);
        Table ht = queryServices.getTable(PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES);
        try {
            Map results = ht.coprocessorService(MetaDataProtos.MetaDataService.class, tableKey, tableKey, (Batch.Call)callable);
            assert (results.size() == 1);
            MetaDataProtos.MetaDataResponse result = (MetaDataProtos.MetaDataResponse)results.values().iterator().next();
            assert (result.getTable().getIndexesCount() == 1);
            assert (PIndexState.valueOf((String)result.getTable().getIndexes(0).getIndexState()).equals((Object)PIndexState.DISABLE));
        }
        catch (Exception e) {
            LOGGER.error("Exception Occurred: " + e);
        }
        finally {
            Closeables.closeQuietly((Closeable)ht);
        }
    }
}

