/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexWithTableSchemaChangeIT
extends ParallelStatsDisabledIT {
    private void assertIndexExists(Connection conn, boolean exists, String schemaName, String dataTableName) throws SQLException {
        ResultSet rs = conn.getMetaData().getIndexInfo(null, schemaName, dataTableName, false, false);
        Assert.assertEquals((Object)exists, (Object)rs.next());
    }

    @Test
    public void testImmutableIndexDropIndexedColumn() throws Exception {
        this.helpTestDropIndexedColumn(false, false);
    }

    @Test
    public void testImmutableLocalIndexDropIndexedColumn() throws Exception {
        this.helpTestDropIndexedColumn(false, true);
    }

    @Test
    public void testMutableIndexDropIndexedColumn() throws Exception {
        this.helpTestDropIndexedColumn(true, false);
    }

    @Test
    public void testMutableLocalIndexDropIndexedColumn() throws Exception {
        this.helpTestDropIndexedColumn(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestDropIndexedColumn(boolean mutable, boolean local) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexName = IndexWithTableSchemaChangeIT.generateUniqueName();
        try {
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)" + (!mutable ? " IMMUTABLE_ROWS=true" : ""));
            String query = "SELECT * FROM " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (local ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (v1 || '_' || v2)");
            query = "SELECT * FROM " + dataTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            IndexWithTableSchemaChangeIT.assertIndexExists(conn, dataTableName, true);
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " DROP COLUMN v1");
            IndexWithTableSchemaChangeIT.assertIndexExists(conn, dataTableName, false);
            query = "SELECT * FROM " + dataTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "2");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + dataTableName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    private static void assertIndexExists(Connection conn, String tableName, boolean exists) throws SQLException {
        ResultSet rs = conn.getMetaData().getIndexInfo(null, null, tableName, false, false);
        Assert.assertEquals((Object)exists, (Object)rs.next());
    }

    @Test
    public void testImmutableIndexDropCoveredColumn() throws Exception {
        this.helpTestDropCoveredColumn(false, false);
    }

    @Test
    public void testImmutableLocalIndexDropCoveredColumn() throws Exception {
        this.helpTestDropCoveredColumn(false, true);
    }

    @Test
    public void testMutableIndexDropCoveredColumn() throws Exception {
        this.helpTestDropCoveredColumn(true, false);
    }

    @Test
    public void testMutableLocalIndexDropCoveredColumn() throws Exception {
        this.helpTestDropCoveredColumn(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestDropCoveredColumn(boolean mutable, boolean local) throws Exception {
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexName = IndexWithTableSchemaChangeIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR)");
            String dataTableQuery = "SELECT * FROM " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (local ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (k || '_' || v1) include (v2, v3)");
            String indexTableQuery = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.setString(4, "j");
            stmt.execute();
            conn.commit();
            IndexWithTableSchemaChangeIT.assertIndexExists(conn, dataTableName, true);
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " DROP COLUMN v2");
            IndexWithTableSchemaChangeIT.assertIndexExists(conn, dataTableName, true);
            rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"j", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a_x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"j", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?)");
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "k");
            stmt.execute();
            conn.commit();
            rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"j", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"k", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a_x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"j", (Object)rs.getString(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b_y", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((Object)"k", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testImmutableIndexAddPKColumnToTable() throws Exception {
        this.helpTestAddPKColumnToTable(false, false);
    }

    @Test
    public void testImmutableLocalIndexAddPKColumnToTable() throws Exception {
        this.helpTestAddPKColumnToTable(false, true);
    }

    @Test
    public void testMutableIndexAddPKColumnToTable() throws Exception {
        this.helpTestAddPKColumnToTable(true, false);
    }

    @Test
    public void testMutableLocalIndexAddPKColumnToTable() throws Exception {
        this.helpTestAddPKColumnToTable(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestAddPKColumnToTable(boolean mutable, boolean local) throws Exception {
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexName = IndexWithTableSchemaChangeIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);){
            conn.setAutoCommit(false);
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR)");
            String dataTableQuery = "SELECT * FROM " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (local ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (v1 || '_' || v2)");
            String indexTableQuery = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            conn.commit();
            IndexWithTableSchemaChangeIT.assertIndexExists(conn, dataTableName, true);
            conn.createStatement().execute("ALTER TABLE " + dataTableName + " ADD v3 VARCHAR, k2 DECIMAL PRIMARY KEY");
            rs = conn.getMetaData().getPrimaryKeys("", "", dataTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"K", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)1L, (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"K2", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)2L, (long)rs.getShort("KEY_SEQ"));
            rs = conn.getMetaData().getPrimaryKeys("", "", indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)":(V1 || '_' || V2)", (Object)rs.getString("COLUMN_NAME"));
            int offset = local ? 1 : 0;
            Assert.assertEquals((long)(offset + 1), (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)":K", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)(offset + 2), (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)":K2", (Object)rs.getString("COLUMN_NAME"));
            Assert.assertEquals((long)(offset + 3), (long)rs.getShort("KEY_SEQ"));
            rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertNull((Object)rs.getBigDecimal(4));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getBigDecimal(3));
            Assert.assertFalse((boolean)rs.next());
            stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + "(K,K2,V1,V2) VALUES(?,?,?,?)");
            stmt.setString(1, "b");
            stmt.setBigDecimal(2, BigDecimal.valueOf(2L));
            stmt.setString(3, "y");
            stmt.setString(4, "2");
            stmt.execute();
            conn.commit();
            rs = conn.createStatement().executeQuery(dataTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"1", (Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertNull((Object)rs.getBigDecimal(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"2", (Object)rs.getString(3));
            Assert.assertNull((Object)rs.getString(4));
            Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)rs.getBigDecimal(5));
            Assert.assertFalse((boolean)rs.next());
            rs = conn.createStatement().executeQuery(indexTableQuery);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertNull((Object)rs.getBigDecimal(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y_2", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)rs.getBigDecimal(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testDropIndexedColumnImmutableIndex() throws Exception {
        this.helpTestDropIndexedEncodedColumn(true, false);
    }

    @Test
    public void testDropIndexedColumnMutableIndex() throws Exception {
        this.helpTestDropIndexedEncodedColumn(false, false);
    }

    @Test
    public void testDropIndexedColumnImmutableEncodedIndex() throws Exception {
        this.helpTestDropIndexedEncodedColumn(true, true);
    }

    @Test
    public void testDropIndexedColumnMutableEncodedIndex() throws Exception {
        this.helpTestDropIndexedEncodedColumn(false, true);
    }

    private void helpTestDropIndexedEncodedColumn(boolean immutable, boolean columnEncoded) throws Exception {
        String schemaName = "";
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexTableName = "I_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String localIndexTableName = "LI_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE " + (immutable ? "IMMUTABLE" : "") + " TABLE " + dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) " + (!columnEncoded ? "IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN : ""));
        String query = "SELECT * FROM " + dataTableFullName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (v1, v2)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexTableName + " ON " + dataTableFullName + " (v1, v2)");
        query = "SELECT * FROM " + indexTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "x");
        stmt.setString(3, "1");
        stmt.execute();
        conn.commit();
        this.assertIndexExists(conn, true, schemaName, dataTableName);
        conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " DROP COLUMN v1");
        this.assertIndexExists(conn, false, schemaName, dataTableName);
        query = "SELECT * FROM " + dataTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"1", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "2");
        stmt.execute();
        conn.commit();
        query = "SELECT * FROM " + dataTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"2", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDropCoveredColumn() throws Exception {
        String schemaName = "";
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexTableName = "I_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String localIndexTableName = "LI_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        String localIndexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)localIndexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR, v3 VARCHAR) ");
        String dataTableQuery = "SELECT * FROM " + dataTableFullName;
        ResultSet rs = conn.createStatement().executeQuery(dataTableQuery);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (v1) include (v2, v3)");
        conn.createStatement().execute("CREATE LOCAL INDEX " + localIndexTableName + " ON " + dataTableFullName + " (v1) include (v2, v3)");
        rs = conn.createStatement().executeQuery(dataTableQuery);
        Assert.assertFalse((boolean)rs.next());
        String indexTableQuery = "SELECT * FROM " + indexTableName;
        rs = conn.createStatement().executeQuery(indexTableQuery);
        Assert.assertFalse((boolean)rs.next());
        String localIndexTableQuery = "SELECT * FROM " + localIndexTableFullName;
        rs = conn.createStatement().executeQuery(localIndexTableQuery);
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "x");
        stmt.setString(3, "1");
        stmt.setString(4, "j");
        stmt.execute();
        conn.commit();
        this.assertIndexExists(conn, true, schemaName, dataTableName);
        conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " DROP COLUMN v2");
        this.assertIndexExists(conn, true, schemaName, dataTableName);
        Scan scan = new Scan();
        Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)dataTableFullName));
        ResultScanner results = table.getScanner(scan);
        for (Result res : results) {
            Assert.assertNull((String)"Column value was not deleted", (Object)res.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"V2")));
        }
        results.close();
        rs = conn.createStatement().executeQuery(dataTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"x", (Object)rs.getString(2));
        Assert.assertEquals((Object)"j", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        scan = new Scan();
        table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)indexTableFullName));
        results = table.getScanner(scan);
        for (Result res : results) {
            Assert.assertNull((String)"Column value was not deleted", (Object)res.getValue(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"0:V2")));
        }
        results.close();
        rs = conn.createStatement().executeQuery(indexTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertEquals((Object)"j", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery(localIndexTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertEquals((Object)"j", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "y");
        stmt.setString(3, "k");
        stmt.execute();
        conn.commit();
        rs = conn.createStatement().executeQuery(dataTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"y", (Object)rs.getString(2));
        Assert.assertEquals((Object)"k", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery(indexTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"y", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertEquals((Object)"k", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.createStatement().executeQuery(localIndexTableQuery);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"y", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertEquals((Object)"k", (Object)rs.getString(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testAddPKColumnToTableWithIndex() throws Exception {
        String schemaName = "";
        String dataTableName = IndexWithTableSchemaChangeIT.generateUniqueName();
        String indexTableName = "I_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String localIndexTableName = "LI_" + IndexWithTableSchemaChangeIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexWithTableSchemaChangeIT.getUrl(), props);
        conn.setAutoCommit(false);
        conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (k VARCHAR NOT NULL PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) ");
        String query = "SELECT * FROM " + dataTableFullName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableFullName + " (v1) include (v2)");
        query = "SELECT * FROM " + indexTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertFalse((boolean)rs.next());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        stmt.setString(1, "a");
        stmt.setString(2, "x");
        stmt.setString(3, "1");
        stmt.execute();
        conn.commit();
        this.assertIndexExists(conn, true, schemaName, dataTableName);
        conn.createStatement().execute("ALTER TABLE " + dataTableFullName + " ADD v3 VARCHAR, k2 DECIMAL PRIMARY KEY, k3 DECIMAL PRIMARY KEY");
        rs = conn.getMetaData().getPrimaryKeys("", schemaName, dataTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"K", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"K2", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)2L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"K3", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)3L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertFalse((boolean)rs.next());
        rs = conn.getMetaData().getPrimaryKeys("", schemaName, indexTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"0:V1", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)1L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)":K", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)2L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)":K2", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)3L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)":K3", (Object)rs.getString("COLUMN_NAME"));
        Assert.assertEquals((long)4L, (long)rs.getShort("KEY_SEQ"));
        Assert.assertFalse((boolean)rs.next());
        query = "SELECT * FROM " + dataTableFullName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
        Assert.assertEquals((Object)"x", (Object)rs.getString(2));
        Assert.assertEquals((Object)"1", (Object)rs.getString(3));
        Assert.assertNull((Object)rs.getBigDecimal(4));
        Assert.assertFalse((boolean)rs.next());
        stmt = conn.prepareStatement("UPSERT INTO " + dataTableFullName + "(K,K2,V1,V2,K3) VALUES(?,?,?,?,?)");
        stmt.setString(1, "b");
        stmt.setBigDecimal(2, BigDecimal.valueOf(2L));
        stmt.setString(3, "y");
        stmt.setString(4, "2");
        stmt.setBigDecimal(5, BigDecimal.valueOf(3L));
        stmt.execute();
        conn.commit();
        query = "SELECT k,k2,k3 FROM " + dataTableFullName + " WHERE v1='y'";
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        Assert.assertEquals((Object)BigDecimal.valueOf(2L), (Object)rs.getBigDecimal(2));
        Assert.assertEquals((Object)BigDecimal.valueOf(3L), (Object)rs.getBigDecimal(3));
        Assert.assertFalse((boolean)rs.next());
    }
}

