/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.mapreduce.index.IndexTool;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRepository;
import org.apache.phoenix.mapreduce.index.IndexVerificationOutputRow;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.util.EnvironmentEdge;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.ManualEnvironmentEdge;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexVerificationOutputRepositoryIT
extends ParallelStatsDisabledIT {
    @BeforeClass
    public static synchronized void setupClass() throws Exception {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("phoenix.task.handling.interval.ms", "100000000");
        IndexVerificationOutputRepositoryIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @Test
    public void testReadIndexVerificationOutputRow() throws Exception {
        String expectedErrorMessage = "I am an error message";
        byte[] expectedValue = Bytes.toBytes((String)"ab");
        byte[] actualValue = Bytes.toBytes((String)"ac");
        try (Connection conn = DriverManager.getConnection(IndexVerificationOutputRepositoryIT.getUrl());){
            String tableName = "T" + IndexVerificationOutputRepositoryIT.generateUniqueName();
            byte[] tableNameBytes = Bytes.toBytes((String)tableName);
            String indexName = "I" + IndexVerificationOutputRepositoryIT.generateUniqueName();
            this.createTableAndIndexes(conn, tableName, indexName);
            byte[] indexNameBytes = Bytes.toBytes((String)indexName);
            IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(indexNameBytes, conn);
            outputRepository.createOutputTable(conn);
            this.populateTable(conn, tableName);
            byte[] dataRowKey = this.getRowKey(conn, tableNameBytes);
            byte[] indexRowKey = this.getRowKey(conn, indexNameBytes);
            long dataRowTs = this.getTimestamp(conn, tableNameBytes);
            long indexRowTs = this.getTimestamp(conn, indexNameBytes);
            long scanMaxTs = EnvironmentEdgeManager.currentTimeMillis();
            outputRepository.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, expectedErrorMessage, expectedValue, actualValue, scanMaxTs, tableNameBytes, true, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            outputRepository.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, expectedErrorMessage, expectedValue, actualValue, scanMaxTs + 1L, tableNameBytes, false, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            IndexVerificationOutputRow expectedRow = this.buildVerificationRow(dataRowKey, indexRowKey, dataRowTs, indexRowTs, expectedErrorMessage, expectedValue, actualValue, scanMaxTs, tableNameBytes, indexNameBytes, IndexVerificationOutputRepository.PHASE_BEFORE_VALUE, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            this.verifyOutputRow(outputRepository, scanMaxTs, indexNameBytes, expectedRow);
            IndexVerificationOutputRow secondExpectedRow = this.buildVerificationRow(dataRowKey, indexRowKey, dataRowTs, indexRowTs, expectedErrorMessage, expectedValue, actualValue, scanMaxTs + 1L, tableNameBytes, indexNameBytes, IndexVerificationOutputRepository.PHASE_AFTER_VALUE, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            this.verifyOutputRow(outputRepository, scanMaxTs + 1L, indexNameBytes, secondExpectedRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTTLOnOutputTable() throws SQLException, IOException {
        String mockString = "mock_value";
        byte[] mockStringBytes = Bytes.toBytes((String)mockString);
        try (Connection conn = DriverManager.getConnection(IndexVerificationOutputRepositoryIT.getUrl());){
            Table hTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES);
            IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(mockStringBytes, conn);
            outputRepository.createOutputTable(conn);
            TestUtil.assertTTLValue(conn, TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES), 604800, false);
            ManualEnvironmentEdge customClock = new ManualEnvironmentEdge();
            customClock.setValue(EnvironmentEdgeManager.currentTimeMillis());
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customClock);
            outputRepository.logToIndexToolOutputTable(mockStringBytes, mockStringBytes, 1L, 2L, mockString, mockStringBytes, mockStringBytes, EnvironmentEdgeManager.currentTimeMillis(), mockStringBytes, true, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
            customClock.incrementValue(1L);
            Assert.assertEquals((long)1L, (long)TestUtil.getRowCount(hTable, false));
            customClock.incrementValue(604805000L);
            EnvironmentEdgeManager.injectEdge((EnvironmentEdge)customClock);
            int count = TestUtil.getRowCount(hTable, false);
            Assert.assertEquals((long)0L, (long)count);
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testDisableLoggingBefore() throws SQLException, IOException {
        IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.BEFORE;
        boolean expectedBefore = false;
        boolean expectedAfter = true;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
    }

    @Test
    public void testDisableLoggingAfter() throws SQLException, IOException {
        IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.AFTER;
        boolean expectedBefore = true;
        boolean expectedAfter = false;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
    }

    @Test
    public void testDisableLoggingBoth() throws SQLException, IOException {
        IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.BOTH;
        boolean expectedBefore = false;
        boolean expectedAfter = false;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
    }

    @Test
    public void testDisableLoggingNone() throws SQLException, IOException {
        IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.NONE;
        boolean expectedBefore = true;
        boolean expectedAfter = true;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.INVALID_ROW);
    }

    @Test
    public void testDisableLoggingBeyondMaxLookback() throws SQLException, IOException {
        IndexTool.IndexDisableLoggingType disableLoggingVerifyType = IndexTool.IndexDisableLoggingType.NONE;
        boolean expectedBefore = false;
        boolean expectedAfter = false;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_INVALID, false);
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_MISSING, false);
        expectedBefore = true;
        expectedAfter = true;
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_INVALID, true);
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType.BEYOND_MAX_LOOKBACK_MISSING, true);
    }

    public void verifyDisableLogging(IndexTool.IndexDisableLoggingType disableLoggingVerifyType, boolean expectedBefore, boolean expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType errorType) throws SQLException, IOException {
        this.verifyDisableLogging(disableLoggingVerifyType, expectedBefore, expectedAfter, errorType, true);
    }

    public void verifyDisableLogging(IndexTool.IndexDisableLoggingType disableLoggingVerifyType, boolean expectedBefore, boolean expectedAfter, IndexVerificationOutputRepository.IndexVerificationErrorType errorType, boolean shouldLogBeyondMaxLookback) throws SQLException, IOException {
        Table mockOutputTable = (Table)Mockito.mock(Table.class);
        Table mockIndexTable = (Table)Mockito.mock(Table.class);
        Mockito.when((Object)mockIndexTable.getName()).thenReturn((Object)TableName.valueOf((String)"testDisableLoggingIndexName"));
        IndexVerificationOutputRepository outputRepository = new IndexVerificationOutputRepository(mockOutputTable, mockIndexTable, disableLoggingVerifyType);
        outputRepository.setShouldLogBeyondMaxLookback(shouldLogBeyondMaxLookback);
        byte[] dataRowKey = Bytes.toBytes((String)"dataRowKey");
        byte[] indexRowKey = Bytes.toBytes((String)"indexRowKey");
        long dataRowTs = EnvironmentEdgeManager.currentTimeMillis();
        long indexRowTs = EnvironmentEdgeManager.currentTimeMillis();
        String errorMsg = "";
        byte[] expectedValue = Bytes.toBytes((String)"expectedValue");
        byte[] actualValue = Bytes.toBytes((String)"actualValue");
        long scanMaxTs = EnvironmentEdgeManager.currentTimeMillis();
        byte[] tableName = Bytes.toBytes((String)"testDisableLoggingTableName");
        outputRepository.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, errorMsg, expectedValue, actualValue, scanMaxTs, tableName, true, errorType);
        outputRepository.logToIndexToolOutputTable(dataRowKey, indexRowKey, dataRowTs, indexRowTs, errorMsg, expectedValue, actualValue, scanMaxTs, tableName, false, errorType);
        int expectedRowsLogged = 0;
        if (expectedBefore && expectedAfter) {
            expectedRowsLogged = 2;
        } else if (expectedBefore || expectedAfter) {
            expectedRowsLogged = 1;
        }
        ((Table)Mockito.verify((Object)mockOutputTable, (VerificationMode)Mockito.times((int)expectedRowsLogged))).put((Put)Mockito.any(Put.class));
    }

    public void verifyOutputRow(IndexVerificationOutputRepository outputRepository, long scanMaxTs, byte[] indexNameBytes, IndexVerificationOutputRow expectedRow) throws IOException {
        List actualRows = outputRepository.getOutputRows(scanMaxTs, indexNameBytes);
        Assert.assertNotNull((Object)actualRows);
        Assert.assertEquals((long)1L, (long)actualRows.size());
        Assert.assertEquals((Object)expectedRow, actualRows.get(0));
    }

    private IndexVerificationOutputRow buildVerificationRow(byte[] dataRowKey, byte[] indexRowKey, long dataRowTs, long indexRowTs, String expectedErrorMessage, byte[] expectedValue, byte[] actualValue, long scanMaxTs, byte[] tableNameBytes, byte[] indexNameBytes, byte[] phaseBeforeValue, IndexVerificationOutputRepository.IndexVerificationErrorType errorType) {
        IndexVerificationOutputRow.IndexVerificationOutputRowBuilder builder = new IndexVerificationOutputRow.IndexVerificationOutputRowBuilder();
        return builder.setDataTableRowKey(dataRowKey).setIndexTableRowKey(indexRowKey).setScanMaxTimestamp(Long.valueOf(dataRowTs)).setDataTableRowTimestamp(dataRowTs).setIndexTableRowTimestamp(indexRowTs).setErrorMessage(Bytes.toString((byte[])IndexVerificationOutputRepository.getErrorMessageBytes((String)expectedErrorMessage, (byte[])expectedValue, (byte[])actualValue))).setExpectedValue(expectedValue).setActualValue(actualValue).setScanMaxTimestamp(Long.valueOf(scanMaxTs)).setDataTableName(Bytes.toString((byte[])tableNameBytes)).setIndexTableName(Bytes.toString((byte[])indexNameBytes)).setPhaseValue(phaseBeforeValue).setErrorType(errorType).build();
    }

    private byte[] getRowKey(Connection conn, byte[] tableNameBytes) throws SQLException, IOException {
        Scan scan = new Scan();
        Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableNameBytes);
        ResultScanner scanner = table.getScanner(scan);
        Result r = scanner.next();
        return r.getRow();
    }

    private long getTimestamp(Connection conn, byte[] tableNameBytes) throws SQLException, IOException {
        Scan scan = new Scan();
        Table table = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(tableNameBytes);
        ResultScanner scanner = table.getScanner(scan);
        Result r = scanner.next();
        return ((Cell)r.listCells().get(0)).getTimestamp();
    }

    private void createTable(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("create table " + tableName + " (id varchar(10) not null primary key, val1 varchar(10), val2 varchar(10), val3 varchar(10))");
    }

    private void populateTable(Connection conn, String tableName) throws Exception {
        conn.createStatement().execute("upsert into " + tableName + " values ('a', 'ab', 'abc', 'abcd')");
        conn.commit();
    }

    private void createTableAndIndexes(Connection conn, String dataTableName, String indexTableName) throws Exception {
        this.createTable(conn, dataTableName);
        conn.createStatement().execute("CREATE INDEX " + indexTableName + " on " + dataTableName + " (val1) include (val2, val3)");
        conn.commit();
    }

    @After
    public void dropOutputTable() throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexVerificationOutputRepositoryIT.getUrl());){
            ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
            Admin admin = queryServices.getAdmin();
            TableName outputTableName = TableName.valueOf((byte[])IndexVerificationOutputRepository.OUTPUT_TABLE_NAME_BYTES);
            if (admin.tableExists(outputTableName)) {
                admin.disableTable(outputTableName);
                admin.deleteTable(outputTableName);
            }
        }
        EnvironmentEdgeManager.reset();
    }
}

