/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.execute.CommitException;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexUsageIT
extends ParallelStatsDisabledIT {
    private void insertRow(PreparedStatement stmt, int i) throws SQLException {
        stmt.setString(1, "varchar" + String.valueOf(i));
        stmt.setString(2, "char" + String.valueOf(i));
        stmt.setInt(3, i);
        stmt.setLong(4, i);
        stmt.setBigDecimal(5, new BigDecimal((double)i * 0.5));
        Date date = new Date(DateUtil.parseDate((String)"2015-01-01 00:00:00").getTime() + (long)((i - 1) * 86400000));
        stmt.setDate(6, date);
        stmt.setString(7, "a.varchar" + String.valueOf(i));
        stmt.setString(8, "a.char" + String.valueOf(i));
        stmt.setInt(9, i);
        stmt.setLong(10, i);
        stmt.setBigDecimal(11, new BigDecimal((double)i * 0.5));
        stmt.setDate(12, date);
        stmt.setString(13, "b.varchar" + String.valueOf(i));
        stmt.setString(14, "b.char" + String.valueOf(i));
        stmt.setInt(15, i);
        stmt.setLong(16, i);
        stmt.setBigDecimal(17, new BigDecimal((double)i * 0.5));
        stmt.setDate(18, date);
        stmt.executeUpdate();
    }

    private void createDataTable(Connection conn, String dataTableName, String tableProps) throws SQLException {
        String tableDDL = "create table " + dataTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + tableProps;
        conn.createStatement().execute(tableDDL);
    }

    private void populateDataTable(Connection conn, String dataTable) throws SQLException {
        String upsert = "UPSERT INTO " + dataTable + " VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement stmt1 = conn.prepareStatement(upsert);
        this.insertRow(stmt1, 1);
        this.insertRow(stmt1, 2);
        conn.commit();
    }

    @Test
    public void testGroupByCountImmutableIndex() throws Exception {
        this.helpTestGroupByCount(false, false);
    }

    @Test
    public void testGroupByCountImmutableLocalIndex() throws Exception {
        this.helpTestGroupByCount(false, true);
    }

    @Test
    public void testGroupByCountMutableIndex() throws Exception {
        this.helpTestGroupByCount(true, false);
    }

    @Test
    public void testGroupByCountMutableLocalIndex() throws Exception {
        this.helpTestGroupByCount(true, true);
    }

    protected void helpTestGroupByCount(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (int_col1+int_col2)";
            conn.createStatement().execute(ddl);
            String groupBySql = "SELECT (int_col1+int_col2), COUNT(*) FROM " + fullDataTableName + " GROUP BY (int_col1+int_col2)";
            ExplainPlan plan = conn.prepareStatement(groupBySql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [TO_BIGINT(\"(A.INT_COL1 + B.INT_COL2)\")]", (Object)explainPlanAttributes.getServerAggregate());
            if (localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)("INDEX_TEST." + indexName + "(" + fullDataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)("INDEX_TEST." + indexName), (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(groupBySql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectDistinctImmutableIndex() throws Exception {
        this.helpTestSelectDistinct(false, false);
    }

    @Test
    public void testSelectDistinctImmutableIndexLocal() throws Exception {
        this.helpTestSelectDistinct(false, true);
    }

    @Test
    public void testSelectDistinctMutableIndex() throws Exception {
        this.helpTestSelectDistinct(true, false);
    }

    @Test
    public void testSelectDistinctMutableLocalIndex() throws Exception {
        this.helpTestSelectDistinct(true, true);
    }

    protected void helpTestSelectDistinct(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (int_col1+1)";
            conn.createStatement().execute(ddl);
            String sql = "SELECT distinct int_col1+1 FROM " + fullDataTableName + " where int_col1+1 > 0";
            ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            Assert.assertEquals((Object)"SERVER DISTINCT PREFIX FILTER OVER [TO_BIGINT(\"(A.INT_COL1 + 1)\")]", (Object)explainPlanAttributes.getServerDistinctFilter());
            Assert.assertEquals((Object)"SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [TO_BIGINT(\"(A.INT_COL1 + 1)\")]", (Object)explainPlanAttributes.getServerAggregate());
            if (localIndex) {
                Assert.assertEquals((Object)("INDEX_TEST." + indexName + "(" + fullDataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,0] - [1,*]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)("INDEX_TEST." + indexName), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [0] - [*]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testInClauseWithImmutableIndex() throws Exception {
        this.helpTestInClauseWithIndex(false, false);
    }

    @Test
    public void testInClauseWithImmutableLocalIndex() throws Exception {
        this.helpTestInClauseWithIndex(false, true);
    }

    @Test
    public void testInClauseWithMutableIndex() throws Exception {
        this.helpTestInClauseWithIndex(true, false);
    }

    @Test
    public void testInClauseWithMutableLocalIndex() throws Exception {
        this.helpTestInClauseWithIndex(true, false);
    }

    protected void helpTestInClauseWithIndex(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (int_col1+1)";
            conn.createStatement().execute(ddl);
            String sql = "SELECT int_col1+1 FROM " + fullDataTableName + " where int_col1+1 IN (2)";
            ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            if (localIndex) {
                Assert.assertEquals((Object)("INDEX_TEST." + indexName + "(" + fullDataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,2]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)("INDEX_TEST." + indexName), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [2]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testOrderByWithImmutableIndex() throws Exception {
        this.helpTestSelectAliasAndOrderByWithIndex(false, false);
    }

    @Test
    public void testOrderByWithImmutableLocalIndex() throws Exception {
        this.helpTestSelectAliasAndOrderByWithIndex(false, true);
    }

    @Test
    public void testOrderByWithMutableIndex() throws Exception {
        this.helpTestSelectAliasAndOrderByWithIndex(true, false);
    }

    @Test
    public void testOrderByWithMutableLocalIndex() throws Exception {
        this.helpTestSelectAliasAndOrderByWithIndex(true, false);
    }

    protected void helpTestSelectAliasAndOrderByWithIndex(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (int_col1+1)";
            conn.createStatement().execute(ddl);
            String sql = "SELECT int_col1+1 AS foo FROM " + fullDataTableName + " ORDER BY foo";
            ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            if (localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)("INDEX_TEST." + indexName + "(" + fullDataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)("INDEX_TEST." + indexName), (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testImmutableIndexWithCaseSensitiveCols() throws Exception {
        this.helpTestIndexWithCaseSensitiveCols(false, false);
    }

    @Test
    public void testImmutableLocalIndexWithCaseSensitiveCols() throws Exception {
        this.helpTestIndexWithCaseSensitiveCols(false, true);
    }

    @Test
    public void testMutableIndexWithCaseSensitiveCols() throws Exception {
        this.helpTestIndexWithCaseSensitiveCols(true, false);
    }

    @Test
    public void testMutableLocalIndexWithCaseSensitiveCols() throws Exception {
        this.helpTestIndexWithCaseSensitiveCols(true, true);
    }

    protected void helpTestIndexWithCaseSensitiveCols(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, \"cf1\".\"V1\" VARCHAR, \"CF2\".\"v2\" VARCHAR) " + (mutable ? "IMMUTABLE_ROWS=true" : ""));
            String query = "SELECT * FROM " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (\"cf1\".\"V1\" || '_' || \"CF2\".\"v2\") INCLUDE (\"V1\",\"v2\")";
            conn.createStatement().execute(ddl);
            query = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?,?)");
            stmt.setString(1, "a");
            stmt.setString(2, "x");
            stmt.setString(3, "1");
            stmt.execute();
            stmt.setString(1, "b");
            stmt.setString(2, "y");
            stmt.setString(3, "2");
            stmt.execute();
            conn.commit();
            query = "SELECT (\"V1\" || '_' || \"v2\"), k, \"V1\", \"v2\"  FROM " + dataTableName + " WHERE (\"V1\" || '_' || \"v2\") = 'x_1'";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            if (localIndex) {
                Assert.assertEquals((Object)(indexName + "(" + dataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,'x_1']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)indexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" ['x_1']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertEquals((Object)"x", (Object)rs.getString(3));
            Assert.assertEquals((Object)"1", (Object)rs.getString(4));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString("\"('cf1'.'V1' || '_' || 'CF2'.'v2')\""));
            Assert.assertEquals((Object)"a", (Object)rs.getString("k"));
            Assert.assertEquals((Object)"x", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"1", (Object)rs.getString("v2"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT \"V1\", \"V1\" as foo1, (\"V1\" || '_' || \"v2\") as foo, (\"V1\" || '_' || \"v2\") as \"Foo1\", (\"V1\" || '_' || \"v2\") FROM " + dataTableName + " ORDER BY foo";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)(indexName + "(" + dataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)indexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertEquals((Object)"x", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"x", (Object)rs.getString(2));
            Assert.assertEquals((Object)"x", (Object)rs.getString("foo1"));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(3));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString("Foo"));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(4));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString("Foo1"));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString(5));
            Assert.assertEquals((Object)"x_1", (Object)rs.getString("\"('cf1'.'V1' || '_' || 'CF2'.'v2')\""));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"y", (Object)rs.getString(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString("V1"));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertEquals((Object)"y", (Object)rs.getString("foo1"));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString(3));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString("Foo"));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString(4));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString("Foo1"));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString(5));
            Assert.assertEquals((Object)"y_2", (Object)rs.getString("\"('cf1'.'V1' || '_' || 'CF2'.'v2')\""));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testSelectColOnlyInDataTableImmutableIndex() throws Exception {
        this.helpTestSelectColOnlyInDataTable(false, false);
    }

    @Test
    public void testSelectColOnlyInDataTableImmutableLocalIndex() throws Exception {
        this.helpTestSelectColOnlyInDataTable(false, true);
    }

    @Test
    public void testSelectColOnlyInDataTableMutableIndex() throws Exception {
        this.helpTestSelectColOnlyInDataTable(true, false);
    }

    @Test
    public void testSelectColOnlyInDataTableMutableLocalIndex() throws Exception {
        this.helpTestSelectColOnlyInDataTable(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void helpTestSelectColOnlyInDataTable(boolean mutable, boolean localIndex) throws Exception {
        String dataTableName = IndexUsageIT.generateUniqueName();
        String fullDataTableName = "INDEX_TEST." + dataTableName;
        String indexName = IndexUsageIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            conn.setAutoCommit(false);
            this.createDataTable(conn, fullDataTableName, mutable ? "" : "IMMUTABLE_ROWS=true");
            this.populateDataTable(conn, fullDataTableName);
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullDataTableName + " (int_col1+1)";
            conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);
            conn.setAutoCommit(false);
            conn.createStatement().execute(ddl);
            String sql = "SELECT int_col1+1, int_col2 FROM " + fullDataTableName + " WHERE int_col1+1=2";
            ExplainPlan plan = conn.prepareStatement(sql).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            if (localIndex) {
                Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)("INDEX_TEST." + indexName + "(" + fullDataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,2]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            } else {
                Assert.assertEquals((Object)"FULL SCAN ", (Object)explainPlanAttributes.getExplainScanType());
                Assert.assertEquals((Object)fullDataTableName, (Object)explainPlanAttributes.getTableName());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
                Assert.assertEquals((Object)"SERVER FILTER BY (A.INT_COL1 + 1) = 2", (Object)explainPlanAttributes.getServerWhereFilter());
            }
            ResultSet rs = conn.createStatement().executeQuery(sql);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpdatableViewWithIndex() throws Exception {
        this.helpTestUpdatableViewIndex(false);
    }

    @Test
    public void testUpdatableViewWithLocalIndex() throws Exception {
        this.helpTestUpdatableViewIndex(true);
    }

    private void helpTestUpdatableViewIndex(boolean local) throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl());){
            String dataTableName = IndexUsageIT.generateUniqueName();
            String indexName1 = IndexUsageIT.generateUniqueName();
            String viewName = IndexUsageIT.generateUniqueName();
            String indexName2 = IndexUsageIT.generateUniqueName();
            String ddl = "CREATE TABLE " + dataTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, k3 DECIMAL, s1 VARCHAR, s2 VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2, k3))";
            conn.createStatement().execute(ddl);
            ddl = "CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTableName + " WHERE k1 = 1";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,s1,s2,k3) VALUES(120,'foo0','bar0',50.0)");
            conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,s1,s2,k3) VALUES(121,'foo1','bar1',51.0)");
            conn.commit();
            conn.createStatement().execute("CREATE " + (local ? "LOCAL" : "") + " INDEX " + indexName1 + " on " + viewName + "(k1+k2+k3) include (s1, s2)");
            conn.createStatement().execute("UPSERT INTO " + viewName + "(k2,s1,s2,k3) VALUES(120,'foo2','bar2',50.0)");
            conn.commit();
            String query = "SELECT k1, k2, k3, s1, s2 FROM " + viewName + " WHERE k1+k2+k3 = 173.0";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            if (local) {
                Assert.assertEquals((Object)(indexName1 + "(" + dataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,173]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)("_IDX_" + dataTableName), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [-32768,173]", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)121L, (long)rs.getInt(2));
            Assert.assertTrue((BigDecimal.valueOf(51.0).compareTo(rs.getBigDecimal(3)) == 0 ? 1 : 0) != 0);
            Assert.assertEquals((Object)"foo1", (Object)rs.getString(4));
            Assert.assertEquals((Object)"bar1", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (local ? "LOCAL" : "") + " INDEX " + indexName2 + " on " + viewName + "(s1||'_'||s2)");
            query = "SELECT k1, k2, s1||'_'||s2 FROM " + viewName + " WHERE (s1||'_'||s2)='foo2_bar2'";
            plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            if (local) {
                Assert.assertEquals((Object)(indexName2 + "(" + dataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [2,'foo2_bar2']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)("_IDX_" + dataTableName), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [-32767,'foo2_bar2']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)120L, (long)rs.getInt(2));
            Assert.assertEquals((Object)"foo2_bar2", (Object)rs.getString(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testViewUsesMutableTableIndex() throws Exception {
        this.helpTestViewUsesTableIndex(false);
    }

    @Test
    public void testViewUsesImmutableTableIndex() throws Exception {
        this.helpTestViewUsesTableIndex(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpTestViewUsesTableIndex(boolean immutable) throws Exception {
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl());){
            String dataTableName = IndexUsageIT.generateUniqueName();
            String indexName1 = IndexUsageIT.generateUniqueName();
            String viewName = IndexUsageIT.generateUniqueName();
            String indexName2 = IndexUsageIT.generateUniqueName();
            String ddl = "CREATE TABLE " + dataTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, s1 VARCHAR, s2 VARCHAR, s3 VARCHAR, s4 VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2)) " + (immutable ? "IMMUTABLE_ROWS = true" : "");
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("CREATE INDEX " + indexName1 + " ON " + dataTableName + "(k2, s2, s3, s1)");
            conn.createStatement().execute("CREATE INDEX " + indexName2 + " ON " + dataTableName + "(k2, s2||'_'||s3, s1, s4)");
            ddl = "CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTableName + " WHERE s1 = 'foo'";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES(1,1,'foo','abc','cab')");
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES(2,2,'bar','xyz','zyx')");
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT count(*) FROM " + viewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
            String query = "SELECT s2||'_'||s3 FROM " + viewName + " WHERE k2=1 AND (s2||'_'||s3)='abc_cab'";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)indexName2, (Object)explainPlanAttributes.getTableName());
            Assert.assertEquals((Object)" [1,'abc_cab','foo']", (Object)explainPlanAttributes.getKeyRanges());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc_cab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("ALTER VIEW " + viewName + " DROP COLUMN s4");
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String queryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName1 + " [1]\n    SERVER FILTER BY FIRST KEY ONLY AND ((\"S2\" || '_' || \"S3\") = 'abc_cab' AND \"S1\" = 'foo')"), (Object)queryPlan);
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc_cab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpressionThrowsException() throws Exception {
        Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl());
        String dataTableName = IndexUsageIT.generateUniqueName();
        String indexName = IndexUsageIT.generateUniqueName();
        try {
            String ddl = "CREATE TABLE " + dataTableName + " (k1 INTEGER PRIMARY KEY, k2 INTEGER)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE INDEX " + indexName + " on " + dataTableName + "(k1/k2)";
            conn.createStatement().execute(ddl);
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES(1,1)");
            conn.commit();
            conn.createStatement().execute("UPSERT INTO " + dataTableName + " VALUES(1,0)");
            conn.commit();
            Assert.fail();
        }
        catch (CommitException commitException) {
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testImmutableCaseSensitiveFunctionIndex() throws Exception {
        this.helpTestCaseSensitiveFunctionIndex(false, false);
    }

    @Test
    public void testImmutableLocalCaseSensitiveFunctionIndex() throws Exception {
        this.helpTestCaseSensitiveFunctionIndex(false, true);
    }

    @Test
    public void testMutableCaseSensitiveFunctionIndex() throws Exception {
        this.helpTestCaseSensitiveFunctionIndex(true, false);
    }

    @Test
    public void testMutableLocalCaseSensitiveFunctionIndex() throws Exception {
        this.helpTestCaseSensitiveFunctionIndex(true, true);
    }

    protected void helpTestCaseSensitiveFunctionIndex(boolean mutable, boolean localIndex) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);){
            String dataTableName = IndexUsageIT.generateUniqueName();
            String indexName = IndexUsageIT.generateUniqueName();
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR) " + (!mutable ? "IMMUTABLE_ROWS=true" : ""));
            String query = "SELECT * FROM  " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            String ddl = "CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (REGEXP_SUBSTR(v,'id:\\\\w+'))";
            conn.createStatement().execute(ddl);
            query = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?)");
            stmt.setString(1, "k1");
            stmt.setString(2, "{id:id1}");
            stmt.execute();
            stmt.setString(1, "k2");
            stmt.setString(2, "{id:id2}");
            stmt.execute();
            conn.commit();
            query = "SELECT k FROM " + dataTableName + " WHERE REGEXP_SUBSTR(v,'id:\\\\w+') = 'id:id1'";
            ExplainPlan plan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = plan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)"PARALLEL 1-WAY", (Object)explainPlanAttributes.getIteratorTypeAndScanSize());
            Assert.assertEquals((Object)"RANGE SCAN ", (Object)explainPlanAttributes.getExplainScanType());
            Assert.assertEquals((Object)"SERVER FILTER BY FIRST KEY ONLY", (Object)explainPlanAttributes.getServerWhereFilter());
            if (localIndex) {
                Assert.assertEquals((Object)(indexName + "(" + dataTableName + ")"), (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" [1,'id:id1']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertEquals((Object)"CLIENT MERGE SORT", (Object)explainPlanAttributes.getClientSortAlgo());
            } else {
                Assert.assertEquals((Object)indexName, (Object)explainPlanAttributes.getTableName());
                Assert.assertEquals((Object)" ['id:id1']", (Object)explainPlanAttributes.getKeyRanges());
                Assert.assertNull((Object)explainPlanAttributes.getClientSortAlgo());
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testImmutableTableGlobalIndexExpressionWithJoin() throws Exception {
        this.helpTestIndexExpressionWithJoin(false, false);
    }

    @Test
    public void testImmutableTableLocalIndexExpressionWithJoin() throws Exception {
        this.helpTestIndexExpressionWithJoin(false, true);
    }

    @Test
    public void testMutableTableGlobalIndexExpressionWithJoin() throws Exception {
        this.helpTestIndexExpressionWithJoin(true, false);
    }

    @Test
    public void testMutableTableLocalIndexExpressionWithJoin() throws Exception {
        this.helpTestIndexExpressionWithJoin(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void helpTestIndexExpressionWithJoin(boolean mutable, boolean localIndex) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);
        String nameSuffix = "T" + (mutable ? "MUTABLE" : "_IMMUTABLE") + (localIndex ? "_LOCAL" : "_GLOBAL");
        String tableName = "T" + nameSuffix;
        String indexName = "IDX" + nameSuffix;
        try {
            conn.createStatement().execute("CREATE TABLE " + tableName + "( c_customer_sk varchar primary key, c_first_name varchar, c_last_name varchar )" + (!mutable ? "IMMUTABLE_ROWS=true" : ""));
            String query = "SELECT * FROM " + tableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + tableName + " (c_customer_sk || c_first_name asc)");
            query = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES(?,?,?)");
            stmt.setString(1, "1");
            stmt.setString(2, "David");
            stmt.setString(3, "Smith");
            stmt.execute();
            conn.commit();
            query = "select c.c_customer_sk from  " + tableName + " c left outer join " + tableName + " c2 on c.c_customer_sk = c2.c_customer_sk where c.c_customer_sk || c.c_first_name = '1David'";
            rs = conn.createStatement().executeQuery("EXPLAIN " + query);
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            if (localIndex) {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1,'1David']\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT\n    PARALLEL LEFT-JOIN TABLE 0 (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + "(" + tableName + ") [1]\n            SERVER FILTER BY FIRST KEY ONLY\n        CLIENT MERGE SORT"), (Object)explainPlan);
            } else {
                Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexName + " ['1David']\n    SERVER FILTER BY FIRST KEY ONLY\n    PARALLEL LEFT-JOIN TABLE 0 (SKIP MERGE)\n        CLIENT PARALLEL 1-WAY FULL SCAN OVER " + indexName + "\n            SERVER FILTER BY FIRST KEY ONLY"), (Object)explainPlan);
            }
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexNotFoundForWrongIndexNameRebuild() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);
        String dataTableName = IndexUsageIT.generateUniqueName();
        String wrongIndexName = IndexUsageIT.generateUniqueName();
        try {
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR)");
            conn.createStatement().execute("ALTER INDEX " + wrongIndexName + " ON " + dataTableName + " rebuild");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.INDEX_UNDEFINED.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexNotFoundForDropWongIndexName() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexUsageIT.getUrl(), props);
        String dataTableName = IndexUsageIT.generateUniqueName();
        String wrongIndexName = IndexUsageIT.generateUniqueName();
        try {
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (k VARCHAR NOT NULL PRIMARY KEY, v VARCHAR)");
            conn.createStatement().execute("DROP INDEX " + wrongIndexName + " ON " + dataTableName);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)e.getErrorCode(), (long)SQLExceptionCode.INDEX_UNDEFINED.getErrorCode());
        }
        finally {
            conn.close();
        }
    }
}

