/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompareOperator;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CoprocessorDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.index.PhoenixIndexBuilder;
import org.apache.phoenix.index.PhoenixIndexCodec;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;

public class IndexTestUtil {
    private static final String SELECT_DATA_INDEX_ROW = "SELECT COLUMN_FAMILY FROM \"SYSTEM\".\"CATALOG\" WHERE TENANT_ID IS NULL AND TABLE_SCHEM=? AND TABLE_NAME=? AND COLUMN_NAME IS NULL AND COLUMN_FAMILY=?";

    public static ResultSet readDataTableIndexRow(Connection conn, String schemaName, String tableName, String indexName) throws SQLException {
        PreparedStatement stmt = conn.prepareStatement(SELECT_DATA_INDEX_ROW);
        stmt.setString(1, schemaName);
        stmt.setString(2, tableName);
        stmt.setString(3, indexName);
        return stmt.executeQuery();
    }

    private static void coerceDataValueToIndexValue(PColumn dataColumn, PColumn indexColumn, ImmutableBytesWritable ptr) {
        PDataType dataType = dataColumn.getDataType();
        SortOrder dataModifier = dataColumn.getSortOrder();
        PDataType indexType = indexColumn.getDataType();
        SortOrder indexModifier = indexColumn.getSortOrder();
        indexType.coerceBytes(ptr, dataType, dataModifier, indexModifier);
    }

    public static List<Mutation> generateIndexData(PTable index, PTable table, List<Mutation> dataMutations, ImmutableBytesWritable ptr, KeyValueBuilder builder) throws SQLException {
        ArrayList indexMutations = Lists.newArrayListWithExpectedSize((int)dataMutations.size());
        for (Mutation dataMutation : dataMutations) {
            indexMutations.addAll(IndexTestUtil.generateIndexData(index, table, dataMutation, ptr, builder));
        }
        return indexMutations;
    }

    public static List<Mutation> generateIndexData(PTable indexTable, PTable dataTable, Mutation dataMutation, ImmutableBytesWritable ptr, KeyValueBuilder builder) throws SQLException {
        PRow row;
        Boolean hasValue;
        byte[] dataRowKey = dataMutation.getRow();
        RowKeySchema dataRowKeySchema = dataTable.getRowKeySchema();
        List dataPKColumns = dataTable.getPKColumns();
        int i = 0;
        int indexOffset = 0;
        int maxOffset = dataRowKey.length;
        dataRowKeySchema.iterator(dataRowKey, ptr, dataTable.getBucketNum() == null ? i : ++i);
        List indexPKColumns = indexTable.getPKColumns();
        List indexColumns = indexTable.getColumns();
        int nIndexColumns = indexPKColumns.size();
        int maxIndexValues = indexColumns.size() - nIndexColumns - indexOffset;
        BitSet indexValuesSet = new BitSet(maxIndexValues);
        byte[][] indexValues = new byte[indexColumns.size() - indexOffset][];
        while ((hasValue = dataRowKeySchema.next(ptr, i, maxOffset)) != null) {
            if (hasValue.booleanValue()) {
                PColumn dataColumn = (PColumn)dataPKColumns.get(i);
                PColumn indexColumn = indexTable.getColumnForColumnName(IndexUtil.getIndexColumnName((PColumn)dataColumn));
                IndexTestUtil.coerceDataValueToIndexValue(dataColumn, indexColumn, ptr);
                indexValues[indexColumn.getPosition() - indexOffset] = ptr.copyBytes();
            }
            ++i;
        }
        long ts = MetaDataUtil.getClientTimeStamp((Mutation)dataMutation);
        if (dataMutation instanceof Delete && dataMutation.getFamilyCellMap().values().isEmpty()) {
            indexTable.newKey(ptr, (byte[][])indexValues);
            row = indexTable.newRow(builder, ts, ptr, false, (byte[][])new byte[0][]);
            row.delete();
        } else {
            if (!dataTable.getColumnFamilies().isEmpty()) {
                for (Map.Entry entry : dataMutation.getFamilyCellMap().entrySet()) {
                    PColumnFamily family = dataTable.getColumnFamily((byte[])entry.getKey());
                    for (Cell kv : (List)entry.getValue()) {
                        byte[] cq = CellUtil.cloneQualifier((Cell)kv);
                        byte[] emptyKVQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)dataTable).getFirst();
                        if (Bytes.compareTo((byte[])emptyKVQualifier, (byte[])cq) == 0) continue;
                        try {
                            PColumn dataColumn = family.getPColumnForColumnQualifier(cq);
                            PColumn indexColumn = indexTable.getColumnForColumnName(IndexUtil.getIndexColumnName((String)family.getName().getString(), (String)dataColumn.getName().getString()));
                            ptr.set(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                            IndexTestUtil.coerceDataValueToIndexValue(dataColumn, indexColumn, ptr);
                            indexValues[indexPKColumns.indexOf((Object)indexColumn) - indexOffset] = ptr.copyBytes();
                            if (SchemaUtil.isPKColumn((PColumn)indexColumn)) continue;
                            indexValuesSet.set(indexColumn.getPosition() - nIndexColumns - indexOffset);
                        }
                        catch (ColumnNotFoundException columnNotFoundException) {}
                    }
                }
            }
            indexTable.newKey(ptr, (byte[][])indexValues);
            row = indexTable.newRow(builder, ts, ptr, false, (byte[][])new byte[0][]);
            int pos = 0;
            while ((pos = indexValuesSet.nextSetBit(pos)) >= 0) {
                int index = nIndexColumns + indexOffset + pos++;
                PColumn indexColumn = (PColumn)indexColumns.get(index);
                row.setValue(indexColumn, indexValues[index]);
            }
        }
        return row.toRowMutations();
    }

    public static void downgradeCoprocs(String physicalTableName, String physicalIndexName, Admin admin) throws Exception {
        TableDescriptor baseDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalTableName));
        TableDescriptorBuilder baseDescBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)baseDescriptor);
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.removeCoproc(IndexRegionObserver.class, baseDescBuilder, admin);
        if (physicalIndexName != null) {
            TableDescriptor indexDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalIndexName));
            IndexTestUtil.assertCoprocsContains(GlobalIndexChecker.class, indexDescriptor);
            TableDescriptorBuilder indexDescBuilder = TableDescriptorBuilder.newBuilder((TableDescriptor)indexDescriptor);
            IndexTestUtil.removeCoproc(IndexRegionObserver.class, indexDescBuilder, admin);
            IndexTestUtil.removeCoproc(GlobalIndexChecker.class, indexDescBuilder, admin);
        }
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("org.apache.hadoop.hbase.index.codec.class", PhoenixIndexCodec.class.getName());
        IndexUtil.enableIndexing((TableDescriptorBuilder)baseDescBuilder, (String)PhoenixIndexBuilder.class.getName(), props, (int)0x2FFFFFFE, (String)"org.apache.phoenix.hbase.index.Indexer");
        admin.modifyTable(baseDescBuilder.build());
        baseDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalTableName));
        TableDescriptor indexDescriptor = null;
        if (physicalIndexName != null) {
            indexDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalIndexName));
        }
        IndexTestUtil.assertUsingOldCoprocs(baseDescriptor, indexDescriptor);
    }

    public static void assertCoprocsContains(Class clazz, TableDescriptor descriptor) {
        String expectedCoprocName = clazz.getName();
        boolean foundCoproc = IndexTestUtil.isCoprocPresent(descriptor, expectedCoprocName);
        Assert.assertTrue((String)("Could not find coproc " + expectedCoprocName + " in descriptor " + descriptor), (boolean)foundCoproc);
    }

    public static boolean isCoprocPresent(TableDescriptor descriptor, String expectedCoprocName) {
        boolean foundCoproc = false;
        for (CoprocessorDescriptor coprocDesc : descriptor.getCoprocessorDescriptors()) {
            if (!coprocDesc.getClassName().equals(expectedCoprocName)) continue;
            foundCoproc = true;
            break;
        }
        return foundCoproc;
    }

    public static void removeCoproc(Class clazz, TableDescriptorBuilder descBuilder, Admin admin) throws Exception {
        descBuilder.removeCoprocessor(clazz.getName());
        admin.modifyTable(descBuilder.build());
    }

    public static void assertUsingOldCoprocs(TableDescriptor baseDescriptor, TableDescriptor indexDescriptor) {
        IndexTestUtil.assertCoprocsContains(Indexer.class, baseDescriptor);
        IndexTestUtil.assertCoprocConfig(baseDescriptor, Indexer.class.getName(), "|org.apache.phoenix.hbase.index.Indexer|805306366|index.builder=org.apache.phoenix.index.PhoenixIndexBuilder,org.apache.hadoop.hbase.index.codec.class=org.apache.phoenix.index.PhoenixIndexCodec");
        IndexTestUtil.assertCoprocsNotContains(IndexRegionObserver.class, baseDescriptor);
        if (indexDescriptor != null) {
            IndexTestUtil.assertCoprocsNotContains(IndexRegionObserver.class, indexDescriptor);
            IndexTestUtil.assertCoprocsNotContains(GlobalIndexChecker.class, indexDescriptor);
        }
    }

    public static void assertCoprocConfig(TableDescriptor indexDesc, String className, String expectedConfigValue) {
        boolean foundConfig = false;
        for (Map.Entry entry : indexDesc.getValues().entrySet()) {
            String propKey = Bytes.toString((byte[])((Bytes)entry.getKey()).get());
            String propValue = Bytes.toString((byte[])((Bytes)entry.getValue()).get());
            if (!propKey.contains("coprocessor") || !propValue.contains(className)) continue;
            Assert.assertEquals((String)(className + " is configured incorrectly"), (Object)expectedConfigValue, (Object)propValue);
            foundConfig = true;
            break;
        }
        Assert.assertTrue((String)("Couldn't find config for " + className), (boolean)foundConfig);
    }

    public static void assertCoprocsNotContains(Class clazz, TableDescriptor descriptor) {
        String expectedCoprocName = clazz.getName();
        boolean foundCoproc = IndexTestUtil.isCoprocPresent(descriptor, expectedCoprocName);
        Assert.assertFalse((String)("Could find coproc " + expectedCoprocName + " in descriptor " + descriptor), (boolean)foundCoproc);
    }

    public static void assertRowsForEmptyColValue(Connection conn, String tableName, byte[] emptyValue) throws SQLException, IOException {
        ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
        PTable pTable = conn.unwrap(PhoenixConnection.class).getTable(tableName);
        Table hTable = cqs.getTable(pTable.getPhysicalName().getBytes());
        byte[] emptyKeyValueCF = SchemaUtil.getEmptyColumnFamily((PTable)pTable);
        byte[] emptyKeyValueQualifier = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)pTable).getFirst();
        Scan scan = new Scan();
        scan.setFilter((Filter)new SingleColumnValueFilter(emptyKeyValueCF, emptyKeyValueQualifier, CompareOperator.NOT_EQUAL, (ByteArrayComparable)new BinaryComparator(emptyValue)));
        try (ResultScanner scanner = hTable.getScanner(scan);){
            Assert.assertNull((String)("There are rows with in the table where the empty value is not " + Bytes.toStringBinary((byte[])emptyValue)), (Object)scanner.next());
        }
    }
}

