/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryServicesOptions;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.types.PDate;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class IndexMetadataIT
extends ParallelStatsDisabledIT {
    private static void assertIndexInfoMetadata(ResultSet rs, String schemaName, String dataTableName, String indexName, int colPos, String colName, Order order) throws SQLException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)schemaName, (Object)rs.getString(2));
        Assert.assertEquals((Object)dataTableName, (Object)rs.getString(3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getBoolean(4));
        Assert.assertEquals(null, (Object)rs.getString(5));
        Assert.assertEquals((Object)indexName, (Object)rs.getString(6));
        Assert.assertEquals((long)3L, (long)rs.getShort(7));
        Assert.assertEquals((long)colPos, (long)rs.getShort(8));
        Assert.assertEquals((Object)colName, (Object)rs.getString(9));
        Assert.assertEquals((Object)(order == Order.ASC ? "A" : (order == Order.DESC ? "D" : null)), (Object)rs.getString(10));
        Assert.assertEquals((long)0L, (long)rs.getInt(11));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(12));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals(null, (Object)rs.getString(13));
    }

    private static void assertIndexInfoMetadata(ResultSet rs, String schemaName, String dataTableName, String indexName, int colPos, String colName, Order order, int type) throws SQLException {
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals(null, (Object)rs.getString(1));
        Assert.assertEquals((Object)schemaName, (Object)rs.getString(2));
        Assert.assertEquals((Object)dataTableName, (Object)rs.getString(3));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)rs.getBoolean(4));
        Assert.assertEquals(null, (Object)rs.getString(5));
        Assert.assertEquals((Object)indexName, (Object)rs.getString(6));
        Assert.assertEquals((long)3L, (long)rs.getShort(7));
        Assert.assertEquals((long)colPos, (long)rs.getShort(8));
        Assert.assertEquals((Object)colName, (Object)rs.getString(9));
        Assert.assertEquals((Object)(order == Order.ASC ? "A" : (order == Order.DESC ? "D" : null)), (Object)rs.getString(10));
        Assert.assertEquals((long)0L, (long)rs.getInt(11));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals((long)0L, (long)rs.getInt(12));
        Assert.assertTrue((boolean)rs.wasNull());
        Assert.assertEquals(null, (Object)rs.getString(13));
        Assert.assertEquals((long)type, (long)rs.getInt(14));
    }

    private static void assertActiveIndex(Connection conn, String schemaName, String tableName) throws SQLException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        conn.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName).next();
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).getIndexMaintainers(ptr, pconn);
        Assert.assertTrue((ptr.getLength() > 0 ? 1 : 0) != 0);
    }

    private static void assertNoActiveIndex(Connection conn, String schemaName, String tableName) throws SQLException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        conn.createStatement().executeQuery("SELECT count(*) FROM " + fullTableName).next();
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).getIndexMaintainers(ptr, pconn);
        Assert.assertTrue((ptr.getLength() == 0 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexCreateDrop() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String indexDataTable = IndexMetadataIT.generateUniqueName();
        String fullIndexDataTable = "INDEX_TEST." + indexDataTable;
        String indexName = IndexMetadataIT.generateUniqueName();
        try {
            String tableDDL = "create table " + fullIndexDataTable + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) ";
            conn.createStatement().execute(tableDDL);
            String ddl = "CREATE INDEX " + indexName + " ON " + fullIndexDataTable + " (varchar_col1 ASC, varchar_col2 ASC, int_pk DESC) INCLUDE (int_col1, int_col2)";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 1, "A:VARCHAR_COL1", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 2, "B:VARCHAR_COL2", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 3, ":INT_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 4, ":VARCHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 5, ":CHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 6, ":LONG_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 7, ":DECIMAL_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 8, ":DATE_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 9, "A:INT_COL1", null);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 10, "B:INT_COL2", null);
            Assert.assertFalse((boolean)rs.next());
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), StringUtil.escapeLike((String)indexName), new String[]{PTableType.INDEX.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            IndexMetadataIT.assertActiveIndex(conn, "INDEX_TEST", indexDataTable);
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " UNUSABLE";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.INACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            IndexMetadataIT.assertActiveIndex(conn, "INDEX_TEST", indexDataTable);
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " USABLE";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            IndexMetadataIT.assertActiveIndex(conn, "INDEX_TEST", indexDataTable);
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " DISABLE";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.DISABLE.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            IndexMetadataIT.assertNoActiveIndex(conn, "INDEX_TEST", indexDataTable);
            try {
                ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " USABLE";
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " UNUSABLE";
                conn.createStatement().execute(ddl);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.INVALID_INDEX_STATE_TRANSITION.getErrorCode(), (long)e.getErrorCode());
            }
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " REBUILD";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.ACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            IndexMetadataIT.assertActiveIndex(conn, "INDEX_TEST", indexDataTable);
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " REBUILD ASYNC";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.BUILDING.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            ddl = "DROP INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable;
            conn.createStatement().execute(ddl);
            IndexMetadataIT.assertNoActiveIndex(conn, "INDEX_TEST", indexDataTable);
            rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            Assert.assertFalse((boolean)rs.next());
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName);
            Assert.assertFalse((boolean)rs.next());
            ddl = "CREATE INDEX " + indexName + "1 ON " + "INDEX_TEST" + "." + indexDataTable + " (varchar_col1 ASC, varchar_col2 ASC, int_pk DESC) INCLUDE (int_col1, int_col2)";
            conn.createStatement().execute(ddl);
            ddl = "CREATE INDEX " + indexName + "2 ON " + "INDEX_TEST" + "." + indexDataTable + " (varchar_col1 ASC, varchar_col2 ASC, int_pk DESC) INCLUDE (long_pk, int_col2)";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 1, "A:VARCHAR_COL1", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 2, "B:VARCHAR_COL2", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 3, ":INT_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 4, ":VARCHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 5, ":CHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 6, ":LONG_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 7, ":DECIMAL_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 8, ":DATE_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 9, "A:INT_COL1", null);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "1", 10, "B:INT_COL2", null);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 1, "A:VARCHAR_COL1", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 2, "B:VARCHAR_COL2", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 3, ":INT_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 4, ":VARCHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 5, ":CHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 6, ":LONG_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 7, ":DECIMAL_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 8, ":DATE_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName + "2", 9, "B:INT_COL2", null);
            Assert.assertFalse((boolean)rs.next());
            String diffTableNameInSameSchema = "INDEX_TEST." + indexDataTable + "2";
            conn.createStatement().execute("CREATE TABLE " + diffTableNameInSameSchema + "(k INTEGER PRIMARY KEY)");
            try {
                conn.createStatement().execute("DROP INDEX " + indexName + "1 ON " + diffTableNameInSameSchema);
                Assert.fail((String)("Should have realized index " + indexName + "1 is not on the table"));
            }
            catch (SQLException e) {
                Assert.assertTrue((e.getErrorCode() == SQLExceptionCode.PARENT_TABLE_NOT_FOUND.getErrorCode() ? 1 : 0) != 0);
            }
            ddl = "DROP TABLE INDEX_TEST." + indexDataTable;
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            Assert.assertFalse((boolean)rs.next());
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName + "1");
            Assert.assertFalse((boolean)rs.next());
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName + "2");
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexDefinitionWithNullableFixedWidthColInPK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String indexDataTable = IndexMetadataIT.generateUniqueName();
        String indexName = IndexMetadataIT.generateUniqueName();
        conn.setAutoCommit(false);
        try {
            String fullTableName = "INDEX_TEST." + indexDataTable;
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            String ddl = "CREATE INDEX " + indexName + " ON " + fullTableName + " (char_col1 ASC, int_col2 ASC, long_col2 DESC) INCLUDE (int_col1)";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 1, "A:CHAR_COL1", Order.ASC, 12);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 2, "B:INT_COL2", Order.ASC, 3);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 3, "B:LONG_COL2", Order.DESC, 3);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 4, ":VARCHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 5, ":CHAR_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 6, ":INT_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 7, ":LONG_PK", Order.DESC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 8, ":DECIMAL_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 9, ":DATE_PK", Order.ASC);
            IndexMetadataIT.assertIndexInfoMetadata(rs, "INDEX_TEST", indexDataTable, indexName, 10, "A:INT_COL1", null);
            Assert.assertFalse((boolean)rs.next());
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " UNUSABLE";
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), indexName, new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)indexName, (Object)rs.getString(3));
            Assert.assertEquals((Object)PIndexState.INACTIVE.toString(), (Object)rs.getString("INDEX_STATE"));
            Assert.assertFalse((boolean)rs.next());
            ddl = "DROP INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable;
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            Assert.assertFalse((boolean)rs.next());
            rs = IndexTestUtil.readDataTableIndexRow(conn, "INDEX_TEST", indexDataTable, indexName);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlterIndexWithLowerCaseName() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String indexName = "\"lowerCaseIndex\"";
        String indexDataTable = IndexMetadataIT.generateUniqueName();
        try {
            String fullTableName = "INDEX_TEST." + indexDataTable;
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            String ddl = "CREATE INDEX " + indexName + " ON " + fullTableName + " (char_col1 ASC, int_col2 ASC, long_col2 DESC) INCLUDE (int_col1)";
            conn.createStatement().execute(ddl);
            ddl = "ALTER INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable + " UNUSABLE";
            conn.createStatement().execute(ddl);
            ResultSet rs = conn.getMetaData().getTables(null, StringUtil.escapeLike((String)"INDEX_TEST"), "lowerCaseIndex", new String[]{PTableType.INDEX.toString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"lowerCaseIndex", (Object)rs.getString(3));
            ddl = "DROP INDEX " + indexName + " ON " + "INDEX_TEST" + "." + indexDataTable;
            conn.createStatement().execute(ddl);
            rs = conn.getMetaData().getIndexInfo(null, "INDEX_TEST", indexDataTable, false, false);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexDefinitionWithRepeatedColumns() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String indexDataTable = IndexMetadataIT.generateUniqueName();
        String indexName = IndexMetadataIT.generateUniqueName();
        try {
            String fullTableName = "INDEX_TEST." + indexDataTable;
            conn.createStatement().execute("create table " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + "IMMUTABLE_ROWS=true");
            String ddl = "CREATE INDEX " + indexName + " ON " + fullTableName + " (a.int_col1, a.long_col1, b.int_col2, b.long_col2) INCLUDE(int_col1, int_col2)";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"Should have caught exception.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.COLUMN_EXIST_IN_DEF.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableWithSameColumnNames() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);){
            String ddl = "create table " + IndexMetadataIT.generateUniqueName() + " (char_pk varchar not null, int_col integer, long_col integer, int_col integer constraint pk primary key (char_pk))";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"Should have caught exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableWithSameColumnNamesWithFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(false);
        try (Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);){
            String ddl = "create table " + IndexMetadataIT.generateUniqueName() + " (char_pk varchar not null, a.int_col integer, a.long_col integer, a.int_col integer, b.long_col integer constraint pk primary key (char_pk))";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"Should have caught exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIndexDefinitionWithSameColumnNamesInTwoFamily() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String testTable = IndexMetadataIT.generateUniqueName();
        String indexName = IndexMetadataIT.generateUniqueName();
        String ddl = "create table " + testTable + " (char_pk varchar not null, a.int_col integer, a.long_col integer, b.int_col integer, b.long_col integer constraint pk primary key (char_pk))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE INDEX " + indexName + "1 ON " + testTable + " (a.int_col, b.int_col)";
        conn.createStatement().execute(ddl);
        try {
            ddl = "CREATE INDEX " + indexName + "2 ON " + testTable + " (int_col)";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"Should have caught exception");
        }
        catch (AmbiguousColumnException e) {
            Assert.assertEquals((long)SQLExceptionCode.AMBIGUOUS_COLUMN.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinaryNonnullableIndex() throws Exception {
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl());
        String testTable = IndexMetadataIT.generateUniqueName();
        String indexName = IndexMetadataIT.generateUniqueName();
        try {
            String ddl = "CREATE TABLE " + testTable + " ( v1 BINARY(64) NOT NULL, v2 VARCHAR, v3 BINARY(64), v4 VARCHAR CONSTRAINT PK PRIMARY KEY (v1))";
            conn.createStatement().execute(ddl);
            conn.commit();
            try {
                conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + testTable + " (v3) INCLUDE (v4)");
                Assert.fail((String)"Should have seen SQLExceptionCode.VARBINARY_IN_ROW_KEY");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.VARBINARY_IN_ROW_KEY.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("CREATE INDEX " + indexName + "3 ON " + testTable + " (v2, v3) INCLUDE (v4)");
                Assert.fail((String)"Should have seen SQLExceptionCode.VARBINARY_IN_ROW_KEY");
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.VARBINARY_IN_ROW_KEY.getErrorCode(), (long)e.getErrorCode());
            }
            conn.createStatement().execute("CREATE INDEX " + indexName + "4 ON " + testTable + " (v4) INCLUDE (v2)");
            conn.commit();
            conn.createStatement().execute("CREATE INDEX varbinLastInRow ON " + testTable + " (v1, v3)");
            conn.commit();
            conn.createStatement().execute("CREATE INDEX " + indexName + "5 ON " + testTable + " (v2) INCLUDE (v4, v3, v1)");
            conn.commit();
            conn.createStatement().executeQuery("select v1,v2,v3,v4 FROM " + testTable + " where v2 = 'abc' and v3 != 'a'");
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testAsyncCreatedDate() throws Exception {
        Date d0 = new Date(System.currentTimeMillis());
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "create table " + testTable + " (k varchar primary key, v1 varchar, v2 varchar, v3 varchar)";
        conn.createStatement().execute(ddl);
        String indexName = "ASYNCIND_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + "1 ON " + testTable + " (v1) ASYNC";
        conn.createStatement().execute(ddl);
        ddl = "CREATE INDEX " + indexName + "2 ON " + testTable + " (v2) ASYNC";
        conn.createStatement().execute(ddl);
        ddl = "CREATE INDEX " + indexName + "3 ON " + testTable + " (v3)";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.createStatement().executeQuery("select table_name, ASYNC_CREATED_DATE from \"SYSTEM\".catalog (ASYNC_CREATED_DATE " + PDate.INSTANCE.getSqlTypeName() + ") where " + "ASYNC_CREATED_DATE" + " is not null and table_name like 'ASYNCIND_%' order by " + "ASYNC_CREATED_DATE");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)(indexName + "1"), (Object)rs.getString(1));
        Date d1 = rs.getDate(2);
        Assert.assertTrue((boolean)d1.after(d0));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)(indexName + "2"), (Object)rs.getString(1));
        Date d2 = rs.getDate(2);
        Assert.assertTrue((boolean)d2.after(d1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testAsyncRebuildTimestamp() throws Exception {
        long startTimestamp = System.currentTimeMillis();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        conn.setAutoCommit(false);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "create table " + testTable + " (k varchar primary key, v1 varchar, v2 varchar, v3 varchar)";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String indexName = "R_ASYNCIND_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + "1 ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        ddl = "CREATE INDEX " + indexName + "2 ON " + testTable + " (v2) ";
        stmt.execute(ddl);
        ddl = "CREATE INDEX " + indexName + "3 ON " + testTable + " (v3)";
        stmt.execute(ddl);
        conn.createStatement().execute("ALTER INDEX " + indexName + "1 ON " + testTable + " DISABLE ");
        conn.createStatement().execute("ALTER INDEX " + indexName + "2 ON " + testTable + " REBUILD ");
        conn.createStatement().execute("ALTER INDEX " + indexName + "3 ON " + testTable + " REBUILD ASYNC");
        ResultSet rs = conn.createStatement().executeQuery("select table_name, ASYNC_REBUILD_TIMESTAMP from \"SYSTEM\".catalog (ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") where " + "ASYNC_REBUILD_TIMESTAMP" + " !=0 and table_name like 'R_ASYNCIND_%' order by table_name");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)(indexName + "3"), (Object)rs.getString(1));
        long asyncTimestamp = rs.getLong(2);
        Assert.assertTrue((String)"Async timestamp is recent timestamp", (asyncTimestamp > startTimestamp ? 1 : 0) != 0);
        PTable table = conn.getTable(indexName + "3");
        Assert.assertEquals((long)table.getTimeStamp(), (long)asyncTimestamp);
        Assert.assertFalse((boolean)rs.next());
        conn.createStatement().execute("ALTER INDEX " + indexName + "3 ON " + testTable + " DISABLE");
        rs = conn.createStatement().executeQuery("select table_name, ASYNC_REBUILD_TIMESTAMP from \"SYSTEM\".catalog (ASYNC_REBUILD_TIMESTAMP " + PLong.INSTANCE.getSqlTypeName() + ") where " + "ASYNC_REBUILD_TIMESTAMP" + " !=0 and table_name like 'ASYNCIND_%' order by table_name");
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testAsyncRebuildAll() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);){
            conn.setAutoCommit(true);
            String testTable = IndexMetadataIT.generateUniqueName();
            String ddl = "create table " + testTable + " (k varchar primary key, v4 varchar)";
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            PreparedStatement upsertStmt = conn.prepareStatement("UPSERT INTO " + testTable + " VALUES(?, ?)");
            upsertStmt.setString(1, "key1");
            upsertStmt.setString(2, "val1");
            upsertStmt.execute();
            String indexName = "R_ASYNCIND_" + IndexMetadataIT.generateUniqueName();
            ddl = "CREATE INDEX " + indexName + " ON " + testTable + " (k, v4)";
            stmt.execute(ddl);
            String val = this.getIndexValue(conn, indexName, 2);
            Assert.assertEquals((Object)"val1", (Object)val);
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " DISABLE");
            upsertStmt = conn.prepareStatement("UPSERT INTO " + testTable + " VALUES(?, ?)");
            upsertStmt.setString(1, "key1");
            upsertStmt.setString(2, "val2");
            upsertStmt.execute();
            conn.commit();
            val = this.getIndexValue(conn, indexName, 2);
            Assert.assertEquals((Object)"val1", (Object)val);
            upsertStmt = conn.prepareStatement("UPSERT INTO " + indexName + " VALUES(?, ?)");
            upsertStmt.setString(1, "key3");
            upsertStmt.setString(2, "val3");
            upsertStmt.execute();
            conn.createStatement().execute("DELETE  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE TABLE_NAME ='" + testTable + "'");
            conn.commit();
            conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " REBUILD ALL ASYNC");
            ResultSet resultSet = conn.createStatement().executeQuery("SELECT * FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME);
            Assert.assertTrue((boolean)resultSet.next());
            Assert.assertEquals((Object)"2", (Object)resultSet.getString(1));
            Assert.assertNull((Object)resultSet.getString(3));
            Assert.assertNull((Object)resultSet.getString(4));
            Assert.assertEquals((Object)testTable, (Object)resultSet.getString(5));
            Assert.assertEquals((Object)"CREATED", (Object)resultSet.getString(6));
            Assert.assertEquals((Object)"4", (Object)resultSet.getString(8));
            Assert.assertEquals((Object)("{\"IndexName\":\"" + indexName + "\",\"RebuildAll\":true}"), (Object)resultSet.getString(9));
            String queryTaskTable = "SELECT * FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME;
            ResultSet rs = conn.createStatement().executeQuery(queryTaskTable);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)testTable, (Object)rs.getString("TABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            TestUtil.waitForIndexState(conn, indexName, PIndexState.ACTIVE);
            String query = "SELECT *  FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE " + "TASK_TYPE" + " = " + PTable.TaskType.INDEX_REBUILD.getSerializedValue() + " AND " + "TABLE_NAME" + " = '" + testTable + "'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            String taskStatus = rs.getString("TASK_STATUS");
            Assert.assertEquals((Object)PTable.TaskStatus.COMPLETED.toString(), (Object)taskStatus);
            String data = rs.getString("TASK_DATA");
            Assert.assertEquals((Object)true, (Object)data.contains("\"IndexName\":\"" + indexName));
            val = this.getIndexValue(conn, indexName, 2);
            Assert.assertEquals((Object)"val2", (Object)val);
            Table indexTable = conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)indexName));
            int count = IndexMetadataIT.getUtility().countRows(indexTable);
            Assert.assertEquals((long)1L, (long)count);
        }
    }

    private String getIndexValue(Connection conn, String indexName, int column) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + indexName);
        Assert.assertTrue((boolean)rs.next());
        String val = rs.getString(column);
        Assert.assertFalse((boolean)rs.next());
        return val;
    }

    @Test
    public void testImmutableTableOnlyHasPrimaryKeyIndex() throws Exception {
        this.helpTestTableOnlyHasPrimaryKeyIndex(false, false);
    }

    @Test
    public void testImmutableLocalTableOnlyHasPrimaryKeyIndex() throws Exception {
        this.helpTestTableOnlyHasPrimaryKeyIndex(false, true);
    }

    @Test
    public void testMutableTableOnlyHasPrimaryKeyIndex() throws Exception {
        this.helpTestTableOnlyHasPrimaryKeyIndex(true, false);
    }

    @Test
    public void testMutableLocalTableOnlyHasPrimaryKeyIndex() throws Exception {
        this.helpTestTableOnlyHasPrimaryKeyIndex(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void helpTestTableOnlyHasPrimaryKeyIndex(boolean mutable, boolean localIndex) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String dataTableName = IndexMetadataIT.generateUniqueName();
        String indexName = IndexMetadataIT.generateUniqueName();
        try {
            conn.createStatement().execute("CREATE TABLE " + dataTableName + " (pk1 VARCHAR not null, pk2 VARCHAR not null, CONSTRAINT PK PRIMARY KEY (pk1, pk2))" + (!mutable ? "IMMUTABLE_ROWS=true" : ""));
            String query = "SELECT * FROM " + dataTableName;
            ResultSet rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().execute("CREATE " + (localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + dataTableName + " (pk2, pk1)");
            query = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertFalse((boolean)rs.next());
            PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + dataTableName + " VALUES(?,?)");
            stmt.setString(1, "k11");
            stmt.setString(2, "k21");
            stmt.execute();
            conn.commit();
            query = "SELECT * FROM " + indexName;
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k21", (Object)rs.getString(1));
            Assert.assertEquals((Object)"k11", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT * FROM " + dataTableName + " WHERE pk2='k21'";
            rs = conn.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"k11", (Object)rs.getString(1));
            Assert.assertEquals((Object)"k21", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testIndexAlterPhoenixProperty() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "create table " + testTable + " (k varchar primary key, v1 varchar)";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String indexName = "IDX_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " ACTIVE SET GUIDE_POSTS_WIDTH = 10");
        ResultSet rs = conn.createStatement().executeQuery("select GUIDE_POSTS_WIDTH from SYSTEM.\"CATALOG\" where TABLE_NAME='" + indexName + "'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)10L, (long)rs.getInt(1));
        conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " ACTIVE SET GUIDE_POSTS_WIDTH = 20");
        rs = conn.createStatement().executeQuery("select GUIDE_POSTS_WIDTH from SYSTEM.\"CATALOG\" where TABLE_NAME='" + indexName + "'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)20L, (long)rs.getInt(1));
    }

    @Test
    public void testCreateIndexSetUpdateCacheFreqFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (k varchar primary key, v1 varchar)";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String indexName = "IDX_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " ON " + testTable + " (v1) UPDATE_CACHE_FREQUENCY=10000";
        try {
            stmt.execute(ddl);
            Assert.fail((String)"Should fail trying to set UPDATE_CACHE_FREQUENCY when creating an index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Unexpected error occurred", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_UPDATE_CACHE_FREQ_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
    }

    @Test
    public void testIndexGetsUpdateCacheFreqFromBaseTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        long updateCacheFreq = 10000L;
        String ddl = "CREATE TABLE " + testTable + " (k varchar primary key, v1 varchar) UPDATE_CACHE_FREQUENCY=" + updateCacheFreq;
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String localIndex = "LOCAL_" + IndexMetadataIT.generateUniqueName();
        String globalIndex = "GLOBAL_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        ddl = "CREATE INDEX " + globalIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        IndexMetadataIT.assertUpdateCacheFreq(conn, testTable, updateCacheFreq);
        IndexMetadataIT.assertUpdateCacheFreq(conn, localIndex, updateCacheFreq);
        IndexMetadataIT.assertUpdateCacheFreq(conn, globalIndex, updateCacheFreq);
    }

    @Test
    public void testAlterTablePropagatesUpdateCacheFreqToIndexes() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (k varchar primary key, v1 varchar) ";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String localIndex = "LOCAL_" + IndexMetadataIT.generateUniqueName();
        String globalIndex = "GLOBAL_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        ddl = "CREATE INDEX " + globalIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        IndexMetadataIT.assertUpdateCacheFreq(conn, testTable, QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY);
        IndexMetadataIT.assertUpdateCacheFreq(conn, localIndex, QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY);
        IndexMetadataIT.assertUpdateCacheFreq(conn, globalIndex, QueryServicesOptions.DEFAULT_UPDATE_CACHE_FREQUENCY);
        long updateCacheFreq = 10000L;
        ddl = "ALTER TABLE " + testTable + " SET UPDATE_CACHE_FREQUENCY=" + updateCacheFreq;
        stmt.execute(ddl);
        IndexMetadataIT.assertUpdateCacheFreq(conn, testTable, updateCacheFreq);
        IndexMetadataIT.assertUpdateCacheFreq(conn, localIndex, updateCacheFreq);
        IndexMetadataIT.assertUpdateCacheFreq(conn, globalIndex, updateCacheFreq);
    }

    @Test
    public void testIndexAlterUpdateCacheFreqFails() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "CREATE TABLE " + testTable + " (k varchar primary key, v1 varchar)";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String localIndex = "LOCAL_" + IndexMetadataIT.generateUniqueName();
        String globalIndex = "GLOBAL_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + localIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        ddl = "CREATE INDEX " + globalIndex + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        try {
            stmt.execute("ALTER INDEX " + localIndex + " ON " + testTable + " ACTIVE SET UPDATE_CACHE_FREQUENCY=NEVER");
            Assert.fail((String)"Should fail trying to alter UPDATE_CACHE_FREQUENCY on index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Unexpected error occurred", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_UPDATE_CACHE_FREQ_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
        try {
            stmt.execute("ALTER INDEX " + globalIndex + " ON " + testTable + " ACTIVE SET UPDATE_CACHE_FREQUENCY=NEVER");
            Assert.fail((String)"Should fail trying to alter UPDATE_CACHE_FREQUENCY on index");
        }
        catch (SQLException sqlE) {
            Assert.assertEquals((String)"Unexpected error occurred", (long)SQLExceptionCode.CANNOT_SET_OR_ALTER_UPDATE_CACHE_FREQ_FOR_INDEX.getErrorCode(), (long)sqlE.getErrorCode());
        }
    }

    @Test
    public void testIndexAlterHBaseProperty() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(IndexMetadataIT.getUrl(), props);
        String testTable = IndexMetadataIT.generateUniqueName();
        String ddl = "create table " + testTable + " (k varchar primary key, v1 varchar)";
        Statement stmt = conn.createStatement();
        stmt.execute(ddl);
        String indexName = "IDX_" + IndexMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " ON " + testTable + " (v1) ";
        stmt.execute(ddl);
        conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " ACTIVE SET DISABLE_WAL=true");
        IndexMetadataIT.asssertIsWALDisabled(conn, indexName, true);
        conn.createStatement().execute("ALTER INDEX " + indexName + " ON " + testTable + " ACTIVE SET DISABLE_WAL=false");
        IndexMetadataIT.asssertIsWALDisabled(conn, indexName, false);
    }

    private static void asssertIsWALDisabled(Connection conn, String fullTableName, boolean expectedValue) throws SQLException {
        PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
        Assert.assertEquals((Object)expectedValue, (Object)pconn.getTable(new PTableKey(pconn.getTenantId(), fullTableName)).isWALDisabled());
    }

    public static void assertUpdateCacheFreq(Connection conn, String name, long expectedUpdateCacheFreq) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("select UPDATE_CACHE_FREQUENCY from SYSTEM.\"CATALOG\" where TABLE_NAME='" + name + "'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((String)("Mismatch found for " + name), (long)expectedUpdateCacheFreq, (long)rs.getLong(1));
        Assert.assertEquals((String)("Mismatch in UPDATE_CACHE_FREQUENCY for PTable of " + name), (long)expectedUpdateCacheFreq, (long)conn.unwrap(PhoenixConnection.class).getTableNoCache(name).getUpdateCacheFrequency());
    }

    private static enum Order {
        ASC,
        DESC;

    }
}

