/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.hbase.index.IndexRegionObserver;
import org.apache.phoenix.hbase.index.Indexer;
import org.apache.phoenix.index.GlobalIndexChecker;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class IndexCoprocIT
extends ParallelStatsDisabledIT {
    private boolean isNamespaceMapped = false;
    private boolean isMultiTenant = false;
    public static final String GLOBAL_INDEX_CHECKER_CONFIG = "|org.apache.phoenix.index.GlobalIndexChecker|805306365|";
    public static final String INDEX_REGION_OBSERVER_CONFIG = "|org.apache.phoenix.hbase.index.IndexRegionObserver|805306366|index.builder=org.apache.phoenix.index.PhoenixIndexBuilder,org.apache.hadoop.hbase.index.codec.class=org.apache.phoenix.index.PhoenixIndexCodec";
    public static final String INDEXER_CONFIG = "|org.apache.phoenix.hbase.index.Indexer|805306366|index.builder=org.apache.phoenix.index.PhoenixIndexBuilder,org.apache.hadoop.hbase.index.codec.class=org.apache.phoenix.index.PhoenixIndexCodec";

    public IndexCoprocIT(boolean isMultiTenant) {
        this.isMultiTenant = isMultiTenant;
    }

    @Parameterized.Parameters(name="CreateIndexCoprocIT_mulitTenant={0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({true}, {false});
    }

    @Test
    public void testCreateCoprocs() throws Exception {
        String schemaName = "S" + IndexCoprocIT.generateUniqueName();
        String tableName = "T_" + IndexCoprocIT.generateUniqueName();
        String indexName = "I_" + IndexCoprocIT.generateUniqueName();
        String physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)this.isNamespaceMapped).getString();
        String physicalIndexName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)indexName, (boolean)this.isNamespaceMapped).getString();
        Admin admin = this.getConnection().getQueryServices().getAdmin();
        this.createBaseTable(schemaName, tableName, this.isMultiTenant, 0, null);
        this.createIndexTable(schemaName, tableName, indexName);
        IndexTestUtil.downgradeCoprocs(physicalTableName, physicalIndexName, admin);
        this.createBaseTable(schemaName, tableName, true, 0, null);
        TableDescriptor baseDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalTableName));
        TableDescriptor indexDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalIndexName));
        IndexTestUtil.assertUsingOldCoprocs(baseDescriptor, indexDescriptor);
    }

    @Test
    public void testCreateOnExistingHBaseTable() throws Exception {
        String schemaName = IndexCoprocIT.generateUniqueName();
        String tableName = IndexCoprocIT.generateUniqueName();
        String indexName = IndexCoprocIT.generateUniqueName();
        byte[] cf = Bytes.toBytes((String)"f");
        try (PhoenixConnection conn = this.getConnection();){
            TableName table = TableName.valueOf((String)SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)this.isNamespaceMapped).getString());
            TableDescriptorBuilder originalDescBuilder = TableDescriptorBuilder.newBuilder((TableName)table);
            ColumnFamilyDescriptorBuilder familyDescBuilder = ColumnFamilyDescriptorBuilder.newBuilder((byte[])cf);
            originalDescBuilder.setColumnFamily(familyDescBuilder.build());
            Admin admin = conn.getQueryServices().getAdmin();
            admin.createTable(originalDescBuilder.build());
            this.createBaseTable(schemaName, tableName, this.isMultiTenant, 0, null);
            TableDescriptor baseDescriptor = admin.getDescriptor(table);
            this.assertUsingNewCoprocs(baseDescriptor);
            this.createIndexTable(schemaName, tableName, indexName);
            baseDescriptor = admin.getDescriptor(table);
            TableName indexTable = TableName.valueOf((String)SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)indexName, (boolean)this.isNamespaceMapped).getString());
            TableDescriptor indexDescriptor = admin.getDescriptor(indexTable);
            this.assertUsingNewCoprocs(baseDescriptor, indexDescriptor);
        }
    }

    @Test
    public void testAlterDoesntChangeCoprocs() throws Exception {
        String schemaName = "S" + IndexCoprocIT.generateUniqueName();
        String tableName = "T_" + IndexCoprocIT.generateUniqueName();
        String indexName = "I_" + IndexCoprocIT.generateUniqueName();
        String physicalTableName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)tableName, (boolean)this.isNamespaceMapped).getString();
        String physicalIndexName = SchemaUtil.getPhysicalHBaseTableName((String)schemaName, (String)indexName, (boolean)this.isNamespaceMapped).getString();
        Admin admin = this.getConnection().getQueryServices().getAdmin();
        this.createBaseTable(schemaName, tableName, this.isMultiTenant, 0, null);
        this.createIndexTable(schemaName, tableName, indexName);
        TableDescriptor baseDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalTableName));
        TableDescriptor indexDescriptor = admin.getDescriptor(TableName.valueOf((String)physicalIndexName));
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.assertCoprocsContains(GlobalIndexChecker.class, indexDescriptor);
        String columnName = "foo";
        this.addColumnToBaseTable(schemaName, tableName, columnName);
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.assertCoprocsContains(GlobalIndexChecker.class, indexDescriptor);
        this.dropColumnToBaseTable(schemaName, tableName, columnName);
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.assertCoprocsContains(GlobalIndexChecker.class, indexDescriptor);
    }

    private void assertUsingNewCoprocs(TableDescriptor baseDescriptor) {
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.assertCoprocsNotContains(Indexer.class, baseDescriptor);
    }

    private void assertUsingNewCoprocs(TableDescriptor baseDescriptor, TableDescriptor indexDescriptor) {
        IndexTestUtil.assertCoprocsContains(IndexRegionObserver.class, baseDescriptor);
        IndexTestUtil.assertCoprocConfig(baseDescriptor, IndexRegionObserver.class.getName(), INDEX_REGION_OBSERVER_CONFIG);
        IndexTestUtil.assertCoprocsNotContains(Indexer.class, baseDescriptor);
        IndexTestUtil.assertCoprocsNotContains(Indexer.class, indexDescriptor);
        IndexTestUtil.assertCoprocsContains(GlobalIndexChecker.class, indexDescriptor);
        IndexTestUtil.assertCoprocConfig(indexDescriptor, GlobalIndexChecker.class.getName(), GLOBAL_INDEX_CHECKER_CONFIG);
    }

    private void createIndexTable(String schemaName, String tableName, String indexName) throws SQLException {
        PhoenixConnection conn = this.getConnection();
        String fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        conn.createStatement().execute("CREATE INDEX " + indexName + " ON " + fullTableName + "(v1)");
    }

    private void addColumnToBaseTable(String schemaName, String tableName, String columnName) throws Exception {
        PhoenixConnection conn = this.getConnection();
        String ddl = "ALTER TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + "  ADD " + columnName + " varchar(512)";
        conn.createStatement().execute(ddl);
    }

    private void dropColumnToBaseTable(String schemaName, String tableName, String columnName) throws Exception {
        PhoenixConnection conn = this.getConnection();
        String ddl = "ALTER TABLE " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + "  DROP COLUMN " + columnName;
        conn.createStatement().execute(ddl);
    }

    private void createBaseTable(String schemaName, String tableName, boolean multiTenant, Integer saltBuckets, String splits) throws SQLException {
        String ddlOptions;
        PhoenixConnection conn = this.getConnection();
        if (this.isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName);
        }
        String ddl = "CREATE TABLE IF NOT EXISTS " + SchemaUtil.getTableName((String)schemaName, (String)tableName) + " (t_id VARCHAR NOT NULL,\nk1 VARCHAR NOT NULL,\nk2 INTEGER NOT NULL,\nv1 VARCHAR,\nv2 INTEGER,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n";
        String string = ddlOptions = multiTenant ? "MULTI_TENANT=true" : "";
        if (saltBuckets != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ",") + "salt_buckets=" + saltBuckets;
        }
        if (splits != null) {
            ddlOptions = ddlOptions + (ddlOptions.isEmpty() ? "" : ",") + "splits=" + splits;
        }
        conn.createStatement().execute(ddl + ddlOptions);
        conn.close();
    }

    private PhoenixConnection getConnection() throws SQLException {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(this.isNamespaceMapped));
        return (PhoenixConnection)DriverManager.getConnection(IndexCoprocIT.getUrl(), props);
    }
}

