/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.phoenix.end2end.IndexToolIT;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.index.IndexTestUtil;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.transaction.PhoenixTransactionProvider;
import org.apache.phoenix.transaction.TransactionFactory;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ImmutableIndexIT
extends BaseTest {
    private final boolean localIndex;
    private final PhoenixTransactionProvider transactionProvider;
    private final String tableDDLOptions;
    private volatile boolean stopThreads = false;
    private static String TABLE_NAME;
    private static String INDEX_DDL;
    public static final AtomicInteger NUM_ROWS;

    public ImmutableIndexIT(boolean localIndex, boolean transactional, String transactionProvider, boolean columnEncoded) {
        StringBuilder optionBuilder = new StringBuilder("IMMUTABLE_ROWS=true");
        this.localIndex = localIndex;
        if (!columnEncoded) {
            optionBuilder.append(",COLUMN_ENCODED_BYTES=0,IMMUTABLE_STORAGE_SCHEME=" + PTable.ImmutableStorageScheme.ONE_CELL_PER_COLUMN);
        }
        if (transactional) {
            optionBuilder.append(",TRANSACTIONAL=true, TRANSACTION_PROVIDER='" + transactionProvider + "'");
            this.transactionProvider = TransactionFactory.Provider.valueOf((String)transactionProvider).getTransactionProvider();
        } else {
            this.transactionProvider = null;
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("hbase.coprocessor.region.classes", CreateIndexRegionObserver.class.getName());
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)5);
        clientProps.put("phoenix.transactions.enabled", "true");
        clientProps.put("phoenix.index.population.wait.time", "15000");
        clientProps.put("phoenix.index.region.observer.enabled", "true");
        clientProps.put("hbase.client.retries.number", "1");
        clientProps.put("hbase.client.pause", "1");
        ImmutableIndexIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
    }

    @Parameterized.Parameters(name="ImmutableIndexIT_localIndex={0},transactional={1},transactionProvider={2},columnEncoded={3}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({false, false, null, false}, {false, false, null, true}, {false, true, "OMID", false}, {true, false, null, false}, {true, false, null, true});
    }

    @Test
    public void testDropIfImmutableKeyValueColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ImmutableIndexIT.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_col1)";
            stmt.execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            conn.setAutoCommit(true);
            String dml = "DELETE from " + fullTableName + " WHERE long_col2 = 4";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            conn.createStatement().execute("DROP TABLE " + fullTableName);
        }
    }

    @Test
    public void testDeleteFromPartialPK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ImmutableIndexIT.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullTableName + " (char_pk, varchar_pk)";
            stmt.execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX*/ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            String dml = "DELETE from " + fullTableName + " WHERE varchar_pk='varchar1'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            this.assertIndexMutations(conn);
            conn.commit();
            rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX*/ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    @Test
    public void testDeleteFromNonPK() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(false);
            String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ImmutableIndexIT.populateTestTable(fullTableName);
            ddl = "CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullTableName + " (varchar_col1, varchar_pk)";
            stmt.execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX*/ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            String dml = "DELETE from " + fullTableName + " WHERE varchar_col1='varchar_a' AND varchar_pk='varchar1'";
            Assert.assertEquals((long)1L, (long)conn.createStatement().executeUpdate(dml));
            this.assertIndexMutations(conn);
            conn.commit();
            TestUtil.dumpTable(conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullTableName)));
            rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX*/ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
        }
    }

    private void assertIndexMutations(Connection conn) throws SQLException {
        Iterator iterator = PhoenixRuntime.getUncommittedDataIterator((Connection)conn);
        Assert.assertTrue((boolean)iterator.hasNext());
        iterator.next();
        Assert.assertEquals((Object)(!this.localIndex || this.transactionProvider != null && this.transactionProvider.isUnsupported(PhoenixTransactionProvider.Feature.MAINTAIN_LOCAL_INDEX_ON_SERVER) ? 1 : 0), (Object)iterator.hasNext());
    }

    private void createAndPopulateTableAndIndexForConsistentIndex(Connection conn, String tableName, String indexName, int numOfRowsToInsert, String storageProps) throws Exception {
        String tableOptions = this.tableDDLOptions;
        if (storageProps != null) {
            tableOptions = tableOptions + " ,IMMUTABLE_STORAGE_SCHEME=" + storageProps;
        }
        String ddl = "CREATE TABLE " + tableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + tableOptions;
        INDEX_DDL = "CREATE  INDEX IF NOT EXISTS " + SchemaUtil.getTableNameFromFullName((String)indexName) + " ON " + tableName + " (long_pk, varchar_pk) INCLUDE (long_col1, long_col2) ";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute(INDEX_DDL);
        ImmutableIndexIT.upsertRows(conn, tableName, numOfRowsToInsert);
        conn.commit();
        TestUtil.waitForIndexState(conn, indexName, PIndexState.ACTIVE);
    }

    @Test
    public void testGlobalImmutableIndexCreate() throws Exception {
        if (this.localIndex || this.transactionProvider != null) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        ArrayList<String> immutableStorageProps = new ArrayList<String>();
        immutableStorageProps.add(null);
        if (!this.tableDDLOptions.contains("IMMUTABLE_STORAGE_SCHEME")) {
            immutableStorageProps.add(PTable.ImmutableStorageScheme.SINGLE_CELL_ARRAY_WITH_OFFSETS.toString());
        }
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            for (String storageProp : immutableStorageProps) {
                String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
                String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
                String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
                String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
                TABLE_NAME = fullTableName;
                int numRows = 1;
                this.createAndPopulateTableAndIndexForConsistentIndex(conn, fullTableName, fullIndexName, numRows, storageProp);
                ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + TABLE_NAME);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)numRows, (long)rs.getInt(1));
                rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)numRows, (long)rs.getInt(1));
                IndexTestUtil.assertRowsForEmptyColValue(conn, fullIndexName, QueryConstants.VERIFIED_BYTES);
                rs = conn.createStatement().executeQuery("SELECT * FROM " + fullIndexName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"1", (Object)rs.getString(1));
                Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
                Throwable throwable = null;
                try {
                    admin.disableTable(TableName.valueOf((String)fullIndexName));
                    boolean isWriteOnDisabledIndexFailed = false;
                    try {
                        ImmutableIndexIT.upsertRows(conn, fullTableName, numRows);
                    }
                    catch (SQLException ex) {
                        isWriteOnDisabledIndexFailed = true;
                    }
                    Assert.assertEquals((Object)true, (Object)isWriteOnDisabledIndexFailed);
                    PIndexState indexState = TestUtil.getIndexState(conn, fullIndexName);
                    Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)indexState);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (admin == null) continue;
                    if (throwable != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    admin.close();
                }
            }
        }
    }

    @Test
    public void testGlobalImmutableIndexDelete() throws Exception {
        if (this.localIndex || this.transactionProvider != null) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        TABLE_NAME = fullTableName;
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            conn.setAutoCommit(true);
            int numRows = 2;
            this.createAndPopulateTableAndIndexForConsistentIndex(conn, fullTableName, fullIndexName, numRows, null);
            String dml = "DELETE from " + fullTableName + " WHERE varchar_pk='varchar1'";
            conn.createStatement().execute(dml);
            conn.commit();
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + TABLE_NAME);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(numRows - 1), (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)(numRows - 1), (long)rs.getInt(1));
            IndexTestUtil.assertRowsForEmptyColValue(conn, fullIndexName, QueryConstants.VERIFIED_BYTES);
            TestUtil.addCoprocessor(conn, fullTableName, DeleteFailingRegionObserver.class);
            dml = "DELETE from " + fullTableName + " WHERE varchar_pk='varchar2'";
            boolean isDeleteFailed = false;
            try {
                conn.createStatement().execute(dml);
            }
            catch (Exception ex) {
                isDeleteFailed = true;
            }
            Assert.assertEquals((Object)true, (Object)isDeleteFailed);
            TestUtil.removeCoprocessor(conn, fullTableName, DeleteFailingRegionObserver.class);
            Assert.assertEquals((long)(numRows - 1), (long)TestUtil.getRowCount(conn.unwrap(PhoenixConnection.class).getQueryServices().getTable(Bytes.toBytes((String)fullIndexName)), false));
            IndexTestUtil.assertRowsForEmptyColValue(conn, fullIndexName, QueryConstants.UNVERIFIED_BYTES);
            admin.disableTable(TableName.valueOf((String)fullTableName));
            admin.truncateTable(TableName.valueOf((String)fullTableName), true);
            String selectFromIndex = "SELECT long_pk, varchar_pk, long_col1 FROM " + TABLE_NAME + " WHERE varchar_pk='varchar2' AND long_pk=2";
            rs = conn.createStatement().executeQuery("EXPLAIN " + selectFromIndex);
            String actualExplainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            IndexToolIT.assertExplainPlan(false, actualExplainPlan, fullTableName, fullIndexName);
            rs = conn.createStatement().executeQuery(selectFromIndex);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Ignore
    @Test
    public void testCreateIndexDuringUpsertSelect() throws Exception {
        String fullTableName;
        if (this.localIndex) {
            return;
        }
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        TABLE_NAME = fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String ddl = "CREATE TABLE " + TABLE_NAME + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
        INDEX_DDL = "CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX IF NOT EXISTS " + indexName + " ON " + TABLE_NAME + " (long_pk, varchar_pk) INCLUDE (long_col1, long_col2)";
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(false);
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ImmutableIndexIT.upsertRows(conn, TABLE_NAME, 220);
            conn.commit();
            conn.setAutoCommit(true);
            String upsertSelect = "UPSERT INTO " + TABLE_NAME + "(varchar_pk, char_pk, int_pk, long_pk, decimal_pk, date_pk) SELECT varchar_pk||'_upsert_select', char_pk, int_pk, long_pk, decimal_pk, date_pk FROM " + TABLE_NAME;
            conn.createStatement().execute(upsertSelect);
            TestUtil.waitForIndexRebuild(conn, indexName, PIndexState.ACTIVE);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + TABLE_NAME);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)440L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)440L, (long)rs.getInt(1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore
    @Test
    public void testCreateIndexWhileUpsertingData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String tableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)"S", (String)tableName);
        String fullIndexName = SchemaUtil.getTableName((String)"S", (String)indexName);
        String ddl = "CREATE TABLE " + fullTableName + "(   varchar_pk VARCHAR NOT NULL,    char_pk CHAR(10) NOT NULL,    int_pk INTEGER NOT NULL,    long_pk BIGINT NOT NULL,    decimal_pk DECIMAL(31, 10) NOT NULL,    date_pk DATE NOT NULL,    a.varchar_col1 VARCHAR,    a.char_col1 CHAR(10),    a.int_col1 INTEGER,    a.long_col1 BIGINT,    a.decimal_col1 DECIMAL(31, 10),    a.date1 DATE,    b.varchar_col2 VARCHAR,    b.char_col2 CHAR(10),    b.int_col2 INTEGER,    b.long_col2 BIGINT,    b.decimal_col2 DECIMAL(31, 10),    b.date2 DATE    CONSTRAINT pk PRIMARY KEY (varchar_pk, char_pk, int_pk, long_pk DESC, decimal_pk, date_pk)) " + this.tableDDLOptions;
        String indexDDL = "CREATE " + (this.localIndex ? "LOCAL" : "") + " INDEX " + indexName + " ON " + fullTableName + " (long_pk, varchar_pk) INCLUDE (long_col1, long_col2)";
        int numThreads = 2;
        ExecutorService executorService = Executors.newFixedThreadPool(numThreads, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                t.setPriority(1);
                return t;
            }
        });
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            stmt.execute(ddl);
            ResultSet rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            int dataTableRowCount = rs.getInt(1);
            Assert.assertEquals((long)0L, (long)dataTableRowCount);
            ArrayList futureList = Lists.newArrayListWithExpectedSize((int)numThreads);
            for (int i = 0; i < numThreads; ++i) {
                futureList.add(executorService.submit(new UpsertRunnable(fullTableName)));
            }
            Thread.sleep(100L);
            try (Connection conn2 = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
                conn2.createStatement().execute(indexDDL);
            }
            Thread.sleep(50L);
            this.stopThreads = true;
            executorService.shutdown();
            Assert.assertTrue((boolean)executorService.awaitTermination(30L, TimeUnit.SECONDS));
            rs = conn.createStatement().executeQuery("SELECT /*+ NO_INDEX */ COUNT(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            dataTableRowCount = rs.getInt(1);
            rs = conn.createStatement().executeQuery("SELECT COUNT(*) FROM " + fullIndexName);
            Assert.assertTrue((boolean)rs.next());
            int indexTableRowCount = rs.getInt(1);
            Assert.assertEquals((String)"Data and Index table should have the same number of rows ", (long)dataTableRowCount, (long)indexTableRowCount);
        }
        finally {
            executorService.shutdownNow();
        }
    }

    private void setupForDeleteCount(Connection conn, String schemaName, String dataTableName, String indexTableName1, String indexTableName2) throws SQLException {
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        conn.createStatement().execute("CREATE TABLE " + dataTableFullName + " (ID INTEGER NOT NULL PRIMARY KEY, VAL1 INTEGER, VAL2 INTEGER) " + this.tableDDLOptions);
        if (indexTableName1 != null) {
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL1) INCLUDE (VAL2)", indexTableName1, dataTableFullName));
        }
        if (indexTableName2 != null) {
            conn.createStatement().execute(String.format("CREATE INDEX %s ON %s (VAL2) INCLUDE (VAL1)", indexTableName2, dataTableFullName));
        }
        PreparedStatement dataPreparedStatement = conn.prepareStatement("UPSERT INTO " + dataTableFullName + " VALUES(?,?,?)");
        for (int i = 1; i <= 10; ++i) {
            dataPreparedStatement.setInt(1, i);
            dataPreparedStatement.setInt(2, i + 1);
            dataPreparedStatement.setInt(3, i * 2);
            dataPreparedStatement.execute();
        }
        conn.commit();
    }

    @Test
    public void testDeleteCount_PK() throws Exception {
        String schemaName = ImmutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName = "IND_" + ImmutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName, null);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE ID > 5");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_nonPK() throws Exception {
        String schemaName = ImmutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName1 = "IND_" + ImmutableIndexIT.generateUniqueName();
        String indexTableName2 = "IND_" + ImmutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName1, indexTableName2);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE VAL1 > 6");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_limit() throws Exception {
        String schemaName = ImmutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String indexTableName1 = "IND_" + ImmutableIndexIT.generateUniqueName();
        String indexTableName2 = "IND_" + ImmutableIndexIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName1, indexTableName2);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + dataTableFullName + " WHERE VAL1 > 6 LIMIT 3");
            Assert.assertEquals((long)3L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    @Test
    public void testDeleteCount_index() throws Exception {
        String schemaName = ImmutableIndexIT.generateUniqueName();
        String dataTableName = "TBL_" + ImmutableIndexIT.generateUniqueName();
        String indexTableName = "IND_" + ImmutableIndexIT.generateUniqueName();
        String indexTableFullName = SchemaUtil.getTableName((String)schemaName, (String)indexTableName);
        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl());){
            this.setupForDeleteCount(conn, schemaName, dataTableName, indexTableName, null);
            PreparedStatement deleteStmt = conn.prepareStatement("DELETE FROM " + indexTableFullName + " WHERE \"0:VAL1\" > 6");
            Assert.assertEquals((long)5L, (long)deleteStmt.executeUpdate());
            conn.commit();
        }
    }

    static {
        NUM_ROWS = new AtomicInteger(0);
    }

    private class UpsertRunnable
    implements Runnable {
        private static final int NUM_ROWS_IN_BATCH = 10;
        private final String fullTableName;

        public UpsertRunnable(String fullTableName) {
            this.fullTableName = fullTableName;
        }

        @Override
        public void run() {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
                while (!ImmutableIndexIT.this.stopThreads) {
                    boolean fistRowInBatch = true;
                    for (int i = 0; i < 10 && !ImmutableIndexIT.this.stopThreads; ++i) {
                        BaseTest.upsertRow(conn, this.fullTableName, NUM_ROWS.incrementAndGet(), fistRowInBatch);
                        fistRowInBatch = false;
                    }
                    conn.commit();
                    Thread.sleep(10L);
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class CreateIndexRegionObserver
    extends SimpleRegionObserver {
        public void postPut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            String tableName = ((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionInfo().getTable().getNameAsString();
            if (tableName.equalsIgnoreCase(TABLE_NAME) && Bytes.startsWith((byte[])put.getRow(), (byte[])Bytes.toBytes((String)"varchar200_upsert_select"))) {
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
                        try (Connection conn = DriverManager.getConnection(ImmutableIndexIT.getUrl(), props);){
                            conn.createStatement().execute(INDEX_DDL);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                };
                new Thread(r).start();
            }
        }
    }

    public static class UpsertFailingRegionObserver
    extends SimpleRegionObserver {
        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            throw new DoNotRetryIOException();
        }
    }

    public static class DeleteFailingRegionObserver
    extends SimpleRegionObserver {
        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            throw new DoNotRetryIOException();
        }
    }
}

