/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.SimpleRegionObserver;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EncodedColumnsUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class ImmutableIndexExtendedIT
extends ParallelStatsDisabledIT {
    private final String tableDDLOptions;
    private final FailingRegionObserver coproc;
    private final Boolean useView;

    public ImmutableIndexExtendedIT(FailingRegionObserver coproc, Boolean useView) {
        this.coproc = coproc;
        this.useView = useView;
        StringBuilder optionBuilder = new StringBuilder("IMMUTABLE_ROWS=true");
        this.tableDDLOptions = optionBuilder.toString();
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("hbase.client.retries.number", "5");
        ImmutableIndexExtendedIT.setUpTestDriver(new ReadOnlyProps((Map)props));
    }

    private boolean getExpectedStatus(FailStep step) {
        boolean status;
        switch (step) {
            case NONE: {
                status = true;
                break;
            }
            default: {
                status = false;
            }
        }
        return status;
    }

    private int getExpectedUnverifiedRowCount(FailStep step) {
        int unverifiedRowCount;
        switch (step) {
            case POST_INDEX_TABLE_UPDATE: {
                unverifiedRowCount = 1;
                break;
            }
            default: {
                unverifiedRowCount = 0;
            }
        }
        return unverifiedRowCount;
    }

    @Parameterized.Parameters(name="coproc = {0}, useView = {1}")
    public static Collection<Object[]> data() {
        boolean[] Booleans;
        ArrayList params = Lists.newArrayListWithExpectedSize((int)6);
        for (boolean useView : Booleans = new boolean[]{false, true}) {
            params.add(new Object[]{new PreMutationFailingRegionObserver(), useView});
            params.add(new Object[]{new PostMutationFailingRegionObserver(), useView});
            params.add(new Object[]{new FailOnceMutationRegionObserver(), useView});
        }
        return params;
    }

    private void createAndPopulateTable(Connection conn, String tableName, int rowCount) throws Exception {
        String ddl = "CREATE TABLE " + tableName + " (id integer not null primary key, val1 varchar, val2 varchar, val3 varchar)" + this.tableDDLOptions;
        conn.createStatement().execute(ddl);
        String dml = "UPSERT INTO " + tableName + " (id, val1, val2, val3) VALUES (?, ?, ?, ?)";
        PreparedStatement stmt = conn.prepareStatement(dml);
        for (int id = 1; id <= rowCount; ++id) {
            stmt.setInt(1, id);
            stmt.setString(2, "a" + id);
            stmt.setString(3, "ab" + id);
            stmt.setString(4, "abc" + id);
            stmt.executeUpdate();
        }
        conn.commit();
    }

    private void createView(Connection conn, String dataTable, String viewTable) throws Exception {
        String ddl = "CREATE VIEW " + viewTable + " AS SELECT * FROM " + dataTable;
        conn.createStatement().execute(ddl);
    }

    private void createIndex(Connection conn, String dataTable, String indexTable) throws Exception {
        String ddl = "CREATE INDEX " + indexTable + " on " + dataTable + " (val1) include (val2, val3)";
        conn.createStatement().execute(ddl);
        conn.commit();
        TestUtil.waitForIndexState(conn, indexTable, PIndexState.ACTIVE);
    }

    public static int getRowCountForEmptyColValue(Connection conn, String tableName, byte[] valueBytes) throws IOException, SQLException {
        PTable table = conn.unwrap(PhoenixConnection.class).getTable(tableName);
        byte[] emptyCF = SchemaUtil.getEmptyColumnFamily((PTable)table);
        byte[] emptyCQ = (byte[])EncodedColumnsUtil.getEmptyKeyValueInfo((PTable)table).getFirst();
        ConnectionQueryServices queryServices = conn.unwrap(PhoenixConnection.class).getQueryServices();
        Table htable = queryServices.getTable(table.getPhysicalName().getBytes());
        Scan scan = new Scan();
        scan.addColumn(emptyCF, emptyCQ);
        ResultScanner resultScanner = htable.getScanner(scan);
        int count = 0;
        Result result = resultScanner.next();
        while (result != null) {
            if (Bytes.compareTo((byte[])result.getValue(emptyCF, emptyCQ), (int)0, (int)valueBytes.length, (byte[])valueBytes, (int)0, (int)valueBytes.length) == 0) {
                ++count;
            }
            result = resultScanner.next();
        }
        return count;
    }

    private static void verifyRowCountForEmptyCol(Connection conn, String indexTable, int expectedVerifiedCount, int expectedUnverifiedCount) throws Exception {
        Assert.assertEquals((long)expectedVerifiedCount, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, indexTable, QueryConstants.VERIFIED_BYTES));
        Assert.assertEquals((long)expectedUnverifiedCount, (long)ImmutableIndexExtendedIT.getRowCountForEmptyColValue(conn, indexTable, QueryConstants.UNVERIFIED_BYTES));
    }

    @Test
    public void testFailingUpsertMutations() throws Exception {
        String dataTable = "TBL_" + ImmutableIndexExtendedIT.generateUniqueName();
        String indexTable = "IND_" + ImmutableIndexExtendedIT.generateUniqueName();
        String viewTable = "VIEW_" + ImmutableIndexExtendedIT.generateUniqueName();
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ImmutableIndexExtendedIT.getUrl());){
            int initialRowCount = 2;
            this.createAndPopulateTable((Connection)conn, dataTable, 2);
            this.createView((Connection)conn, dataTable, viewTable);
            String baseTable = this.useView != false ? viewTable : dataTable;
            this.createIndex((Connection)conn, baseTable, indexTable);
            String index = conn.getTable(indexTable).getPhysicalName().getString();
            TestUtil.addCoprocessor((Connection)conn, index, this.coproc.getClass());
            boolean upsertStatus = true;
            try {
                String dml = "UPSERT INTO " + baseTable + " VALUES (3, 'a3', 'ab3', 'abc3')";
                conn.createStatement().execute(dml);
                conn.commit();
            }
            catch (Exception ex) {
                upsertStatus = false;
            }
            boolean expectedStatus = this.getExpectedStatus(this.coproc.getFailStep());
            Assert.assertEquals((Object)expectedStatus, (Object)upsertStatus);
            String dql = "SELECT * FROM " + baseTable + " WHERE id = 3";
            ResultSet rs = conn.createStatement().executeQuery(dql);
            if (!upsertStatus) {
                Assert.assertFalse((boolean)rs.next());
                ImmutableIndexExtendedIT.verifyRowCountForEmptyCol((Connection)conn, indexTable, 2, this.getExpectedUnverifiedRowCount(this.coproc.getFailStep()));
            } else {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getInt(1));
                ImmutableIndexExtendedIT.verifyRowCountForEmptyCol((Connection)conn, indexTable, 3, this.getExpectedUnverifiedRowCount(this.coproc.getFailStep()));
            }
            TestUtil.removeCoprocessor((Connection)conn, index, this.coproc.getClass());
        }
    }

    public static class FailOnceMutationRegionObserver
    extends SimpleRegionObserver
    implements FailingRegionObserver {
        private boolean failOnce = true;

        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            if (this.failOnce) {
                this.failOnce = false;
                throw new IOException();
            }
        }

        @Override
        public FailStep getFailStep() {
            return FailStep.NONE;
        }
    }

    public static class PostMutationFailingRegionObserver
    extends SimpleRegionObserver
    implements FailingRegionObserver {
        public void postBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            throw new IOException();
        }

        @Override
        public FailStep getFailStep() {
            return FailStep.POST_INDEX_TABLE_UPDATE;
        }
    }

    public static class PreMutationFailingRegionObserver
    extends SimpleRegionObserver
    implements FailingRegionObserver {
        public void preBatchMutate(ObserverContext<RegionCoprocessorEnvironment> c, MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
            throw new IOException();
        }

        @Override
        public FailStep getFailStep() {
            return FailStep.PRE_INDEX_TABLE_UPDATE;
        }
    }

    static interface FailingRegionObserver {
        public FailStep getFailStep();
    }

    private static enum FailStep {
        NONE,
        PRE_INDEX_TABLE_UPDATE,
        POST_INDEX_TABLE_UPDATE;

    }
}

