/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class GlobalIndexOptimizationIT
extends ParallelStatsDisabledIT {
    private void createBaseTable(String tableName, Integer saltBuckets, String splits, boolean multiTenant) throws SQLException {
        Connection conn = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());
        String ddl = "CREATE TABLE " + tableName + " (t_id VARCHAR NOT NULL,\nk1 INTEGER NOT NULL,\nk2 INTEGER NOT NULL,\nk3 INTEGER,\nv1 VARCHAR,\nCONSTRAINT pk PRIMARY KEY (t_id, k1, k2))\n" + (multiTenant ? "MULTI_TENANT = true\n" : "") + (saltBuckets != null && splits == null ? ",salt_buckets=" + saltBuckets : "" + (saltBuckets == null && splits != null ? " split on " + splits : ""));
        conn.createStatement().execute(ddl);
        conn.close();
    }

    private void createIndex(String indexName, String tableName, String columns, String includes, boolean local) throws SQLException {
        Connection conn = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());
        String ddl = "CREATE " + (local ? "LOCAL " : "") + "INDEX " + indexName + " ON " + tableName + " (" + columns + ")" + (includes != null ? " INCLUDE (" + includes + ")" : "");
        conn.createStatement().execute(ddl);
        conn.close();
    }

    @Test
    public void testIndexDeleteOptimizationWithLocalIndex() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        this.createBaseTable(dataTableName, null, null, false);
        this.createIndex(indexTableName + "L", dataTableName, "k3", null, true);
        this.createIndex(indexTableName + "G", dataTableName, "v1", "k3", false);
        String query = "DELETE FROM " + dataTableName + " where k3 < 100";
        try (Connection conn1 = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values(TO_CHAR(rand()*100),rand()*10000,rand()*10000,rand()*10000,TO_CHAR(rand()*100))");
            for (int i = 0; i < 16; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + dataTableName + " SELECT TO_CHAR(rand()*100),rand()*10000,rand()*10000,rand()*10000,TO_CHAR(rand()*100) FROM " + dataTableName);
            }
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            String expected = "DELETE ROWS CLIENT SELECT\nCLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + "L(" + dataTableName + ") [1,*] - [1,100]\n    SERVER FILTER BY FIRST KEY ONLY\nCLIENT MERGE SORT";
            String actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertEquals((Object)expected, (Object)actual);
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + dataTableName);
            rs.next();
            int count = rs.getInt(1);
            int deleted = conn1.createStatement().executeUpdate(query);
            int expectedCount = count - deleted;
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + dataTableName);
            rs.next();
            count = rs.getInt(1);
            Assert.assertEquals((long)expectedCount, (long)count);
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName + "L");
            rs.next();
            count = rs.getInt(1);
            Assert.assertEquals((long)expectedCount, (long)count);
            rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + indexTableName + "G");
            rs.next();
            count = rs.getInt(1);
            Assert.assertEquals((long)expectedCount, (long)count);
        }
    }

    @Test
    public void testGlobalIndexOptimization() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)"", (String)dataTableName);
        this.testOptimization(dataTableName, dataTableFullName, indexTableName, 4);
    }

    @Test
    public void testGlobalIndexOptimizationWithSalting() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)"", (String)dataTableName);
        this.testOptimization(dataTableName, dataTableFullName, indexTableName, 4);
    }

    @Test
    public void testGlobalIndexOptimizationTenantSpecific() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        this.testOptimizationTenantSpecific(dataTableName, indexTableName, null);
    }

    @Test
    public void testGlobalIndexOptimizationWithSaltingTenantSpecific() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        this.testOptimizationTenantSpecific(dataTableName, indexTableName, 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOptimization(String dataTableName, String dataTableFullName, String indexTableName, Integer saltBuckets) throws Exception {
        this.createBaseTable(dataTableName, saltBuckets, "('e','i','o')", false);
        try (Connection conn1 = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('q',3,1,1,'c')");
            conn1.commit();
            this.createIndex(indexTableName, dataTableName, "v1", null, false);
            String query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ * FROM " + dataTableName + " where v1='a'";
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            String expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " ['a']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY";
            String actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ * FROM " + dataTableName + " where v1='a'";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " ['a']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ * FROM " + dataTableName + " where v1='a' limit 1";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT SERIAL 1-WAY RANGE SCAN OVER " + indexTableName + " ['a']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER 1 ROW LIMIT\nCLIENT 1 ROW LIMIT";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ t_id, k1, k2, k3, V1 from " + dataTableFullName + "  where v1<='z' and k3 > 1 order by V1,t_id";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " [*] - ['z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY AND \"K3\" > 1";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + "), NO_INDEX_SERVER_MERGE */ t_id, k1, k2, k3, V1 from " + dataTableFullName + "  where v1<='z' and k3 > 1 order by V1,t_id";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT PARALLEL 1-WAY FULL SCAN OVER " + dataTableName + "\n    SERVER FILTER BY K3 > 1\n    SERVER SORTED BY \\[" + dataTableName + "\\.V1, " + dataTableName + "\\.T_ID\\]\nCLIENT MERGE SORT\n    SKIP-SCAN-JOIN TABLE 0\n        CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " \\[\\*\\] - \\['z'\\]\n            SERVER FILTER BY FIRST KEY ONLY\n    DYNAMIC SERVER FILTER BY \\(\"" + dataTableName + "\\.T_ID\", \"" + dataTableName + "\\.K1\", \"" + dataTableName + "\\.K2\"\\) IN \\(\\(\\$\\d+\\.\\$\\d+, \\$\\d+\\.\\$\\d+, \\$\\d+\\.\\$\\d+\\)\\)";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)Pattern.matches(expected, actual));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ t_id, V1, k3 from " + dataTableFullName + "  where v1 <='z' group by v1,t_id, k3";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " [*] - ['z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO DISTINCT ROWS BY [\"V1\", \"T_ID\", \"K3\"]\nCLIENT MERGE SORT";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"q", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ v1,sum(k3) from " + dataTableFullName + " where v1 <='z'  group by v1 order by v1";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " [*] - ['z']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY\n    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY [\"V1\"]";
            actual = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((long)5L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"c", (Object)rs.getString(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString(1));
            Assert.assertEquals((long)4L, (long)rs.getInt(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testOptimizationTenantSpecific(String dataTableName, String indexTableName, Integer saltBuckets) throws Exception {
        this.createBaseTable(dataTableName, saltBuckets, "('e','i','o')", true);
        try (Connection conn1 = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl() + ';' + "TenantId" + "=tid1");){
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values(1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values(1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values(2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values(3,1,1,'c')");
            conn1.commit();
            this.createIndex(indexTableName, dataTableName, "v1", null, false);
            String query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ k1,k2,k3,v1 FROM " + dataTableName + " where v1='a'";
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            String actual = QueryUtil.getExplainPlan((ResultSet)rs);
            String expected = "CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " ['tid1','a']\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY";
            Assert.assertTrue((String)("Expected:\n" + expected + "\nbut got\n" + actual), (boolean)actual.equals(expected));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("v1"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGlobalIndexOptimizationOnSharedIndex() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        this.createBaseTable(dataTableName, null, "('e','i','o')", false);
        Connection conn1 = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());
        String viewName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexOnDataTable = GlobalIndexOptimizationIT.generateUniqueName();
        try {
            conn1.createStatement().execute("CREATE INDEX " + indexOnDataTable + " ON " + dataTableName + "(k2,k1) INCLUDE (v1)");
            conn1.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + dataTableName + " WHERE v1 = 'a'");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('q',3,1,1,'c')");
            conn1.commit();
            ResultSet rs = conn1.createStatement().executeQuery("SELECT COUNT(*) FROM " + viewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
            String viewIndex = GlobalIndexOptimizationIT.generateUniqueName();
            conn1.createStatement().execute("CREATE INDEX " + viewIndex + " ON " + viewName + " (k1)");
            String query = "SELECT /*+ INDEX(" + viewName + " " + viewIndex + ")*/ t_id,k1,k2,k3,v1 FROM " + viewName + " where k1 IN (1,2) and k2 IN (3,4)";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            String actual = QueryUtil.getExplainPlan((ResultSet)rs);
            String expected = "CLIENT PARALLEL 1-WAY SKIP SCAN ON 2 KEYS OVER _IDX_" + dataTableName + " [" + Short.MIN_VALUE + ",1] - [" + Short.MIN_VALUE + ",2]\n    SERVER MERGE [0.K3]\n    SERVER FILTER BY FIRST KEY ONLY";
            Assert.assertEquals((Object)expected, (Object)actual);
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString(5));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn1.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoGlobalIndexOptimization() throws Exception {
        String dataTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String indexTableName = GlobalIndexOptimizationIT.generateUniqueName();
        String dataTableFullName = SchemaUtil.getTableName((String)"", (String)dataTableName);
        this.createBaseTable(dataTableName, null, "('e','i','o')", false);
        try (Connection conn1 = DriverManager.getConnection(GlobalIndexOptimizationIT.getUrl());){
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('b',1,2,4,'z')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('f',1,2,3,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('j',2,4,2,'a')");
            conn1.createStatement().execute("UPSERT INTO " + dataTableName + " values('q',3,1,1,'c')");
            conn1.commit();
            conn1.createStatement().execute("CREATE INDEX " + indexTableName + " ON " + dataTableName + "(v1)");
            String query = "SELECT /*+ INDEX(" + dataTableName + " " + indexTableName + ")*/ t_id, k1, k2, V1 FROM " + dataTableName + " where v1='a'";
            ResultSet rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY RANGE SCAN OVER " + indexTableName + " ['a']\n    SERVER FILTER BY FIRST KEY ONLY"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2, k3, V1 FROM " + dataTableName + " where v1='a'";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 1-WAY FULL SCAN OVER " + dataTableName + "\n    SERVER FILTER BY V1 = 'a'"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT  t_id, k1, k2, k3, V1 from " + dataTableFullName + " order by V1,t_id";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 4-WAY FULL SCAN OVER " + dataTableName + "\n    SERVER SORTED BY [V1, T_ID]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"q", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"c", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            Assert.assertFalse((boolean)rs.next());
            query = "SELECT t_id, k1, k2, k3, V1 from " + dataTableFullName + "  where k3 > 1 order by V1,t_id";
            rs = conn1.createStatement().executeQuery("EXPLAIN " + query);
            Assert.assertEquals((Object)("CLIENT PARALLEL 4-WAY FULL SCAN OVER " + dataTableName + "\n    SERVER FILTER BY K3 > 1\n    SERVER SORTED BY [V1, T_ID]\nCLIENT MERGE SORT"), (Object)QueryUtil.getExplainPlan((ResultSet)rs));
            rs = conn1.createStatement().executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"f", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)3L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"j", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"a", (Object)rs.getString("V1"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString("t_id"));
            Assert.assertEquals((long)1L, (long)rs.getInt("k1"));
            Assert.assertEquals((long)2L, (long)rs.getInt("k2"));
            Assert.assertEquals((long)4L, (long)rs.getInt("k3"));
            Assert.assertEquals((Object)"z", (Object)rs.getString("V1"));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

