/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end.index;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class AsyncIndexDisabledIT
extends ParallelStatsDisabledIT {
    @Test
    public void testAsyncIndexRegularBuild() throws Exception {
        try (Connection conn = DriverManager.getConnection(AsyncIndexDisabledIT.getUrl());){
            conn.setAutoCommit(true);
            Statement stmt = conn.createStatement();
            String tableName = "TBL_" + AsyncIndexDisabledIT.generateUniqueName();
            String indexName = "IND_" + AsyncIndexDisabledIT.generateUniqueName();
            String ddl = "CREATE TABLE " + tableName + " (pk INTEGER NOT NULL PRIMARY KEY, val VARCHAR)";
            stmt.execute(ddl);
            stmt.execute("UPSERT INTO " + tableName + " values(1, 'y')");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + "(val) ASYNC");
            PhoenixConnection phxConn = conn.unwrap(PhoenixConnection.class);
            PTable table = phxConn.getTable(new PTableKey(null, tableName));
            Assert.assertEquals((String)"Index not built", (long)1L, (long)table.getIndexes().size());
            Assert.assertEquals((String)"Wrong index created", (Object)indexName, (Object)((PTable)table.getIndexes().get(0)).getName().getString());
            ResultSet rs = stmt.executeQuery("select /*+ INDEX(" + indexName + ")*/ pk, val from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((Object)"y", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

