/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import org.apache.hadoop.hbase.TableName;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.bson.RawBsonDocument;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class WhereOptimizerForArrayAnyIT
extends BaseTest {
    @BeforeClass
    public static void setup() throws Exception {
        WhereOptimizerForArrayAnyIT.setUpTestDriver(new ReadOnlyProps(new HashMap()));
    }

    @Test
    public void testArrayAnyComparisonForNonPkColumn() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        this.createTableASCPkColumns(tableName);
        this.insertData(tableName, 1, "x", "a");
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            String selectSql = "SELECT * FROM " + tableName + " WHERE col1 = ANY(?)";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"a", "b"});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreNotGenerated(stmt);
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithInequalityOperator() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        this.createTableASCPkColumns(tableName);
        this.insertData(tableName, 2, "x", "a");
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 > ANY(?)";
            Array arr = conn.createArrayOf("INTEGER", new Integer[]{1, 2, 3});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreNotGenerated(stmt);
            }
        }
    }

    @Test
    public void testArrayAnyComparsionWithBindVariable() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        this.createTableASCPkColumns(tableName);
        this.insertData(tableName, 1, "x", "a");
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'x'";
            Array arr = conn.createArrayOf("INTEGER", new Integer[]{1, 2});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithLiteralArray() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        this.createTableASCPkColumns(tableName);
        this.insertData(tableName, 1, "x", "a");
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = 1 AND pk2 = ANY(ARRAY['x', 'y'])";
            try (Statement stmt = conn.createStatement();){
                try (ResultSet rs = stmt.executeQuery(selectSql);){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, selectSql, 2);
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithDoubleToFloatConversion() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 FLOAT NOT NULL, pk2 VARCHAR(3) NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
            stmt.execute("UPSERT INTO " + tableName + " VALUES (2.2, 'y', 'b')");
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'y'";
            Array arr = conn.createArrayOf("DOUBLE", new Double[]{4.4, 2.2, 0.0});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"y", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithLongToIntegerConversion() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3) NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        this.insertData(tableName, 2, "y", "b");
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'y'";
            Array arr = conn.createArrayOf("BIGINT", new Long[]{4L, 2L, 0L});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"y", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithNullInArray() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        this.createTableASCPkColumns(tableName);
        this.insertData(tableName, 1, null, "a");
        this.insertData(tableName, 2, "y", "b");
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            Throwable throwable;
            ResultSet rs;
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = 1 AND pk2 = ANY(?)";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"y", "z", null});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                rs = stmt.executeQuery();
                throwable = null;
                try {
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
            selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = 2 AND pk2 = ANY(?)";
            stmt = conn.prepareStatement(selectSql);
            var7_9 = null;
            try {
                stmt.setArray(1, arr);
                rs = stmt.executeQuery();
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"y", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
            catch (Throwable throwable6) {
                var7_9 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var7_9 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var7_9.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithDescPKAndNullInArray() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2 DESC))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        this.insertData(tableName, 1, null, "a");
        this.insertData(tableName, 2, "y", "b");
        this.insertData(tableName, 3, "z", null);
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            Throwable throwable;
            ResultSet rs;
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = 1 AND pk2 = ANY(?)";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"y", "z", null});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                rs = stmt.executeQuery();
                throwable = null;
                try {
                    Assert.assertFalse((boolean)rs.next());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
            selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = 2 AND pk2 = ANY(?)";
            stmt = conn.prepareStatement(selectSql);
            var8_15 = null;
            try {
                stmt.setArray(1, arr);
                rs = stmt.executeQuery();
                throwable = null;
                try {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"y", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
            catch (Throwable throwable6) {
                var8_15 = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (var8_15 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            var8_15.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonForDescCharPKWithPadding() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 CHAR(3) NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setString(1, "a");
            stmt.setString(2, "b");
            stmt.setString(3, "c");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var5_5 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'b'";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"a", "c", null});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"c", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithDecimalArray() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 DECIMAL(10, 2) NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setBigDecimal(1, new BigDecimal("1.23"));
            stmt.setString(2, "x");
            stmt.setString(3, "a");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var5_5 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'x'";
            Array arr = conn.createArrayOf("DECIMAL", new BigDecimal[]{new BigDecimal("1.230"), new BigDecimal("2.340"), new BigDecimal("3.450")});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)new BigDecimal("1.23"), (Object)rs.getBigDecimal(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithDataTypeAndSortOrderCoercionForDecimalColumn() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 DECIMAL(10, 2) NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setBigDecimal(1, new BigDecimal("1.23"));
            stmt.setString(2, "x");
            stmt.setString(3, "a");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var5_5 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = 'x'";
            Array arr = conn.createArrayOf("DOUBLE", new Double[]{1.23, 2.34, 3.45});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)new BigDecimal("1.23"), (Object)rs.getBigDecimal(1));
                    Assert.assertEquals((Object)"x", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonForDateTimeColumn() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 TIMESTAMP NOT NULL, pk2 TIME NOT NULL, pk3 DATE NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String pk1Value = "2025-07-18 10:00:00";
        String pk2Value = "2025-07-18 11:00:00";
        String pk3Value = "2025-07-18 12:00:00";
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setTimestamp(1, DateUtil.parseTimestamp((String)pk1Value));
            stmt.setTime(2, DateUtil.parseTime((String)pk2Value));
            stmt.setDate(3, DateUtil.parseDate((String)pk3Value));
            stmt.setString(4, "a");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var8_13 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = ANY(?) AND pk3 = ANY(?)";
            Array timestampArr = conn.createArrayOf("TIMESTAMP", new Timestamp[]{DateUtil.parseTimestamp((String)pk1Value), DateUtil.parseTimestamp((String)"2025-07-19 10:00:00"), DateUtil.parseTimestamp((String)"2025-07-17 10:00:00")});
            Array timeArr = conn.createArrayOf("TIME", new Time[]{DateUtil.parseTime((String)pk2Value), DateUtil.parseTime((String)"2025-07-19 11:00:00"), DateUtil.parseTime((String)"2025-07-17 11:00:00")});
            Array dateArr = conn.createArrayOf("DATE", new Date[]{DateUtil.parseDate((String)pk3Value), DateUtil.parseDate((String)"2025-07-19 12:00:00"), DateUtil.parseDate((String)"2025-07-17 12:00:00")});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, timestampArr);
                stmt.setArray(2, timeArr);
                stmt.setArray(3, dateArr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)DateUtil.parseTimestamp((String)pk1Value), (Object)rs.getTimestamp(1));
                    Assert.assertEquals((Object)DateUtil.parseTime((String)pk2Value), (Object)rs.getTime(2));
                    Assert.assertEquals((Object)DateUtil.parseDate((String)pk3Value), (Object)rs.getDate(3));
                }
                this.assertPointLookupsAreGenerated(stmt, 27);
            }
            String timestampLiteralArr = "ARRAY[TO_TIMESTAMP('" + pk1Value + "'), TO_TIMESTAMP('" + pk2Value + "'), TO_TIMESTAMP('" + pk3Value + "')]";
            String timeLiteralArr = "ARRAY[TO_TIME('" + pk1Value + "'), TO_TIME('" + pk2Value + "'), TO_TIME('" + pk3Value + "')]";
            String dateLiteralArr = "ARRAY[TO_DATE('" + pk1Value + "'), TO_DATE('" + pk2Value + "'), TO_DATE('" + pk3Value + "')]";
            selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(" + timestampLiteralArr + ") AND pk2 = ANY(" + timeLiteralArr + ")AND pk3 = ANY(" + dateLiteralArr + ")";
            try (Statement stmt = conn.createStatement();){
                try (ResultSet rs = stmt.executeQuery(selectSql);){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)DateUtil.parseTimestamp((String)pk1Value), (Object)rs.getTimestamp(1));
                    Assert.assertEquals((Object)DateUtil.parseTime((String)pk2Value), (Object)rs.getTime(2));
                    Assert.assertEquals((Object)DateUtil.parseDate((String)pk3Value), (Object)rs.getDate(3));
                }
                this.assertPointLookupsAreGenerated(stmt, selectSql, 27);
            }
        }
        catch (Throwable throwable) {
            var8_13 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var8_13 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var8_13.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithTimestampToDateCoercion() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 TIMESTAMP NOT NULL, pk2 DATE NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2 DESC))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String pk1Value = "2025-07-18 10:00:00";
        String pk2Value = "2025-07-18 11:00:00";
        String pk3Value = "2025-07-18 12:00:00";
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setTimestamp(1, DateUtil.parseTimestamp((String)pk1Value));
            stmt.setDate(2, DateUtil.parseDate((String)pk2Value));
            stmt.setString(3, "a");
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var8_13 = null;
        try {
            String timestampLiteralArr = "ARRAY[TO_TIMESTAMP('" + pk1Value + "'), TO_TIMESTAMP('" + pk2Value + "'), TO_TIMESTAMP('" + pk3Value + "')]";
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(" + timestampLiteralArr + ") AND pk2 = ANY(" + timestampLiteralArr + ")";
            try (Statement stmt = conn.createStatement();){
                try (ResultSet rs = stmt.executeQuery(selectSql);){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)DateUtil.parseTimestamp((String)pk1Value), (Object)rs.getTimestamp(1));
                    Assert.assertEquals((Object)DateUtil.parseDate((String)pk2Value), (Object)rs.getDate(2));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreGenerated(stmt, selectSql, 9);
            }
        }
        catch (Throwable throwable) {
            var8_13 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var8_13 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var8_13.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonForBinaryColumn() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 BINARY(3) NOT NULL, pk2 VARBINARY_ENCODED(3) NOT NULL, pk3 VARBINARY(3) NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2, pk3))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String pk1Value = "a";
        String pk2Value = "b";
        String pk3Value = "c";
        String col1Value = "d";
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setBytes(1, pk1Value.getBytes());
            stmt.setBytes(2, pk2Value.getBytes());
            stmt.setBytes(3, pk3Value.getBytes());
            stmt.setString(4, col1Value);
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var9_15 = null;
        try {
            TestUtil.dumpTable(conn, TableName.valueOf((String)tableName));
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = ANY(?) AND pk3 = ANY(?)";
            byte[][] nativeByteArr = new byte[][]{pk1Value.getBytes(), pk2Value.getBytes(), pk3Value.getBytes()};
            Array binaryArr = conn.createArrayOf("BINARY", (Object[])nativeByteArr);
            Array varbinaryArr = conn.createArrayOf("VARBINARY", (Object[])nativeByteArr);
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, binaryArr);
                stmt.setArray(2, varbinaryArr);
                stmt.setArray(3, varbinaryArr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    this.assertBinaryValue(pk1Value.getBytes(), rs.getBytes(1));
                    this.assertBinaryValue(pk2Value.getBytes(), rs.getBytes(2));
                    this.assertBinaryValue(pk3Value.getBytes(), rs.getBytes(3));
                    Assert.assertEquals((Object)col1Value, (Object)rs.getString(4));
                }
                this.assertPointLookupsAreGenerated(stmt, 27);
            }
        }
        catch (Throwable throwable) {
            var9_15 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_15.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonForBinaryColumnWithCoercion() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 BINARY(3) NOT NULL, pk2 VARBINARY_ENCODED(3) NOT NULL, pk3 VARBINARY(3) NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC, pk2 DESC, pk3))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        String pk1Value = "a";
        String pk2Value = "b";
        String pk3Value = "c";
        String col1Value = "d";
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(upsertStmt);){
            stmt.setBytes(1, pk1Value.getBytes());
            stmt.setBytes(2, pk2Value.getBytes());
            stmt.setBytes(3, pk3Value.getBytes());
            stmt.setString(4, col1Value);
            stmt.executeUpdate();
            conn.commit();
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var9_15 = null;
        try {
            TestUtil.dumpTable(conn, TableName.valueOf((String)tableName));
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?) AND pk2 = ANY(?) AND pk3 = ANY(?)";
            byte[][] nativeByteArr = new byte[][]{pk1Value.getBytes(), pk2Value.getBytes(), pk3Value.getBytes()};
            Array binaryArr = conn.createArrayOf("BINARY", (Object[])nativeByteArr);
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, binaryArr);
                stmt.setArray(2, binaryArr);
                stmt.setArray(3, binaryArr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    this.assertBinaryValue(pk1Value.getBytes(), rs.getBytes(1));
                    this.assertBinaryValue(pk2Value.getBytes(), rs.getBytes(2));
                    this.assertBinaryValue(pk3Value.getBytes(), rs.getBytes(3));
                    Assert.assertEquals((Object)col1Value, (Object)rs.getString(4));
                }
                this.assertPointLookupsAreGenerated(stmt, 27);
            }
        }
        catch (Throwable throwable) {
            var9_15 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var9_15.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonForBsonColumn() throws Exception {
        Throwable throwable;
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 BSON NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1 DESC))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());){
            throwable = null;
            try (Statement stmt = conn.createStatement();){
                stmt.execute(ddl);
                conn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        RawBsonDocument pk1Value = WhereOptimizerForArrayAnyIT.getBsonDocument1();
        String upsertStmt = "UPSERT INTO " + tableName + " VALUES (?, ?)";
        throwable = null;
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt2 = conn.prepareStatement(upsertStmt);){
            stmt2.setObject(1, pk1Value);
            stmt2.setString(2, "a");
            stmt2.executeUpdate();
            conn.commit();
        }
        catch (Throwable stmt2) {
            throwable = stmt2;
            throw stmt2;
        }
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        throwable = null;
        try {
            TestUtil.dumpTable(conn, TableName.valueOf((String)tableName));
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?)";
            Array bsonArr = conn.createArrayOf("VARBINARY", (Object[])new byte[][]{ByteUtil.toBytes((ByteBuffer)pk1Value.getByteBuffer().asNIO()), ByteUtil.toBytes((ByteBuffer)WhereOptimizerForArrayAnyIT.getBsonDocument2().getByteBuffer().asNIO())});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, bsonArr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    byte[] pk1ValueBytes = rs.getBytes(1);
                    RawBsonDocument actualPk1Value = new RawBsonDocument(pk1ValueBytes, 0, pk1ValueBytes.length);
                    Assert.assertEquals((Object)pk1Value, (Object)actualPk1Value);
                    Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                }
                this.assertPointLookupsAreGenerated(stmt, 2);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonInGroupedAggregateQuery() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR NOT NULL, col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        this.insertData(tableName, 1, "a11", "b11");
        this.insertData(tableName, 1, "a12", "b12");
        this.insertData(tableName, 2, "a21", "b21");
        this.insertData(tableName, 2, "a22", "b22");
        this.insertData(tableName, 2, "a23", "b23");
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            String selectSql = "SELECT pk1, COUNT(*) FROM " + tableName + " WHERE pk1 = 2 AND pk2 = ANY(?) GROUP BY pk1";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"a11", "a21", "a23"});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)2L, (long)rs.getInt(1));
                    Assert.assertEquals((long)2L, (long)rs.getInt(2));
                }
                this.assertPointLookupsAreGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithIndexPKColumn() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String createTableDdl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        String createIndexDdl = "CREATE INDEX idx_pk1 ON " + tableName + " (col1)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(createTableDdl);
            conn.commit();
            stmt.execute(createIndexDdl);
            conn.commit();
        }
        this.insertData(tableName, 1, "a", "b");
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var5_5 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE col1 = ANY(?)";
            Array arr = conn.createArrayOf("VARCHAR", new String[]{"a", "b", "c"});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                this.assertSkipScanIsGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var5_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWithRowKeyPrefix() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        this.insertData(tableName, 1, "a", "b");
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE pk1 = ANY(?)";
            Array arr = conn.createArrayOf("INTEGER", new Integer[]{1, 2, 3});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                this.assertSkipScanIsGenerated(stmt, 3);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testArrayAnyComparisonWhenRowKeyColumnExpressionIsNotTopLevelExpression() throws Exception {
        String tableName = WhereOptimizerForArrayAnyIT.generateUniqueName();
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
        this.insertData(tableName, 1, "a", "b");
        conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
        var4_4 = null;
        try {
            String selectSql = "SELECT * FROM " + tableName + " WHERE CAST (pk1 as BIGINT) = ANY(?) AND pk2 = 'a'";
            Array arr = conn.createArrayOf("BIGINT", new Long[]{1L, 2L, 3L});
            try (PreparedStatement stmt = conn.prepareStatement(selectSql);){
                stmt.setArray(1, arr);
                try (ResultSet rs = stmt.executeQuery();){
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((long)1L, (long)rs.getInt(1));
                    Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                    Assert.assertEquals((Object)"b", (Object)rs.getString(3));
                }
                this.assertPointLookupsAreNotGenerated(stmt);
            }
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var4_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void assertBinaryValue(byte[] expected, byte[] actual) {
        int expectedLength = expected.length;
        for (int i = 0; i < expectedLength; ++i) {
            Assert.assertEquals((long)expected[i], (long)actual[i]);
        }
    }

    private void assertPointLookupsAreNotGenerated(PreparedStatement stmt) throws SQLException {
        ExplainPlan explain = stmt.unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
        ExplainPlanAttributes planAttributes = explain.getPlanStepsAsAttributes();
        Assert.assertEquals((Object)"FULL SCAN ", (Object)planAttributes.getExplainScanType());
    }

    private void assertPointLookupsAreGenerated(PreparedStatement stmt, int noOfPointLookups) throws SQLException {
        QueryPlan queryPlan = stmt.unwrap(PhoenixPreparedStatement.class).optimizeQuery();
        this.assertPointLookupsAreGenerated(queryPlan, noOfPointLookups);
    }

    private void assertPointLookupsAreGenerated(Statement stmt, String selectSql, int noOfPointLookups) throws SQLException {
        QueryPlan queryPlan = stmt.unwrap(PhoenixStatement.class).optimizeQuery(selectSql);
        this.assertPointLookupsAreGenerated(queryPlan, noOfPointLookups);
    }

    private void assertSkipScanIsGenerated(PreparedStatement stmt, int skipListSize) throws SQLException {
        QueryPlan queryPlan = stmt.unwrap(PhoenixPreparedStatement.class).optimizeQuery();
        ExplainPlan explain = queryPlan.getExplainPlan();
        ExplainPlanAttributes planAttributes = explain.getPlanStepsAsAttributes();
        String expectedScanType = "SKIP SCAN ON " + skipListSize + " KEY" + (skipListSize > 1 ? "S " : " ");
        Assert.assertEquals((Object)expectedScanType, (Object)planAttributes.getExplainScanType());
    }

    private void assertPointLookupsAreGenerated(QueryPlan queryPlan, int noOfPointLookups) throws SQLException {
        ExplainPlan explain = queryPlan.getExplainPlan();
        ExplainPlanAttributes planAttributes = explain.getPlanStepsAsAttributes();
        String expectedScanType = "POINT LOOKUP ON " + noOfPointLookups + " KEY" + (noOfPointLookups > 1 ? "S " : " ");
        Assert.assertEquals((Object)expectedScanType, (Object)planAttributes.getExplainScanType());
    }

    private void createTableASCPkColumns(String tableName) throws SQLException {
        String ddl = "CREATE TABLE " + tableName + " (pk1 INTEGER NOT NULL, pk2 VARCHAR(3), col1 VARCHAR, CONSTRAINT pk PRIMARY KEY (pk1, pk2))";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(ddl);
            conn.commit();
        }
    }

    private void insertData(String tableName, int pk1, String pk2, String col1) throws SQLException {
        String ddl = "UPSERT INTO " + tableName + " VALUES (?, ?, ?)";
        try (Connection conn = DriverManager.getConnection(WhereOptimizerForArrayAnyIT.getUrl());
             PreparedStatement stmt = conn.prepareStatement(ddl);){
            stmt.setInt(1, pk1);
            if (pk2 != null) {
                stmt.setString(2, pk2);
            } else {
                stmt.setNull(2, 12);
            }
            if (col1 != null) {
                stmt.setString(3, col1);
            } else {
                stmt.setNull(3, 12);
            }
            stmt.executeUpdate();
            conn.commit();
        }
    }

    private static RawBsonDocument getBsonDocument1() {
        String json = "{\n  \"attr_9\" : {\n    \"$set\" : [ {\n      \"$binary\" : {\n        \"base64\" : \"YWJjZA==\",\n        \"subType\" : \"00\"\n      }\n    }, {\n      \"$binary\" : {\n        \"base64\" : \"c3RyaW5nXzAyMDM=\",\n        \"subType\" : \"00\"\n      }\n    } ]\n  },\n  \"attr_8\" : {\n    \"$set\" : [ 3802.34, -40.667, -4839, 7593 ]\n  },\n  \"attr_7\" : {\n    \"$set\" : [ \"str_set002\", \"strset003\", \"strset001\" ]\n  },\n  \"attr_6\" : {\n    \"n_attr_0\" : \"str_val_0\",\n    \"n_attr_1\" : 1295.03,\n    \"n_attr_2\" : {\n      \"$binary\" : {\n        \"base64\" : \"MjA0OHU1bmJsd2plaVdGR1RIKDRiZjkzMA==\",\n        \"subType\" : \"00\"\n      }\n    },\n    \"n_attr_3\" : true,\n    \"n_attr_4\" : null\n  },\n  \"attr_5\" : [ 1234, \"str001\", {\n    \"$binary\" : {\n      \"base64\" : \"AAECAwQF\",\n      \"subType\" : \"00\"\n    }\n  } ],\n  \"attr_4\" : null,\n  \"attr_3\" : true,\n  \"attr_2\" : {\n    \"$binary\" : {\n      \"base64\" : \"cmFuZG9tZTkzaDVvbmVmaHUxbmtyXzE5MzBga2p2LSwhJCVeaWVpZmhiajAzNA==\",\n      \"subType\" : \"00\"\n    }\n  },\n  \"attr_1\" : 1295.03,\n  \"attr_0\" : \"str_val_0\"\n}";
        return RawBsonDocument.parse((String)json);
    }

    private static RawBsonDocument getBsonDocument2() {
        String json = "{\n  \"InPublication\" : false,\n  \"ISBN\" : \"111-1111111111\",\n  \"NestedList1\" : [ -485.34, \"1234abcd\", [ \"xyz0123\", {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01\n  } ] ],\n  \"NestedMap1\" : {\n    \"InPublication\" : false,\n    \"ISBN\" : \"111-1111111111\",\n    \"Title\" : \"Book 101 Title\",\n    \"Id\" : 101.01,\n    \"NList1\" : [ \"NListVal01\", -23.4 ]\n  },\n  \"Id2\" : 101.01,\n  \"attr_6\" : {\n    \"n_attr_0\" : \"str_val_0\",\n    \"n_attr_1\" : 1295.03,\n    \"n_attr_2\" : {\n      \"$binary\" : {\n        \"base64\" : \"MjA0OHU1bmJsd2plaVdGR1RIKDRiZjkzMA==\",\n        \"subType\" : \"00\"\n      }\n    },\n    \"n_attr_3\" : true,\n    \"n_attr_4\" : null\n  },\n  \"attr_5\" : [ 1234, \"str001\", {\n    \"$binary\" : {\n      \"base64\" : \"AAECAwQF\",\n      \"subType\" : \"00\"\n    }\n  } ],\n  \"IdS\" : \"101.01\",\n  \"Title\" : \"Book 101 Title\",\n  \"Id\" : 101.01,\n  \"attr_1\" : 1295.03,\n  \"attr_0\" : \"str_val_0\"\n}";
        return RawBsonDocument.parse((String)json);
    }
}

