/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.coprocessorclient.TableInfo;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.end2end.ViewConcurrencyAndFailureIT;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.base.Predicate;
import org.apache.phoenix.thirdparty.com.google.common.collect.Collections2;
import org.apache.phoenix.thirdparty.com.google.common.collect.Lists;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ViewUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class ViewMetadataIT
extends SplitSystemCatalogIT {
    private static RegionCoprocessorEnvironment TaskRegionEnvironment;
    static final String BASE_TABLE_SCHEMA = "S";
    static final String CHILD_VIEW_LEVEL_1_SCHEMA = "S1";
    private static final String CHILD_VIEW_LEVEL_2_SCHEMA = "S2";
    private static final String CHILD_VIEW_LEVEL_3_SCHEMA = "S3";
    static final String CREATE_BASE_TABLE_DDL = "CREATE TABLE %s.%s (A INTEGER NOT NULL PRIMARY KEY, B INTEGER, C INTEGER)";
    static final String CREATE_CHILD_VIEW_LEVEL_1_DDL = "CREATE VIEW %s.%s (NEW_COL1 INTEGER) AS SELECT * FROM %s.%s WHERE B > 10";
    static final String CREATE_CHILD_VIEW_LEVEL_2_DDL = "CREATE VIEW %s.%s (NEW_COL2 INTEGER) AS SELECT * FROM %s.%s WHERE NEW_COL1=5";
    static final String CREATE_CHILD_VIEW_LEVEL_3_DDL = "CREATE VIEW %s.%s (NEW_COL3 INTEGER) AS SELECT * FROM %s.%s WHERE NEW_COL2=10";

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 6;
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)1);
        clientProps.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        boolean splitSystemCatalog = driver == null;
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("phoenix.acls.enabled", "true");
        serverProps.put("hbase.coprocessor.phoenix.classes", ViewConcurrencyAndFailureIT.TestMetaDataRegionObserver.class.getName());
        serverProps.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        serverProps.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        serverProps.put("phoenix.schema.dropMetaData", Boolean.TRUE.toString());
        ViewMetadataIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        if (splitSystemCatalog) {
            ViewMetadataIT.getUtility().getHBaseCluster().getMaster().balanceSwitch(false);
            ViewMetadataIT.splitSystemCatalog();
        }
        TaskRegionEnvironment = (RegionCoprocessorEnvironment)((HRegion)ViewMetadataIT.getUtility().getRSForFirstRegionInTable(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).getRegions(PhoenixDatabaseMetaData.SYSTEM_TASK_HBASE_TABLE_NAME).get(0)).getCoprocessorHost().findCoprocessorEnvironment(TaskRegionObserver.class.getName());
    }

    @Test
    public void testCreateViewWithUpdateCacheFrquency() throws Exception {
        Properties props = new Properties();
        Connection conn1 = DriverManager.getConnection(ViewMetadataIT.getUrl(), props);
        conn1.setAutoCommit(true);
        String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        conn1.createStatement().execute("CREATE TABLE " + tableName + " (k VARCHAR PRIMARY KEY, v1 VARCHAR, v2 VARCHAR) UPDATE_CACHE_FREQUENCY=1000000");
        conn1.createStatement().execute("upsert into " + tableName + " values ('row1', 'value1', 'key1')");
        conn1.createStatement().execute("CREATE VIEW " + viewName + " (v43 VARCHAR) AS SELECT * FROM " + tableName + " WHERE v1 = 'value1'");
        ResultSet rs = conn1.createStatement().executeQuery("SELECT * FROM " + tableName + " WHERE v1 = 'value1'");
        Assert.assertTrue((boolean)rs.next());
    }

    @Test
    public void testCreateViewFromHBaseTable() throws Exception {
        String tableNameStr = ViewMetadataIT.generateUniqueName();
        String familyNameStr = ViewMetadataIT.generateUniqueName();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)tableNameStr));
        builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)familyNameStr));
        HBaseTestingUtility testUtil = ViewMetadataIT.getUtility();
        Admin admin = testUtil.getAdmin();
        admin.createTable(builder.build());
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        try {
            conn.createStatement().executeUpdate("CREATE VIEW \"" + tableNameStr + "\" (ROWKEY VARCHAR, \"" + familyNameStr + "\".a VARCHAR)");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.PRIMARY_KEY_MISSING.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().executeUpdate("CREATE VIEW \"" + tableNameStr + "\" (ROWKEY VARCHAR PRIMARY KEY, \"" + familyNameStr + "\".a VARCHAR)");
        conn.createStatement().executeUpdate("DROP VIEW \"" + tableNameStr + "\"");
        try {
            conn.createStatement().executeUpdate("CREATE VIEW \"" + tableNameStr + "\" (ROWKEY VARCHAR, \"" + familyNameStr + "\".a VARCHAR) AS SELECT * FROM \"" + tableNameStr + "\" WHERE ROWKEY = '1'");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.PRIMARY_KEY_MISSING.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().executeUpdate("CREATE VIEW \"" + tableNameStr + "\" (ROWKEY VARCHAR PRIMARY KEY, \"" + familyNameStr + "\".a VARCHAR) AS SELECT * FROM \"" + tableNameStr + "\" WHERE ROWKEY = '1'");
        conn.createStatement().executeUpdate("DROP VIEW \"" + tableNameStr + "\"");
    }

    @Test
    public void testCreateViewMappedToExistingHbaseTableWithNSMappingEnabled() throws Exception {
        String NS = "NS_" + ViewMetadataIT.generateUniqueName();
        String TBL = "TBL_" + ViewMetadataIT.generateUniqueName();
        String CF = "CF";
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.TRUE.toString());
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl(), props);
             Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
            conn.createStatement().execute("CREATE SCHEMA " + NS);
            TableName tableName = TableName.valueOf((String)NS, (String)TBL);
            TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"CF"));
            admin.createTable(builder.build());
            String view1 = NS + "." + TBL;
            conn.createStatement().execute("CREATE VIEW " + view1 + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + view1)).contains(NS + ":" + TBL));
            conn.createStatement().execute("DROP VIEW " + view1);
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            tableName = TableName.valueOf((String)(NS + "." + TBL));
            builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"CF"));
            admin.createTable(builder.build());
            String view2 = "\"" + NS + "." + TBL + "\"";
            conn.createStatement().execute("CREATE VIEW " + view2 + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + view2)).contains(NS + "." + TBL));
            conn.createStatement().execute("DROP VIEW " + view2);
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            tableName = TableName.valueOf((String)NS, (String)(NS + "." + TBL));
            builder = TableDescriptorBuilder.newBuilder((TableName)tableName);
            builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"CF"));
            admin.createTable(builder.build());
            String view3 = NS + ".\"" + NS + "." + TBL + "\"";
            conn.createStatement().execute("CREATE VIEW " + view3 + " (PK VARCHAR PRIMARY KEY, " + "CF" + ".COL VARCHAR)");
            Assert.assertTrue((boolean)QueryUtil.getExplainPlan((ResultSet)conn.createStatement().executeQuery("explain select * from " + view3)).contains(NS + ":" + NS + "." + TBL));
            conn.createStatement().execute("DROP VIEW " + view3);
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
            conn.createStatement().execute("DROP SCHEMA " + NS);
        }
    }

    @Test
    public void testRecreateDroppedTableWithChildViews() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        String indexName = ViewMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " on " + fullViewName1 + "(v2)";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName2 + "(v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 10";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("DROP TABLE " + fullTableName + " CASCADE");
        this.runDropChildViewsTask();
        this.validateViewDoesNotExist((Connection)conn, fullViewName1);
        this.validateViewDoesNotExist((Connection)conn, fullViewName2);
        conn.createStatement().execute(tableDdl);
        try {
            conn.getTableNoCache(fullViewName1);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            conn.getTableNoCache(fullViewName2);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testAlterTableIsResilientToOrphanLinks() throws SQLException {
        String parent1TableName = ViewMetadataIT.generateUniqueName();
        String parent2TableName = ViewMetadataIT.generateUniqueName();
        String viewName = "V_" + ViewMetadataIT.generateUniqueName();
        String alterTableDDL = "ALTER TABLE %s ADD NEW_COL1 VARCHAR";
        ViewMetadataIT.createOrphanLink(SCHEMA1, parent1TableName, parent2TableName, SCHEMA2, viewName);
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("ALTER TABLE %s ADD NEW_COL1 VARCHAR", SchemaUtil.getTableName((String)SCHEMA1, (String)parent2TableName)));
            try {
                stmt.execute(String.format("ALTER TABLE %s ADD NEW_COL1 VARCHAR", SchemaUtil.getTableName((String)SCHEMA1, (String)parent1TableName)));
                Assert.fail((String)"Adding column should be disallowed since there is a conflicting column type on the child view");
            }
            catch (SQLException sqlEx) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)sqlEx.getErrorCode());
            }
        }
    }

    @Test
    public void testDropTableIsResilientToOrphanLinks() throws SQLException {
        String parent1TableName = ViewMetadataIT.generateUniqueName();
        String parent2TableName = ViewMetadataIT.generateUniqueName();
        String viewName = "V_" + ViewMetadataIT.generateUniqueName();
        String dropTableNoCascadeDDL = "DROP TABLE %s ";
        ViewMetadataIT.createOrphanLink(SCHEMA1, parent1TableName, parent2TableName, SCHEMA2, viewName);
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format("DROP TABLE %s ", SchemaUtil.getTableName((String)SCHEMA1, (String)parent2TableName)));
            try {
                stmt.execute(String.format("DROP TABLE %s ", SchemaUtil.getTableName((String)SCHEMA1, (String)parent1TableName)));
                Assert.fail((String)"Drop table without cascade should fail since there is a child view");
            }
            catch (SQLException sqlEx) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)sqlEx.getErrorCode());
            }
        }
    }

    @Test
    public void testViewHierarchyWithOrphanLinks() throws Exception {
        ArrayList<TableInfo> expectedLegitChildViewsListForParent1 = new ArrayList<TableInfo>();
        ArrayList<TableInfo> expectedLegitChildViewsListForParent2 = new ArrayList<TableInfo>();
        String tenantId = "t001";
        String parent1TableName = "P1_" + ViewMetadataIT.generateUniqueName();
        String parent2TableName = "P2_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName1 = "L1_V_1_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName2 = "L1_V_2_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName3 = "L1_V_3_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName4 = "L1_V_4_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName5 = "L1_V_5_" + ViewMetadataIT.generateUniqueName();
        String level1ViewName6 = "L1_V_6_" + ViewMetadataIT.generateUniqueName();
        String level2ViewName1 = "L2_V_1_" + ViewMetadataIT.generateUniqueName();
        String level2ViewName2 = "L2_V_2_" + ViewMetadataIT.generateUniqueName();
        String level3ViewName1 = "L3_V_1_" + ViewMetadataIT.generateUniqueName();
        ViewMetadataIT.createOrphanLink(BASE_TABLE_SCHEMA, parent1TableName, parent2TableName, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName1);
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());){
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName3, BASE_TABLE_SCHEMA, parent1TableName));
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName4, BASE_TABLE_SCHEMA, parent1TableName));
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName2, BASE_TABLE_SCHEMA, parent2TableName));
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName5, BASE_TABLE_SCHEMA, parent2TableName));
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName6, BASE_TABLE_SCHEMA, parent2TableName));
        }
        Properties props = new Properties();
        props.put("TenantId", "t001");
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl(), props);){
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_2_DDL, CHILD_VIEW_LEVEL_2_SCHEMA, level2ViewName1, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName1));
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_2_DDL, CHILD_VIEW_LEVEL_2_SCHEMA, level2ViewName2, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName2));
            try {
                conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_2_DDL, CHILD_VIEW_LEVEL_2_SCHEMA, level2ViewName2, CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName1));
                Assert.fail((String)"Creating the same view again should have failed");
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
            conn.createStatement().execute(String.format(CREATE_CHILD_VIEW_LEVEL_3_DDL, CHILD_VIEW_LEVEL_3_SCHEMA, level3ViewName1, CHILD_VIEW_LEVEL_2_SCHEMA, level2ViewName2));
        }
        expectedLegitChildViewsListForParent1.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName1.getBytes()));
        expectedLegitChildViewsListForParent1.add(new TableInfo("t001".getBytes(), CHILD_VIEW_LEVEL_2_SCHEMA.getBytes(), level2ViewName1.getBytes()));
        expectedLegitChildViewsListForParent1.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName3.getBytes()));
        expectedLegitChildViewsListForParent1.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName4.getBytes()));
        expectedLegitChildViewsListForParent2.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName2.getBytes()));
        expectedLegitChildViewsListForParent2.add(new TableInfo("t001".getBytes(), CHILD_VIEW_LEVEL_2_SCHEMA.getBytes(), level2ViewName2.getBytes()));
        expectedLegitChildViewsListForParent2.add(new TableInfo("t001".getBytes(), CHILD_VIEW_LEVEL_3_SCHEMA.getBytes(), level3ViewName1.getBytes()));
        expectedLegitChildViewsListForParent2.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName5.getBytes()));
        expectedLegitChildViewsListForParent2.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName6.getBytes()));
        conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        var17_19 = null;
        try {
            ConnectionQueryServices cqs = conn.unwrap(PhoenixConnection.class).getQueryServices();
            try (Table childLinkTable = cqs.getTable(SchemaUtil.getPhysicalName((byte[])PhoenixDatabaseMetaData.SYSTEM_LINK_HBASE_TABLE_NAME.toBytes(), (ReadOnlyProps)cqs.getProps()).getName());){
                Pair allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])BASE_TABLE_SCHEMA.getBytes(), (byte[])parent1TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                List legitChildViews = (List)allDescendants.getFirst();
                List orphanViews = (List)allDescendants.getSecond();
                Assert.assertTrue((boolean)orphanViews.isEmpty());
                this.assertLegitChildViews(expectedLegitChildViewsListForParent1, legitChildViews);
                allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])BASE_TABLE_SCHEMA.getBytes(), (byte[])parent2TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                legitChildViews = (List)allDescendants.getFirst();
                orphanViews = (List)allDescendants.getSecond();
                Assert.assertTrue((boolean)orphanViews.isEmpty());
                this.assertLegitChildViews(expectedLegitChildViewsListForParent2, legitChildViews);
                conn.createStatement().execute(String.format("DROP VIEW %s.%s CASCADE", CHILD_VIEW_LEVEL_1_SCHEMA, level1ViewName1));
                this.runDropChildViewsTask();
                this.runDropChildViewsTask();
                expectedLegitChildViewsListForParent1.clear();
                expectedLegitChildViewsListForParent1.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName3.getBytes()));
                expectedLegitChildViewsListForParent1.add(new TableInfo(null, CHILD_VIEW_LEVEL_1_SCHEMA.getBytes(), level1ViewName4.getBytes()));
                allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])BASE_TABLE_SCHEMA.getBytes(), (byte[])parent1TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                legitChildViews = (List)allDescendants.getFirst();
                orphanViews = (List)allDescendants.getSecond();
                this.assertLegitChildViews(expectedLegitChildViewsListForParent1, legitChildViews);
                Assert.assertTrue((boolean)orphanViews.isEmpty());
                allDescendants = ViewUtil.findAllDescendantViews((Table)childLinkTable, (Configuration)cqs.getConfiguration(), (byte[])ByteUtil.EMPTY_BYTE_ARRAY, (byte[])BASE_TABLE_SCHEMA.getBytes(), (byte[])parent2TableName.getBytes(), (long)Long.MAX_VALUE, (boolean)false, (boolean)true);
                legitChildViews = (List)allDescendants.getFirst();
                orphanViews = (List)allDescendants.getSecond();
                Assert.assertEquals((long)1L, (long)orphanViews.size());
                Assert.assertEquals((long)0L, (long)((TableInfo)orphanViews.get(0)).getTenantId().length);
                Assert.assertEquals((Object)CHILD_VIEW_LEVEL_1_SCHEMA, (Object)Bytes.toString((byte[])((TableInfo)orphanViews.get(0)).getSchemaName()));
                Assert.assertEquals((Object)level1ViewName1, (Object)Bytes.toString((byte[])((TableInfo)orphanViews.get(0)).getTableName()));
                this.assertLegitChildViews(expectedLegitChildViewsListForParent2, legitChildViews);
            }
        }
        catch (Throwable throwable) {
            var17_19 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var17_19 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var17_19.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void assertLegitChildViews(List<TableInfo> expectedList, List<PTable> actualList) {
        Assert.assertEquals((long)expectedList.size(), (long)actualList.size());
        for (int i = 0; i < expectedList.size(); ++i) {
            TableInfo expectedChild = expectedList.get(i);
            byte[] expectedTenantId = expectedChild.getTenantId();
            PName actualTenantId = actualList.get(i).getTenantId();
            Assert.assertTrue((expectedTenantId == null && actualTenantId == null || actualTenantId != null && expectedTenantId != null && Arrays.equals(actualTenantId.getBytes(), expectedTenantId) ? 1 : 0) != 0);
            Assert.assertEquals((Object)Bytes.toString((byte[])expectedChild.getSchemaName()), (Object)actualList.get(i).getSchemaName().getString());
            Assert.assertEquals((Object)Bytes.toString((byte[])expectedChild.getTableName()), (Object)actualList.get(i).getTableName().getString());
        }
    }

    static void createOrphanLink(String parentSchema, String parent1, String parent2, String viewSchema, String viewName) throws SQLException {
        String querySysChildLink = "SELECT * FROM SYSTEM.CHILD_LINK WHERE TABLE_SCHEM='%s' AND TABLE_NAME='%s' AND COLUMN_FAMILY='%s' AND LINK_TYPE = " + PTable.LinkType.CHILD_TABLE.getSerializedValue();
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(String.format(CREATE_BASE_TABLE_DDL, parentSchema, parent1));
            stmt.execute(String.format(CREATE_BASE_TABLE_DDL, parentSchema, parent2));
            stmt.execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, viewSchema, viewName, parentSchema, parent1));
            try {
                stmt.execute(String.format(CREATE_CHILD_VIEW_LEVEL_1_DDL, viewSchema, viewName, parentSchema, parent2));
                Assert.fail((String)"Creating the same view again should have failed");
            }
            catch (TableAlreadyExistsException tableAlreadyExistsException) {
                // empty catch block
            }
            ResultSet rs = stmt.executeQuery(String.format(querySysChildLink, parentSchema, parent2, SchemaUtil.getTableName((String)viewSchema, (String)viewName)));
            Assert.assertTrue((boolean)rs.next());
        }
    }

    void runDropChildViewsTask() {
        TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(TaskRegionEnvironment, 1800000L);
        task.run();
    }

    @Test
    public void testRecreateIndexWhoseAncestorWasDropped() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName1 = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullTableName2 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String tableDdl = "CREATE TABLE " + fullTableName1 + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        tableDdl = "CREATE TABLE " + fullTableName2 + "  (k INTEGER NOT NULL PRIMARY KEY, v3 DATE)";
        conn.createStatement().execute(tableDdl);
        String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName1 + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        String indexName = ViewMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName + " on " + fullViewName1 + "(v2)";
        conn.createStatement().execute(ddl);
        try {
            ddl = "CREATE INDEX " + indexName + " on " + fullTableName2 + "(v1)";
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        conn.createStatement().execute("DROP TABLE " + fullTableName1 + " CASCADE");
        this.runDropChildViewsTask();
        ddl = "CREATE INDEX " + indexName + " on " + fullTableName2 + "(v3)";
        conn.createStatement().execute(ddl);
        String fullIndexName = SchemaUtil.getTableName((String)SCHEMA2, (String)indexName);
        PTable index = conn.getTableNoCache(fullIndexName);
        this.validateCols(index);
    }

    @Test
    public void testRecreateViewWhoseParentWasDropped() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName1 = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullTableName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String tableDdl = "CREATE TABLE " + fullTableName1 + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        tableDdl = "CREATE TABLE " + fullTableName2 + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName1 + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("DROP TABLE " + fullTableName1 + " CASCADE");
        this.runDropChildViewsTask();
        ddl = "CREATE VIEW " + fullViewName1 + " (v3 VARCHAR) AS SELECT * FROM " + fullTableName2 + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        PTable view = conn.getTableNoCache(fullViewName1);
        this.validateCols(view);
    }

    @Test
    public void testRepeatedCreateAndDropCascadeTableWorks() throws Exception {
        String tableName = ViewMetadataIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());){
            this.createTableViewAndDropCascade(conn, fullTableName, fullViewName, false);
            this.validateViewDoesNotExist(conn, fullViewName);
            this.validateSystemTaskContainsCompletedDropChildViewsTasks(conn, SCHEMA1, tableName, 1);
            this.createTableViewAndDropCascade(conn, fullTableName, fullViewName, false);
            this.validateViewDoesNotExist(conn, fullViewName);
            this.validateSystemTaskContainsCompletedDropChildViewsTasks(conn, SCHEMA1, tableName, 2);
        }
    }

    @Test
    public void testDropTableCascadeWithChildViewWithIndex() throws SQLException {
        String tableName = ViewMetadataIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)tableName);
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());){
            this.createTableViewAndDropCascade(conn, fullTableName, fullViewName, true);
            this.validateViewDoesNotExist(conn, fullViewName);
            this.validateSystemTaskContainsCompletedDropChildViewsTasks(conn, SCHEMA1, tableName, 1);
        }
    }

    private void createTableViewAndDropCascade(Connection conn, String fullTableName, String fullViewName, boolean createViewIndex) throws SQLException {
        String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        String ddl = "CREATE VIEW " + fullViewName + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        if (createViewIndex) {
            conn.createStatement().execute("CREATE INDEX INDEX_" + ViewMetadataIT.generateUniqueName() + " ON " + fullViewName + "(v2)");
        }
        conn.createStatement().execute("DROP TABLE " + fullTableName + " CASCADE");
        this.runDropChildViewsTask();
    }

    private void validateSystemTaskContainsCompletedDropChildViewsTasks(Connection conn, String schemaName, String tableName, int numTasks) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM " + PhoenixDatabaseMetaData.SYSTEM_TASK_NAME + " WHERE " + "TASK_TYPE" + "=" + PTable.TaskType.DROP_CHILD_VIEWS.getSerializedValue() + " AND " + "TENANT_ID" + " IS NULL AND " + "TABLE_SCHEM" + "='" + schemaName + "' AND " + "TABLE_NAME" + "='" + tableName + "'");
        Assert.assertTrue((boolean)rs.next());
        for (int i = 0; i < numTasks; ++i) {
            Timestamp maxTs = new Timestamp(Long.MAX_VALUE);
            Assert.assertNotEquals((String)"Should have got a valid timestamp", (Object)maxTs, (Object)rs.getTimestamp(2));
            Assert.assertEquals((String)"Task should be completed", (Object)PTable.TaskStatus.COMPLETED.toString(), (Object)rs.getString(6));
            Assert.assertNotNull((String)"Task end time should not be null", (Object)rs.getTimestamp(7));
            String taskData = rs.getString(9);
            Assert.assertTrue((String)"Task data should contain final status", (taskData != null && taskData.contains("TaskDetails") && taskData.contains(PTable.TaskStatus.COMPLETED.toString()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testViewAndTableInDifferentSchemasWithNamespaceMappingEnabled() throws Exception {
        this.testViewAndTableInDifferentSchemas(true);
    }

    @Test
    public void testViewAndTableInDifferentSchemas() throws Exception {
        this.testViewAndTableInDifferentSchemas(false);
    }

    private void testViewAndTableInDifferentSchemas(boolean isNamespaceMapped) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(isNamespaceMapped));
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl(), props);
        String tableName = "T_" + ViewMetadataIT.generateUniqueName();
        String schemaName1 = SCHEMA1;
        String fullTableName1 = SchemaUtil.getTableName((String)schemaName1, (String)tableName);
        String viewName1 = "V_" + ViewMetadataIT.generateUniqueName();
        String viewSchemaName = SCHEMA2;
        String fullViewName1 = SchemaUtil.getTableName((String)viewSchemaName, (String)viewName1);
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)viewName1);
        if (isNamespaceMapped) {
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + schemaName1);
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + viewSchemaName);
            conn.createStatement().execute("CREATE SCHEMA IF NOT EXISTS " + SCHEMA3);
        }
        String ddl = "CREATE TABLE " + fullTableName1 + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        conn.createStatement().execute(ddl);
        Assert.assertTrue((boolean)admin.tableExists(SchemaUtil.getPhysicalTableName((String)SchemaUtil.normalizeIdentifier((String)fullTableName1), (ReadOnlyProps)conn.unwrap(PhoenixConnection.class).getQueryServices().getProps())));
        ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName1 + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName2 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName1 + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        conn.createStatement().executeQuery("SELECT * FROM " + fullViewName1);
        conn.createStatement().executeQuery("SELECT * FROM " + fullViewName2);
        ddl = "DROP VIEW " + viewName1;
        try {
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        ddl = "DROP VIEW " + fullViewName1;
        conn.createStatement().execute(ddl);
        ddl = "DROP VIEW " + SchemaUtil.getTableName((String)viewSchemaName, (String)ViewMetadataIT.generateUniqueName());
        try {
            conn.createStatement().execute(ddl);
            Assert.fail();
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        ddl = "DROP TABLE " + fullTableName1;
        ddl = "DROP VIEW " + fullViewName2;
        conn.createStatement().execute(ddl);
        ddl = "DROP TABLE " + fullTableName1;
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testViewAndTableAndDropCascade() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(tableDdl);
        String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        String indexName = ViewMetadataIT.generateUniqueName();
        ddl = "CREATE LOCAL INDEX " + indexName + " on " + fullViewName1 + "(v2)";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName2 + "(v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 10";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().execute("DROP TABLE " + fullTableName);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().execute("DROP TABLE " + fullTableName + " CASCADE");
        this.runDropChildViewsTask();
        this.validateViewDoesNotExist(conn, fullViewName1);
        this.validateViewDoesNotExist(conn, fullViewName2);
    }

    @Test
    public void testUpdatingPropertyOnBaseTable() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewMetadataIT.getUrl());){
            conn.createStatement().execute("create table " + fullTableName + "(tenantId CHAR(15) NOT NULL, pk1 integer NOT NULL, v varchar CONSTRAINT PK PRIMARY KEY (tenantId, pk1)) MULTI_TENANT=true");
            conn.createStatement().execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName);
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " set IMMUTABLE_ROWS = true");
            PTable table = conn.getTableNoCache(fullTableName);
            PTable view = conn.getTableNoCache(fullViewName);
            Assert.assertTrue((String)"IMMUTABLE_ROWS property set incorrectly", (boolean)table.isImmutableRows());
            Assert.assertTrue((String)"IMMUTABLE_ROWS property set incorrectly", (boolean)view.isImmutableRows());
        }
    }

    @Test
    public void testViewAddsPKColumnWhoseParentsLastPKIsVarLength() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 VARCHAR NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + "  AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        ddl = "ALTER VIEW " + fullViewName + " ADD k3 VARCHAR PRIMARY KEY, k4 VARCHAR PRIMARY KEY, v2 INTEGER";
        try {
            conn.createStatement().execute(ddl);
            Assert.fail((String)"View cannot extend PK if parent's last PK is variable length. See https://issues.apache.org/jira/browse/PHOENIX-978.");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_MODIFY_VIEW_PK.getErrorCode(), (long)e.getErrorCode());
        }
        String fullViewName2 = "V_" + ViewMetadataIT.generateUniqueName();
        ddl = "CREATE VIEW " + fullViewName2 + " (k3 VARCHAR PRIMARY KEY)  AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        try {
            conn.createStatement().execute(ddl);
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_MODIFY_VIEW_PK.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test(expected=ColumnAlreadyExistsException.class)
    public void testViewAddsClashingPKColumn() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + "  AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        ddl = "ALTER VIEW " + fullViewName + " ADD k3 VARCHAR PRIMARY KEY, k2 VARCHAR PRIMARY KEY, v2 INTEGER";
        conn.createStatement().execute(ddl);
    }

    @Test
    public void testQueryWithSeparateConnectionForViewOnTableThatHasIndex() throws SQLException {
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Connection conn2 = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Statement s = conn.createStatement();
             Statement s2 = conn2.createStatement();){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
            String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
            String indexName = ViewMetadataIT.generateUniqueName();
            this.helpTestQueryForViewOnTableThatHasIndex(s, s2, tableName, viewName, indexName);
        }
    }

    @Test
    public void testQueryForViewOnTableThatHasIndex() throws SQLException {
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
             Statement s = conn.createStatement();){
            String tableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
            String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
            String indexName = ViewMetadataIT.generateUniqueName();
            this.helpTestQueryForViewOnTableThatHasIndex(s, s, tableName, viewName, indexName);
        }
    }

    private void helpTestQueryForViewOnTableThatHasIndex(Statement s1, Statement s2, String tableName, String viewName, String indexName) throws SQLException {
        s1.execute("create table " + tableName + " (col1 varchar primary key, col2 varchar)");
        s1.execute("create view " + viewName + " (col3 varchar) as select * from " + tableName);
        s1.executeQuery("select * from " + viewName);
        s1.execute("create index " + indexName + " ON " + tableName + " (col2)");
        try (ResultSet rs = s2.executeQuery("explain select /*+ INDEX(" + viewName + " " + indexName + ") */ * from " + viewName + " where col2 = 'aaa'");){
            String explainPlan = QueryUtil.getExplainPlan((ResultSet)rs);
            Assert.assertTrue((boolean)explainPlan.contains(indexName));
        }
    }

    @Test
    public void testViewAndTableAndDropCascadeWithIndexes() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)";
        conn.createStatement().execute(ddl);
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String indexName1 = "I_" + ViewMetadataIT.generateUniqueName();
        String indexName2 = "I_" + ViewMetadataIT.generateUniqueName();
        String indexName3 = "I_" + ViewMetadataIT.generateUniqueName();
        ddl = "CREATE INDEX " + indexName1 + " ON " + fullTableName + " (v1)";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
        conn.createStatement().execute(ddl);
        ddl = "CREATE INDEX " + indexName2 + " ON " + fullViewName1 + " (v2)";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName2 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 10";
        conn.createStatement().execute(ddl);
        ddl = "CREATE INDEX " + indexName3 + " ON " + fullViewName2 + " (v2)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("DROP TABLE " + fullTableName + " CASCADE");
        this.runDropChildViewsTask();
        this.validateViewDoesNotExist(conn, fullViewName1);
        this.validateViewDoesNotExist(conn, fullViewName2);
    }

    @Test
    public void testViewAddsNotNullPKColumn() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + "  AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        try {
            ddl = "ALTER VIEW " + fullViewName + " ADD k3 VARCHAR NOT NULL PRIMARY KEY";
            conn.createStatement().execute(ddl);
            Assert.fail((String)"can only add nullable PKs via ALTER VIEW/TABLE");
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.NOT_NULLABLE_COLUMN_IN_ROW_KEY.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testDisallowDropOfColumnOnParentTable() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String viewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + viewName + "(v2 VARCHAR, v3 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().execute("ALTER TABLE " + fullTableName + " DROP COLUMN v1");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testDisallowDropOfReferencedColumn() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName1 + "(v2 VARCHAR, v3 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName2 + " AS SELECT * FROM " + fullViewName1 + " WHERE v2 != 'foo'";
        conn.createStatement().execute(ddl);
        try {
            conn.createStatement().execute("ALTER VIEW " + fullViewName1 + " DROP COLUMN v1");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_VIEW_REFERENCED_COL.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            conn.createStatement().execute("ALTER VIEW " + fullViewName2 + " DROP COLUMN v1");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_VIEW_REFERENCED_COL.getErrorCode(), (long)e.getErrorCode());
        }
        try {
            conn.createStatement().execute("ALTER VIEW " + fullViewName2 + " DROP COLUMN v2");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_VIEW_REFERENCED_COL.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().execute("ALTER VIEW " + fullViewName2 + " DROP COLUMN v3");
    }

    @Test
    public void testViewAddsPKColumn() throws Exception {
        Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String viewName = ViewMetadataIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)viewName);
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + "  AS SELECT * FROM " + fullTableName + " WHERE v1 = 1.0";
        conn.createStatement().execute(ddl);
        ddl = "ALTER VIEW " + fullViewName + " ADD k3 VARCHAR PRIMARY KEY, k4 VARCHAR PRIMARY KEY, v2 INTEGER";
        conn.createStatement().execute(ddl);
        ResultSet rs = conn.getMetaData().getPrimaryKeys(null, SCHEMA2, viewName);
        this.assertPKs(rs, new String[]{"K1", "K2", "K3", "K4"});
    }

    @Test
    public void testCreateViewDefinesPKConstraint() throws Exception {
        PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewMetadataIT.getUrl());
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String ddl = "CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 INTEGER NOT NULL, v1 DECIMAL, CONSTRAINT pk PRIMARY KEY (k1, k2))";
        conn.createStatement().execute(ddl);
        ddl = "CREATE VIEW " + fullViewName + "(v2 VARCHAR, k3 VARCHAR, k4 INTEGER NOT NULL, CONSTRAINT PKVEW PRIMARY KEY (k3, k4)) AS SELECT * FROM " + fullTableName + " WHERE K1 = 1";
        conn.createStatement().execute(ddl);
        conn.getTableNoCache(fullViewName);
        ResultSet rs = conn.getMetaData().getPrimaryKeys(null, SchemaUtil.getSchemaNameFromFullName((String)fullViewName), SchemaUtil.getTableNameFromFullName((String)fullViewName));
        this.assertPKs(rs, new String[]{"K1", "K2", "K3", "K4"});
    }

    @Test
    public void testAncestorLastDDLMapPopulatedInViewAndIndexHierarchy() throws SQLException {
        String baseTable = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewMetadataIT.generateUniqueName());
        String view1 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String view2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewMetadataIT.generateUniqueName());
        String view3 = SchemaUtil.getTableName((String)SCHEMA4, (String)ViewMetadataIT.generateUniqueName());
        String view4 = SchemaUtil.getTableName((String)SCHEMA2, (String)ViewMetadataIT.generateUniqueName());
        String index1 = ViewMetadataIT.generateUniqueName();
        String index2 = ViewMetadataIT.generateUniqueName();
        String index3 = ViewMetadataIT.generateUniqueName();
        String tenant1 = TENANT1;
        String tenant2 = TENANT2;
        try (Connection conn = DriverManager.getConnection(ViewMetadataIT.getUrl());){
            String baseTableDDL = "CREATE TABLE " + baseTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            conn.createStatement().execute(baseTableDDL);
            String index1DDL = "CREATE INDEX " + index1 + " ON " + baseTable + "(V1)";
            conn.createStatement().execute(index1DDL);
            String index3DDL = "CREATE LOCAL INDEX " + index3 + " ON " + baseTable + "(V1)";
            conn.createStatement().execute(index3DDL);
            try (Connection tenant1Conn = this.getTenantConnection(tenant1);){
                String view1DDL = "CREATE VIEW " + view1 + " AS SELECT * FROM " + baseTable;
                tenant1Conn.createStatement().execute(view1DDL);
                String view2DDL = "CREATE VIEW " + view2 + " AS SELECT * FROM " + view1;
                tenant1Conn.createStatement().execute(view2DDL);
                String index2DDL = "CREATE INDEX " + index2 + " ON " + view2 + "(V1)";
                tenant1Conn.createStatement().execute(index2DDL);
            }
            var17_19 = null;
            try (Connection tenant2Conn = this.getTenantConnection(tenant2);){
                String view3DDL = "CREATE VIEW " + view3 + " AS SELECT * FROM " + baseTable;
                tenant2Conn.createStatement().execute(view3DDL);
            }
            catch (Throwable view3DDL) {
                var17_19 = view3DDL;
                throw view3DDL;
            }
            String view4DDL = "CREATE VIEW " + view4 + " AS SELECT * FROM " + baseTable;
            conn.createStatement().execute(view4DDL);
            PTable basePTable = PhoenixRuntime.getTable((Connection)conn, (String)baseTable);
            Long baseTableLastDDLTimestamp = basePTable.getLastDDLTimestamp();
            PTableKey baseTableKey = new PTableKey(null, baseTable);
            Map map = basePTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)0L, (long)map.size());
            map = PhoenixRuntime.getTable((Connection)conn, (String)view4).getAncestorLastDDLTimestampMap();
            Assert.assertEquals((long)1L, (long)map.size());
            Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            PTable index1PTable = PhoenixRuntime.getTable((Connection)conn, (String)SchemaUtil.getTableName((String)SCHEMA1, (String)index1));
            map = index1PTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            PTable index3PTable = PhoenixRuntime.getTable((Connection)conn, (String)SchemaUtil.getTableName((String)SCHEMA1, (String)index3));
            map = index3PTable.getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            Assert.assertEquals((long)2L, (long)basePTable.getIndexes().size());
            map = ((PTable)basePTable.getIndexes().get(0)).getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            map = ((PTable)basePTable.getIndexes().get(1)).getAncestorLastDDLTimestampMap();
            Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            try (Connection tenant2Conn = this.getTenantConnection(tenant2);){
                map = PhoenixRuntime.getTable((Connection)tenant2Conn, (String)view3).getAncestorLastDDLTimestampMap();
                Assert.assertEquals((long)1L, (long)map.size());
                Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
            }
            var24_34 = null;
            try (Connection tenant1Conn = this.getTenantConnection(tenant1);){
                PTable view1PTable = PhoenixRuntime.getTable((Connection)tenant1Conn, (String)view1);
                map = view1PTable.getAncestorLastDDLTimestampMap();
                Assert.assertEquals((long)1L, (long)map.size());
                Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
                PTableKey view1Key = new PTableKey(view1PTable.getTenantId(), view1);
                map = PhoenixRuntime.getTable((Connection)tenant1Conn, (String)view2).getAncestorLastDDLTimestampMap();
                Assert.assertEquals((long)2L, (long)map.size());
                Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
                Assert.assertEquals((Object)view1PTable.getLastDDLTimestamp(), map.get(view1Key));
                PTable view2PTable = PhoenixRuntime.getTable((Connection)tenant1Conn, (String)view2);
                PTableKey view2Key = new PTableKey(view2PTable.getTenantId(), view2);
                PTable index2PTable = PhoenixRuntime.getTable((Connection)tenant1Conn, (String)SchemaUtil.getTableName((String)SCHEMA3, (String)index2));
                map = index2PTable.getAncestorLastDDLTimestampMap();
                Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
                Assert.assertEquals((Object)view2PTable.getLastDDLTimestamp(), map.get(view2Key));
                Assert.assertEquals((long)3L, (long)view2PTable.getIndexes().size());
                for (PTable index : view2PTable.getIndexes()) {
                    if (index.getTableName().getString().equals(index1) || index.getTableName().getString().equals(index3)) {
                        map = index.getAncestorLastDDLTimestampMap();
                        Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
                        continue;
                    }
                    map = index.getAncestorLastDDLTimestampMap();
                    Assert.assertEquals((Object)baseTableLastDDLTimestamp, map.get(baseTableKey));
                    Assert.assertEquals((Object)view2PTable.getLastDDLTimestamp(), map.get(view2Key));
                }
            }
            catch (Throwable throwable) {
                var24_34 = throwable;
                throw throwable;
            }
        }
    }

    private Connection getTenantConnection(String tenantId) throws SQLException {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(ViewMetadataIT.getUrl(), tenantProps);
    }

    private void assertPKs(ResultSet rs, String[] expectedPKs) throws SQLException {
        ArrayList pkCols = Lists.newArrayListWithExpectedSize((int)expectedPKs.length);
        while (rs.next()) {
            pkCols.add(rs.getString("COLUMN_NAME"));
        }
        Object[] actualPKs = pkCols.toArray(new String[0]);
        Assert.assertArrayEquals((Object[])expectedPKs, (Object[])actualPKs);
    }

    private void validateViewDoesNotExist(Connection conn, String fullViewName) throws SQLException {
        try {
            String ddl1 = "DROP VIEW " + fullViewName;
            conn.createStatement().execute(ddl1);
            Assert.fail((String)("View " + fullViewName + " should have been deleted when parent was dropped"));
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    private void validateCols(PTable table) {
        final String prefix = table.getType() == PTableType.INDEX ? "0:" : "";
        Predicate<PColumn> predicate = new Predicate<PColumn>(){

            public boolean apply(PColumn col) {
                return col.getName().getString().equals(prefix + "V3") || col.getName().getString().equals(prefix + "V2");
            }
        };
        List colList = table.getColumns();
        Collection filteredCols = Collections2.filter((Collection)colList, (Predicate)predicate);
        Assert.assertEquals((long)1L, (long)filteredCols.size());
        Assert.assertEquals((Object)(prefix + "V3"), (Object)((PColumn)filteredCols.iterator().next()).getName().getString());
    }
}

