/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.phoenix.coprocessor.BaseMetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.MetaDataEndpointObserver;
import org.apache.phoenix.coprocessor.PhoenixMetaDataCoprocessorHost;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ConcurrentTableMutationException;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={NeedsOwnMiniClusterTest.class})
@RunWith(value=Parameterized.class)
public class ViewConcurrencyAndFailureIT
extends SplitSystemCatalogIT {
    protected String tableDDLOptions;
    protected String transactionProvider;
    protected boolean columnEncoded;
    private static final String FAILED_VIEWNAME = SchemaUtil.getTableName((String)SCHEMA2, (String)("FAILED_VIEW_" + ViewConcurrencyAndFailureIT.generateUniqueName()));
    private static final String SLOW_VIEWNAME_PREFIX = SchemaUtil.getTableName((String)SCHEMA2, (String)"SLOW_VIEW");
    private static volatile CountDownLatch latch1 = null;
    private static volatile CountDownLatch latch2 = null;
    private static volatile boolean throwExceptionInChildLinkPreHook = false;
    private static volatile boolean slowDownAddingChildLink = false;

    public ViewConcurrencyAndFailureIT(String transactionProvider, boolean columnEncoded) {
        StringBuilder optionBuilder = new StringBuilder();
        this.transactionProvider = transactionProvider;
        this.columnEncoded = columnEncoded;
        if (transactionProvider != null) {
            optionBuilder.append(" TRANSACTION_PROVIDER='").append(transactionProvider).append("'");
        }
        if (!columnEncoded) {
            if (optionBuilder.length() != 0) {
                optionBuilder.append(",");
            }
            optionBuilder.append("COLUMN_ENCODED_BYTES=0");
        }
        this.tableDDLOptions = optionBuilder.toString();
    }

    @Parameterized.Parameters(name="ViewConcurrencyAndFailureIT_transactionProvider={0}, columnEncoded={1}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList({"OMID", false}, {null, false}, {null, true});
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 6;
        boolean splitSystemCatalog = driver == null;
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("phoenix.acls.enabled", "true");
        serverProps.put("hbase.coprocessor.phoenix.classes", TestMetaDataRegionObserver.class.getName());
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        ViewConcurrencyAndFailureIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), ReadOnlyProps.EMPTY_PROPS);
        if (splitSystemCatalog) {
            ViewConcurrencyAndFailureIT.getUtility().getHBaseCluster().getMaster().balanceSwitch(false);
            ViewConcurrencyAndFailureIT.splitSystemCatalog();
        }
    }

    @After
    public void cleanup() throws Exception {
        boolean refCountLeaked = ViewConcurrencyAndFailureIT.isAnyStoreRefCountLeaked();
        latch1 = null;
        latch2 = null;
        throwExceptionInChildLinkPreHook = false;
        slowDownAddingChildLink = false;
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Test
    public void testChildViewCreationFails() throws Exception {
        try (PhoenixConnection conn = (PhoenixConnection)DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String failingViewName = FAILED_VIEWNAME;
            String succeedingViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String createTableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)" + this.tableDDLOptions;
            stmt.execute(createTableDdl);
            String createViewDdl = "CREATE VIEW " + failingViewName + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 5";
            try {
                stmt.execute(createViewDdl);
                Assert.fail();
            }
            catch (PhoenixIOException phoenixIOException) {
                // empty catch block
            }
            createViewDdl = "CREATE VIEW " + succeedingViewName + "(v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k > 10";
            stmt.execute(createViewDdl);
            try {
                conn.getTableNoCache(failingViewName);
                Assert.fail();
            }
            catch (TableNotFoundException tableNotFoundException) {
                // empty catch block
            }
            conn.getTableNoCache(fullTableName);
            conn.getTableNoCache(succeedingViewName);
        }
    }

    @Test
    public void testConcurrentViewCreationAndTableDrop() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
            latch1 = new CountDownLatch(1);
            latch2 = new CountDownLatch(1);
            String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER, v2 INTEGER)" + this.tableDDLOptions;
            stmt.execute(tableDdl);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setPriority(1);
                    return t;
                }
            });
            slowDownAddingChildLink = true;
            Future<Exception> future = executorService.submit(new CreateViewRunnable(fullTableName, fullViewName1));
            latch1.await();
            tableDdl = "DROP TABLE " + fullTableName;
            slowDownAddingChildLink = false;
            stmt.execute(tableDdl);
            latch2.countDown();
            Exception e = future.get();
            Assert.assertTrue((String)"Expected TableNotFoundException since drop table goes through first", (e instanceof TableNotFoundException && fullTableName.equals(((TableNotFoundException)((Object)e)).getTableName()) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testChildLinkCreationFailThrowsException() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String fullViewName1 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)" + this.tableDDLOptions;
            stmt.execute(tableDdl);
            throwExceptionInChildLinkPreHook = true;
            String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
            try {
                stmt.execute(ddl);
                Assert.fail((String)"Should have thrown an exception");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Expected a different Error code", (long)SQLExceptionCode.UNABLE_TO_CREATE_CHILD_LINK.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
    }

    @Test
    public void testConcurrentAddSameColumnDifferentType() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
            String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)" + this.tableDDLOptions;
            stmt.execute(tableDdl);
            String ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
            stmt.execute(ddl);
            latch1 = new CountDownLatch(1);
            latch2 = new CountDownLatch(1);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setPriority(1);
                    return t;
                }
            });
            Future<Exception> future = executorService.submit(new AddColumnRunnable(fullViewName1, null));
            boolean result = latch1.await(2L, TimeUnit.MINUTES);
            if (!result) {
                Assert.fail((String)"The create view rpc look too long");
            }
            tableDdl = "ALTER TABLE " + fullTableName + " ADD v3 INTEGER";
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Adding a column to a base table should fail when the same column of a different type is being added to a child view");
            }
            catch (ConcurrentTableMutationException concurrentTableMutationException) {
                // empty catch block
            }
            latch2.countDown();
            Exception e = future.get();
            Assert.assertNull((Object)e);
            ddl = "CREATE VIEW " + fullViewName2 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
            stmt.execute(ddl);
            tableDdl = "ALTER VIEW " + fullViewName2 + " ADD v3 INTEGER";
            stmt.execute(tableDdl);
        }
    }

    @Test
    public void testConcurrentAddSameColumnDifferentTypeTenantView() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
        String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
        String fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
        String tenantId = "t001";
        String tableDdl = "CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, k INTEGER NOT NULL, v1 DATE CONSTRAINT PK PRIMARY KEY (TENANT_ID, k)) MULTI_TENANT=true" + (!this.tableDDLOptions.isEmpty() ? ", " : "") + this.tableDDLOptions;
        String viewDdl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            stmt.execute(tableDdl);
            Properties props = new Properties();
            props.setProperty("TenantId", tenantId);
            try (Connection tenantConn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl(), props);
                 Statement tenantStmt = tenantConn.createStatement();){
                tenantStmt.execute(viewDdl);
            }
            latch1 = new CountDownLatch(1);
            latch2 = new CountDownLatch(1);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setPriority(1);
                    return t;
                }
            });
            Future<Exception> future = executorService.submit(new AddColumnRunnable(fullViewName1, tenantId));
            boolean result = latch1.await(2L, TimeUnit.MINUTES);
            if (!result) {
                Assert.fail((String)"The tenant-specific view creation rpc look too long");
            }
            tableDdl = "ALTER TABLE " + fullTableName + " ADD v3 INTEGER";
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Adding a column to a base table should fail when the same column of a different type is being added to a child view");
            }
            catch (ConcurrentTableMutationException concurrentTableMutationException) {
                // empty catch block
            }
            latch2.countDown();
            Exception e = future.get();
            Assert.assertNull((Object)e);
            viewDdl = "CREATE VIEW " + fullViewName2 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
            stmt.execute(viewDdl);
            tableDdl = "ALTER VIEW " + fullViewName2 + " ADD v3 INTEGER";
            stmt.execute(tableDdl);
        }
    }

    @Test
    public void testConcurrentAddDifferentColumnParentHasColEncoding() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            Future<Exception> future;
            String ddl;
            String tableDdl;
            String fullViewName2;
            String fullTableName;
            block28: {
                fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
                String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
                fullViewName2 = SchemaUtil.getTableName((String)SCHEMA3, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
                String fullViewName3 = SchemaUtil.getTableName((String)SCHEMA4, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
                tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 DATE)" + this.tableDDLOptions;
                stmt.execute(tableDdl);
                ddl = "CREATE VIEW " + fullViewName1 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
                stmt.execute(ddl);
                ddl = "CREATE VIEW " + fullViewName3 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 7";
                stmt.execute(ddl);
                latch1 = new CountDownLatch(1);
                latch2 = new CountDownLatch(1);
                ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread t = Executors.defaultThreadFactory().newThread(r);
                        t.setDaemon(true);
                        t.setPriority(1);
                        return t;
                    }
                });
                future = executorService.submit(new AddColumnRunnable(fullViewName1, null));
                boolean result = latch1.await(2L, TimeUnit.MINUTES);
                if (!result) {
                    Assert.fail((String)"The alter view rpc look too long");
                }
                tableDdl = "ALTER VIEW " + fullViewName3 + " ADD v4 INTEGER";
                try {
                    stmt.execute(tableDdl);
                    if (this.columnEncoded) {
                        Assert.fail((String)"Adding columns to two different views concurrently where the base table uses encoded columns should fail");
                    }
                }
                catch (ConcurrentTableMutationException e) {
                    if (this.columnEncoded) break block28;
                    Assert.fail((String)"Adding columns to two different views concurrently where the base table does not use encoded columns should succeed");
                }
            }
            latch2.countDown();
            Exception e = future.get();
            Assert.assertNull((Object)e);
            ddl = "CREATE VIEW " + fullViewName2 + " (v2 VARCHAR) AS SELECT * FROM " + fullTableName + " WHERE k = 6";
            stmt.execute(ddl);
            tableDdl = "ALTER VIEW " + fullViewName2 + " ADD v3 INTEGER";
            stmt.execute(tableDdl);
        }
    }

    @Test
    public void testConcurrentViewCreationParentColDropViewCondition() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
            String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER)" + this.tableDDLOptions;
            stmt.execute(tableDdl);
            latch1 = new CountDownLatch(1);
            latch2 = new CountDownLatch(1);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setPriority(1);
                    return t;
                }
            });
            Future<Exception> future = executorService.submit(new CreateViewRunnable(fullTableName, fullViewName1));
            boolean result = latch1.await(2L, TimeUnit.MINUTES);
            if (!result) {
                Assert.fail((String)"The create view rpc look too long");
            }
            tableDdl = "ALTER TABLE " + fullTableName + " DROP COLUMN v1";
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Dropping a column from a base table should fail when a child view is concurrently being created whose view WHERE condition depends on this column");
            }
            catch (ConcurrentTableMutationException concurrentTableMutationException) {
                // empty catch block
            }
            latch2.countDown();
            Exception e = future.get();
            Assert.assertNull((Object)e);
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Dropping a column from a parent that a child view depends on should fail");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Expected a different SQLException", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
    }

    @Test
    public void testConcurrentViewCreationWithNewColParentColAddition() throws Exception {
        try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl());
             Statement stmt = conn.createStatement();){
            String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)ViewConcurrencyAndFailureIT.generateUniqueName());
            String fullViewName1 = SLOW_VIEWNAME_PREFIX + "_" + ViewConcurrencyAndFailureIT.generateUniqueName();
            String tableDdl = "CREATE TABLE " + fullTableName + "  (k INTEGER NOT NULL PRIMARY KEY, v1 INTEGER)" + this.tableDDLOptions;
            stmt.execute(tableDdl);
            latch1 = new CountDownLatch(1);
            latch2 = new CountDownLatch(1);
            ExecutorService executorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = Executors.defaultThreadFactory().newThread(r);
                    t.setDaemon(true);
                    t.setPriority(1);
                    return t;
                }
            });
            Future<Exception> future = executorService.submit(new CreateViewRunnable(fullTableName, fullViewName1));
            boolean result = latch1.await(2L, TimeUnit.MINUTES);
            if (!result) {
                Assert.fail((String)"The create view rpc look too long");
            }
            tableDdl = "ALTER TABLE " + fullTableName + " ADD new_col INTEGER";
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Adding a column to a base table should fail when a child view is concurrently being created that has that new column");
            }
            catch (ConcurrentTableMutationException concurrentTableMutationException) {
                // empty catch block
            }
            latch2.countDown();
            Exception e = future.get();
            Assert.assertNull((Object)e);
            try {
                stmt.execute(tableDdl);
                Assert.fail((String)"Adding a column to a parent that its child view already contains should fail");
            }
            catch (SQLException sqlE) {
                Assert.assertEquals((String)"Expected a different SQLException", (long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)sqlE.getErrorCode());
            }
        }
    }

    private static class AddColumnRunnable
    implements Callable<Exception> {
        private final String fullViewName;
        private final String tenantId;

        public AddColumnRunnable(String fullViewName, String tenantId) {
            this.fullViewName = fullViewName;
            this.tenantId = tenantId;
        }

        @Override
        public Exception call() throws Exception {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            if (this.tenantId != null) {
                props.setProperty("TenantId", this.tenantId);
            }
            try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl(), props);
                 Statement stmt = conn.createStatement();){
                String ddl = "ALTER VIEW " + this.fullViewName + " ADD v3 CHAR(15)";
                stmt.execute(ddl);
            }
            catch (SQLException e) {
                return e;
            }
            return null;
        }
    }

    private static class CreateViewRunnable
    implements Callable<Exception> {
        private final String fullTableName;
        private final String fullViewName;

        public CreateViewRunnable(String fullTableName, String fullViewName) {
            this.fullTableName = fullTableName;
            this.fullViewName = fullViewName;
        }

        @Override
        public Exception call() throws Exception {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            try (Connection conn = DriverManager.getConnection(ViewConcurrencyAndFailureIT.getUrl(), props);
                 Statement stmt = conn.createStatement();){
                String ddl = "CREATE VIEW " + this.fullViewName + " (new_pk VARCHAR PRIMARY KEY, new_col VARCHAR) AS SELECT * FROM " + this.fullTableName + " WHERE v1 = 5";
                stmt.execute(ddl);
            }
            catch (SQLException e) {
                return e;
            }
            return null;
        }
    }

    public static class TestMetaDataRegionObserver
    extends BaseMetaDataEndpointObserver {
        public Optional<MetaDataEndpointObserver> getPhoenixObserver() {
            return Optional.of(this);
        }

        public void preAlterTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType type) throws IOException {
            this.processTable(tableName);
        }

        public void preCreateTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, Set<byte[]> familySet, Set<TableName> indexes) throws IOException {
            this.processTable(tableName);
        }

        public void preDropTable(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tenantId, String tableName, TableName physicalTableName, TableName parentPhysicalTableName, PTableType tableType, List<PTable> indexes) throws IOException {
            this.processTable(tableName);
        }

        public void preCreateViewAddChildLink(ObserverContext<PhoenixMetaDataCoprocessorHost.PhoenixMetaDataControllerEnvironment> ctx, String tableName) throws IOException {
            if (throwExceptionInChildLinkPreHook) {
                throw new IOException();
            }
            this.processTable(tableName);
        }

        private void processTable(String tableName) throws DoNotRetryIOException {
            if (tableName.equals(FAILED_VIEWNAME)) {
                throw new DoNotRetryIOException();
            }
            if (tableName.startsWith(SLOW_VIEWNAME_PREFIX) || slowDownAddingChildLink) {
                if (latch1 != null) {
                    latch1.countDown();
                }
                if (latch2 != null) {
                    try {
                        boolean result = latch2.await(2L, TimeUnit.MINUTES);
                        if (!result) {
                            throw new RuntimeException("Second task took too long to complete");
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

