/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Format;
import java.util.Properties;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class VariableLengthPKIT
extends ParallelStatsDisabledIT {
    private static final String DS1 = "1970-01-01 00:58:00";
    private static final Date D1 = VariableLengthPKIT.toDate("1970-01-01 00:58:00");

    private static Date toDate(String dateString) {
        return DateUtil.parseDate((String)dateString);
    }

    protected static void initGroupByRowKeyColumns(String pTSDBtableName) throws Exception {
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBtableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBtableName + " (    INST,     HOST,    \"DATE\")VALUES (?, ?, CURRENT_DATE())");
        stmt.setString(1, "ab");
        stmt.setString(2, "a");
        stmt.execute();
        stmt.setString(1, "ac");
        stmt.setString(2, "b");
        stmt.execute();
        stmt.setString(1, "ad");
        stmt.setString(2, "a");
        stmt.execute();
        conn.commit();
        conn.close();
    }

    private static void initVarcharKeyTableValues(byte[][] splits, String varcharKeyTestTableName) throws Exception {
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        String ddl = "create table " + varcharKeyTestTableName + "   (pk varchar not null primary key)";
        VariableLengthPKIT.createTestTable(VariableLengthPKIT.getUrl(), ddl, splits, null);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + varcharKeyTestTableName + "(pk) VALUES (?)");
        stmt.setString(1, "   def");
        stmt.execute();
        stmt.setString(1, "jkl   ");
        stmt.execute();
        stmt.setString(1, "   ghi   ");
        stmt.execute();
        conn.commit();
        conn.close();
    }

    private static void initPTSDBTableValues(byte[][] splits, String pTSDBtableName) throws Exception {
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBtableName, "PTSDB", splits, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBtableName + " (    INST,     HOST,    \"DATE\",    VAL)VALUES (?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "abc-def-ghi");
        stmt.setDate(3, new Date(System.currentTimeMillis()));
        stmt.setBigDecimal(4, new BigDecimal(0.5));
        stmt.execute();
        conn.close();
    }

    private static void initBTableValues(byte[][] splits, String bTableName) throws Exception {
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), bTableName, "BTABLE", splits, null, null);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + bTableName + " (    A_STRING,     A_ID,    B_STRING,    A_INTEGER,    B_INTEGER,    C_INTEGER,    D_STRING,    E_STRING)VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "111");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setInt(5, 10);
        stmt.setInt(6, 1000);
        stmt.setString(7, null);
        stmt.setString(8, "0123456789");
        stmt.execute();
        stmt.setString(1, "abcd");
        stmt.setString(2, "222");
        stmt.setString(3, "xy");
        stmt.setInt(4, 2);
        stmt.setNull(5, 4);
        stmt.setNull(6, 4);
        stmt.execute();
        stmt.setString(3, "xyz");
        stmt.setInt(4, 3);
        stmt.setInt(5, 10);
        stmt.setInt(6, 1000);
        stmt.setString(7, "efg");
        stmt.execute();
        stmt.setString(3, "xyzz");
        stmt.setInt(4, 4);
        stmt.setInt(5, 40);
        stmt.setNull(6, 4);
        stmt.setString(7, null);
        stmt.execute();
        conn.commit();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleColumnScanKey() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_STRING,substr(a_id,1,1),B_STRING,A_INTEGER,B_INTEGER FROM " + bTableName + " WHERE A_STRING=?";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "abc");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertEquals((Object)"1", (Object)rs.getString(2));
            Assert.assertEquals((Object)"x", (Object)rs.getString(3));
            Assert.assertEquals((long)1L, (long)rs.getInt(4));
            Assert.assertEquals((long)10L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleColumnGroupBy() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT INST FROM " + pTSDBTableName + " GROUP BY INST";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initPTSDBTableValues(null, pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonfirstColumnGroupBy() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT HOST FROM " + pTSDBTableName + " WHERE INST='abc' GROUP BY HOST";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initPTSDBTableValues(null, pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc-def-ghi", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGroupByRowKeyColumns() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT SUBSTR(INST,1,1),HOST FROM " + pTSDBTableName + " GROUP BY SUBSTR(INST,1,1),HOST";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initGroupByRowKeyColumns(pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"a", (Object)rs.getString(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((Object)"b", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipScan() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT HOST FROM " + pTSDBTableName + " WHERE INST='abc' AND \"DATE\">=TO_DATE('1970-01-01 00:00:00') AND \"DATE\" <TO_DATE('2171-01-01 00:00:00')";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initPTSDBTableValues(null, pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc-def-ghi", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipMax() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT MAX(INST),MAX(\"DATE\") FROM " + pTSDBTableName + " WHERE INST='abc' AND \"DATE\">=TO_DATE('1970-01-01 00:00:00') AND \"DATE\" <TO_DATE('2171-01-01 00:00:00')";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initPTSDBTableValues(null, pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipMaxWithLimit() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT MAX(INST),MAX(\"DATE\") FROM " + pTSDBTableName + " WHERE INST='abc' AND \"DATE\">=TO_DATE('1970-01-01 00:00:00') AND \"DATE\" <TO_DATE('2171-01-01 00:00:00') LIMIT 2";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initPTSDBTableValues(null, pTSDBTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abc", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleColumnKeyFilter() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_STRING,substr(a_id,1,1),B_STRING,A_INTEGER,B_INTEGER FROM " + bTableName + " WHERE B_STRING=?";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "xy");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(3));
            Assert.assertEquals((long)2L, (long)rs.getInt(4));
            Assert.assertEquals((long)0L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiColumnEqScanKey() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_STRING,substr(a_id,1,1),B_STRING,A_INTEGER,B_INTEGER FROM " + bTableName + " WHERE A_STRING=? AND A_ID=? AND B_STRING=?";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "abcd");
            statement.setString(2, "222");
            statement.setString(3, "xy");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"xy", (Object)rs.getString(3));
            Assert.assertEquals((long)2L, (long)rs.getInt(4));
            Assert.assertEquals((long)0L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiColumnGTScanKey() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_STRING,substr(a_id,1,1),B_STRING,A_INTEGER,B_INTEGER FROM " + bTableName + " WHERE A_STRING=? AND A_ID=? AND B_STRING>?";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "abcd");
            statement.setString(2, "222");
            statement.setString(3, "xy");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(3));
            Assert.assertEquals((long)3L, (long)rs.getInt(4));
            Assert.assertEquals((long)10L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"xyzz", (Object)rs.getString(3));
            Assert.assertEquals((long)4L, (long)rs.getInt(4));
            Assert.assertEquals((long)40L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiColumnGTKeyFilter() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_STRING,substr(a_id,1,1),B_STRING,A_INTEGER,B_INTEGER FROM " + bTableName + " WHERE A_STRING>? AND A_INTEGER>=?";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, "abc");
            statement.setInt(2, 4);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
            Assert.assertEquals((Object)"2", (Object)rs.getString(2));
            Assert.assertEquals((Object)"xyzz", (Object)rs.getString(3));
            Assert.assertEquals((long)4L, (long)rs.getInt(4));
            Assert.assertEquals((long)40L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNullValueEqualityScan() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES ('', '', ?, 0.5)");
        stmt.setDate(1, D1);
        stmt.execute();
        conn.close();
        String query = "SELECT HOST,\"DATE\" FROM " + pTSDBTableName + " WHERE HOST='' AND INST=''";
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVarLengthPKColScan() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES (?, 'y', ?, 0.5)");
        stmt.setString(1, "x");
        stmt.setDate(2, D1);
        stmt.execute();
        stmt.setString(1, "xy");
        stmt.execute();
        conn.close();
        String query = "SELECT HOST,\"DATE\" FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y'";
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)D1, (Object)rs.getDate(2));
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEscapedQuoteScan() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES (?, 'y', ?, 0.5)");
        stmt.setString(1, "x'y");
        stmt.setDate(2, D1);
        stmt.execute();
        stmt.setString(1, "x");
        stmt.execute();
        conn.close();
        String query1 = "SELECT INST,\"DATE\" FROM " + pTSDBTableName + " WHERE INST='x''y'";
        String query2 = "SELECT INST,\"DATE\" FROM " + pTSDBTableName + " WHERE INST='x\\'y'";
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement(query1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x'y", (Object)rs.getString(1));
            Assert.assertEquals((Object)D1, (Object)rs.getDate(2));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement(query2);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x'y", (Object)rs.getString(1));
            Assert.assertEquals((Object)D1, (Object)rs.getDate(2));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    private static void initPTSDBTableValues1(String pTSDBTableName) throws Exception {
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES ('x', 'y', ?, 0.5)");
        stmt.setDate(1, D1);
        stmt.execute();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToStringOnDate() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.initPTSDBTableValues1(pTSDBTableName);
        String query = "SELECT HOST,\"DATE\" FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y'";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.DEFAULT_DATE_FORMATTER.format(D1), (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private static void initPTSDBTableValues2(String pTSDB2TableName, Date d) throws Exception {
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDB2TableName, "PTSDB2", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDB2TableName + "(inst,\"DATE\",val2) VALUES (?, ?, ?)");
        stmt.setString(1, "a");
        stmt.setDate(2, d);
        stmt.setDouble(3, 101.3);
        stmt.execute();
        stmt.setString(1, "a");
        stmt.setDate(2, new Date(d.getTime() + 86400000L));
        stmt.setDouble(3, 99.7);
        stmt.execute();
        stmt.setString(1, "a");
        stmt.setDate(2, new Date(d.getTime() - 86400000L));
        stmt.setDouble(3, 105.3);
        stmt.execute();
        stmt.setString(1, "b");
        stmt.setDate(2, d);
        stmt.setDouble(3, 88.5);
        stmt.execute();
        stmt.setString(1, "b");
        stmt.setDate(2, new Date(d.getTime() + 86400000L));
        stmt.setDouble(3, 89.7);
        stmt.execute();
        stmt.setString(1, "b");
        stmt.setDate(2, new Date(d.getTime() - 86400000L));
        stmt.setDouble(3, 94.9);
        stmt.execute();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRoundOnDate() throws Exception {
        String pTSDB2TableName = VariableLengthPKIT.generateUniqueName();
        Date date = new Date(System.currentTimeMillis());
        VariableLengthPKIT.initPTSDBTableValues2(pTSDB2TableName, date);
        String query = "SELECT MAX(val2) FROM " + pTSDB2TableName + " WHERE inst='a' GROUP BY ROUND(\"DATE\",'day',1) ORDER BY MAX(val2)";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)99.7, (double)rs.getDouble(1), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)101.3, (double)rs.getDouble(1), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((double)105.3, (double)rs.getDouble(1), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderBy() throws Exception {
        String pTSDB2TableName = VariableLengthPKIT.generateUniqueName();
        Date date = new Date(System.currentTimeMillis());
        VariableLengthPKIT.initPTSDBTableValues2(pTSDB2TableName, date);
        String query = "SELECT inst,MAX(val2),MIN(val2) FROM " + pTSDB2TableName + " GROUP BY inst,ROUND(\"DATE\",'day',1) ORDER BY inst,ROUND(\"DATE\",'day',1)";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((double)105.3, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)105.3, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((double)101.3, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)101.3, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertEquals((double)99.7, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)99.7, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((double)94.9, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)94.9, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((double)88.5, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)88.5, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"b", (Object)rs.getString(1));
            Assert.assertEquals((double)89.7, (double)rs.getDouble(2), (double)1.0E-6);
            Assert.assertEquals((double)89.7, (double)rs.getDouble(3), (double)1.0E-6);
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectCount() throws Exception {
        String pTSDB2TableName = VariableLengthPKIT.generateUniqueName();
        Date date = new Date(System.currentTimeMillis());
        VariableLengthPKIT.initPTSDBTableValues2(pTSDB2TableName, date);
        String query = "SELECT COUNT(*) FROM " + pTSDB2TableName + " WHERE inst='a'";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testBatchUpsert() throws Exception {
        String pTSDB2TableName = VariableLengthPKIT.generateUniqueName();
        Date d = new Date(System.currentTimeMillis());
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDB2TableName, "PTSDB2", null, null, null);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String query = "SELECT SUM(val1),SUM(val2),SUM(val3) FROM " + pTSDB2TableName;
        String sql1 = "UPSERT INTO " + pTSDB2TableName + "(inst,\"DATE\",val1) VALUES (?, ?, ?)";
        String sql2 = "UPSERT INTO " + pTSDB2TableName + "(inst,\"DATE\",val2) VALUES (?, ?, ?)";
        String sql3 = "UPSERT INTO " + pTSDB2TableName + "(inst,\"DATE\",val3) VALUES (?, ?, ?)";
        Connection conn = DriverManager.getConnection(VariableLengthPKIT.getUrl(), props);
        conn.setAutoCommit(false);
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertNull((Object)rs.getBigDecimal(1));
        Assert.assertNull((Object)rs.getBigDecimal(2));
        Assert.assertNull((Object)rs.getBigDecimal(3));
        Assert.assertFalse((boolean)rs.next());
        statement.close();
        PreparedStatement s = conn.prepareStatement(sql1);
        s.setString(1, "a");
        s.setDate(2, d);
        s.setInt(3, 1);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        s = conn.prepareStatement(sql2);
        s.setString(1, "b");
        s.setDate(2, d);
        s.setInt(3, 1);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        s = conn.prepareStatement(sql3);
        s.setString(1, "c");
        s.setDate(2, d);
        s.setInt(3, 1);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        s = conn.prepareStatement(sql1);
        s.setString(1, "a");
        s.setDate(2, d);
        s.setInt(3, 5);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        s = conn.prepareStatement(sql1);
        s.setString(1, "b");
        s.setDate(2, d);
        s.setInt(3, 5);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        s = conn.prepareStatement(sql1);
        s.setString(1, "c");
        s.setDate(2, d);
        s.setInt(3, 5);
        Assert.assertEquals((long)1L, (long)s.executeUpdate());
        s.close();
        conn.commit();
        conn.close();
        conn = DriverManager.getConnection(VariableLengthPKIT.getUrl(), props);
        statement = conn.prepareStatement(query);
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((double)15.0, (double)rs.getDouble(1), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)rs.getDouble(2), (double)1.0E-6);
        Assert.assertEquals((double)1.0, (double)rs.getDouble(3), (double)1.0E-6);
        Assert.assertFalse((boolean)rs.next());
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectStar() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.initPTSDBTableValues1(pTSDBTableName);
        String query = "SELECT * FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y'";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString("inst"));
            Assert.assertEquals((Object)"y", (Object)rs.getString("host"));
            Assert.assertEquals((Object)D1, (Object)rs.getDate("DATE"));
            Assert.assertEquals((Object)BigDecimal.valueOf(0.5), (Object)rs.getBigDecimal("val"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToCharOnDate() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.initPTSDBTableValues1(pTSDBTableName);
        String query = "SELECT HOST,TO_CHAR(\"DATE\") FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y'";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)DateUtil.DEFAULT_DATE_FORMATTER.format(D1), (Object)rs.getString(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToCharWithFormatOnDate() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.initPTSDBTableValues1(pTSDBTableName);
        String format = "HH:mm:ss";
        Format dateFormatter = DateUtil.getDateFormatter((String)format);
        String query = "SELECT HOST,TO_CHAR(\"DATE\",'" + format + "') FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y'";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)dateFormatter.format(D1), (Object)rs.getString(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testToDateWithFormatOnDate() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.initPTSDBTableValues1(pTSDBTableName);
        String format = "yyyy-MM-dd HH:mm:ss.S";
        Format dateFormatter = DateUtil.getDateFormatter((String)format);
        String query = "SELECT HOST,TO_CHAR(\"DATE\",'" + format + "') FROM " + pTSDBTableName + " WHERE INST='x' AND HOST='y' and \"DATE\"=TO_DATE(?,'" + format + "')";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, dateFormatter.format(D1));
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)dateFormatter.format(D1), (Object)rs.getString(2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMissingPKColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        Statement stmt = conn.createStatement();
        try {
            stmt.execute("upsert into " + pTSDBTableName + "(INST,HOST,VAL) VALUES ('abc', 'abc-def-ghi', 0.5)");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CONSTRAINT_VIOLATION.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testNoKVColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "BTABLE", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES (?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "123");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setString(5, "ab");
        stmt.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooShortKVColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "BTABLE", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " (    A_STRING,     A_ID,    B_STRING,    A_INTEGER,    C_STRING,    E_STRING)VALUES (?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "123");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setString(5, "ab");
        stmt.setString(6, "01234");
        try {
            stmt.execute();
        }
        catch (ConstraintViolationException e) {
            Assert.fail((String)"Constraint voilation Exception should not be thrown, the characters have to be padded");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooShortPKColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "BTABLE", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " (    A_STRING,     A_ID,    B_STRING,    A_INTEGER,    C_STRING,    E_STRING)VALUES (?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "12");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setString(5, "ab");
        stmt.setString(6, "0123456789");
        try {
            stmt.execute();
        }
        catch (ConstraintViolationException e) {
            Assert.fail((String)"Constraint voilation Exception should not be thrown, the characters have to be padded");
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooLongPKColumn() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), bTableName, "BTABLE", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + bTableName + "(    A_STRING,     A_ID,    B_STRING,    A_INTEGER,    C_STRING,    E_STRING)VALUES (?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "123");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setString(5, "abc");
        stmt.setString(6, "0123456789");
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTooLongKVColumn() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), bTableName, "BTABLE", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + bTableName + "(    A_STRING,     A_ID,    B_STRING,    A_INTEGER,    C_STRING,    D_STRING,    E_STRING)VALUES (?, ?, ?, ?, ?, ?, ?)");
        stmt.setString(1, "abc");
        stmt.setString(2, "123");
        stmt.setString(3, "x");
        stmt.setInt(4, 1);
        stmt.setString(5, "ab");
        stmt.setString(6, "abcd");
        stmt.setString(7, "0123456789");
        try {
            stmt.execute();
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiFixedLengthNull() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT B_INTEGER,C_INTEGER,COUNT(1) FROM " + bTableName + " GROUP BY B_INTEGER,C_INTEGER";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            Assert.assertEquals((long)1000L, (long)rs.getInt(2));
            Assert.assertEquals((long)2L, (long)rs.getLong(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)40L, (long)rs.getInt(1));
            Assert.assertEquals((long)0L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)1L, (long)rs.getLong(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleFixedLengthNull() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT C_INTEGER,COUNT(1) FROM " + bTableName + " GROUP BY C_INTEGER";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1000L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getLong(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiMixedTypeGroupBy() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String query = "SELECT A_ID, E_STRING, D_STRING, C_INTEGER, COUNT(1) FROM " + bTableName + " GROUP BY A_ID, E_STRING, D_STRING, C_INTEGER";
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"111", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0123456789", (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Assert.assertEquals((long)1000L, (long)rs.getInt(4));
            Assert.assertEquals((long)1L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"222", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0123456789", (Object)rs.getString(2));
            Assert.assertEquals(null, (Object)rs.getString(3));
            Assert.assertEquals((long)0L, (long)rs.getInt(4));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertEquals((long)2L, (long)rs.getInt(5));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"222", (Object)rs.getString(1));
            Assert.assertEquals((Object)"0123456789", (Object)rs.getString(2));
            Assert.assertEquals((Object)"efg", (Object)rs.getString(3));
            Assert.assertEquals((long)1000L, (long)rs.getInt(4));
            Assert.assertEquals((long)1L, (long)rs.getInt(5));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSubstrFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String varcharKeyTestTable = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT substr('ABC',-1,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('ABC',-4,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('ABC',2,4) FROM " + bTableName + " LIMIT 1", "SELECT substr('ABC',1,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('ABC',0,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',0,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',0,2) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',1,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',1,2) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',2,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',2,2) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u0112',-1,1) FROM " + bTableName + " LIMIT 1", "SELECT substr('\u010e\u010f\u025a\u028d',2,4) FROM " + bTableName + " LIMIT 1", "SELECT pk FROM " + varcharKeyTestTable + " WHERE substr(pk, 0, 3)='jkl'"};
        String[] result = new String[]{"C", null, "BC", "A", "A", "\u010e", "\u010e\u010f", "\u010e", "\u010e\u010f", "\u010f", "\u010f\u0112", "\u0112", "\u010f\u025a\u028d", "jkl   "};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            VariableLengthPKIT.initVarcharKeyTableValues(null, varcharKeyTestTable);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegexReplaceFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT regexp_replace('', '') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('', 'abc', 'def') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('123abcABC', '[a-z]+') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('123-abc-ABC', '-[a-zA-Z-]+') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('abcABC123', '\\\\d+', '') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('abcABC123', '\\\\D+', '') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('abc', 'abc', 'def') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('abc123ABC', '\\\\d+', 'def') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('abc123ABC', '[0-9]+', '#') FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN regexp_replace('abcABC123', '[a-zA-Z]+') = '123' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT A_STRING FROM " + bTableName + " WHERE A_ID = regexp_replace('abcABC111', '[a-zA-Z]+') LIMIT 1", "SELECT regexp_replace('\u010e\u010f \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2', '[a-zA-Z]+') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('\u010e\u010f \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2', '[\u010e-\u011b]+', '#') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('\u010e\u010f \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2', '.+', 'replacement') FROM " + bTableName + " LIMIT 1", "SELECT regexp_replace('\u010e\u010f \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2', '\u010e\u010f', 'DD') FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{null, null, "123ABC", "123", "abcABC", "123", "def", "abcdefABC", "abc#ABC", "1", "abc", "\u010e\u010f \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2", "# # \u011c\u011e \u03d7\u03d8\u03db\u03e2", "replacement", "DD \u0112\u0115 \u011c\u011e \u03d7\u03d8\u03db\u03e2"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRegexpSubstrFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT regexp_substr('', '', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('', '', 1) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('', 'abc', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('abc', '', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123', '123', 3) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123', '123', -4) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABC', '[a-z]+', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABC', '[0-9]+', 4) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABCabc', '\\\\d+', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABCabc', '\\\\D+', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABCabc', '\\\\D+', 4) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('123ABCabc', '\\\\D+', 7) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('na11-app5-26-sjl', '[^-]+', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('na11-app5-26-sjl', '[^-]+') FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('\u010e\u010f\u0112\u0115\u011c\u011e', '.+') FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('\u010e\u010f\u0112\u0115\u011c\u011e', '.+', 3) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('\u010e\u010f\u0112\u0115\u011c\u011e', '[a-zA-Z]+', 0) FROM " + bTableName + " LIMIT 1", "SELECT regexp_substr('\u010e\u010f\u0112\u0115\u011c\u011e', '[\u010e-\u011b]+', 3) FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{null, null, null, null, null, null, null, null, "123", "ABCabc", "ABCabc", "abc", "na11", "na11", "\u010e\u010f\u0112\u0115\u011c\u011e", "\u0112\u0115\u011c\u011e", null, "\u0112\u0115"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testRegexpSubstrFunction2() throws Exception {
        String tTableName = VariableLengthPKIT.generateUniqueName();
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        String ddl = "create table " + tTableName + " (k INTEGER NOT NULL PRIMARY KEY, name VARCHAR)";
        conn.createStatement().execute(ddl);
        conn.close();
        String dml = "upsert into " + tTableName + " values(?,?)";
        conn = DriverManager.getConnection(url, props);
        PreparedStatement stmt = conn.prepareStatement(dml);
        String[] values = new String[]{"satax", "jruls", "hrjcu", "yqtrv", "jjcvw"};
        for (int i = 0; i < values.length; ++i) {
            stmt.setInt(1, i + 1);
            stmt.setString(2, values[i]);
            stmt.execute();
        }
        conn.commit();
        conn.close();
        String query = "select regexp_substr(name,'[^s]+',1) from " + tTableName + " limit 5";
        conn = DriverManager.getConnection(url, props);
        ResultSet rs = conn.createStatement().executeQuery(query);
        int count = 0;
        String[] results = new String[]{"atax", "jrul", "hrjcu", "yqtrv", "jjcvw"};
        while (rs.next()) {
            Assert.assertEquals((Object)results[count], (Object)rs.getString(1));
            ++count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLikeConstant() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT CASE WHEN 'ABC' LIKE '' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'ABC' LIKE 'A_' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'ABC' LIKE 'A__' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'AB_C' LIKE 'AB\\_C' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'ABC%DE' LIKE 'ABC\\%D%' THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{"2", "2", "1", "1", "1"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInListConstant() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT CASE WHEN 'a' IN (null,'a') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN NOT 'a' IN (null,'b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'a' IN (null,'b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN NOT 'a' IN ('c','b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 1 IN ('foo',2,1) THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN NOT null IN ('c','b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN NOT null IN (null,'c','b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN null IN (null,'c','b') THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1", "SELECT CASE WHEN 'a' IN (null,1) THEN '1' ELSE '2' END FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{"1", "1", "2", "1", "1", "2", "2", "2", "2"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLikeOnColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES (?, ?, ?, 0.5)");
        stmt.setDate(3, D1);
        stmt.setString(1, "a");
        stmt.setString(2, "a");
        stmt.execute();
        stmt.setString(1, "x");
        stmt.setString(2, "a");
        stmt.execute();
        stmt.setString(1, "xy");
        stmt.setString(2, "b");
        stmt.execute();
        stmt.setString(1, "xyz");
        stmt.setString(2, "c");
        stmt.execute();
        stmt.setString(1, "xyza");
        stmt.setString(2, "d");
        stmt.execute();
        stmt.setString(1, "xyzab");
        stmt.setString(2, "e");
        stmt.execute();
        stmt.setString(1, "z");
        stmt.setString(2, "e");
        stmt.execute();
        conn.commit();
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST LIKE 'x%'");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyza", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyzab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST LIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyza", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyzab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST NOT LIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE 'xzabc' LIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE 'abcdef' LIKE '%bCd%'");
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testILikeOnColumn() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + "(INST, HOST, \"DATE\", VAL, PATTERN VARCHAR) VALUES (?, ?, ?, 0.5, 'x_Z%')");
        stmt.setDate(3, D1);
        stmt.setString(1, "a");
        stmt.setString(2, "a");
        stmt.execute();
        stmt.setString(1, "x");
        stmt.setString(2, "a");
        stmt.execute();
        stmt.setString(1, "xy");
        stmt.setString(2, "b");
        stmt.execute();
        stmt.setString(1, "xyz");
        stmt.setString(2, "c");
        stmt.execute();
        stmt.setString(1, "xyza");
        stmt.setString(2, "d");
        stmt.execute();
        stmt.setString(1, "xyzab");
        stmt.setString(2, "e");
        stmt.execute();
        stmt.setString(1, "z");
        stmt.setString(2, "e");
        stmt.execute();
        conn.commit();
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST ILIKE 'x%'");
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyza", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyzab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST ILIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyza", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyzab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE INST NOT ILIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"a", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"x", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xy", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"z", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE 'xzabc' ILIKE 'xy_a%'");
            rs = statement.executeQuery();
            Assert.assertFalse((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + " WHERE 'abcdef' ILIKE '%bCd%'");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            statement = conn.prepareStatement("SELECT INST FROM " + pTSDBTableName + "(PATTERN VARCHAR) WHERE INST ILIKE PATTERN");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyz", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyza", (Object)rs.getString(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"xyzab", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsNullInPK() throws Exception {
        String pTSDBTableName = VariableLengthPKIT.generateUniqueName();
        VariableLengthPKIT.ensureTableCreated(VariableLengthPKIT.getUrl(), pTSDBTableName, "PTSDB", null, null, null);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(url, props);
        conn.setAutoCommit(true);
        PreparedStatement stmt = conn.prepareStatement("upsert into " + pTSDBTableName + " VALUES ('', '', ?, 0.5)");
        stmt.setDate(1, D1);
        stmt.execute();
        conn.close();
        String query = "SELECT HOST,INST,\"DATE\" FROM " + pTSDBTableName + " WHERE HOST IS NULL AND INST IS NULL AND \"DATE\"=?";
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url, props);
        try {
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setDate(1, D1);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertNull((Object)rs.getString(1));
            Assert.assertNull((Object)rs.getString(2));
            Assert.assertEquals((Object)D1, (Object)rs.getDate(3));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLengthFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT length('') FROM " + bTableName + " LIMIT 1", "SELECT length(' ') FROM " + bTableName + " LIMIT 1", "SELECT length('1') FROM " + bTableName + " LIMIT 1", "SELECT length('1234') FROM " + bTableName + " LIMIT 1", "SELECT length('\u025a\u0266\u0270\u0278') FROM " + bTableName + " LIMIT 1", "SELECT length('\u01e2\u01db\u01df\u0188') FROM " + bTableName + " LIMIT 1", "SELECT length('This is a test!') FROM " + bTableName + " LIMIT 1", "SELECT A_STRING FROM " + bTableName + " WHERE length(A_STRING)=3"};
        String[] result = new String[]{null, "1", "1", "4", "4", "4", "15", "abc"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpperFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT upper('abc') FROM " + bTableName + " LIMIT 1", "SELECT upper('Abc') FROM " + bTableName + " LIMIT 1", "SELECT upper('ABC') FROM " + bTableName + " LIMIT 1", "SELECT upper('\u010e\u010f\u0112') FROM " + bTableName + " LIMIT 1", "SELECT upper('\u00df') FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{"ABC", "ABC", "ABC", "\u010e\u010e\u0112", "SS"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLowerFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT lower('abc') FROM " + bTableName + " LIMIT 1", "SELECT lower('Abc') FROM " + bTableName + " LIMIT 1", "SELECT lower('ABC') FROM " + bTableName + " LIMIT 1", "SELECT lower('\u010e\u010f\u0112') FROM " + bTableName + " LIMIT 1", "SELECT lower('\u00df') FROM " + bTableName + " LIMIT 1", "SELECT lower('SS') FROM " + bTableName + " LIMIT 1"};
        String[] result = new String[]{"abc", "abc", "abc", "\u010f\u010f\u0113", "\u00df", "ss"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRTrimFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String varcharKeyTestTable = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT rtrim('') FROM " + bTableName + " LIMIT 1", "SELECT rtrim(' ') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('   ') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('abc') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('abc   ') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('abc   def') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('abc   def   ') FROM " + bTableName + " LIMIT 1", "SELECT rtrim('\u010e\u010f\u0112   ') FROM " + bTableName + " LIMIT 1", "SELECT pk FROM " + varcharKeyTestTable + " WHERE rtrim(pk)='jkl' LIMIT 1"};
        String[] result = new String[]{null, null, null, "abc", "abc", "abc   def", "abc   def", "\u010e\u010f\u0112", "jkl   "};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            VariableLengthPKIT.initVarcharKeyTableValues(null, varcharKeyTestTable);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLTrimFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String varcharKeyTestTable = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT ltrim('') FROM " + bTableName + " LIMIT 1", "SELECT ltrim(' ') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('   ') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('abc') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('   abc') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('abc   def') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('   abc   def') FROM " + bTableName + " LIMIT 1", "SELECT ltrim('   \u010e\u010f\u0112') FROM " + bTableName + " LIMIT 1", "SELECT pk FROM " + varcharKeyTestTable + " WHERE ltrim(pk)='def' LIMIT 1"};
        String[] result = new String[]{null, null, null, "abc", "abc", "abc   def", "abc   def", "\u010e\u010f\u0112", "   def"};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            VariableLengthPKIT.initVarcharKeyTableValues(null, varcharKeyTestTable);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }

    @Test
    public void testSubstrFunctionOnRowKeyInWhere() throws Exception {
        String substrTestTableName = VariableLengthPKIT.generateUniqueName();
        String url = VariableLengthPKIT.getUrl();
        Connection conn = DriverManager.getConnection(url);
        conn.createStatement().execute("CREATE TABLE " + substrTestTableName + " (s1 varchar not null, s2 varchar not null constraint pk primary key(s1,s2))");
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abc','a')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd','b')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abce','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcde','d')");
        conn.commit();
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        ResultSet rs = conn.createStatement().executeQuery("SELECT s1 from " + substrTestTableName + " where substr(s1,1,4) = 'abcd'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcde", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testRTrimFunctionOnRowKeyInWhere() throws Exception {
        String substrTestTableName = VariableLengthPKIT.generateUniqueName();
        String url = VariableLengthPKIT.getUrl();
        Connection conn = DriverManager.getConnection(url);
        conn.createStatement().execute("CREATE TABLE " + substrTestTableName + " (s1 varchar not null, s2 varchar not null constraint pk primary key(s1,s2))");
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abc','a')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd','b')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd ','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd  ','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd  a','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcde','d')");
        conn.commit();
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        ResultSet rs = conn.createStatement().executeQuery("SELECT s1 from " + substrTestTableName + " where rtrim(s1) = 'abcd'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcd", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcd ", (Object)rs.getString(1));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcd  ", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testLikeFunctionOnRowKeyInWhere() throws Exception {
        String substrTestTableName = VariableLengthPKIT.generateUniqueName();
        String url = VariableLengthPKIT.getUrl();
        Connection conn = DriverManager.getConnection(url);
        conn.createStatement().execute("CREATE TABLE " + substrTestTableName + " (s1 varchar not null, s2 varchar not null constraint pk primary key(s1,s2))");
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abc','a')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd','b')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd-','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abcd-1','c')");
        conn.createStatement().execute("UPSERT INTO " + substrTestTableName + " VALUES('abce','d')");
        conn.commit();
        conn.close();
        url = VariableLengthPKIT.getUrl();
        conn = DriverManager.getConnection(url);
        ResultSet rs = conn.createStatement().executeQuery("SELECT s1 from " + substrTestTableName + " where s1 like 'abcd%1'");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"abcd-1", (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrimFunction() throws Exception {
        String bTableName = VariableLengthPKIT.generateUniqueName();
        String varcharKeyTestTable = VariableLengthPKIT.generateUniqueName();
        String[] query = new String[]{"SELECT trim('') FROM " + bTableName + " LIMIT 1", "SELECT trim(' ') FROM " + bTableName + " LIMIT 1", "SELECT trim('   ') FROM " + bTableName + " LIMIT 1", "SELECT trim('abc') FROM " + bTableName + " LIMIT 1", "SELECT trim('   abc') FROM " + bTableName + " LIMIT 1", "SELECT trim('abc   ') FROM " + bTableName + " LIMIT 1", "SELECT trim('abc   def') FROM " + bTableName + " LIMIT 1", "SELECT trim('   abc   def') FROM " + bTableName + " LIMIT 1", "SELECT trim('abc   def   ') FROM " + bTableName + " LIMIT 1", "SELECT trim('   abc   def   ') FROM " + bTableName + " LIMIT 1", "SELECT trim('   \u010e\u010f\u0112   ') FROM " + bTableName + " LIMIT 1", "SELECT pk FROM " + varcharKeyTestTable + " WHERE trim(pk)='ghi'"};
        String[] result = new String[]{null, null, null, "abc", "abc", "abc", "abc   def", "abc   def", "abc   def", "abc   def", "\u010e\u010f\u0112", "   ghi   "};
        Assert.assertEquals((long)query.length, (long)result.length);
        String url = VariableLengthPKIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            VariableLengthPKIT.initBTableValues(null, bTableName);
            VariableLengthPKIT.initVarcharKeyTableValues(null, varcharKeyTestTable);
            for (int i = 0; i < query.length; ++i) {
                PreparedStatement statement = conn.prepareStatement(query[i]);
                ResultSet rs = statement.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((String)query[i], (Object)result[i], (Object)rs.getString(1));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

