/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class UseSchemaIT
extends ParallelStatsDisabledIT {
    @Test
    public void testUseSchemaCaseInsensitive() throws Exception {
        String schemaName = UseSchemaIT.generateUniqueName();
        this.testUseSchema(schemaName);
    }

    @Test
    public void testUseSchemaCaseSensitive() throws Exception {
        String schemaName = UseSchemaIT.generateUniqueName();
        this.testUseSchema("\"" + schemaName + "\"");
    }

    public void testUseSchema(String schema) throws Exception {
        Properties props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(UseSchemaIT.getUrl(), props);
        String ddl = "CREATE SCHEMA IF NOT EXISTS " + schema;
        conn.createStatement().execute(ddl);
        String testTable = UseSchemaIT.generateUniqueName();
        ddl = "create table " + schema + "." + testTable + "(id varchar primary key)";
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("use " + schema);
        String query = "select count(*) from " + testTable;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)0L, (long)rs.getInt(1));
        try {
            conn.createStatement().execute("use " + testTable);
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.SCHEMA_NOT_FOUND.getErrorCode(), (long)e.getErrorCode());
        }
        conn.createStatement().execute("use default");
        ddl = "create table IF NOT EXISTS " + testTable + "(schema_name varchar primary key)";
        conn.createStatement().execute(ddl);
        conn.createStatement().executeUpdate("upsert into " + testTable + " values('" + "default" + "')");
        conn.commit();
        rs = conn.createStatement().executeQuery("select schema_name from " + testTable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"default", (Object)rs.getString(1));
        conn.close();
    }

    @Test
    public void testSchemaInJdbcUrl() throws Exception {
        Properties props = new Properties();
        String schema = UseSchemaIT.generateUniqueName();
        props.setProperty("phoenix.connection.schema", schema);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(UseSchemaIT.getUrl(), props);
        conn.setAutoCommit(true);
        String ddl = "CREATE SCHEMA IF NOT EXISTS " + schema;
        conn.createStatement().execute(ddl);
        String testTable = UseSchemaIT.generateUniqueName();
        ddl = "create table IF NOT EXISTS " + schema + "." + testTable + " (schema_name varchar primary key)";
        conn.createStatement().execute(ddl);
        conn.createStatement().executeUpdate("upsert into " + schema + "." + testTable + " values('" + schema + "')");
        String query = "select schema_name from " + testTable;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)schema, (Object)rs.getString(1));
        schema = UseSchemaIT.generateUniqueName();
        ddl = "CREATE SCHEMA " + schema;
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("use " + schema);
        ddl = "create table " + testTable + "(schema_name varchar primary key)";
        conn.createStatement().execute(ddl);
        conn.createStatement().executeUpdate("upsert into " + testTable + " values('" + schema + "')");
        rs = conn.createStatement().executeQuery("select schema_name from " + testTable);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)schema, (Object)rs.getString(1));
        conn.createStatement().execute("DROP TABLE " + testTable);
        conn.close();
    }

    @Test
    public void testSequences() throws Exception {
        Properties props = new Properties();
        String schema = UseSchemaIT.generateUniqueName();
        props.setProperty("phoenix.connection.schema", schema);
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        Connection conn = DriverManager.getConnection(UseSchemaIT.getUrl(), props);
        conn.setAutoCommit(true);
        String ddl = "CREATE SCHEMA IF NOT EXISTS " + schema;
        conn.createStatement().execute(ddl);
        String sequenceName = UseSchemaIT.generateUniqueName();
        ddl = "create SEQUENCE " + schema + "." + sequenceName + " START WITH 100 INCREMENT BY 2 CACHE 10";
        conn.createStatement().execute(ddl);
        String query = "SELECT NEXT VALUE FOR " + schema + "." + sequenceName;
        ResultSet rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        conn.createStatement().execute("DROP Sequence " + schema + "." + sequenceName);
        schema = UseSchemaIT.generateUniqueName();
        sequenceName = UseSchemaIT.generateUniqueName();
        ddl = "CREATE SCHEMA " + schema;
        conn.createStatement().execute(ddl);
        conn.createStatement().execute("use " + schema);
        ddl = "create SEQUENCE " + sequenceName + " START WITH 100 INCREMENT BY 2 CACHE 10";
        conn.createStatement().execute(ddl);
        query = "SELECT NEXT VALUE FOR " + sequenceName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        query = "SELECT CURRENT VALUE FOR " + sequenceName;
        rs = conn.createStatement().executeQuery(query);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"100", (Object)rs.getString(1));
        conn.createStatement().execute("DROP Sequence " + sequenceName);
        conn.close();
    }

    @Test
    public void testMappedView() throws Exception {
        Properties props = new Properties();
        String schema = UseSchemaIT.generateUniqueName();
        String tableName = UseSchemaIT.generateUniqueName();
        String fullTablename = schema + "." + tableName;
        props.setProperty("phoenix.connection.schema", schema);
        Connection conn = DriverManager.getConnection(UseSchemaIT.getUrl(), props);
        Admin admin = driver.getConnectionQueryServices(UseSchemaIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        admin.createNamespace(NamespaceDescriptor.create((String)schema).build());
        admin.createTable(TableDescriptorBuilder.newBuilder((TableName)TableName.valueOf((String)fullTablename)).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES)).build());
        Put put = new Put(PVarchar.INSTANCE.toBytes((Object)fullTablename));
        put.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, QueryConstants.EMPTY_COLUMN_VALUE_BYTES);
        Table phoenixSchematable = admin.getConnection().getTable(TableName.valueOf((String)fullTablename));
        phoenixSchematable.put(put);
        phoenixSchematable.close();
        conn.createStatement().execute("CREATE VIEW " + tableName + " (tablename VARCHAR PRIMARY KEY)");
        ResultSet rs = conn.createStatement().executeQuery("select tablename from " + tableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)fullTablename, (Object)rs.getString(1));
        admin.close();
        conn.close();
    }
}

