/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Properties;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.monitoring.GlobalClientMetrics;
import org.apache.phoenix.monitoring.GlobalMetric;
import org.apache.phoenix.schema.types.PInteger;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.EnvironmentEdgeManager;
import org.apache.phoenix.util.PhoenixRuntime;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class UpsertSelectIT
extends ParallelStatsDisabledIT {
    private final String allowServerSideMutations;

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        HashMap props = Maps.newHashMapWithExpectedSize((int)1);
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600));
        props.put("phoenix.task.handling.interval.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        UpsertSelectIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    public UpsertSelectIT(String allowServerSideMutations) {
        this.allowServerSideMutations = allowServerSideMutations;
    }

    @Before
    public void setup() {
        Assert.assertTrue((boolean)PhoenixRuntime.areGlobalClientMetricsBeingCollected());
        for (GlobalMetric m : PhoenixRuntime.getGlobalPhoenixClientMetrics()) {
            m.reset();
        }
    }

    @After
    public void assertNoConnLeak() throws Exception {
        boolean refCountLeaked = UpsertSelectIT.isAnyStoreRefCountLeaked();
        Assert.assertTrue((boolean)PhoenixRuntime.areGlobalClientMetricsBeingCollected());
        Assert.assertEquals((long)0L, (long)GlobalClientMetrics.GLOBAL_OPEN_PHOENIX_CONNECTIONS.getMetric().getValue());
        Assert.assertFalse((String)"refCount leaked", (boolean)refCountLeaked);
    }

    @Parameterized.Parameters(name="UpsertSelecttIT_allowServerSideMutations={0}")
    public static synchronized Object[] data() {
        return new Object[]{"true", "false"};
    }

    @Test
    public void testUpsertSelectWithNoIndex() throws Exception {
        this.testUpsertSelect(false, false);
    }

    @Test
    public void testUpsertSelectWithIndex() throws Exception {
        this.testUpsertSelect(true, false);
    }

    @Test
    public void testUpsertSelectWithIndexWithSalt() throws Exception {
        this.testUpsertSelect(true, true);
    }

    @Test
    public void testUpsertSelectWithNoIndexWithSalt() throws Exception {
        this.testUpsertSelect(false, true);
    }

    private void testUpsertSelect(boolean createIndex, boolean saltTable) throws Exception {
        Object rs2;
        PreparedStatement statement2;
        Throwable throwable;
        Connection conn;
        Object ddl2;
        Throwable throwable2;
        Object stmt;
        String tenantId = UpsertSelectIT.getOrganizationId();
        byte[][] splits = UpsertSelectIT.getDefaultSplits(tenantId);
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String aTable = UpsertSelectIT.initATableValues(tenantId, saltTable ? (byte[][])null : splits, null, null, UpsertSelectIT.getUrl(), saltTable ? "salt_buckets = 2" : null);
        String customEntityTable = UpsertSelectIT.generateUniqueName();
        try (Connection conn2 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn2.createStatement();
            throwable2 = null;
            try {
                ddl2 = "create table " + customEntityTable + "   (organization_id char(15) not null, \n    key_prefix char(3) not null,\n    custom_entity_data_id char(12) not null,\n    created_by varchar,\n    created_date date,\n    currency_iso_code char(3),\n    deleted char(1),\n    division decimal(31,10),\n    last_activity date,\n    last_update date,\n    last_update_by varchar,\n    name varchar(240),\n    owner varchar,\n    record_type_id char(15),\n    setup_owner varchar,\n    system_modstamp date,\n    b.val0 varchar,\n    b.val1 varchar,\n    b.val2 varchar,\n    b.val3 varchar,\n    b.val4 varchar,\n    b.val5 varchar,\n    b.val6 varchar,\n    b.val7 varchar,\n    b.val8 varchar,\n    b.val9 varchar\n    CONSTRAINT pk PRIMARY KEY (organization_id, key_prefix, custom_entity_data_id)) " + (saltTable ? "salt_buckets = 2" : "");
                stmt.execute((String)ddl2);
            }
            catch (Throwable ddl2) {
                throwable2 = ddl2;
                throw ddl2;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable ddl2) {
                            throwable2.addSuppressed(ddl2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        String indexName = UpsertSelectIT.generateUniqueName();
        if (createIndex) {
            conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
            stmt = null;
            try {
                Statement stmt2 = conn.createStatement();
                ddl2 = null;
                try {
                    stmt2.execute("CREATE INDEX IF NOT EXISTS " + indexName + " ON " + aTable + "(a_string)");
                }
                catch (Throwable throwable3) {
                    ddl2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (stmt2 != null) {
                        if (ddl2 != null) {
                            try {
                                stmt2.close();
                            }
                            catch (Throwable throwable4) {
                                ((Throwable)ddl2).addSuppressed(throwable4);
                            }
                        } else {
                            stmt2.close();
                        }
                    }
                }
            }
            catch (Throwable stmt2) {
                stmt = stmt2;
                throw stmt2;
            }
            finally {
                if (conn != null) {
                    if (stmt != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable stmt2) {
                            ((Throwable)stmt).addSuppressed(stmt2);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        props.setProperty("UpsertBatchSize", Integer.toString(3));
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        stmt = null;
        try {
            PreparedStatement upsertStmt;
            conn.setAutoCommit(true);
            String upsert = "UPSERT INTO " + customEntityTable + "(custom_entity_data_id, key_prefix, organization_id, created_by) SELECT substr(entity_id, 4), substr(entity_id, 1, 3), organization_id, a_string  FROM " + aTable + " WHERE ?=a_string";
            if (createIndex) {
                upsertStmt = conn.prepareStatement("EXPLAIN " + upsert);
                throwable = null;
                try {
                    upsertStmt.setString(1, tenantId);
                    ResultSet ers = upsertStmt.executeQuery();
                    Assert.assertTrue((boolean)ers.next());
                    String explainPlan = QueryUtil.getExplainPlan((ResultSet)ers);
                    Assert.assertTrue((boolean)explainPlan.contains(" SCAN OVER " + indexName));
                }
                catch (Throwable ers) {
                    throwable = ers;
                    throw ers;
                }
                finally {
                    if (upsertStmt != null) {
                        if (throwable != null) {
                            try {
                                upsertStmt.close();
                            }
                            catch (Throwable ers) {
                                throwable.addSuppressed(ers);
                            }
                        } else {
                            upsertStmt.close();
                        }
                    }
                }
            }
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                upsertStmt.setString(1, "a");
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
                Assert.assertEquals((long)4L, (long)upsertStmt.getUpdateCount());
                Assert.assertNull((Object)upsertStmt.getResultSet());
            }
            catch (Throwable rowsInserted) {
                throwable = rowsInserted;
                throw rowsInserted;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable rowsInserted) {
                            throwable.addSuppressed(rowsInserted);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            conn.commit();
        }
        catch (Throwable throwable5) {
            stmt = throwable5;
            throw throwable5;
        }
        finally {
            if (conn != null) {
                if (stmt != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable6) {
                        ((Throwable)stmt).addSuppressed(throwable6);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String query = "SELECT key_prefix, substr(custom_entity_data_id, 1, 1), created_by FROM " + customEntityTable + " WHERE organization_id = ? ";
        throwable2 = null;
        try (Connection conn3 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            statement2 = conn3.prepareStatement(query);
            throwable = null;
            try {
                statement2.setString(1, tenantId);
                rs2 = statement2.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"1", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"2", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"3", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"4", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable rs2) {
                throwable = rs2;
                throw rs2;
            }
            finally {
                if (statement2 != null) {
                    if (throwable != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable rs2) {
                            throwable.addSuppressed(rs2);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Throwable statement2) {
            throwable2 = statement2;
            throw statement2;
        }
        conn3 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            conn3.setAutoCommit(true);
            String upsert = "UPSERT INTO " + customEntityTable + "(custom_entity_data_id, key_prefix, organization_id, last_update_by, division) SELECT custom_entity_data_id, key_prefix, organization_id, created_by, 1.0  FROM " + customEntityTable + " WHERE organization_id = ? and created_by >= 'a'";
            PreparedStatement upsertStmt = conn3.prepareStatement(upsert);
            rs2 = null;
            try {
                upsertStmt.setString(1, tenantId);
                Assert.assertEquals((long)4L, (long)upsertStmt.executeUpdate());
            }
            catch (Throwable throwable7) {
                rs2 = throwable7;
                throw throwable7;
            }
            finally {
                if (upsertStmt != null) {
                    if (rs2 != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable8) {
                            ((Throwable)rs2).addSuppressed(throwable8);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            conn3.commit();
        }
        catch (Throwable upsert) {
            throwable2 = upsert;
            throw upsert;
        }
        finally {
            if (conn3 != null) {
                if (throwable2 != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable upsert) {
                        throwable2.addSuppressed(upsert);
                    }
                } else {
                    conn3.close();
                }
            }
        }
        query = "SELECT key_prefix, substr(custom_entity_data_id, 1, 1), created_by, last_update_by, division FROM " + customEntityTable + " WHERE organization_id = ?";
        conn3 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            statement2 = conn3.prepareStatement(query);
            throwable = null;
            try {
                statement2.setString(1, tenantId);
                rs2 = statement2.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"1", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs2.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"2", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs2.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"3", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs2.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"00A", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"4", (Object)rs2.getString(2));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(3));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(4));
                Assert.assertTrue((BigDecimal.valueOf(1.0).compareTo(rs2.getBigDecimal(5)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                if (statement2 != null) {
                    if (throwable != null) {
                        try {
                            statement2.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        statement2.close();
                    }
                }
            }
        }
        catch (Throwable throwable11) {
            throwable2 = throwable11;
            throw throwable11;
        }
        finally {
            if (conn3 != null) {
                if (throwable2 != null) {
                    try {
                        conn3.close();
                    }
                    catch (Throwable throwable12) {
                        throwable2.addSuppressed(throwable12);
                    }
                } else {
                    conn3.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectEmptyPKColumn() throws Exception {
        Throwable throwable;
        PreparedStatement statement3;
        ResultSet rs;
        Throwable throwable2;
        int rowsInserted;
        Object upsertStmt;
        String upsert;
        String tenantId = UpsertSelectIT.getOrganizationId();
        String aTable = UpsertSelectIT.initATableValues(tenantId, UpsertSelectIT.getDefaultSplits(tenantId));
        String ptsdbTable = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.ensureTableCreated(UpsertSelectIT.getUrl(), ptsdbTable, "PTSDB");
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            conn.setAutoCommit(false);
            upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host) SELECT current_date(), x_integer+2, entity_id FROM " + aTable + " WHERE a_integer >= ?";
            upsertStmt = conn.prepareStatement(upsert);
            Throwable throwable3 = null;
            try {
                upsertStmt.setInt(1, 6);
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
            }
            catch (Throwable throwable4) {
                throwable3 = throwable4;
                throw throwable4;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable3 != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable3.addSuppressed(throwable5);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            conn.commit();
        }
        String query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable;
        Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        upsertStmt = null;
        try {
            throwable2 = null;
            try (PreparedStatement statement2 = conn.prepareStatement(query);){
                rs = statement2.executeQuery();
                Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(7L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(6L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(5L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable now) {
                throwable2 = now;
                throw now;
            }
        }
        catch (Throwable statement2) {
            upsertStmt = statement2;
            throw statement2;
        }
        finally {
            if (conn != null) {
                if (upsertStmt != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable statement2) {
                        ((Throwable)upsertStmt).addSuppressed(statement2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        upsertStmt = null;
        try {
            conn.setAutoCommit(true);
            upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, inst) SELECT \"DATE\"+1, val*10, host FROM " + ptsdbTable;
            throwable2 = null;
            try (PreparedStatement upsertStmt2 = conn.prepareStatement(upsert);){
                rowsInserted = upsertStmt2.executeUpdate();
                Assert.assertEquals((long)4L, (long)rowsInserted);
            }
            catch (Throwable now) {
                throwable2 = now;
                throw now;
            }
            conn.commit();
        }
        catch (Throwable upsertStmt2) {
            upsertStmt = upsertStmt2;
            throw upsertStmt2;
        }
        finally {
            if (conn != null) {
                if (upsertStmt != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable upsertStmt2) {
                        ((Throwable)upsertStmt).addSuppressed(upsertStmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
        Date then = new Date(now.getTime() + 86400000L);
        query = "SELECT host,inst, \"DATE\",val FROM " + ptsdbTable + " where inst is not null";
        throwable2 = null;
        try (Connection conn2 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            statement3 = conn2.prepareStatement(query);
            throwable = null;
            try {
                rs = statement3.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(70L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(60L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(50L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (statement3 != null) {
                    if (throwable != null) {
                        try {
                            statement3.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        statement3.close();
                    }
                }
            }
        }
        catch (Throwable statement3) {
            throwable2 = statement3;
            throw statement3;
        }
        conn2 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            conn2.setAutoCommit(true);
            upsert = "UPSERT INTO " + ptsdbTable + " SELECT * FROM " + ptsdbTable;
            throwable = null;
            try (PreparedStatement upsertStmt3 = conn2.prepareStatement(upsert);){
                rowsInserted = upsertStmt3.executeUpdate();
                Assert.assertEquals((long)8L, (long)rowsInserted);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            conn2.commit();
        }
        catch (Throwable upsertStmt3) {
            throwable2 = upsertStmt3;
            throw upsertStmt3;
        }
        finally {
            if (conn2 != null) {
                if (throwable2 != null) {
                    try {
                        conn2.close();
                    }
                    catch (Throwable upsertStmt3) {
                        throwable2.addSuppressed(upsertStmt3);
                    }
                } else {
                    conn2.close();
                }
            }
        }
        query = "SELECT * FROM " + ptsdbTable;
        conn2 = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            statement3 = conn2.prepareStatement(query);
            throwable = null;
            try {
                rs = statement3.executeQuery();
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(7L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(6L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals(null, (Object)rs.getString(1));
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(5L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00B623122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertEquals(null, (Object)rs.getBigDecimal(4));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00B723122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(70L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00B823122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(60L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"00C923122312312", (Object)rs.getString(1));
                Assert.assertEquals(null, (Object)rs.getString(2));
                Assert.assertTrue((rs.getDate(3).after(now) && rs.getDate(3).before(then) ? 1 : 0) != 0);
                Assert.assertTrue((BigDecimal.valueOf(50L).compareTo(rs.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable9) {
                throwable = throwable9;
                throw throwable9;
            }
            finally {
                if (statement3 != null) {
                    if (throwable != null) {
                        try {
                            statement3.close();
                        }
                        catch (Throwable throwable10) {
                            throwable.addSuppressed(throwable10);
                        }
                    } else {
                        statement3.close();
                    }
                }
            }
        }
        catch (Throwable throwable11) {
            throwable2 = throwable11;
            throw throwable11;
        }
        finally {
            if (conn2 != null) {
                if (throwable2 != null) {
                    try {
                        conn2.close();
                    }
                    catch (Throwable throwable12) {
                        throwable2.addSuppressed(throwable12);
                    }
                } else {
                    conn2.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectForAggAutoCommit() throws Exception {
        this.testUpsertSelectForAgg(true);
    }

    @Test
    public void testUpsertSelectForAgg() throws Exception {
        this.testUpsertSelectForAgg(false);
    }

    private void testUpsertSelectForAgg(boolean autoCommit) throws Exception {
        Object rs2;
        PreparedStatement statement;
        Throwable throwable;
        String tenantId = UpsertSelectIT.getOrganizationId();
        String aTable = UpsertSelectIT.initATableValues(tenantId, UpsertSelectIT.getDefaultSplits(tenantId));
        String ptsdbTable = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.ensureTableCreated(UpsertSelectIT.getUrl(), ptsdbTable, "PTSDB");
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            conn.setAutoCommit(autoCommit);
            String upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host) SELECT current_date(), sum(a_integer), a_string FROM " + aTable + " GROUP BY a_string";
            throwable = null;
            try (PreparedStatement upsertStmt = conn.prepareStatement(upsert);){
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)3L, (long)rowsInserted);
            }
            catch (Throwable rowsInserted) {
                throwable = rowsInserted;
                throw rowsInserted;
            }
            if (!autoCommit) {
                conn.commit();
            }
        }
        String query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            statement = conn.prepareStatement(query);
            throwable = null;
            try {
                rs2 = statement.executeQuery();
                Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals(null, (Object)rs2.getString(1));
                Assert.assertEquals((Object)"a", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(10L).compareTo(rs2.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals(null, (Object)rs2.getString(1));
                Assert.assertEquals((Object)"b", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(26L).compareTo(rs2.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals(null, (Object)rs2.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(9L).compareTo(rs2.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable rs2) {
                throwable = rs2;
                throw rs2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable rs2) {
                            throwable.addSuppressed(rs2);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_8 = null;
        try {
            conn.setAutoCommit(true);
            String upsert = "UPSERT INTO " + ptsdbTable + "(\"DATE\", val, host, inst) SELECT current_date(), max(val), max(host), 'x' FROM " + ptsdbTable;
            PreparedStatement upsertStmt = conn.prepareStatement(upsert);
            rs2 = null;
            try {
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            catch (Throwable rowsInserted) {
                rs2 = rowsInserted;
                throw rowsInserted;
            }
            finally {
                if (upsertStmt != null) {
                    if (rs2 != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable rowsInserted) {
                            ((Throwable)rs2).addSuppressed(rowsInserted);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            if (!autoCommit) {
                conn.commit();
            }
        }
        catch (Throwable upsert) {
            var8_8 = upsert;
            throw upsert;
        }
        finally {
            if (conn != null) {
                if (var8_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable upsert) {
                        var8_8.addSuppressed(upsert);
                    }
                } else {
                    conn.close();
                }
            }
        }
        query = "SELECT inst,host,\"DATE\",val FROM " + ptsdbTable + " WHERE inst='x'";
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_8 = null;
        try {
            statement = conn.prepareStatement(query);
            throwable = null;
            try {
                rs2 = statement.executeQuery();
                Date now = new Date(EnvironmentEdgeManager.currentTimeMillis());
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"x", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"c", (Object)rs2.getString(2));
                Assert.assertTrue((boolean)rs2.getDate(3).before(now));
                Assert.assertTrue((BigDecimal.valueOf(26L).compareTo(rs2.getBigDecimal(4)) == 0 ? 1 : 0) != 0);
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var8_8 = throwable4;
            throw throwable4;
        }
        finally {
            if (conn != null) {
                if (var8_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable5) {
                        var8_8.addSuppressed(throwable5);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectLongToInt() throws Exception {
        int rowsInserted;
        Throwable throwable;
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.ensureTableCreated(UpsertSelectIT.getUrl(), tableName, "IntKeyTest", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + "  select i+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var7_6 = null;
        try {
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var7_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var7_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var7_6.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String select = "SELECT i FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectRunOnServer() throws Exception {
        PreparedStatement upsertStmt3;
        ResultSet rs;
        Throwable throwable;
        Statement stmt;
        int rowsInserted;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.createTestTable(UpsertSelectIT.getUrl(), "create table " + tableName + " (i integer not null primary key desc, j integer)", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1, 1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             PreparedStatement upsertStmt2 = conn.prepareStatement(upsert);){
            rowsInserted = upsertStmt2.executeUpdate();
            Assert.assertEquals((long)1L, (long)rowsInserted);
            conn.commit();
        }
        String select = "SELECT i,j+1 FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                Assert.assertEquals((long)2L, (long)rs.getInt(2));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + "(i,j) select i, j+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_7 = null;
        try {
            conn.setAutoCommit(true);
            upsertStmt3 = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt3.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (upsertStmt3 != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        upsertStmt3.close();
                    }
                }
            }
        }
        catch (Throwable upsertStmt3) {
            var9_7 = upsertStmt3;
            throw upsertStmt3;
        }
        finally {
            if (conn != null) {
                if (var9_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable upsertStmt3) {
                        var9_7.addSuppressed(upsertStmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        select = "SELECT j FROM " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_7 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var9_7 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var9_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var9_7.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + "(i,j) select i, i from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_7 = null;
        try {
            conn.setAutoCommit(true);
            upsertStmt3 = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt3.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (upsertStmt3 != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt3.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        upsertStmt3.close();
                    }
                }
            }
        }
        catch (Throwable upsertStmt4) {
            var9_7 = upsertStmt4;
            throw upsertStmt4;
        }
        finally {
            if (conn != null) {
                if (var9_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable upsertStmt4) {
                        var9_7.addSuppressed(upsertStmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        select = "SELECT j FROM " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_7 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery(select);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getInt(1));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable12) {
            var9_7 = throwable12;
            throw throwable12;
        }
        finally {
            if (conn != null) {
                if (var9_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable13) {
                        var9_7.addSuppressed(throwable13);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectOnDescToAsc() throws Exception {
        int rowsInserted;
        Throwable throwable;
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.createTestTable(UpsertSelectIT.getUrl(), "create table " + tableName + " (i integer not null primary key desc, j integer)", splits, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(1, 1)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
                conn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + " (i,j) select i+1, j+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_6 = null;
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)1L, (long)rowsInserted);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            conn.commit();
        }
        catch (Throwable throwable6) {
            var8_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var8_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var8_6.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String select = "SELECT i,j FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            Assert.assertEquals((long)2L, (long)rs.getInt(2));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectRowKeyMutationOnSplitedTable() throws Exception {
        Throwable throwable;
        PreparedStatement upsertStmt;
        byte[][] splits = new byte[][]{PInteger.INSTANCE.toBytes((Object)1), PInteger.INSTANCE.toBytes((Object)2), PInteger.INSTANCE.toBytes((Object)3), PInteger.INSTANCE.toBytes((Object)4)};
        String tableName = UpsertSelectIT.generateUniqueName();
        UpsertSelectIT.ensureTableCreated(UpsertSelectIT.getUrl(), tableName, "IntKeyTest", splits, null, null);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String upsert = "UPSERT INTO " + tableName + " VALUES(?)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                upsertStmt.setInt(1, 1);
                upsertStmt.executeUpdate();
                upsertStmt.setInt(1, 3);
                upsertStmt.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
        }
        upsert = "UPSERT INTO " + tableName + " (i) SELECT i+1 from " + tableName;
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_6 = null;
        try {
            conn.setAutoCommit(true);
            upsertStmt = conn.prepareStatement(upsert);
            throwable = null;
            try {
                int rowsInserted = upsertStmt.executeUpdate();
                Assert.assertEquals((long)2L, (long)rowsInserted);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (upsertStmt != null) {
                    if (throwable != null) {
                        try {
                            upsertStmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        upsertStmt.close();
                    }
                }
            }
            conn.commit();
        }
        catch (Throwable throwable6) {
            var8_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var8_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var8_6.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String select = "SELECT i FROM " + tableName;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            ResultSet rs = stmt.executeQuery(select);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpsertSelectWithLimit() throws Exception {
        ResultSet rs;
        Throwable throwable;
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String tableName = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("create table " + tableName + " (id varchar(10) not null primary key, val varchar(10), ts timestamp)");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + tableName + " values ('aaa', 'abc', current_date())");
                stmt.execute("upsert into " + tableName + " values ('bbb', 'bcd', current_date())");
                stmt.execute("upsert into " + tableName + " values ('ccc', 'cde', current_date())");
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var5_4 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var5_4.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery("select * from " + tableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"bbb", (Object)rs.getString(1));
                Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"ccc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"cde", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var5_4 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var5_4.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + tableName + " (id, ts) select id, CAST(null AS timestamp) from " + tableName + " where id <= 'bbb' limit 1");
                conn.commit();
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            var5_4 = stmt4;
            throw stmt4;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt4) {
                        var5_4.addSuppressed(stmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery("select * from " + tableName);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"aaa", (Object)rs.getString(1));
                Assert.assertEquals((Object)"abc", (Object)rs.getString(2));
                Assert.assertNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"bbb", (Object)rs.getString(1));
                Assert.assertEquals((Object)"bcd", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"ccc", (Object)rs.getString(1));
                Assert.assertEquals((Object)"cde", (Object)rs.getString(2));
                Assert.assertNotNull((Object)rs.getDate(3));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable10) {
                throwable = throwable10;
                throw throwable10;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable11) {
                            throwable.addSuppressed(throwable11);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable12) {
            var5_4 = throwable12;
            throw throwable12;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable13) {
                        var5_4.addSuppressed(throwable13);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectWithOrderBy() throws Exception {
        Throwable throwable;
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        props.setProperty("phoenix.connection.autoCommit", "true");
        String uniqueName = UpsertSelectIT.generateUniqueName();
        String tableName1 = uniqueName + "_1";
        String tableName2 = uniqueName + "_2";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("create table " + tableName1 + " (c1 char(3) not null primary key, c2 char(3), c3 char(3)) SALT_BUCKETS=16");
                stmt.execute("create table " + tableName2 + " (cc1 char(3) not null primary key, cc2 char(3), cc3 char(3)) SALT_BUCKETS=16");
                conn.commit();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                int maxNums = 512;
                for (int i = 0; i <= maxNums; ++i) {
                    String c1Val = String.format("%03d", i);
                    String c3Val = String.format("%03d", maxNums - i);
                    stmt.execute("upsert into " + tableName1 + " values ('" + c1Val + "','a','" + c3Val + "')");
                }
                conn.commit();
            }
            catch (Throwable maxNums) {
                throwable = maxNums;
                throw maxNums;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable maxNums) {
                            throwable.addSuppressed(maxNums);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var6_6 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var6_6.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + tableName2 + "(cc1,cc2,cc3) select c2,c1,c3 from " + tableName1 + " order by c3");
                conn.commit();
            }
            catch (Throwable maxNums) {
                throwable = maxNums;
                throw maxNums;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable maxNums) {
                            throwable.addSuppressed(maxNums);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var6_6 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var6_6.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = stmt.executeQuery("select * from " + tableName2);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"a", (Object)rs.getString(1));
                Assert.assertEquals((Object)"000", (Object)rs.getString(2));
                Assert.assertEquals((Object)"512", (Object)rs.getString(3));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var6_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var6_6.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectWithSequence() throws Exception {
        Throwable throwable;
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectIT.generateUniqueName();
        String t2 = UpsertSelectIT.generateUniqueName();
        String seq = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("create table  " + t1 + " (id bigint not null primary key, v varchar)");
                stmt.execute("create table " + t2 + " (k varchar primary key)");
                stmt.execute("create sequence " + seq);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + t2 + " values ('a')");
                stmt.execute("upsert into " + t2 + " values ('b')");
                stmt.execute("upsert into " + t2 + " values ('c')");
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var6_6 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var6_6.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + t1 + " select next value for  " + seq + " , k from " + t2);
                conn.commit();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var6_6 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var6_6.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = stmt.executeQuery("select * from " + t1);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"a", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"b", (Object)rs.getString(2));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)3L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"c", (Object)rs.getString(2));
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable10) {
            var6_6 = throwable10;
            throw throwable10;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable11) {
                        var6_6.addSuppressed(throwable11);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectWithSequenceAndOrderByWithSalting() throws Exception {
        Throwable throwable;
        Statement stmt;
        int numOfRecords = 200;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectIT.generateUniqueName();
        String t2 = UpsertSelectIT.generateUniqueName();
        String ddl = "CREATE TABLE IF NOT EXISTS " + t1 + "(ORGANIZATION_ID CHAR(15) NOT NULL, QUERY_ID CHAR(15) NOT NULL, CURSOR_ORDER BIGINT NOT NULL, K1 INTEGER, V1 INTEGER CONSTRAINT MAIN_PK PRIMARY KEY (ORGANIZATION_ID, QUERY_ID, CURSOR_ORDER) ) SALT_BUCKETS = 4";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute(ddl);
                stmt.execute("CREATE TABLE " + t2 + "(ORGANIZATION_ID CHAR(15) NOT NULL, k1 integer NOT NULL, v1 integer NOT NULL CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, k1, v1) ) VERSIONS=1, SALT_BUCKETS = 4");
                stmt.execute("create sequence s cache 2147483647");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var7_7 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                for (int i = 0; i < numOfRecords; ++i) {
                    stmt.execute("UPSERT INTO " + t2 + " values ('00Dxx0000001gEH'," + i + "," + (i + 2) + ")");
                }
                conn.commit();
            }
            catch (Throwable i) {
                throwable = i;
                throw i;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable i) {
                            throwable.addSuppressed(i);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var7_7 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var7_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var7_7.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var7_7 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(true);
                stmt.execute("UPSERT INTO " + t1 + " SELECT '00Dxx0000001gEH', 'MyQueryId', NEXT VALUE FOR S, k1, v1  FROM " + t2 + " ORDER BY K1, V1");
            }
            catch (Throwable i) {
                throwable = i;
                throw i;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable i) {
                            throwable.addSuppressed(i);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var7_7 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var7_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var7_7.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var7_7 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                ResultSet rs = stmt.executeQuery("select count(*) from " + t1);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)numOfRecords, (long)rs.getLong(1));
                ResultSet rs2 = stmt.executeQuery("select cursor_order, k1, v1 from " + t1 + " order by cursor_order");
                long seq = 1L;
                while (rs2.next()) {
                    Assert.assertEquals((long)seq, (long)rs2.getLong("cursor_order"));
                    Assert.assertEquals((long)(seq - 1L), (long)rs2.getLong("k1"));
                    ++seq;
                }
                stmt.execute("drop sequence s");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var7_7 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var7_7 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var7_7.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectWithRowtimeStampColumn() throws Exception {
        ResultSet rs3;
        ResultSet rs22;
        Throwable throwable;
        PreparedStatement prepStmt2;
        Throwable throwable2;
        Statement stmt;
        String t1 = UpsertSelectIT.generateUniqueName();
        String t2 = UpsertSelectIT.generateUniqueName();
        String t3 = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl());
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + t1 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP )) ");
            stmt2.execute("CREATE TABLE " + t2 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + t3 + " (PK1 VARCHAR NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP )) ");
        }
        long rowTimestamp = EnvironmentEdgeManager.currentTimeMillis();
        Date rowTimestampDate = new Date(rowTimestamp);
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.prepareStatement("UPSERT INTO " + t1 + " (PK1, PK2, KV1) VALUES(?, ?, ?)");
            throwable2 = null;
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                stmt.setString(3, "KV1");
                stmt.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl());
        var9_15 = null;
        try {
            stmt = conn.createStatement();
            throwable2 = null;
            try {
                stmt.executeUpdate("UPSERT INTO " + t2 + " SELECT * FROM " + t1);
                conn.commit();
                prepStmt2 = conn.prepareStatement("SELECT * FROM " + t2 + " WHERE PK1 = ? AND PK2 = ?");
                throwable = null;
                try {
                    prepStmt2.setString(1, "PK1");
                    prepStmt2.setDate(2, rowTimestampDate);
                    rs22 = prepStmt2.executeQuery();
                    Assert.assertTrue((boolean)rs22.next());
                    Assert.assertEquals((Object)"PK1", (Object)rs22.getString("PK1"));
                    Assert.assertEquals((Object)rowTimestampDate, (Object)rs22.getDate("PK2"));
                    Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                }
                catch (Throwable rs22) {
                    throwable = rs22;
                    throw rs22;
                }
                finally {
                    if (prepStmt2 != null) {
                        if (throwable != null) {
                            try {
                                prepStmt2.close();
                            }
                            catch (Throwable rs22) {
                                throwable.addSuppressed(rs22);
                            }
                        } else {
                            prepStmt2.close();
                        }
                    }
                }
            }
            catch (Throwable prepStmt2) {
                throwable2 = prepStmt2;
                throw prepStmt2;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable prepStmt2) {
                            throwable2.addSuppressed(prepStmt2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var9_15 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var9_15.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        props.setProperty("CurrentSCN", Long.toString(rowTimestamp - 1L));
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_15 = null;
        try {
            stmt = conn.prepareStatement("SELECT * FROM " + t2 + " WHERE PK1 = ? AND PK2 = ?");
            throwable2 = null;
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                rs3 = stmt.executeQuery();
                Assert.assertFalse((boolean)rs3.next());
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            var9_15 = stmt4;
            throw stmt4;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt4) {
                        var9_15.addSuppressed(stmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl());
        var9_15 = null;
        try {
            stmt = conn.createStatement();
            throwable2 = null;
            try {
                stmt.executeUpdate("UPSERT INTO " + t3 + " SELECT * FROM " + t1);
                conn.commit();
                prepStmt2 = conn.prepareStatement("SELECT * FROM " + t3 + " WHERE PK1 = ? AND PK2 = ?");
                throwable = null;
                try {
                    prepStmt2.setString(1, "PK1");
                    prepStmt2.setDate(2, rowTimestampDate);
                    rs22 = prepStmt2.executeQuery();
                    Assert.assertTrue((boolean)rs22.next());
                    Assert.assertEquals((Object)"PK1", (Object)rs22.getString("PK1"));
                    Assert.assertEquals((Object)rowTimestampDate, (Object)rs22.getDate("PK2"));
                    Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (prepStmt2 != null) {
                        if (throwable != null) {
                            try {
                                prepStmt2.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            prepStmt2.close();
                        }
                    }
                }
            }
            catch (Throwable prepStmt3) {
                throwable2 = prepStmt3;
                throw prepStmt3;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable prepStmt3) {
                            throwable2.addSuppressed(prepStmt3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt5) {
            var9_15 = stmt5;
            throw stmt5;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt5) {
                        var9_15.addSuppressed(stmt5);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var9_15 = null;
        try {
            stmt = conn.prepareStatement("SELECT * FROM " + t3 + " WHERE PK1 = ? AND PK2 = ?");
            throwable2 = null;
            try {
                stmt.setString(1, "PK1");
                stmt.setDate(2, rowTimestampDate);
                rs3 = stmt.executeQuery();
                Assert.assertFalse((boolean)rs3.next());
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable9) {
            var9_15 = throwable9;
            throw throwable9;
        }
        finally {
            if (conn != null) {
                if (var9_15 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable10) {
                        var9_15.addSuppressed(throwable10);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectSameTableWithRowTimestampColumn() throws Exception {
        Throwable throwable;
        Statement stmt;
        String tableName = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + tableName + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP)) ");
        }
        long rowTimestamp = 100L;
        Date rowTimestampDate = new Date(rowTimestamp);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             PreparedStatement stmt3 = conn.prepareStatement("UPSERT INTO  " + tableName + " (PK1, PK2, KV1) VALUES(?, ?, ?)");){
            stmt3.setInt(1, 1);
            stmt3.setDate(2, rowTimestampDate);
            stmt3.setString(3, "KV1");
            stmt3.executeUpdate();
            conn.commit();
        }
        String seq = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("CREATE SEQUENCE " + seq);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_14 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.executeUpdate("UPSERT INTO  " + tableName + "  SELECT NEXT VALUE FOR " + seq + ", PK2 FROM  " + tableName);
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            var8_14 = stmt4;
            throw stmt4;
        }
        finally {
            if (conn != null) {
                if (var8_14 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt4) {
                        var8_14.addSuppressed(stmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_14 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(true);
                for (int i = 0; i < 10; ++i) {
                    int count = stmt.executeUpdate("UPSERT INTO  " + tableName + "  SELECT NEXT VALUE FOR " + seq + ", PK2 FROM  " + tableName);
                    Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)count);
                }
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable8) {
            var8_14 = throwable8;
            throw throwable8;
        }
        finally {
            if (conn != null) {
                if (var8_14 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable9) {
                        var8_14.addSuppressed(throwable9);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testAutomaticallySettingRowtimestamp() throws Exception {
        ResultSet rs2;
        Throwable throwable;
        PreparedStatement stmt4;
        Throwable throwable2;
        String table1 = UpsertSelectIT.generateUniqueName();
        String table2 = UpsertSelectIT.generateUniqueName();
        String table3 = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl());
             Statement stmt2 = conn.createStatement();){
            stmt2.execute("CREATE TABLE " + table1 + " (T1PK1 VARCHAR NOT NULL, T1PK2 DATE NOT NULL, T1KV1 VARCHAR, T1KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T1PK1, T1PK2 DESC ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + table2 + " (T2PK1 VARCHAR NOT NULL, T2PK2 DATE NOT NULL, T2KV1 VARCHAR, T2KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T2PK1, T2PK2 ROW_TIMESTAMP)) ");
            stmt2.execute("CREATE TABLE " + table3 + " (T3PK1 VARCHAR NOT NULL, T3PK2 DATE NOT NULL, T3KV1 VARCHAR, T3KV2 VARCHAR CONSTRAINT PK PRIMARY KEY(T3PK1, T3PK2 DESC ROW_TIMESTAMP)) ");
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            throwable2 = null;
            try (PreparedStatement stmt3 = conn.prepareStatement("UPSERT INTO  " + table1 + " (T1PK1, T1KV1, T1KV2) VALUES (?, ?, ?)");){
                stmt3.setString(1, "PK1");
                stmt3.setString(2, "KV1");
                stmt3.setString(3, "KV2");
                stmt3.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        throwable2 = null;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt4 = conn.prepareStatement("SELECT T1KV1, T1KV2 FROM " + table1 + " WHERE T1PK1 = ? AND T1PK2 >= ? AND T1PK2 <= ?");
            throwable = null;
            try {
                stmt4.setString(1, "PK1");
                stmt4.setDate(2, new Date(startTime));
                stmt4.setDate(3, new Date(endTime));
                rs2 = stmt4.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString(2));
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable rs2) {
                throwable = rs2;
                throw rs2;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable rs2) {
                            throwable.addSuppressed(rs2);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            throwable2 = stmt4;
            throw stmt4;
        }
        startTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            stmt4 = conn.prepareStatement("UPSERT INTO  " + table2 + " (T2PK1, T2KV1, T2KV2) SELECT T1PK1, T1KV1, T1KV2 FROM " + table1);
            throwable = null;
            try {
                stmt4.executeUpdate();
                conn.commit();
            }
            catch (Throwable rs2) {
                throwable = rs2;
                throw rs2;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable rs2) {
                            throwable.addSuppressed(rs2);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable stmt5) {
            throwable2 = stmt5;
            throw stmt5;
        }
        finally {
            if (conn != null) {
                if (throwable2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt5) {
                        throwable2.addSuppressed(stmt5);
                    }
                } else {
                    conn.close();
                }
            }
        }
        endTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            stmt4 = conn.prepareStatement("SELECT T2KV1, T2KV2 FROM " + table2 + " WHERE T2PK1 = ? AND T2PK2 >= ?  AND T2PK2 <= ?");
            throwable = null;
            try {
                stmt4.setString(1, "PK1");
                stmt4.setDate(2, new Date(startTime));
                stmt4.setDate(3, new Date(endTime));
                rs2 = stmt4.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString(2));
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable rs3) {
                throwable = rs3;
                throw rs3;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable rs3) {
                            throwable.addSuppressed(rs3);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable stmt6) {
            throwable2 = stmt6;
            throw stmt6;
        }
        finally {
            if (conn != null) {
                if (throwable2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt6) {
                        throwable2.addSuppressed(stmt6);
                    }
                } else {
                    conn.close();
                }
            }
        }
        startTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            stmt4 = conn.prepareStatement("UPSERT INTO  " + table3 + " (T3PK1, T3KV1, T3KV2) SELECT T2PK1, T2KV1, T2KV2 FROM " + table2);
            throwable = null;
            try {
                stmt4.executeUpdate();
                conn.commit();
            }
            catch (Throwable rs3) {
                throwable = rs3;
                throw rs3;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable rs3) {
                            throwable.addSuppressed(rs3);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable stmt7) {
            throwable2 = stmt7;
            throw stmt7;
        }
        finally {
            if (conn != null) {
                if (throwable2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt7) {
                        throwable2.addSuppressed(stmt7);
                    }
                } else {
                    conn.close();
                }
            }
        }
        endTime = EnvironmentEdgeManager.currentTimeMillis();
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        throwable2 = null;
        try {
            stmt4 = conn.prepareStatement("SELECT T3KV1, T3KV2 FROM " + table3 + " WHERE T3PK1 = ? AND T3PK2 >= ? AND T3PK2 <= ?");
            throwable = null;
            try {
                stmt4.setString(1, "PK1");
                stmt4.setDate(2, new Date(startTime));
                stmt4.setDate(3, new Date(endTime));
                rs2 = stmt4.executeQuery();
                Assert.assertTrue((boolean)rs2.next());
                Assert.assertEquals((Object)"KV1", (Object)rs2.getString(1));
                Assert.assertEquals((Object)"KV2", (Object)rs2.getString(2));
                Assert.assertFalse((boolean)rs2.next());
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt4 != null) {
                    if (throwable != null) {
                        try {
                            stmt4.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt4.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            throwable2 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (throwable2 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        throwable2.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectAutoCommitWithRowTimestampColumn() throws Exception {
        String[] tableNames;
        String tableName1 = UpsertSelectIT.generateUniqueName();
        String tableName2 = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String[] stringArray = null;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName1 + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 ROW_TIMESTAMP, PK3)) ");
            stmt.execute("CREATE TABLE " + tableName2 + " (PK1 INTEGER NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR CONSTRAINT PK PRIMARY KEY(PK1, PK2 DESC ROW_TIMESTAMP, PK3)) ");
        }
        catch (Throwable object) {
            stringArray = object;
            throw object;
        }
        for (String tableName : tableNames = new String[]{tableName1, tableName2}) {
            ResultSet rs2;
            Throwable throwable;
            Statement stmt4;
            Throwable throwable2;
            Throwable throwable3;
            long rowTimestamp1 = 100L;
            Date rowTimestampDate = new Date(rowTimestamp1);
            try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
                throwable3 = null;
                try (PreparedStatement stmt2 = conn.prepareStatement("UPSERT INTO  " + tableName + " (PK1, PK2, PK3, KV1) VALUES(?, ?, ?, ?)");){
                    stmt2.setInt(1, 1);
                    stmt2.setDate(2, rowTimestampDate);
                    stmt2.setInt(3, 3);
                    stmt2.setString(4, "KV1");
                    stmt2.executeUpdate();
                    conn.commit();
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
            }
            long startTime = EnvironmentEdgeManager.currentTimeMillis();
            throwable3 = null;
            try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
                throwable2 = null;
                try (Statement stmt3 = conn.createStatement();){
                    conn.setAutoCommit(true);
                    stmt3.executeUpdate("UPSERT INTO  " + tableName + " (PK1, PK3, KV1) SELECT PK1, PK3, KV1 FROM  " + tableName);
                }
                catch (Throwable throwable5) {
                    throwable2 = throwable5;
                    throw throwable5;
                }
            }
            catch (Throwable stmt3) {
                throwable3 = stmt3;
                throw stmt3;
            }
            long endTime = EnvironmentEdgeManager.currentTimeMillis();
            throwable2 = null;
            try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
                stmt4 = conn.prepareStatement("SELECT * FROM  " + tableName + " WHERE PK1 = ? AND PK2 >= ? AND PK2<= ? AND PK3 = ?");
                throwable = null;
                try {
                    stmt4.setInt(1, 1);
                    stmt4.setDate(2, new Date(startTime));
                    stmt4.setDate(3, new Date(endTime));
                    stmt4.setInt(4, 3);
                    rs2 = stmt4.executeQuery();
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)1L, (long)rs2.getInt("PK1"));
                    Assert.assertEquals((long)3L, (long)rs2.getInt("PK3"));
                    Assert.assertEquals((Object)"KV1", (Object)rs2.getString("KV1"));
                    Assert.assertFalse((boolean)rs2.next());
                    try (Statement newStmt = conn.createStatement();){
                        rs2 = newStmt.executeQuery("SELECT COUNT(*) FROM " + tableName);
                        Assert.assertTrue((boolean)rs2.next());
                        Assert.assertEquals((long)2L, (long)rs2.getInt(1));
                    }
                }
                catch (Throwable rs2) {
                    throwable = rs2;
                    throw rs2;
                }
                finally {
                    if (stmt4 != null) {
                        if (throwable != null) {
                            try {
                                stmt4.close();
                            }
                            catch (Throwable rs2) {
                                throwable.addSuppressed(rs2);
                            }
                        } else {
                            stmt4.close();
                        }
                    }
                }
            }
            catch (Throwable stmt4) {
                throwable2 = stmt4;
                throw stmt4;
            }
            conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
            throwable2 = null;
            try {
                stmt4 = conn.createStatement();
                throwable = null;
                try {
                    conn.setAutoCommit(true);
                    stmt4.executeUpdate("UPSERT INTO  " + tableName + " (PK1, PK2, PK3, KV1) SELECT PK1, PK2, PK3, KV1 FROM  " + tableName);
                }
                catch (Throwable rs2) {
                    throwable = rs2;
                    throw rs2;
                }
                finally {
                    if (stmt4 != null) {
                        if (throwable != null) {
                            try {
                                stmt4.close();
                            }
                            catch (Throwable rs2) {
                                throwable.addSuppressed(rs2);
                            }
                        } else {
                            stmt4.close();
                        }
                    }
                }
            }
            catch (Throwable stmt5) {
                throwable2 = stmt5;
                throw stmt5;
            }
            finally {
                if (conn != null) {
                    if (throwable2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable stmt5) {
                            throwable2.addSuppressed(stmt5);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
            conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
            throwable2 = null;
            try {
                stmt4 = conn.createStatement();
                throwable = null;
                try {
                    rs2 = stmt4.executeQuery("SELECT COUNT(*) FROM " + tableName);
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((long)2L, (long)rs2.getInt(1));
                    Assert.assertFalse((boolean)rs2.next());
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stmt4 != null) {
                        if (throwable != null) {
                            try {
                                stmt4.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            stmt4.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (conn != null) {
                    if (throwable2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
    }

    @Test
    public void testRowTimestampColWithViewsIndexesAndSaltedTables() throws Exception {
        Date upsertedDate;
        ResultSet rs6;
        Throwable throwable;
        PreparedStatement stmt;
        long upsertedTs;
        Object plan;
        ResultSet rs22;
        Throwable throwable2;
        PreparedStatement stmt2;
        Throwable throwable3;
        Throwable throwable4;
        String baseTable = UpsertSelectIT.generateUniqueName();
        String tenantView = UpsertSelectIT.generateUniqueName();
        String globalView = UpsertSelectIT.generateUniqueName();
        String baseTableIdx = UpsertSelectIT.generateUniqueName();
        String tenantViewIdx = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt3 = conn.createStatement();){
            stmt3.execute("CREATE IMMUTABLE TABLE " + baseTable + " (TENANT_ID CHAR(15) NOT NULL, PK2 DATE NOT NULL, PK3 INTEGER NOT NULL, KV1 VARCHAR, KV2 VARCHAR, KV3 VARCHAR CONSTRAINT PK PRIMARY KEY(TENANT_ID, PK2 ROW_TIMESTAMP, PK3)) MULTI_TENANT = true, SALT_BUCKETS = 8");
            stmt3.execute("CREATE INDEX " + baseTableIdx + " ON " + baseTable + " (PK2, KV3) INCLUDE (KV1)");
            stmt3.execute("CREATE VIEW " + globalView + " AS SELECT * FROM " + baseTable + " WHERE KV1 = 'KV1'");
        }
        String tenantId = "tenant1";
        try (Connection conn = this.getTenantConnection(tenantId);){
            throwable4 = null;
            try (Statement stmt4 = conn.createStatement();){
                stmt4.execute("CREATE VIEW " + tenantView + " AS SELECT * FROM " + baseTable);
                stmt4.execute("CREATE INDEX " + tenantViewIdx + " ON " + tenantView + " (PK2, KV2) INCLUDE (KV1)");
            }
            catch (Throwable throwable5) {
                throwable4 = throwable5;
                throw throwable5;
            }
        }
        long startTime = EnvironmentEdgeManager.currentTimeMillis();
        throwable4 = null;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            throwable3 = null;
            try (PreparedStatement stmt5 = conn.prepareStatement("UPSERT INTO  " + baseTable + " (TENANT_ID, PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?, ?)");){
                stmt5.setString(1, tenantId);
                stmt5.setInt(2, 3);
                stmt5.setString(3, "KV1");
                stmt5.setString(4, "KV2");
                stmt5.setString(5, "KV3");
                stmt5.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable6) {
                throwable3 = throwable6;
                throw throwable6;
            }
        }
        catch (Throwable stmt5) {
            throwable4 = stmt5;
            throw stmt5;
        }
        long endTime = EnvironmentEdgeManager.currentTimeMillis();
        throwable3 = null;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt2 = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            throwable2 = null;
            try {
                stmt2.setString(1, tenantId);
                stmt2.setDate(2, new Date(startTime));
                stmt2.setDate(3, new Date(endTime));
                stmt2.setInt(4, 3);
                rs22 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs22.next());
                Assert.assertEquals((Object)tenantId, (Object)rs22.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs22.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs22.getString("KV3"));
                Assert.assertFalse((boolean)rs22.next());
            }
            catch (Throwable rs22) {
                throwable2 = rs22;
                throw rs22;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable rs22) {
                            throwable2.addSuppressed(rs22);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
            stmt2 = conn.prepareStatement("SELECT /*+ NO_INDEX */ * FROM  " + globalView + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            throwable2 = null;
            try {
                stmt2.setString(1, tenantId);
                stmt2.setDate(2, new Date(startTime));
                stmt2.setDate(3, new Date(endTime));
                stmt2.setInt(4, 3);
                rs22 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs22.next());
                Assert.assertEquals((Object)tenantId, (Object)rs22.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs22.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs22.getString("KV3"));
                Assert.assertFalse((boolean)rs22.next());
            }
            catch (Throwable rs3) {
                throwable2 = rs3;
                throw rs3;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable rs3) {
                            throwable2.addSuppressed(rs3);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
            stmt2 = conn.prepareStatement("SELECT KV1 FROM  " + baseTable + " WHERE PK2 >= ? AND PK2 <= ? AND KV3 = ?");
            throwable2 = null;
            try {
                stmt2.setDate(1, new Date(startTime));
                stmt2.setDate(2, new Date(endTime));
                stmt2.setString(3, "KV3");
                rs22 = stmt2.executeQuery();
                plan = stmt2.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertEquals((Object)plan.getTableRef().getTable().getName().getString(), (Object)baseTableIdx);
                Assert.assertTrue((boolean)rs22.next());
                Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                Assert.assertFalse((boolean)rs22.next());
            }
            catch (Throwable rs4) {
                throwable2 = rs4;
                throw rs4;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable rs4) {
                            throwable2.addSuppressed(rs4);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable stmt6) {
            throwable3 = stmt6;
            throw stmt6;
        }
        throwable3 = null;
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            stmt2 = tenantConn.prepareStatement("SELECT * FROM  " + tenantView + " WHERE PK2 >= ? AND PK2 <= ? AND PK3 = ?");
            throwable2 = null;
            try {
                stmt2.setDate(1, new Date(startTime));
                stmt2.setDate(2, new Date(endTime));
                stmt2.setInt(3, 3);
                rs22 = stmt2.executeQuery();
                Assert.assertTrue((boolean)rs22.next());
                Assert.assertEquals((Object)"KV1", (Object)rs22.getString("KV1"));
                Assert.assertEquals((Object)"KV2", (Object)rs22.getString("KV2"));
                Assert.assertEquals((Object)"KV3", (Object)rs22.getString("KV3"));
                Assert.assertFalse((boolean)rs22.next());
            }
            catch (Throwable rs5) {
                throwable2 = rs5;
                throw rs5;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable rs5) {
                            throwable2.addSuppressed(rs5);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable stmt7) {
            throwable3 = stmt7;
            throw stmt7;
        }
        throwable2 = null;
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            startTime = EnvironmentEdgeManager.currentTimeMillis();
            PreparedStatement stmt8 = tenantConn.prepareStatement("UPSERT INTO  " + tenantView + " (PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?)");
            plan = null;
            try {
                stmt8.setInt(1, 33);
                stmt8.setString(2, "KV13");
                stmt8.setString(3, "KV23");
                stmt8.setString(4, "KV33");
                stmt8.executeUpdate();
            }
            catch (Throwable throwable7) {
                plan = throwable7;
                throw throwable7;
            }
            finally {
                if (stmt8 != null) {
                    if (plan != null) {
                        try {
                            stmt8.close();
                        }
                        catch (Throwable throwable8) {
                            ((Throwable)plan).addSuppressed(throwable8);
                        }
                    } else {
                        stmt8.close();
                    }
                }
            }
            tenantConn.commit();
            upsertedTs = endTime = EnvironmentEdgeManager.currentTimeMillis();
            stmt8 = tenantConn.prepareStatement("UPSERT INTO  " + tenantView + " (PK2, PK3, KV1, KV2, KV3) VALUES (?, ?, ?, ?, ?)");
            plan = null;
            try {
                stmt8.setDate(1, new Date(upsertedTs));
                stmt8.setInt(2, 44);
                stmt8.setString(3, "KV14");
                stmt8.setString(4, "KV24");
                stmt8.setString(5, "KV34");
                stmt8.executeUpdate();
            }
            catch (Throwable throwable9) {
                plan = throwable9;
                throw throwable9;
            }
            finally {
                if (stmt8 != null) {
                    if (plan != null) {
                        try {
                            stmt8.close();
                        }
                        catch (Throwable throwable10) {
                            ((Throwable)plan).addSuppressed(throwable10);
                        }
                    } else {
                        stmt8.close();
                    }
                }
            }
            tenantConn.commit();
        }
        catch (Throwable throwable11) {
            throwable2 = throwable11;
            throw throwable11;
        }
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 >= ? AND PK2 <= ? AND PK3 = ? ");
            throwable = null;
            try {
                stmt.setString(1, tenantId);
                stmt.setDate(2, new Date(startTime));
                stmt.setDate(3, new Date(endTime));
                stmt.setInt(4, 33);
                rs6 = stmt.executeQuery();
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)tenantId, (Object)rs6.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV13", (Object)rs6.getString("KV1"));
                Assert.assertEquals((Object)"KV23", (Object)rs6.getString("KV2"));
                Assert.assertEquals((Object)"KV33", (Object)rs6.getString("KV3"));
                upsertedDate = rs6.getDate("PK2");
                Assert.assertFalse((boolean)rs6.next());
            }
            catch (Throwable rs6) {
                throwable = rs6;
                throw rs6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs6) {
                            throwable.addSuppressed(rs6);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.prepareStatement("SELECT * FROM  " + baseTable + " WHERE TENANT_ID = ? AND PK2 = ? AND PK3 = ? ");
            throwable = null;
            try {
                stmt.setString(1, tenantId);
                stmt.setDate(2, new Date(upsertedTs));
                stmt.setInt(3, 44);
                rs6 = stmt.executeQuery();
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)tenantId, (Object)rs6.getString("TENANT_ID"));
                Assert.assertEquals((Object)"KV14", (Object)rs6.getString("KV1"));
                Assert.assertEquals((Object)"KV24", (Object)rs6.getString("KV2"));
                Assert.assertEquals((Object)"KV34", (Object)rs6.getString("KV3"));
                Assert.assertFalse((boolean)rs6.next());
            }
            catch (Throwable rs7) {
                throwable = rs7;
                throw rs7;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs7) {
                            throwable.addSuppressed(rs7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
            stmt = conn.prepareStatement("SELECT KV1 FROM  " + baseTable + " WHERE (PK2, KV3) IN ((?, ?), (?, ?)) ORDER BY KV1");
            throwable = null;
            try {
                stmt.setDate(1, upsertedDate);
                stmt.setString(2, "KV33");
                stmt.setDate(3, new Date(upsertedTs));
                stmt.setString(4, "KV34");
                rs6 = stmt.executeQuery();
                QueryPlan plan2 = stmt.unwrap(PhoenixStatement.class).getQueryPlan();
                Assert.assertTrue((boolean)plan2.getTableRef().getTable().getName().getString().equals(baseTableIdx));
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)"KV13", (Object)rs6.getString("KV1"));
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)"KV14", (Object)rs6.getString("KV1"));
                Assert.assertFalse((boolean)rs6.next());
            }
            catch (Throwable rs8) {
                throwable = rs8;
                throw rs8;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs8) {
                            throwable.addSuppressed(rs8);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        var16_40 = null;
        try (Connection tenantConn = this.getTenantConnection(tenantId);){
            stmt = tenantConn.prepareStatement("SELECT * FROM  " + tenantView + " WHERE (PK2, PK3) IN ((?, ?), (?, ?)) ORDER BY KV1");
            throwable = null;
            try {
                stmt.setDate(1, upsertedDate);
                stmt.setInt(2, 33);
                stmt.setDate(3, new Date(upsertedTs));
                stmt.setInt(4, 44);
                rs6 = stmt.executeQuery();
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)"KV13", (Object)rs6.getString("KV1"));
                Assert.assertTrue((boolean)rs6.next());
                Assert.assertEquals((Object)"KV14", (Object)rs6.getString("KV1"));
                Assert.assertFalse((boolean)rs6.next());
            }
            catch (Throwable throwable12) {
                throwable = throwable12;
                throw throwable12;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable13) {
                            throwable.addSuppressed(throwable13);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable14) {
            var16_40 = throwable14;
            throw throwable14;
        }
    }

    @Test
    public void testDisallowNegativeValuesForRowTsColumn() throws Exception {
        Throwable throwable;
        PreparedStatement stmt3;
        Throwable throwable2;
        String tableName = UpsertSelectIT.generateUniqueName();
        String tableName2 = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            throwable2 = null;
            try (Statement stmt2 = conn.createStatement();){
                stmt2.execute("CREATE TABLE " + tableName + " (PK1 BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR)");
                stmt2.execute("CREATE TABLE " + tableName2 + " (PK1 BIGINT NOT NULL PRIMARY KEY ROW_TIMESTAMP, KV1 VARCHAR)");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
        }
        long upsertedTs = 100L;
        throwable2 = null;
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt3 = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?)");
            throwable = null;
            try {
                stmt3.setLong(1, upsertedTs);
                stmt3.setString(2, "KV1");
                stmt3.executeUpdate();
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt3 != null) {
                    if (throwable != null) {
                        try {
                            stmt3.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt3.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            throwable2 = stmt3;
            throw stmt3;
        }
        try {
            conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
            throwable2 = null;
            try {
                stmt3 = conn.prepareStatement("UPSERT INTO " + tableName2 + " SELECT (PK1 - 500), KV1 FROM " + tableName);
                throwable = null;
                try {
                    stmt3.executeUpdate();
                    Assert.fail();
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (stmt3 != null) {
                        if (throwable != null) {
                            try {
                                stmt3.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                        } else {
                            stmt3.close();
                        }
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable2 = throwable8;
                throw throwable8;
            }
            finally {
                if (conn != null) {
                    if (throwable2 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable9) {
                            throwable2.addSuppressed(throwable9);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.ILLEGAL_DATA.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testUpsertSelectWithFixedWidthNullByteSizeArray() throws Exception {
        Throwable throwable;
        Statement stmt;
        ResultSet rs;
        Throwable throwable2;
        Statement stmt2;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt2 = conn.createStatement();
            throwable2 = null;
            try {
                stmt2.execute("create table " + t1 + " (id bigint not null primary key, ca char(3)[])");
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt2 = conn.createStatement();
            throwable2 = null;
            try {
                stmt2.execute("upsert into " + t1 + " values (1, ARRAY['aaa', 'bbb'])");
                conn.commit();
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var5_4 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var5_4.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt2 = conn.createStatement();
            throwable2 = null;
            try {
                stmt2.execute("upsert into " + t1 + " (id, ca) select id, ARRAY['ccc', 'ddd'] from " + t1 + " WHERE id = 1");
                conn.commit();
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable8) {
                            throwable2.addSuppressed(throwable8);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            var5_4 = stmt4;
            throw stmt4;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt4) {
                        var5_4.addSuppressed(stmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var5_4 = null;
        try {
            stmt2 = conn.createStatement();
            throwable2 = null;
            try {
                rs = stmt2.executeQuery("select * from " + t1);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"['ccc', 'ddd']", (Object)rs.getArray(2).toString());
            }
            catch (Throwable throwable9) {
                throwable2 = throwable9;
                throw throwable9;
            }
            finally {
                if (stmt2 != null) {
                    if (throwable2 != null) {
                        try {
                            stmt2.close();
                        }
                        catch (Throwable throwable10) {
                            throwable2.addSuppressed(throwable10);
                        }
                    } else {
                        stmt2.close();
                    }
                }
            }
        }
        catch (Throwable throwable11) {
            var5_4 = throwable11;
            throw throwable11;
        }
        finally {
            if (conn != null) {
                if (var5_4 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable12) {
                        var5_4.addSuppressed(throwable12);
                    }
                } else {
                    conn.close();
                }
            }
        }
        String t2 = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("create table " + t2 + " (id bigint not null primary key, ba binary(4)[])");
            }
            catch (Throwable throwable13) {
                throwable = throwable13;
                throw throwable13;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable14) {
                            throwable.addSuppressed(throwable14);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_5 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + t2 + " values (2, ARRAY[1, 27])");
                conn.commit();
            }
            catch (Throwable throwable15) {
                throwable = throwable15;
                throw throwable15;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable16) {
                            throwable.addSuppressed(throwable16);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt5) {
            var6_5 = stmt5;
            throw stmt5;
        }
        finally {
            if (conn != null) {
                if (var6_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt5) {
                        var6_5.addSuppressed(stmt5);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_5 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                stmt.execute("upsert into " + t2 + " (id, ba) select id, ARRAY[54, 1024] from " + t2 + " WHERE id = 2");
                conn.commit();
            }
            catch (Throwable throwable17) {
                throwable = throwable17;
                throw throwable17;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable18) {
                            throwable.addSuppressed(throwable18);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt6) {
            var6_5 = stmt6;
            throw stmt6;
        }
        finally {
            if (conn != null) {
                if (var6_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt6) {
                        var6_5.addSuppressed(stmt6);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_5 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                rs = stmt.executeQuery("select * from " + t2);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)2L, (long)rs.getLong(1));
                Assert.assertEquals((Object)"[X'80000036', X'80000400']", (Object)rs.getArray(2).toString());
            }
            catch (Throwable throwable19) {
                throwable = throwable19;
                throw throwable19;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable20) {
                            throwable.addSuppressed(throwable20);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable21) {
            var6_5 = throwable21;
            throw throwable21;
        }
        finally {
            if (conn != null) {
                if (var6_5 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable22) {
                        var6_5.addSuppressed(throwable22);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testUpsertSelectWithMultiByteCharsNoAutoCommit() throws Exception {
        this.testUpsertSelectWithMultiByteChars(false);
    }

    @Test
    public void testUpsertSelectWithMultiByteCharsAutoCommit() throws Exception {
        this.testUpsertSelectWithMultiByteChars(true);
    }

    private void testUpsertSelectWithMultiByteChars(boolean autoCommit) throws Exception {
        Throwable throwable;
        Statement stmt;
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectIT.generateUniqueName();
        String validValue = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889\u7889";
        String invalidValue = "\u6fb4\u7c96\u87e4\u092f\u893b\u9143\u5ca4\u8c66\ud311\u85b0\u9129\u813c\u056a\ub066\u7889\u7889\u7889\u7889\u7889\u7889\u7889";
        String columnTypeInfo = "VARCHAR(20)";
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("create table " + t1 + " (id bigint not null primary key, v varchar(20))");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_9 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("upsert into " + t1 + " values (1, 'foo')");
                conn.commit();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var8_9 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var8_9.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_9 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(autoCommit);
                stmt.execute("upsert into " + t1 + " (id, v) select id, '" + validValue + "' from " + t1 + " WHERE id = 1");
                conn.commit();
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable7) {
                            throwable.addSuppressed(throwable7);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt3) {
            var8_9 = stmt3;
            throw stmt3;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt3) {
                        var8_9.addSuppressed(stmt3);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var8_9 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(autoCommit);
                ResultSet rs = stmt.executeQuery("select * from  " + t1);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((long)1L, (long)rs.getLong(1));
                Assert.assertEquals((Object)validValue, (Object)rs.getString(2));
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt4) {
            var8_9 = stmt4;
            throw stmt4;
        }
        finally {
            if (conn != null) {
                if (var8_9 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt4) {
                        var8_9.addSuppressed(stmt4);
                    }
                } else {
                    conn.close();
                }
            }
        }
        try {
            conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
            var8_9 = null;
            try {
                stmt = conn.createStatement();
                throwable = null;
                try {
                    conn.setAutoCommit(autoCommit);
                    stmt.execute("upsert into  " + t1 + " (id, v) select id, '" + invalidValue + "' from " + t1 + " WHERE id = 1");
                    conn.commit();
                    Assert.fail();
                }
                catch (Throwable throwable10) {
                    throwable = throwable10;
                    throw throwable10;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable11) {
                                throwable.addSuppressed(throwable11);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (Throwable throwable12) {
                var8_9 = throwable12;
                throw throwable12;
            }
            finally {
                if (conn != null) {
                    if (var8_9 != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable13) {
                            var8_9.addSuppressed(throwable13);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY.getErrorCode(), (long)e.getErrorCode());
            Assert.assertTrue((boolean)e.getMessage().contains(columnTypeInfo));
        }
    }

    @Test
    public void testParallelUpsertSelect() throws Exception {
        Throwable throwable;
        Statement stmt;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        String t1 = UpsertSelectIT.generateUniqueName();
        String t2 = UpsertSelectIT.generateUniqueName();
        String seq = UpsertSelectIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);){
            stmt = conn.createStatement();
            throwable = null;
            try {
                conn.setAutoCommit(false);
                stmt.execute("CREATE SEQUENCE " + seq);
                stmt.execute("CREATE TABLE  " + t1 + "  (pk INTEGER PRIMARY KEY, val INTEGER) SALT_BUCKETS=4");
                stmt.execute("CREATE TABLE  " + t2 + "  (pk INTEGER PRIMARY KEY, val INTEGER)");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                for (int i = 0; i < 100; ++i) {
                    stmt.execute("UPSERT INTO  " + t1 + "  VALUES (NEXT VALUE FOR " + seq + ", " + i % 10 + ")");
                }
                conn.commit();
            }
            catch (Throwable i) {
                throwable = i;
                throw i;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable i) {
                            throwable.addSuppressed(i);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable stmt2) {
            var6_6 = stmt2;
            throw stmt2;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable stmt2) {
                        var6_6.addSuppressed(stmt2);
                    }
                } else {
                    conn.close();
                }
            }
        }
        conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
        var6_6 = null;
        try {
            conn.setAutoCommit(true);
            stmt = conn.createStatement();
            throwable = null;
            try {
                int upsertCount = stmt.executeUpdate("UPSERT INTO " + t2 + " SELECT pk, val FROM  " + t1);
                Assert.assertEquals((long)100L, (long)upsertCount);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable6) {
            var6_6 = throwable6;
            throw throwable6;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable7) {
                        var6_6.addSuppressed(throwable7);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test
    public void testLongCodecUsedForRowTimestamp() throws Exception {
        String tableName = UpsertSelectIT.generateUniqueName();
        String indexName = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement statement = conn.createStatement();){
            statement.execute("CREATE IMMUTABLE TABLE " + tableName + " (k1 TIMESTAMP not null, k2 bigint not null, v bigint, constraint pk primary key (k1 row_timestamp, k2)) SALT_BUCKETS = 9");
            statement.execute("CREATE INDEX " + indexName + " ON " + tableName + " (v) INCLUDE (k2)");
            try (PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, ?, ?) ");){
                stmt.setTimestamp(1, new Timestamp(1000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 1000L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(2000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(3000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(4000L));
                stmt.setLong(2, 5000L);
                stmt.setLong(3, 5L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(5000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 10L);
                stmt.executeUpdate();
                stmt.setTimestamp(1, new Timestamp(6000L));
                stmt.setLong(2, 2000L);
                stmt.setLong(3, 20L);
                stmt.executeUpdate();
            }
            conn.commit();
            ResultSet rs = statement.executeQuery("SELECT  K2 FROM " + tableName + " WHERE V = 5");
            Assert.assertTrue((String)("Index " + indexName + " should have been used"), (boolean)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getTableRef().getTable().getName().getString().equals(indexName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertFalse((boolean)rs.next());
            rs = statement.executeQuery("SELECT /*+ INDEX(" + tableName + " " + indexName + ") */  K2 FROM " + tableName + " WHERE V = 5");
            Assert.assertTrue((String)("Index " + indexName + " should have been used"), (boolean)rs.unwrap(PhoenixResultSet.class).getStatement().getQueryPlan().getTableRef().getTable().getName().getString().equals(indexName));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)5000L, (long)rs.getLong("k2"));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testLengthLimitedVarchar() throws Exception {
        String tableName1 = UpsertSelectIT.generateUniqueName();
        String tableName2 = UpsertSelectIT.generateUniqueName();
        Properties props = new Properties();
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        try (Connection conn = DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
             Statement stmt = conn.createStatement();){
            conn.setAutoCommit(true);
            stmt.execute("create table " + tableName1 + "(name varchar(160) primary key, id varchar(120), address varchar(160))");
            stmt.execute("create table " + tableName2 + "(name varchar(160) primary key, id varchar(10), address  varchar(10))");
            stmt.execute("upsert into " + tableName1 + " values('test','test','test')");
            stmt.execute("upsert into " + tableName2 + " select * from " + tableName1);
            ResultSet rs = stmt.executeQuery("select * from " + tableName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"test", (Object)rs.getString(1));
            Assert.assertEquals((Object)"test", (Object)rs.getString(2));
            Assert.assertEquals((Object)"test", (Object)rs.getString(2));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        props.setProperty("TenantId", tenantId);
        return DriverManager.getConnection(UpsertSelectIT.getUrl(), props);
    }
}

