/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
public class UpsertSelectAutoCommitIT
extends ParallelStatsDisabledIT {
    private final String allowServerSideMutations;

    public UpsertSelectAutoCommitIT(String allowServerSideMutations) {
        this.allowServerSideMutations = allowServerSideMutations;
    }

    @Parameterized.Parameters(name="UpsertSelectAutoCommitIT_allowServerSideMutations={0}")
    public static synchronized Object[] data() {
        return new Object[]{"true", "false"};
    }

    @Test
    public void testAutoCommitUpsertSelect() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(UpsertSelectAutoCommitIT.getUrl(), props);
        conn.setAutoCommit(true);
        String atable = UpsertSelectAutoCommitIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + atable + " (ORGANIZATION_ID CHAR(15) NOT NULL, ENTITY_ID CHAR(15) NOT NULL, A_STRING VARCHAR\nCONSTRAINT pk PRIMARY KEY (organization_id, entity_id))");
        String tenantId = UpsertSelectAutoCommitIT.getOrganizationId();
        PreparedStatement stmt = conn.prepareStatement("upsert into " + atable + "(    ORGANIZATION_ID,     ENTITY_ID,     A_STRING     )VALUES (?, ?, ?)");
        stmt.setString(1, tenantId);
        stmt.setString(2, "00A123122312312");
        stmt.setString(3, "a");
        stmt.execute();
        Assert.assertEquals((long)1L, (long)stmt.getUpdateCount());
        Assert.assertNull((Object)stmt.getResultSet());
        String query = "SELECT entity_id, a_string FROM " + atable;
        PreparedStatement statement = conn.prepareStatement(query);
        ResultSet rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
        String atable2 = UpsertSelectAutoCommitIT.generateUniqueName();
        conn.createStatement().execute("CREATE TABLE " + atable2 + " (ORGANIZATION_ID CHAR(15) NOT NULL, ENTITY_ID CHAR(15) NOT NULL, A_STRING VARCHAR\nCONSTRAINT pk PRIMARY KEY (organization_id, entity_id DESC))");
        Statement upsertStmt = conn.createStatement();
        upsertStmt.execute("UPSERT INTO " + atable2 + " SELECT * FROM " + atable);
        Assert.assertEquals((long)1L, (long)upsertStmt.getUpdateCount());
        Assert.assertNull((Object)upsertStmt.getResultSet());
        query = "SELECT entity_id, a_string FROM " + atable2;
        statement = conn.prepareStatement(query);
        rs = statement.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
        Assert.assertEquals((Object)"a", (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testDynamicUpsertSelect() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(UpsertSelectAutoCommitIT.getUrl(), props);
        String tableName = UpsertSelectAutoCommitIT.generateUniqueName();
        String cursorDDL = " CREATE TABLE IF NOT EXISTS " + tableName + " (ORGANIZATION_ID VARCHAR(15) NOT NULL, \nQUERY_ID VARCHAR(15) NOT NULL, \nCURSOR_ORDER UNSIGNED_LONG NOT NULL, \nCONSTRAINT API_HBASE_CURSOR_STORAGE_PK PRIMARY KEY (ORGANIZATION_ID, QUERY_ID, CURSOR_ORDER))\nSALT_BUCKETS = 4";
        conn.createStatement().execute(cursorDDL);
        String tableName2 = UpsertSelectAutoCommitIT.generateUniqueName();
        String dataTableDDL = "CREATE TABLE IF NOT EXISTS " + tableName2 + "(ORGANIZATION_ID CHAR(15) NOT NULL, PLINY_ID CHAR(15) NOT NULL, CREATED_DATE DATE NOT NULL, TEXT VARCHAR, CONSTRAINT PK PRIMARY KEY (ORGANIZATION_ID, PLINY_ID, CREATED_DATE))";
        conn.createStatement().execute(dataTableDDL);
        PreparedStatement stmt = null;
        String upsert = "UPSERT INTO " + tableName2 + " VALUES (?, ?, ?, ?)";
        stmt = conn.prepareStatement(upsert);
        stmt.setString(1, UpsertSelectAutoCommitIT.getOrganizationId());
        stmt.setString(2, "aaaaaaaaaaaaaaa");
        stmt.setDate(3, new Date(System.currentTimeMillis()));
        stmt.setString(4, "text");
        stmt.executeUpdate();
        conn.commit();
        String upsertSelect = "UPSERT INTO " + tableName + " (ORGANIZATION_ID, QUERY_ID, CURSOR_ORDER, PLINY_ID CHAR(15),CREATED_DATE DATE) SELECT ?, ?, ?, PLINY_ID, CREATED_DATE FROM " + tableName2 + " WHERE ORGANIZATION_ID = ?";
        stmt = conn.prepareStatement(upsertSelect);
        String orgId = UpsertSelectAutoCommitIT.getOrganizationId();
        stmt.setString(1, orgId);
        stmt.setString(2, "queryqueryquery");
        stmt.setInt(3, 1);
        stmt.setString(4, orgId);
        stmt.executeUpdate();
        conn.commit();
    }

    @Test
    public void testUpsertSelectDoesntSeeUpsertedData() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSizeBytes", Integer.toString(512));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(UpsertSelectAutoCommitIT.getUrl(), props);
        conn.setAutoCommit(true);
        String tableName = UpsertSelectAutoCommitIT.generateUniqueName();
        conn.createStatement().execute("CREATE SEQUENCE " + tableName + "_seq CACHE 1000");
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, val INTEGER) UPDATE_CACHE_FREQUENCY=3600000");
        Statement upsertStmt = conn.createStatement();
        upsertStmt.execute("UPSERT INTO " + tableName + " VALUES (NEXT VALUE FOR " + tableName + "_seq, 1)");
        Assert.assertEquals((long)1L, (long)upsertStmt.getUpdateCount());
        Assert.assertNull((Object)upsertStmt.getResultSet());
        PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " SELECT NEXT VALUE FOR " + tableName + "_seq, val FROM " + tableName);
        Admin admin = driver.getConnectionQueryServices(UpsertSelectAutoCommitIT.getUrl(), TestUtil.TEST_PROPERTIES).getAdmin();
        for (int i = 0; i < 12; ++i) {
            try {
                admin.split(TableName.valueOf((String)tableName));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int upsertCount = stmt.executeUpdate();
            Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)upsertCount);
        }
        admin.close();
        conn.close();
    }

    @Test
    public void testMaxMutationSize() throws Exception {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("phoenix.mutate.maxSize", "3");
        connectionProperties.setProperty("phoenix.mutate.maxSizeBytes", "50000");
        connectionProperties.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        PhoenixConnection connection = (PhoenixConnection)DriverManager.getConnection(UpsertSelectAutoCommitIT.getUrl(), connectionProperties);
        connection.setAutoCommit(true);
        String fullTableName = UpsertSelectAutoCommitIT.generateUniqueName();
        try (Statement stmt = connection.createStatement();){
            stmt.execute("CREATE TABLE " + fullTableName + " (pk INTEGER PRIMARY KEY, v1 INTEGER, v2 INTEGER)");
            stmt.execute("CREATE SEQUENCE " + fullTableName + "_seq cache 1000");
            stmt.execute("UPSERT INTO " + fullTableName + " VALUES (NEXT VALUE FOR " + fullTableName + "_seq, rand(), rand())");
        }
        stmt = connection.createStatement();
        var5_5 = null;
        try {
            for (int i = 0; i < 16; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " SELECT NEXT VALUE FOR " + fullTableName + "_seq, rand(), rand() FROM " + fullTableName);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (stmt != null) {
                if (var5_5 != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    stmt.close();
                }
            }
        }
        connection.close();
    }

    @Test
    public void testRowCountWithNoAutoCommitOnUpsertSelect() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("phoenix.mutate.batchSize", Integer.toString(3));
        props.setProperty("hbase.client.scanner.caching", Integer.toString(3));
        props.setProperty("phoenix.query.scanResultChunkSize", Integer.toString(3));
        props.setProperty("phoenix.client.enable.server.upsert.mutations", this.allowServerSideMutations);
        Connection conn = DriverManager.getConnection(UpsertSelectAutoCommitIT.getUrl(), props);
        conn.setAutoCommit(false);
        String tableName = UpsertSelectAutoCommitIT.generateUniqueName();
        conn.createStatement().execute("CREATE SEQUENCE " + tableName + "_seq");
        conn.createStatement().execute("CREATE TABLE " + tableName + " (pk INTEGER PRIMARY KEY, val INTEGER)");
        conn.createStatement().execute("UPSERT INTO " + tableName + " VALUES (NEXT VALUE FOR " + tableName + "_seq, 1)");
        conn.commit();
        for (int i = 0; i < 6; ++i) {
            Statement stmt = conn.createStatement();
            int upsertCount = stmt.executeUpdate("UPSERT INTO " + tableName + " SELECT NEXT VALUE FOR " + tableName + "_seq, val FROM " + tableName);
            conn.commit();
            Assert.assertEquals((long)((int)Math.pow(2.0, i)), (long)upsertCount);
        }
        conn.close();
    }
}

