/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Properties;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class UpsertBindNullParamToCaseExprIT
extends BaseTest {
    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        UpsertBindNullParamToCaseExprIT.setUpTestDriver(new ReadOnlyProps(new HashMap()));
    }

    @AfterClass
    public static synchronized void freeResources() throws Exception {
        BaseTest.freeResourcesIfBeyondThreshold();
    }

    @Test
    public void testBindNullUpsertSelect() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " (row_id, chunk) VALUES (?, ?)";
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "value");
        }
    }

    @Test
    public void testBindNullUpsertSelectWithCaseIsNotNull() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " SELECT :1, CASE WHEN chunk IS NOT NULL THEN chunk ELSE :2 END FROM " + tableName + " WHERE row_id = :1";
            UpsertBindNullParamToCaseExprIT.upsertNullRow(tableName, conn, 1);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "value");
            UpsertBindNullParamToCaseExprIT.upsertNullRow(tableName, conn, 2);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, null, "value");
        }
    }

    @Test
    public void testBindNullUpsertSelectWithCaseIsNull() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " SELECT :1, CASE WHEN :2 IS NULL THEN 'default' ELSE chunk END FROM " + tableName + " WHERE row_id = :1";
            UpsertBindNullParamToCaseExprIT.upsertNullRow(tableName, conn, 1);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, "default");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "default");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, "default");
        }
    }

    @Test
    public void testBindNullUpsertSelectWithCaseIsNull2() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " SELECT :1, CASE WHEN :2 IS NULL THEN NULL ELSE :2 END FROM " + tableName + " WHERE row_id = :1";
            UpsertBindNullParamToCaseExprIT.upsertNullRow(tableName, conn, 1);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
        }
    }

    @Test
    public void testBindNullOnDuplicateKeyIsNotNull1() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " (row_id, chunk) VALUES (:1, :2)\nON DUPLICATE KEY UPDATE\n    chunk = CASE WHEN chunk IS NOT NULL THEN chunk ELSE :2 END";
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "newval", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, null, "value");
        }
    }

    @Test
    public void testBindNullOnDuplicateKeyIsNotNull2() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " (row_id, chunk) VALUES (:1, :2)\nON DUPLICATE KEY UPDATE\n    chunk = CASE WHEN :2 IS NOT NULL THEN :2 ELSE chunk END";
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 2, null, "value");
        }
    }

    @Test
    public void testBindNullOnDuplicateKeyIsNull() throws Exception {
        try (Connection conn = UpsertBindNullParamToCaseExprIT.newConnection();){
            String tableName = UpsertBindNullParamToCaseExprIT.createChunkTable(conn);
            String upsert_stmt = "UPSERT INTO " + tableName + " (row_id, chunk) VALUES (:1, :2)\nON DUPLICATE KEY UPDATE\n    chunk = CASE WHEN :2 IS NULL THEN NULL ELSE :2 END";
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, "value", "value");
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
            UpsertBindNullParamToCaseExprIT.runTestBindForNull(tableName, conn, upsert_stmt, 1, null, null);
        }
    }

    private static Connection newConnection() throws SQLException {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UpsertBindNullParamToCaseExprIT.getUrl(), props);
        conn.setAutoCommit(true);
        return conn;
    }

    private static String createChunkTable(Connection conn) throws Exception {
        String tableName = UpsertBindNullParamToCaseExprIT.generateUniqueName();
        try (Statement stmt = conn.createStatement();){
            stmt.execute("CREATE TABLE " + tableName + " (\n    row_id INTEGER NOT NULL,\n    chunk VARCHAR,\n    CONSTRAINT PK PRIMARY KEY (row_id)\n)");
        }
        return tableName;
    }

    private static void upsertNullRow(String tableName, Connection conn, int rowId) throws Exception {
        try (PreparedStatement stmt = conn.prepareStatement("UPSERT INTO " + tableName + " VALUES (?, NULL)");){
            stmt.setInt(1, rowId);
            stmt.execute();
        }
    }

    private static void runTestBindForNull(String tableName, Connection conn, String upsert_stmt, int rowId, String chunkVal, String expectedChunk) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(upsert_stmt);){
            stmt.setInt(1, rowId);
            if (chunkVal == null) {
                stmt.setNull(2, 12);
            } else {
                stmt.setString(2, chunkVal);
            }
            stmt.execute();
        }
        String select_stmt = "SELECT * FROM " + tableName + " WHERE row_id = " + rowId;
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(select_stmt);){
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)rowId, (long)rs.getInt(1));
            if (expectedChunk == null) {
                Assert.assertNull((Object)rs.getBytes(2));
            } else {
                Assert.assertEquals((Object)expectedChunk, (Object)rs.getString(2));
            }
        }
    }

    @Test
    public void testBindWithComplexCasePHOENIX_7615() throws Exception {
        String tableName = UpsertBindNullParamToCaseExprIT.generateUniqueName();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(UpsertBindNullParamToCaseExprIT.getUrl(), props);){
            conn.setAutoCommit(true);
            try (Statement stmt = conn.createStatement();){
                stmt.execute("CREATE TABLE " + tableName + " (\n    row_id CHAR(15) NOT NULL,\n    chunk_id INTEGER NOT NULL,\n    total_chunks INTEGER,\n    hash VARCHAR,\n    chunk VARBINARY,\n    CONSTRAINT PK PRIMARY KEY (row_id, chunk_id)\n)");
            }
            String upsert_stmt = "UPSERT INTO " + tableName + " (row_id, chunk_id, total_chunks, hash, chunk)\nVALUES (:1, :2, :3, :4, :5)\nON DUPLICATE KEY UPDATE\nchunk = CASE WHEN (hash IS NULL AND :4 IS NOT NULL OR hash IS NOT NULL and :4 IS NULL OR hash != :4) THEN :5 ELSE chunk END";
            String select_stmt = "SELECT * from " + tableName;
            String val1 = "def";
            UpsertBindNullParamToCaseExprIT.upsertRow(conn, upsert_stmt, val1, val1.getBytes());
            UpsertBindNullParamToCaseExprIT.assertRow(conn, select_stmt, val1.getBytes());
            String val2 = "def";
            UpsertBindNullParamToCaseExprIT.upsertRow(conn, upsert_stmt, val2, val2.getBytes());
            UpsertBindNullParamToCaseExprIT.assertRow(conn, select_stmt, val2.getBytes());
            UpsertBindNullParamToCaseExprIT.upsertRow(conn, upsert_stmt, null, null);
            UpsertBindNullParamToCaseExprIT.assertRow(conn, select_stmt, null);
        }
    }

    private static void assertRow(Connection conn, String select_stmt, byte[] val) throws SQLException {
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(select_stmt);){
            Assert.assertTrue((boolean)rs.next());
            if (val == null) {
                Assert.assertNull((Object)rs.getBytes("chunk"));
            } else {
                Assert.assertTrue((Bytes.compareTo((byte[])rs.getBytes("chunk"), (byte[])val) == 0 ? 1 : 0) != 0);
            }
        }
    }

    private static void upsertRow(Connection conn, String upsert_stmt, String hash, byte[] val) throws SQLException {
        try (PreparedStatement stmt = conn.prepareStatement(upsert_stmt);){
            stmt.setString(1, "R1");
            stmt.setInt(2, 1);
            stmt.setInt(3, 1);
            if (hash == null) {
                stmt.setNull(4, 12);
            } else {
                stmt.setString(4, hash);
            }
            if (val == null) {
                stmt.setNull(5, -3);
            } else {
                stmt.setBytes(5, val);
            }
            stmt.execute();
        }
    }
}

