/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class UpperLowerFunctionIT
extends ParallelStatsDisabledIT {
    private static String tableName = UpperLowerFunctionIT.generateUniqueName();
    private static String firstName = "Joe";
    private static String lastName = "Smith";

    @BeforeClass
    public static synchronized void init() throws SQLException {
        Connection conn = DriverManager.getConnection(UpperLowerFunctionIT.getUrl());
        String ddl = "CREATE TABLE " + tableName + " (id INTEGER PRIMARY KEY,first_name VARCHAR,last_name VARCHAR)";
        conn.createStatement().execute(ddl);
        String dml = String.format("UPSERT INTO %s VALUES(1, '%s', '%s')", tableName, firstName, lastName);
        PreparedStatement stmt = conn.prepareStatement(dml);
        stmt.execute();
        conn.commit();
    }

    @Test
    public void testWhereLower() throws SQLException {
        Connection conn = DriverManager.getConnection(UpperLowerFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT first_name, last_name FROM %s WHERE LOWER(first_name || ' ' || last_name) = '%s %s'", tableName, firstName.toLowerCase(), lastName.toLowerCase()));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)firstName, (Object)rs.getString(1));
        Assert.assertEquals((Object)lastName, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectLower() throws SQLException {
        Connection conn = DriverManager.getConnection(UpperLowerFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT LOWER(first_name || ' ' || last_name) FROM %s WHERE id = 1", tableName));
        Assert.assertTrue((boolean)rs.next());
        String expected = String.format("%s %s", firstName.toLowerCase(), lastName.toLowerCase());
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testWhereUpper() throws SQLException {
        Connection conn = DriverManager.getConnection(UpperLowerFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT first_name, last_name FROM %s WHERE UPPER(first_name || ' ' || last_name) = '%s %s'", tableName, firstName.toUpperCase(), lastName.toUpperCase()));
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)firstName, (Object)rs.getString(1));
        Assert.assertEquals((Object)lastName, (Object)rs.getString(2));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSelectUpper() throws SQLException {
        Connection conn = DriverManager.getConnection(UpperLowerFunctionIT.getUrl());
        ResultSet rs = conn.createStatement().executeQuery(String.format("SELECT UPPER(first_name || ' ' || last_name) FROM %s WHERE id = 1", tableName));
        Assert.assertTrue((boolean)rs.next());
        String expected = String.format("%s %s", firstName.toUpperCase(), lastName.toUpperCase());
        Assert.assertEquals((Object)expected, (Object)rs.getString(1));
        Assert.assertFalse((boolean)rs.next());
    }
}

