/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.PFunction;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.UpgradeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpgradeNamespaceIT
extends ParallelStatsDisabledIT {
    @Test
    public void testMapTableToNamespaceDuringUpgrade() throws SQLException, IOException, IllegalArgumentException, InterruptedException {
        String[] strings = new String[]{"a", "b", "c", "d"};
        try (Connection conn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl());){
            Object rs;
            String schemaName = "TEST";
            String phoenixFullTableName = schemaName + "." + UpgradeNamespaceIT.generateUniqueName();
            String indexName = "IDX_" + UpgradeNamespaceIT.generateUniqueName();
            String localIndexName = "LIDX_" + UpgradeNamespaceIT.generateUniqueName();
            String viewName = "VIEW_" + UpgradeNamespaceIT.generateUniqueName();
            String viewIndexName = "VIDX_" + UpgradeNamespaceIT.generateUniqueName();
            String[] tableNames = new String[]{phoenixFullTableName, schemaName + "." + indexName, schemaName + "." + localIndexName, "diff." + viewName, "test." + viewName, viewName};
            String[] viewIndexes = new String[]{"diff." + viewIndexName, "test." + viewIndexName};
            conn.createStatement().execute("CREATE TABLE " + phoenixFullTableName + "(k VARCHAR PRIMARY KEY, v INTEGER, f INTEGER, g INTEGER NULL, h INTEGER NULL)");
            PreparedStatement upsertStmt = conn.prepareStatement("UPSERT INTO " + phoenixFullTableName + " VALUES(?, ?, 0, 0, 0)");
            int i = 1;
            for (String str : strings) {
                upsertStmt.setString(1, str);
                upsertStmt.setInt(2, i++);
                upsertStmt.execute();
            }
            conn.commit();
            conn.createStatement().execute("create local index " + localIndexName + " on " + phoenixFullTableName + "(K)");
            conn.createStatement().execute("create index " + indexName + " on " + phoenixFullTableName + "(k)");
            conn.createStatement().execute("CREATE VIEW diff." + viewName + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW test." + viewName + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW " + viewName + "(col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("create index " + viewIndexName + "  on diff." + viewName + "(col)");
            conn.createStatement().execute("create index " + viewIndexName + " on test." + viewName + "(col)");
            for (String tableName : tableNames) {
                rs = conn.createStatement().executeQuery("select * from " + tableName);
                for (String str : strings) {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)str, (Object)rs.getString(1));
                }
            }
            for (String viewIndex : viewIndexes) {
                rs = conn.createStatement().executeQuery("select * from " + viewIndex);
                for (String str : strings) {
                    Assert.assertTrue((boolean)rs.next());
                    Assert.assertEquals((Object)str, (Object)rs.getString(2));
                }
            }
            try (Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();){
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((String)phoenixFullTableName)));
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((String)(schemaName + "." + indexName))));
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((byte[])MetaDataUtil.getViewIndexPhysicalName((byte[])Bytes.toBytes((String)phoenixFullTableName)))));
            }
            Properties props = new Properties();
            props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
            props.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.toString(false));
            PhoenixConnection phxConn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props).unwrap(PhoenixConnection.class);
            UpgradeUtil.upgradeTable((PhoenixConnection)phxConn, (String)phoenixFullTableName);
            phxConn.close();
            props = new Properties();
            phxConn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props).unwrap(PhoenixConnection.class);
            phxConn.getMetaDataCache().pruneTables(new PMetaData.Pruner(){

                public boolean prune(PTable table) {
                    return table.getType() != PTableType.SYSTEM;
                }

                public boolean prune(PFunction function) {
                    return false;
                }
            });
            String hbaseTableName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)phoenixFullTableName), (boolean)true).getNameAsString();
            String[] admin = phxConn.getQueryServices().getAdmin();
            rs = null;
            try {
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((String)hbaseTableName)));
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((byte[])Bytes.toBytes((String)hbaseTableName))));
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((String)(schemaName + ":" + indexName))));
                Assert.assertTrue((boolean)admin.tableExists(TableName.valueOf((byte[])MetaDataUtil.getViewIndexPhysicalName((byte[])Bytes.toBytes((String)hbaseTableName)))));
            }
            catch (Throwable throwable) {
                rs = throwable;
                throw throwable;
            }
            finally {
                if (admin != null) {
                    if (rs != null) {
                        try {
                            admin.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)rs).addSuppressed(throwable);
                        }
                    } else {
                        admin.close();
                    }
                }
            }
            i = 0;
            for (String tableName : tableNames) {
                ResultSet rs2 = phxConn.createStatement().executeQuery("select * from " + tableName);
                for (String str : strings) {
                    Assert.assertTrue((boolean)rs2.next());
                    Assert.assertEquals((Object)str, (Object)rs2.getString(1));
                }
            }
            for (String viewIndex : viewIndexes) {
                ResultSet rs3 = conn.createStatement().executeQuery("select * from " + viewIndex);
                for (String str : strings) {
                    Assert.assertTrue((boolean)rs3.next());
                    Assert.assertEquals((Object)str, (Object)rs3.getString(2));
                }
            }
            PName tenantId = phxConn.getTenantId();
            PName physicalName = PNameFactory.newName((String)hbaseTableName);
            String newSchemaName = MetaDataUtil.getViewIndexSequenceSchemaName((PName)physicalName, (boolean)true);
            String newSequenceName = MetaDataUtil.getViewIndexSequenceName((PName)physicalName, (PName)tenantId, (boolean)true);
            UpgradeNamespaceIT.verifySequenceValue(null, newSequenceName, newSchemaName, -32765L);
        }
    }

    @Test
    public void testMapMultiTenantTableToNamespaceDuringUpgrade() throws SQLException, SnapshotCreationException, IllegalArgumentException, IOException, InterruptedException {
        ResultSet rs;
        String[] strings = new String[]{"a", "b", "c", "d"};
        String schemaName1 = "S_" + UpgradeNamespaceIT.generateUniqueName();
        String schemaName2 = "S_" + UpgradeNamespaceIT.generateUniqueName();
        String phoenixFullTableName = schemaName1 + "." + UpgradeNamespaceIT.generateUniqueName();
        String hbaseTableName = SchemaUtil.getPhysicalTableName((byte[])Bytes.toBytes((String)phoenixFullTableName), (boolean)true).getNameAsString();
        String indexName = "IDX_" + UpgradeNamespaceIT.generateUniqueName();
        String viewName = "V_" + UpgradeNamespaceIT.generateUniqueName();
        String viewName1 = "V1_" + UpgradeNamespaceIT.generateUniqueName();
        String viewIndexName = "V_IDX_" + UpgradeNamespaceIT.generateUniqueName();
        String tenantViewIndexName = "V1_IDX_" + UpgradeNamespaceIT.generateUniqueName();
        String[] tableNames = new String[]{phoenixFullTableName, schemaName2 + "." + viewName1, schemaName1 + "." + viewName1, viewName1};
        String[] viewIndexes = new String[]{schemaName1 + "." + viewIndexName, schemaName2 + "." + viewIndexName};
        String[] tenantViewIndexes = new String[]{schemaName1 + "." + tenantViewIndexName, schemaName2 + "." + tenantViewIndexName};
        try (Connection conn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl());){
            conn.createStatement().execute("CREATE TABLE " + phoenixFullTableName + "(k VARCHAR not null, v INTEGER not null, f INTEGER, g INTEGER NULL, h INTEGER NULL CONSTRAINT pk PRIMARY KEY(k,v)) MULTI_TENANT=true");
            PreparedStatement upsertStmt = conn.prepareStatement("UPSERT INTO " + phoenixFullTableName + " VALUES(?, ?, 0, 0, 0)");
            int i = 1;
            for (String str : strings) {
                upsertStmt.setString(1, str);
                upsertStmt.setInt(2, i++);
                upsertStmt.execute();
            }
            conn.commit();
            conn.createStatement().execute("create index " + indexName + " on " + phoenixFullTableName + "(f)");
            conn.createStatement().execute("CREATE VIEW " + schemaName2 + "." + viewName + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW " + schemaName1 + "." + viewName + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW " + viewName + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("create local index " + viewIndexName + " on " + schemaName2 + "." + viewName + "(col)");
            conn.createStatement().execute("create local index " + viewIndexName + " on " + schemaName1 + "." + viewName + "(col)");
        }
        Properties props = new Properties();
        String tenantId = strings[0];
        props.setProperty("TenantId", tenantId);
        try (Connection conn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props);){
            PreparedStatement upsertStmt = conn.prepareStatement("UPSERT INTO " + phoenixFullTableName + "(k,v,f,g,h)  VALUES(?, ?, 0, 0, 0)");
            int i = 1;
            String[] stringArray = strings;
            int n = stringArray.length;
            for (int j = 0; j < n; ++j) {
                String str = stringArray[j];
                upsertStmt.setString(1, str);
                upsertStmt.setInt(2, i++);
                upsertStmt.execute();
            }
            conn.commit();
            conn.createStatement().execute("CREATE VIEW " + schemaName2 + "." + viewName1 + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW " + schemaName1 + "." + viewName1 + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("CREATE VIEW " + viewName1 + " (col VARCHAR) AS SELECT * FROM " + phoenixFullTableName);
            conn.createStatement().execute("create index " + tenantViewIndexName + " on " + schemaName2 + "." + viewName1 + "(col)");
            conn.createStatement().execute("create index " + tenantViewIndexName + " on " + schemaName1 + "." + viewName1 + "(col)");
        }
        props = new Properties();
        props.setProperty("phoenix.schema.isNamespaceMappingEnabled", Boolean.toString(true));
        props.setProperty("phoenix.schema.mapSystemTablesToNamespace", Boolean.toString(false));
        PhoenixConnection phxConn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props).unwrap(PhoenixConnection.class);
        UpgradeUtil.upgradeTable((PhoenixConnection)phxConn, (String)phoenixFullTableName);
        props.setProperty("TenantId", tenantId);
        phxConn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props).unwrap(PhoenixConnection.class);
        phxConn.getMetaDataCache().pruneTables(new PMetaData.Pruner(){

            public boolean prune(PTable table) {
                return table.getType() != PTableType.SYSTEM;
            }

            public boolean prune(PFunction function) {
                return false;
            }
        });
        int i2 = 1;
        String indexPhysicalTableName = Bytes.toString((byte[])MetaDataUtil.getViewIndexPhysicalName((byte[])Bytes.toBytes((String)hbaseTableName)));
        for (String tableName : tableNames) {
            this.assertTableUsed((Connection)phxConn, tableName, hbaseTableName);
            rs = phxConn.createStatement().executeQuery("select * from " + tableName);
            Assert.assertTrue((boolean)rs.next());
            do {
                Assert.assertEquals((long)i2++, (long)rs.getInt(1));
            } while (rs.next());
            i2 = 1;
        }
        for (String viewIndex : tenantViewIndexes) {
            this.assertTableUsed((Connection)phxConn, viewIndex, indexPhysicalTableName);
            rs = phxConn.createStatement().executeQuery("select * from " + viewIndex);
            Assert.assertTrue((boolean)rs.next());
            do {
                Assert.assertEquals((long)i2++, (long)rs.getInt(2));
            } while (rs.next());
            i2 = 1;
        }
        phxConn.close();
        props.remove("TenantId");
        phxConn = DriverManager.getConnection(UpgradeNamespaceIT.getUrl(), props).unwrap(PhoenixConnection.class);
        for (String viewIndex : viewIndexes) {
            this.assertTableUsed((Connection)phxConn, viewIndex, hbaseTableName);
            rs = phxConn.createStatement().executeQuery("select * from " + viewIndex);
            for (String str : strings) {
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)str, (Object)rs.getString(1));
            }
        }
        phxConn.close();
    }

    public void assertTableUsed(Connection conn, String phoenixTableName, String hbaseTableName) throws SQLException {
        ResultSet rs = conn.createStatement().executeQuery("EXPLAIN SELECT * FROM " + phoenixTableName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.getString(1).contains(hbaseTableName));
    }
}

