/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.TableName;
import org.apache.phoenix.end2end.LoadSystemTableSnapshotBase;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpgradeFromSnapshotIT
extends LoadSystemTableSnapshotBase {
    static final Set<String> PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES = new HashSet<String>(Arrays.asList("SYSTEM:CATALOG", "SYSTEM:SEQUENCE", "SYSTEM:STATS", "SYSTEM:FUNCTION", "SYSTEM:MUTEX", "SYSTEM:CHILD_LINK", "SYSTEM:TRANSFORM"));

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        boolean blockUpgrade = false;
        UpgradeFromSnapshotIT.setupCluster(blockUpgrade);
    }

    @Test
    public void testPhoenixUpgrade() throws Exception {
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)2);
        serverProps.put("phoenix.jdbc.extra.arguments", "");
        serverProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        HashMap clientProps = Maps.newHashMapWithExpectedSize((int)2);
        clientProps.put("phoenix.schema.isNamespaceMappingEnabled", "true");
        UpgradeFromSnapshotIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), new ReadOnlyProps(clientProps.entrySet().iterator()));
        Assert.assertTrue((boolean)true);
        HashSet<String> tables = new HashSet<String>();
        for (TableName tn : utility.getAdmin().listTableNames()) {
            tables.add(tn.getNameAsString());
        }
        Assert.assertTrue((String)("HBase tables do not include expected Phoenix tables: " + tables), (boolean)tables.containsAll(PHOENIX_NAMESPACE_MAPPED_SYSTEM_TABLES));
    }
}

