/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.end2end.SplitSystemCatalogIT;
import org.apache.phoenix.end2end.ViewConcurrencyAndFailureIT;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.TableProperty;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UpdatableViewRestrictionsIT
extends SplitSystemCatalogIT {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdatableViewRestrictionsIT.class);

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        NUM_SLAVES_BASE = 6;
        boolean splitSystemCatalog = driver == null;
        HashMap serverProps = Maps.newHashMapWithExpectedSize((int)1);
        serverProps.put("phoenix.acls.enabled", "true");
        serverProps.put("hbase.coprocessor.phoenix.classes", ViewConcurrencyAndFailureIT.TestMetaDataRegionObserver.class.getName());
        serverProps.put("hbase.coprocessor.abortonerror", "false");
        UpdatableViewRestrictionsIT.setUpTestDriver(new ReadOnlyProps(serverProps.entrySet().iterator()), ReadOnlyProps.EMPTY_PROPS);
        if (splitSystemCatalog) {
            UpdatableViewRestrictionsIT.getUtility().getHBaseCluster().getMaster().balanceSwitch(false);
            UpdatableViewRestrictionsIT.splitSystemCatalog();
        }
    }

    private void createTable(Connection conn, String tableSQL, Map<String, Object> tableProps) throws Exception {
        Integer nSaltBuckets;
        ArrayList<String> props = new ArrayList<String>();
        Boolean multitenant = (Boolean)TableProperty.MULTI_TENANT.getValue(tableProps);
        if (multitenant != null && multitenant.booleanValue()) {
            props.add(TableProperty.MULTI_TENANT.getPropertyName() + "=" + multitenant);
        }
        if ((nSaltBuckets = (Integer)TableProperty.SALT_BUCKETS.getValue(tableProps)) != null) {
            props.add(TableProperty.SALT_BUCKETS.getPropertyName() + "=" + nSaltBuckets);
        }
        tableSQL = tableSQL + " " + String.join((CharSequence)", ", props);
        LOGGER.debug("Creating table with SQL: " + tableSQL);
        conn.createStatement().execute(tableSQL);
    }

    private void createTable(Connection conn, String tableName, final boolean multitenant, final Integer nSaltBuckets) throws Exception {
        String tableSQL = "CREATE TABLE " + tableName + " (" + (multitenant ? "TENANT_ID VARCHAR NOT NULL, " : "") + "k1 INTEGER NOT NULL, k2 DECIMAL, k3 INTEGER NOT NULL, s VARCHAR CONSTRAINT pk PRIMARY KEY (" + (multitenant ? "TENANT_ID, " : "") + "k1, k2, k3))";
        this.createTable(conn, tableSQL, (Map<String, Object>)new HashMap<String, Object>(){
            {
                this.put(TableProperty.MULTI_TENANT.getPropertyName(), multitenant);
                this.put(TableProperty.SALT_BUCKETS.getPropertyName(), nSaltBuckets);
            }
        });
    }

    private void createTable(Connection conn, String tableName) throws Exception {
        this.createTable(conn, tableName, false, null);
    }

    private Connection getTenantConnection(String tenantId) throws Exception {
        Properties tenantProps = new Properties();
        tenantProps.setProperty("TenantId", tenantId);
        tenantProps.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        return DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), tenantProps);
    }

    private void verifyNumberOfRows(String tableName, String tenantId, int expectedRows, Connection conn) throws Exception {
        String query = "SELECT COUNT(*) FROM " + tableName;
        if (tenantId != null) {
            query = query + " WHERE TENANT_ID = '" + tenantId + "'";
        }
        try (Statement stm = conn.createStatement();){
            ResultSet rs = stm.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)expectedRows, (long)rs.getInt(1));
        }
    }

    @Test
    public void testReadOnlyViewWithNonPkInWhere() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            this.createTable(conn, fullTableName);
            Statement stmt = conn.createStatement();
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE s = 'a'";
            stmt.execute(viewDDL);
            try {
                stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 3, 'a')");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadOnlyViewWithPkNotInOrderInWhere1() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            this.createTable(conn, fullTableName);
            Statement stmt = conn.createStatement();
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1 AND k3 = 3";
            stmt.execute(viewDDL);
            try {
                stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 3, 'a')");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadOnlyViewWithPkNotInOrderInWhere2() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            conn.createStatement().execute("CREATE TABLE " + fullTableName + " (k1 INTEGER NOT NULL, k2 DECIMAL, k3 INTEGER NOT NULL, s VARCHAR CONSTRAINT pk PRIMARY KEY (k1, k2, k3, s))");
            Statement stmt = conn.createStatement();
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1 AND k2 = 2 AND s = 'a'";
            stmt.execute(viewDDL);
            try {
                stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 3, 'a')");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadOnlyViewWithPkNotSameInWhere1() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullGlobalViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullSiblingViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            this.createTable(conn, fullTableName);
            Statement stmt = conn.createStatement();
            String globalViewDDL = "CREATE VIEW " + fullGlobalViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
            stmt.execute(globalViewDDL);
            String siblingViewDDL = "CREATE VIEW " + fullSiblingViewName + " AS SELECT * FROM " + fullGlobalViewName + " WHERE k2 = 1";
            stmt.execute(siblingViewDDL);
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullGlobalViewName + " WHERE k2 = 2 AND k3 = 109";
            stmt.execute(viewDDL);
            try {
                stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 109, 'a')");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadOnlyViewWithPkNotSameInWhere2() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullGlobalViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullSiblingViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            this.createTable(conn, fullTableName);
            Statement stmt = conn.createStatement();
            String globalViewDDL = "CREATE VIEW " + fullGlobalViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
            stmt.execute(globalViewDDL);
            String siblingViewDDL = "CREATE VIEW " + fullSiblingViewName + " AS SELECT * FROM " + fullGlobalViewName + " WHERE k2 = 1 AND k3 = 109";
            stmt.execute(siblingViewDDL);
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullGlobalViewName + " WHERE k2 = 2";
            stmt.execute(viewDDL);
            try {
                stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 109, 'a')");
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    private void testUpdatableViewStartFromFirstPK(boolean multitenant, Integer nSaltBuckets) throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            conn.setAutoCommit(true);
            this.createTable(conn, fullTableName, multitenant, nSaltBuckets);
            String tenantId = null;
            if (multitenant) {
                tenantId = TENANT1;
                try (Connection tenantConn = this.getTenantConnection(tenantId);){
                    this.createAndVerifyUpdatableView(fullTableName, tenantConn);
                }
            } else {
                this.createAndVerifyUpdatableView(fullTableName, conn);
            }
            this.verifyNumberOfRows(fullTableName, tenantId, 1, conn);
        }
    }

    private void testReadOnlyViewNotStartFromFirstPK(boolean multitenant, Integer nSaltBuckets) throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String tenantId = TENANT1;
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection globalConn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);
             Connection tenantConn = this.getTenantConnection(tenantId);){
            globalConn.setAutoCommit(true);
            tenantConn.setAutoCommit(true);
            this.createTable(globalConn, fullTableName, multitenant, nSaltBuckets);
            Statement stmt = multitenant ? tenantConn.createStatement() : globalConn.createStatement();
            stmt.execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k2 = 2");
            try {
                stmt.execute(String.format("UPSERT INTO %s VALUES(1, 2, 3, 's')", fullViewName));
                Assert.fail();
            }
            catch (ReadOnlyTableException readOnlyTableException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadOnlyViewOnNonMultitenantNonSaltedTableNotStartFromFirstPK() throws Exception {
        this.testReadOnlyViewNotStartFromFirstPK(false, null);
    }

    @Test
    public void testReadOnlyViewOnMultitenantNonSaltedTableNotStartFromFirstPK() throws Exception {
        this.testReadOnlyViewNotStartFromFirstPK(true, null);
    }

    @Test
    public void testReadOnlyViewOnNonMultitenantSaltedTableNotStartFromFirstPK() throws Exception {
        this.testReadOnlyViewNotStartFromFirstPK(false, 3);
    }

    @Test
    public void testReadOnlyViewOnMultitenantSaltedTableNotStartFromFirstPK() throws Exception {
        this.testReadOnlyViewNotStartFromFirstPK(true, 3);
    }

    @Test
    public void testUpdatableViewOnNonMultitenantNonSaltedTableStartFromFirstPK() throws Exception {
        this.testUpdatableViewStartFromFirstPK(false, null);
    }

    @Test
    public void testUpdatableViewOnMultitenantNonSaltedTableStartFromFirstPK() throws Exception {
        this.testUpdatableViewStartFromFirstPK(true, null);
    }

    @Test
    public void testUpdatableViewOnNonMultitenantSaltedTableStartFromFirstPK() throws Exception {
        this.testUpdatableViewStartFromFirstPK(false, 3);
    }

    @Test
    public void testUpdatableViewOnMultitenantSaltedTableStartFromFirstPK() throws Exception {
        this.testUpdatableViewStartFromFirstPK(true, 3);
    }

    private void createAndVerifyUpdatableView(String fullTableName, Connection conn) throws Exception {
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1");
        stmt.execute("UPSERT INTO " + fullViewName + " VALUES(1, 2, 109, 'a')");
        conn.commit();
        ResultSet rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullViewName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)109L, (long)rs.getInt(3));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testReadOnlyViewOnUpdatableView1() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullChildViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);
        conn.setAutoCommit(true);
        this.createTable(conn, fullTableName);
        Statement stmt = conn.createStatement();
        String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
        stmt.execute(viewDDL);
        String childViewDDL = "CREATE VIEW " + fullChildViewName + " AS SELECT * FROM " + fullViewName + " WHERE k3 = 3";
        stmt.execute(childViewDDL);
        try {
            stmt.execute("UPSERT INTO " + fullChildViewName + " VALUES(1, 2, 3, 'a')");
            Assert.fail();
        }
        catch (ReadOnlyTableException readOnlyTableException) {
            // empty catch block
        }
    }

    @Test
    public void testReadOnlyViewOnUpdatableView2() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullChildViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);
        conn.setAutoCommit(true);
        this.createTable(conn, fullTableName);
        Statement stmt = conn.createStatement();
        String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
        stmt.execute(viewDDL);
        String childViewDDL = "CREATE VIEW " + fullChildViewName + " AS SELECT * FROM " + fullViewName + " WHERE k2 = 2 AND k3 = 3 AND s = 'a'";
        stmt.execute(childViewDDL);
        try {
            stmt.execute("UPSERT INTO " + fullChildViewName + " VALUES(1, 2, 3, 'a')");
            Assert.fail();
        }
        catch (ReadOnlyTableException readOnlyTableException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdatableViewOnUpdatableView() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullChildViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);
        conn.setAutoCommit(true);
        this.createTable(conn, fullTableName);
        Statement stmt = conn.createStatement();
        String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
        stmt.execute(viewDDL);
        String childViewDDL = "CREATE VIEW " + fullChildViewName + " AS SELECT * FROM " + fullViewName + " WHERE k2 = 2 AND k3 = 3";
        stmt.execute(childViewDDL);
        stmt.execute("UPSERT INTO " + fullChildViewName + " VALUES(1, 2, 3, 'a')");
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + fullChildViewName);
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)rs.getInt(2));
        Assert.assertEquals((long)3L, (long)rs.getInt(3));
        Assert.assertEquals((Object)"a", (Object)rs.getString(4));
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testSiblingsUpdatableOnUpdatableView() throws Exception {
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullGlobalViewName = SchemaUtil.getTableName((String)SCHEMA2, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullViewName = SchemaUtil.getTableName((String)SCHEMA3, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullLeafViewName1 = SchemaUtil.getTableName((String)SCHEMA4, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        String fullLeafViewName2 = SchemaUtil.getTableName((String)SCHEMA4, (String)UpdatableViewRestrictionsIT.generateUniqueName());
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            this.createTable(conn, fullTableName);
            Statement stmt = conn.createStatement();
            String globalViewDDL = "CREATE VIEW " + fullGlobalViewName + " AS SELECT * FROM " + fullTableName + " WHERE k1 = 1";
            stmt.execute(globalViewDDL);
            String viewDDL = "CREATE VIEW " + fullViewName + " AS SELECT * FROM " + fullGlobalViewName + " WHERE k2 = 1";
            stmt.execute(viewDDL);
            String leafView1DDL = "CREATE VIEW " + fullLeafViewName1 + " AS SELECT * FROM " + fullViewName + " WHERE k3 = 101";
            stmt.execute(leafView1DDL);
            String leafView2DDL = "CREATE VIEW " + fullLeafViewName2 + " AS SELECT * FROM " + fullViewName + " WHERE k3 = 105";
            stmt.execute(leafView2DDL);
            for (int i = 0; i < 10; ++i) {
                stmt.execute("UPSERT INTO " + fullTableName + " VALUES(" + i % 4 + "," + (i > 5 ? 2 : 1) + "," + (i + 100) + ")");
            }
            conn.commit();
            ResultSet rs = stmt.executeQuery("SELECT count(*) FROM " + fullTableName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)10L, (long)rs.getInt(1));
            rs = stmt.executeQuery("SELECT count(*) FROM " + fullGlobalViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)3L, (long)rs.getInt(1));
            rs = stmt.executeQuery("SELECT count(*) FROM " + fullViewName);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullLeafViewName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((long)101L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT k1, k2, k3 FROM " + fullLeafViewName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            Assert.assertEquals((long)1L, (long)rs.getInt(2));
            Assert.assertEquals((long)105L, (long)rs.getInt(3));
            Assert.assertFalse((boolean)rs.next());
            stmt.execute("UPSERT INTO " + fullLeafViewName1 + " VALUES(1, 1, 101, 'leaf1')");
            stmt.execute("UPSERT INTO " + fullLeafViewName2 + " VALUES(1, 1, 105, 'leaf2')");
            conn.commit();
            rs = stmt.executeQuery("SELECT s FROM " + fullLeafViewName1);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"leaf1", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
            rs = stmt.executeQuery("SELECT s FROM " + fullLeafViewName2);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"leaf2", (Object)rs.getString(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    @Test
    public void testUpdatableViewWithMultiTenantTable() throws Exception {
        String tableName = UpdatableViewRestrictionsIT.generateUniqueName();
        String fullTableName = SchemaUtil.getTableName((String)SCHEMA1, (String)tableName);
        String view01 = SchemaUtil.getTableName((String)SCHEMA2, (String)("v01_" + tableName));
        String view02 = SchemaUtil.getTableName((String)SCHEMA3, (String)("v02_" + tableName));
        String view03 = SchemaUtil.getTableName((String)SCHEMA4, (String)("v03_" + tableName));
        Properties props = new Properties();
        props.setProperty("phoenix.updatable.view.restriction.enabled", "true");
        try (Connection conn = DriverManager.getConnection(UpdatableViewRestrictionsIT.getUrl(), props);){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + fullTableName + " (TENANT_ID VARCHAR NOT NULL, COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(TENANT_ID, COL1, COL2)) MULTI_TENANT = true");
            try (Connection tenantConn = this.getTenantConnection(TENANT1);){
                tenantConn.setAutoCommit(true);
                Statement tenantStmt = tenantConn.createStatement();
                stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8) NOT NULL, COL5 VARCHAR CONSTRAINT pk PRIMARY KEY(VCOL1)) AS SELECT * FROM " + fullTableName + " WHERE COL1 = 'col1'");
                tenantStmt.execute("CREATE VIEW " + view02 + " AS SELECT * FROM " + view01 + " WHERE COL2 = 'col2'");
                tenantStmt.execute("CREATE VIEW " + view03 + " AS SELECT * FROM " + view02 + " WHERE VCOL1 = 'vcol1'");
                tenantStmt.execute(String.format("UPSERT INTO %s (VCOL1,COL3,COL4,COL5) VALUES('vcol2', 'col3', 'col4', 'col5')", view02));
                tenantStmt.execute(String.format("UPSERT INTO %s (COL3,COL4,COL5) VALUES('col3', 'col4', 'col5')", view03));
                this.verifyNumberOfRows(fullTableName, TENANT1, 2, conn);
                ResultSet rs = tenantConn.createStatement().executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view02);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"col2", (Object)rs.getString(2));
                Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"col2", (Object)rs.getString(2));
                Assert.assertEquals((Object)"vcol2", (Object)rs.getString(3));
                Assert.assertFalse((boolean)rs.next());
                rs = tenantConn.createStatement().executeQuery("SELECT COL1, COL2, VCOL1 FROM " + view03);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertEquals((Object)"col1", (Object)rs.getString(1));
                Assert.assertEquals((Object)"col2", (Object)rs.getString(2));
                Assert.assertEquals((Object)"vcol1", (Object)rs.getString(3));
                Assert.assertFalse((boolean)rs.next());
            }
        }
    }
}

