/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import org.apache.phoenix.end2end.BaseQueryIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsDisabledTest.class})
@RunWith(value=Parameterized.class)
@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
public class UngroupedIT
extends BaseQueryIT {
    public UngroupedIT(String indexDDL, boolean columnEncoded, boolean keepDeletedCells) {
        super(indexDDL, columnEncoded, keepDeletedCells);
    }

    @Parameterized.Parameters(name="UngroupedIT_{index}")
    public static synchronized Collection<Object> data() {
        return BaseQueryIT.allIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUngroupedAggregation() throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        String query = "SELECT count(1) FROM " + tableName + " WHERE organization_id=? and a_string = ?";
        String url = UngroupedIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "b");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        conn = DriverManager.getConnection(url, props);
        try {
            statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            statement.setString(2, "b");
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)4L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUngroupedAggregationNoWhere() throws Exception {
        String query = "SELECT count(*) FROM " + tableName;
        String url = UngroupedIT.getUrl();
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(url, props);){
            PreparedStatement statement = conn.prepareStatement(query);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)9L, (long)rs.getLong(1));
            Assert.assertFalse((boolean)rs.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void zTestSumOverNullIntegerColumn() throws Exception {
        ResultSet rs;
        PreparedStatement statement;
        String query = "SELECT sum(a_integer) FROM " + tableName + " a";
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(UngroupedIT.getUrl(), props);
        conn.setAutoCommit(true);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (organization_id,entity_id,a_integer) VALUES('" + UngroupedIT.getOrganizationId() + "','" + "00A323122312312" + "',NULL)");
        Connection conn1 = DriverManager.getConnection(UngroupedIT.getUrl(), props);
        TestUtil.analyzeTable(conn1, tableName);
        conn1.close();
        conn = DriverManager.getConnection(UngroupedIT.getUrl(), props);
        try {
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)42L, (long)rs.getInt(1));
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
        conn = DriverManager.getConnection(UngroupedIT.getUrl(), props);
        conn.setAutoCommit(true);
        conn.createStatement().execute("UPSERT INTO " + tableName + " (organization_id,entity_id,a_integer) SELECT organization_id, entity_id, CAST(null AS integer) FROM " + tableName);
        conn = DriverManager.getConnection(UngroupedIT.getUrl(), props);
        try {
            statement = conn.prepareStatement(query);
            rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((long)0L, (long)rs.getInt(1));
            Assert.assertTrue((boolean)rs.wasNull());
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }
}

