/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExplainPlanAttributes;
import org.apache.phoenix.coprocessor.MetaDataEndpointImpl;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.end2end.NeedsOwnMiniClusterTest;
import org.apache.phoenix.exception.PhoenixIOException;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixPreparedStatement;
import org.apache.phoenix.protobuf.ProtobufUtil;
import org.apache.phoenix.query.BaseTest;
import org.apache.phoenix.schema.PIndexState;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.thirdparty.com.google.common.collect.Maps;
import org.apache.phoenix.util.ClientUtil;
import org.apache.phoenix.util.ReadOnlyProps;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={NeedsOwnMiniClusterTest.class})
public class UCFWithDisabledIndexIT
extends BaseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UCFWithDisabledIndexIT.class);

    private static void initCluster() throws Exception {
        ConcurrentMap props = Maps.newConcurrentMap();
        props.put("phoenix.max.lookback.age.seconds", Integer.toString(3600000));
        props.put("phoenix.default.update.cache.frequency", "ALWAYS");
        props.put("phoenix.ddl.timestamp.validation.enabled", Boolean.toString(false));
        props.put("phoenix.metadata.invalidate.cache.enabled", Boolean.toString(false));
        props.put("phoenix.task.handling.initial.delay.ms", Long.toString(Long.MAX_VALUE));
        props.put("phoenix.disable.view.subtree.validation", "true");
        UCFWithDisabledIndexIT.setUpTestDriver(new ReadOnlyProps(props.entrySet().iterator()));
    }

    @BeforeClass
    public static synchronized void doSetup() throws Exception {
        UCFWithDisabledIndexIT.initCluster();
    }

    @Test
    public void testUcfWithNoGetTableCalls() throws Throwable {
        String tableName = UCFWithDisabledIndexIT.generateUniqueName();
        String indexName = "IDX_" + tableName;
        String view01 = "v01_" + tableName;
        String view02 = "v02_" + tableName;
        String index_view01 = "idx_v01_" + tableName;
        String index_view02 = "idx_v02_" + tableName;
        String index_view03 = "idx_v03_" + tableName;
        String index_view04 = "idx_v04_" + tableName;
        try (Connection conn = DriverManager.getConnection(UCFWithDisabledIndexIT.getUrl());){
            Statement stmt = conn.createStatement();
            stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2)) UPDATE_CACHE_FREQUENCY=20000");
            stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + " (COL3) INCLUDE (COL4)");
            stmt.execute("CREATE VIEW " + view01 + " (VCOL1 CHAR(8), COL5 VARCHAR) AS SELECT * FROM " + tableName + " WHERE COL1 = 'col1'");
            stmt.execute("CREATE VIEW " + view02 + " (VCOL2 CHAR(10), COL6 VARCHAR) AS SELECT * FROM " + view01 + " WHERE VCOL1 = 'vcol1'");
            stmt.execute("CREATE INDEX " + index_view01 + " ON " + view01 + " (COL5) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view02 + " ON " + view02 + " (COL6) INCLUDE (COL1, COL2, COL3)");
            stmt.execute("CREATE INDEX " + index_view03 + " ON " + view01 + " (COL5) INCLUDE (COL2, COL1)");
            stmt.execute("CREATE INDEX " + index_view04 + " ON " + view02 + " (COL6) INCLUDE (COL2, COL1)");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0001', 'vcol2_01', 'col5_01', 'col6_01')");
            conn.commit();
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0002', 'vcol2_02', 'col5_02', 'col6_02')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0003', 'vcol2_03', 'col5_03', 'col6_03')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0004', 'vcol2', 'col3_04', 'col4_04', 'col5_04')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0005', 'vcol-2', 'col3_05', 'col4_05', 'col5_05')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0006', 'vcol-1', 'col3_06', 'col4_06', 'col5_06')");
            stmt.execute("UPSERT INTO " + view01 + " (col2, vcol1, col3, col4, col5) values ('0007', 'vcol1', 'col3_07', 'col4_07', 'col5_07')");
            stmt.execute("UPSERT INTO " + view02 + " (col2, vcol2, col5, col6) values ('0008', 'vcol2_08', 'col5_08', 'col6_02')");
            conn.commit();
            Statement statement = conn.createStatement();
            ResultSet rs = statement.executeQuery("SELECT COL2, VCOL1, VCOL2, COL5, COL6 FROM " + view02);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            String query = "SELECT COL1, COL2, COL3, COL4 FROM " + tableName + " WHERE COL3 = 'col3_04'";
            rs = statement.executeQuery(query);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertFalse((boolean)rs.next());
            ExplainPlan explainPlan = conn.prepareStatement(query).unwrap(PhoenixPreparedStatement.class).optimizeQuery().getExplainPlan();
            ExplainPlanAttributes explainPlanAttributes = explainPlan.getPlanStepsAsAttributes();
            Assert.assertEquals((Object)indexName, (Object)explainPlanAttributes.getTableName());
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUcfWithDisabledIndex1() throws Throwable {
        String tableName = UCFWithDisabledIndexIT.generateUniqueName();
        String indexName = "IDX_" + tableName;
        Connection conn = DriverManager.getConnection(UCFWithDisabledIndexIT.getUrl());
        try {
            try {
                Statement stmt = UCFWithDisabledIndexIT.createIndexAndUpdateCoproc(conn, tableName, indexName, true);
                stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c011', 'c012', 'c013', 'c014')");
                conn.commit();
                throw new RuntimeException("Should not reach here");
            }
            catch (PhoenixIOException e) {
                LOGGER.error("Error thrown. ", (Throwable)e);
                Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("Not allowed"));
                UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
                TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
                TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
                UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, false);
                conn.close();
            }
        }
        catch (Throwable throwable) {
            UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, false);
            conn.close();
            throw throwable;
        }
    }

    private static void verifyTableAndIndexRows(Connection conn, String tableName, String indexName, boolean isCreateDisableCase) throws SQLException {
        ResultSet rs1 = conn.createStatement().executeQuery("SELECT * FROM " + tableName);
        ResultSet rs2 = conn.createStatement().executeQuery("SELECT * FROM " + indexName);
        if (!isCreateDisableCase) {
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"c000", (Object)rs1.getString(1));
            Assert.assertEquals((Object)"c002", (Object)rs1.getString(2));
            Assert.assertEquals((Object)"c003", (Object)rs1.getString(3));
            Assert.assertEquals((Object)"c004", (Object)rs1.getString(4));
            Assert.assertTrue((boolean)rs1.next());
            Assert.assertEquals((Object)"c001", (Object)rs1.getString(1));
            Assert.assertEquals((Object)"c002", (Object)rs1.getString(2));
            Assert.assertEquals((Object)"c003", (Object)rs1.getString(3));
            Assert.assertEquals((Object)"c004", (Object)rs1.getString(4));
        }
        Assert.assertTrue((boolean)rs1.next());
        Assert.assertEquals((Object)"c011", (Object)rs1.getString(1));
        Assert.assertEquals((Object)"c012", (Object)rs1.getString(2));
        Assert.assertEquals((Object)"c013", (Object)rs1.getString(3));
        Assert.assertEquals((Object)"c014", (Object)rs1.getString(4));
        Assert.assertTrue((boolean)rs1.next());
        Assert.assertEquals((Object)"c0112", (Object)rs1.getString(1));
        Assert.assertEquals((Object)"c012", (Object)rs1.getString(2));
        Assert.assertEquals((Object)"c013", (Object)rs1.getString(3));
        Assert.assertEquals((Object)"c014", (Object)rs1.getString(4));
        Assert.assertFalse((boolean)rs1.next());
        if (!isCreateDisableCase) {
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"c003", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"c000", (Object)rs2.getString(2));
            Assert.assertEquals((Object)"c002", (Object)rs2.getString(3));
            Assert.assertEquals((Object)"c004", (Object)rs2.getString(4));
            Assert.assertTrue((boolean)rs2.next());
            Assert.assertEquals((Object)"c003", (Object)rs2.getString(1));
            Assert.assertEquals((Object)"c001", (Object)rs2.getString(2));
            Assert.assertEquals((Object)"c002", (Object)rs2.getString(3));
            Assert.assertEquals((Object)"c004", (Object)rs2.getString(4));
        }
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((Object)"c013", (Object)rs2.getString(1));
        Assert.assertEquals((Object)"c011", (Object)rs2.getString(2));
        Assert.assertEquals((Object)"c012", (Object)rs2.getString(3));
        Assert.assertEquals((Object)"c014", (Object)rs2.getString(4));
        Assert.assertTrue((boolean)rs2.next());
        Assert.assertEquals((Object)"c013", (Object)rs2.getString(1));
        Assert.assertEquals((Object)"c0112", (Object)rs2.getString(2));
        Assert.assertEquals((Object)"c012", (Object)rs2.getString(3));
        Assert.assertEquals((Object)"c014", (Object)rs2.getString(4));
        Assert.assertFalse((boolean)rs2.next());
    }

    private static void updateIndexToRebuild(Connection conn, String tableName, String indexName) throws Exception {
        TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
        TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        Statement stmt = conn.createStatement();
        stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c011', 'c012', 'c013', 'c014')");
        conn.commit();
        stmt.execute("ALTER INDEX " + indexName + " ON " + tableName + " REBUILD");
        PTable indexTable = conn.unwrap(PhoenixConnection.class).getTableNoCache(indexName);
        Assert.assertEquals((Object)PIndexState.ACTIVE, (Object)indexTable.getIndexState());
        TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
        stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c0112', 'c012', 'c013', 'c014')");
        conn.commit();
    }

    private static Statement createIndexAndUpdateCoproc(Connection conn, String tableName, String indexName, boolean alterIndexState) throws Exception {
        Statement stmt = conn.createStatement();
        stmt.execute("CREATE TABLE " + tableName + " (COL1 CHAR(10) NOT NULL, COL2 CHAR(5) NOT NULL, COL3 VARCHAR, COL4 VARCHAR CONSTRAINT pk PRIMARY KEY(COL1, COL2)) UPDATE_CACHE_FREQUENCY=10000");
        stmt.execute("CREATE INDEX " + indexName + " ON " + tableName + " (COL3) INCLUDE (COL4)");
        if (alterIndexState) {
            stmt.execute("ALTER INDEX " + indexName + " ON " + tableName + " DISABLE");
        }
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName);
        Assert.assertFalse((boolean)rs.next());
        TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
        stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c000', 'c002', 'c003', 'c004')");
        conn.commit();
        TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
        TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        Thread.sleep(11000L);
        stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c001', 'c002', 'c003', 'c004')");
        conn.commit();
        PTable indexTable = conn.unwrap(PhoenixConnection.class).getTableNoCache(indexName);
        if (alterIndexState) {
            Assert.assertEquals((Object)PIndexState.DISABLE, (Object)indexTable.getIndexState());
        } else {
            Assert.assertEquals((Object)PIndexState.CREATE_DISABLE, (Object)indexTable.getIndexState());
        }
        TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
        TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUcfWithDisabledIndex2() throws Throwable {
        String tableName = UCFWithDisabledIndexIT.generateUniqueName();
        String indexName = "IDX_" + tableName;
        Connection conn = DriverManager.getConnection(UCFWithDisabledIndexIT.getUrl());
        try {
            try {
                Statement stmt = UCFWithDisabledIndexIT.createIndexAndUpdateCoproc(conn, tableName, indexName, true);
                stmt.execute("SELECT * FROM " + indexName);
                throw new RuntimeException("Should not reach here");
            }
            catch (PhoenixIOException e) {
                LOGGER.error("Error thrown. ", (Throwable)e);
                Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("Not allowed"));
                UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
                TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
                TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
                UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, false);
                conn.close();
            }
        }
        catch (Throwable throwable) {
            UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, false);
            conn.close();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUcfWithDisabledIndex3() throws Throwable {
        String tableName = UCFWithDisabledIndexIT.generateUniqueName();
        String indexName = "IDX_" + tableName;
        Properties props = new Properties();
        props.setProperty("phoenix.index.create.default.state", PIndexState.CREATE_DISABLE.toString());
        Connection conn = DriverManager.getConnection(UCFWithDisabledIndexIT.getUrl(), props);
        try {
            try {
                Statement stmt = UCFWithDisabledIndexIT.createIndexAndUpdateCoproc(conn, tableName, indexName, false);
                stmt.execute("UPSERT INTO " + tableName + " (col1, col2, col3, col4) values ('c011', 'c012', 'c013', 'c014')");
                conn.commit();
                throw new RuntimeException("Should not reach here");
            }
            catch (PhoenixIOException e) {
                LOGGER.error("Error thrown. ", (Throwable)e);
                Assert.assertTrue((boolean)(e.getCause() instanceof DoNotRetryIOException));
                Assert.assertTrue((boolean)e.getCause().getMessage().contains("Not allowed"));
                UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
                TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
                TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
                UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, true);
                conn.close();
            }
        }
        catch (Throwable throwable) {
            UCFWithDisabledIndexIT.updateIndexToRebuild(conn, tableName, indexName);
            TestUtil.removeCoprocessor(conn, "SYSTEM.CATALOG", TestMetaDataEndpointImpl.class);
            TestUtil.addCoprocessor(conn, "SYSTEM.CATALOG", MetaDataEndpointImpl.class);
            UCFWithDisabledIndexIT.verifyTableAndIndexRows(conn, tableName, indexName, true);
            conn.close();
            throw throwable;
        }
    }

    public static class TestMetaDataEndpointImpl
    extends MetaDataEndpointImpl {
        public void getTable(RpcController controller, MetaDataProtos.GetTableRequest request, RpcCallback<MetaDataProtos.MetaDataResponse> done) {
            LOGGER.error("Not expected to get getTable() for {}", (Object)Bytes.toString((byte[])request.getTableName().toByteArray()));
            ProtobufUtil.setControllerException((RpcController)controller, (IOException)ClientUtil.createIOException((String)SchemaUtil.getPhysicalTableName((byte[])PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES, (boolean)false).toString(), (Throwable)new DoNotRetryIOException("Not allowed")));
        }
    }
}

