/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.util.DateUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class TruncateFunctionIT
extends ParallelStatsDisabledIT {
    private static final String DS1 = "1970-01-10 00:58:01.587";
    private static final String DS2 = "1970-01-20 01:02:45.906";
    private static final String DS3 = "1970-01-30 01:30:24.353";

    private static Date toDate(String s) throws ParseException {
        return DateUtil.parseDate((String)s);
    }

    private static Timestamp toTimestamp(String s) throws ParseException {
        return DateUtil.parseTimestamp((String)s);
    }

    @Test
    public void testTruncate() throws Exception {
        String tenantId = TruncateFunctionIT.getOrganizationId();
        String tableName = TruncateFunctionIT.generateUniqueName();
        TruncateFunctionIT.ensureTableCreated(url, tableName, "ATABLE", null, null, null);
        try (Connection conn = DriverManager.getConnection(TruncateFunctionIT.getUrl());){
            PreparedStatement stmt = conn.prepareStatement("upsert into " + tableName + "(    ORGANIZATION_ID,     ENTITY_ID,     A_DATE,     A_TIMESTAMP)VALUES (?, ?, ?, ?)");
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A123122312312");
            stmt.setDate(3, TruncateFunctionIT.toDate(DS1));
            stmt.setTimestamp(4, TruncateFunctionIT.toTimestamp(DS1));
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A223122312312");
            stmt.setDate(3, TruncateFunctionIT.toDate(DS2));
            stmt.setTimestamp(4, TruncateFunctionIT.toTimestamp(DS2));
            stmt.execute();
            stmt.setString(1, tenantId);
            stmt.setString(2, "00A323122312312");
            stmt.setDate(3, TruncateFunctionIT.toDate(DS3));
            stmt.setTimestamp(4, TruncateFunctionIT.toTimestamp(DS3));
            stmt.execute();
            conn.commit();
            String query = "SELECT entity_id, trunc(a_date, 'day', 7), trunc(a_timestamp, 'second', 10) FROM " + tableName + " WHERE organization_id = ?";
            PreparedStatement statement = conn.prepareStatement(query);
            statement.setString(1, tenantId);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A123122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)new Date(604800000L), (Object)rs.getDate(2));
            Assert.assertEquals((Object)TruncateFunctionIT.toTimestamp("1970-01-10 00:58:00.000"), (Object)rs.getTimestamp(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A223122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)new Date(1209600000L), (Object)rs.getDate(2));
            Assert.assertEquals((Object)TruncateFunctionIT.toTimestamp("1970-01-20 01:02:40.000"), (Object)rs.getTimestamp(3));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)"00A323122312312", (Object)rs.getString(1));
            Assert.assertEquals((Object)new Date(2419200000L), (Object)rs.getDate(2));
            Assert.assertEquals((Object)TruncateFunctionIT.toTimestamp("1970-01-30 01:30:20.000"), (Object)rs.getTimestamp(3));
            Assert.assertFalse((boolean)rs.next());
        }
    }
}

