/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.phoenix.end2end.ParallelStatsEnabledIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={ParallelStatsEnabledTest.class})
@RunWith(value=Parameterized.class)
public class TransactionalViewIT
extends ParallelStatsEnabledIT {
    private String fullTableName;
    private String fullViewName;
    private final String transactionProvider;

    public TransactionalViewIT(String transactionProvider) {
        this.transactionProvider = transactionProvider;
    }

    @Parameterized.Parameters(name="TransactionalViewIT_transactionProvider={0}")
    public static synchronized Collection<Object[]> data() {
        return Arrays.asList(new Object[][]{{"OMID"}});
    }

    @Before
    public void generateTableNames() {
        String schemaName = "S";
        String tableName = "T_" + TransactionalViewIT.generateUniqueName();
        this.fullTableName = SchemaUtil.getTableName((String)schemaName, (String)tableName);
        String viewName = "V_" + TransactionalViewIT.generateUniqueName();
        this.fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
    }

    @Test
    public void testReadOwnWritesWithStats() throws Exception {
        try (Connection conn1 = DriverManager.getConnection(TransactionalViewIT.getUrl());
             Connection conn2 = DriverManager.getConnection(TransactionalViewIT.getUrl());){
            String ddl = "CREATE TABLE " + this.fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'";
            conn1.createStatement().execute(ddl);
            ddl = "CREATE VIEW " + this.fullViewName + " (v2 VARCHAR) AS SELECT * FROM " + this.fullTableName + " where k>5";
            conn1.createStatement().execute(ddl);
            for (int i = 0; i < 10; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + this.fullTableName + " VALUES(" + i + ")");
            }
            int count = 0;
            ResultSet rs = conn1.createStatement().executeQuery("SELECT k FROM " + this.fullTableName);
            while (rs.next()) {
                Assert.assertEquals((long)count++, (long)rs.getInt(1));
            }
            Assert.assertEquals((long)10L, (long)count);
            count = 0;
            rs = conn1.createStatement().executeQuery("SELECT k FROM " + this.fullViewName);
            while (rs.next()) {
                Assert.assertEquals((long)(6 + count++), (long)rs.getInt(1));
            }
            Assert.assertEquals((long)4L, (long)count);
            TestUtil.analyzeTable(conn2, this.fullViewName, true);
            List<KeyRange> splits = TestUtil.getAllSplits(conn2, this.fullViewName);
            Assert.assertEquals((long)4L, (long)splits.size());
        }
    }

    @Test
    public void testInvalidRowsWithStats() throws Exception {
        try (Connection conn1 = DriverManager.getConnection(TransactionalViewIT.getUrl());
             Connection conn2 = DriverManager.getConnection(TransactionalViewIT.getUrl());){
            String ddl = "CREATE TABLE " + this.fullTableName + " (k INTEGER NOT NULL PRIMARY KEY, v1 DATE) TRANSACTIONAL=true,TRANSACTION_PROVIDER='" + this.transactionProvider + "'";
            conn1.createStatement().execute(ddl);
            ddl = "CREATE VIEW " + this.fullViewName + " (v2 VARCHAR) AS SELECT * FROM " + this.fullTableName + " where k>5";
            conn1.createStatement().execute(ddl);
            for (int i = 0; i < 10; ++i) {
                conn1.createStatement().execute("UPSERT INTO " + this.fullTableName + " VALUES(" + i + ")");
            }
            int count = 0;
            ResultSet rs = conn1.createStatement().executeQuery("SELECT k FROM " + this.fullTableName);
            while (rs.next()) {
                Assert.assertEquals((long)count++, (long)rs.getInt(1));
            }
            Assert.assertEquals((long)10L, (long)count);
            count = 0;
            rs = conn1.createStatement().executeQuery("SELECT k FROM " + this.fullViewName);
            while (rs.next()) {
                Assert.assertEquals((long)(6 + count++), (long)rs.getInt(1));
            }
            Assert.assertEquals((long)4L, (long)count);
            TestUtil.analyzeTable(conn2, this.fullViewName, true);
            List<KeyRange> splits = TestUtil.getAllSplits(conn2, this.fullViewName);
            Assert.assertEquals((long)4L, (long)splits.size());
        }
    }
}

