/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Locale;
import org.apache.phoenix.end2end.ParallelStatsDisabledIT;
import org.apache.phoenix.end2end.ParallelStatsDisabledTest;
import org.apache.phoenix.schema.types.PDecimal;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsDisabledTest.class})
public class ToNumberFunctionIT
extends ParallelStatsDisabledIT {
    private static Locale saveLocale;
    public static final String TO_NUMBER_TABLE_NAME;
    public static final String TO_NUMBER_TABLE_DDL;
    private static Date row1Date;
    private static Date row2Date;
    private static Date row3Date;
    private static Time row1Time;
    private static Time row2Time;
    private static Time row3Time;
    private static Timestamp row1Timestamp;
    private static Timestamp row2Timestamp;
    private static Timestamp row3Timestamp;

    @BeforeClass
    public static synchronized void setUpBeforeClass() throws Exception {
        saveLocale = Locale.getDefault();
        Locale.setDefault(Locale.US);
        ToNumberFunctionIT.initTable();
    }

    @AfterClass
    public static synchronized void tearDownAfterClass() {
        Locale.setDefault(saveLocale);
    }

    public static void initTable() throws Exception {
        ToNumberFunctionIT.createTestTable(ToNumberFunctionIT.getUrl(), TO_NUMBER_TABLE_DDL, null, null);
        try (Connection conn = DriverManager.getConnection(url);){
            conn.setAutoCommit(false);
            PreparedStatement stmt = conn.prepareStatement("upsert into " + TO_NUMBER_TABLE_NAME + "    (a_id,     a_string,    b_string,    a_date,    a_time,    a_timestamp)VALUES (?, ?, ?, ?, ?, ?)");
            stmt.setInt(1, 1);
            stmt.setString(2, "   1");
            stmt.setString(3, "   1");
            row1Date = new Date(System.currentTimeMillis() - 1000L);
            row1Time = new Time(System.currentTimeMillis() - 1000L);
            row1Timestamp = new Timestamp(System.currentTimeMillis() + 10000L);
            stmt.setDate(4, row1Date);
            stmt.setTime(5, row1Time);
            stmt.setTimestamp(6, row1Timestamp);
            stmt.execute();
            stmt.setInt(1, 2);
            stmt.setString(2, " 2.2");
            stmt.setString(3, " 2.2");
            row2Date = new Date(System.currentTimeMillis() - 10000L);
            row2Time = new Time(System.currentTimeMillis() - 1234L);
            row2Timestamp = new Timestamp(System.currentTimeMillis() + 1234567L);
            stmt.setDate(4, row2Date);
            stmt.setTime(5, row2Time);
            stmt.setTimestamp(6, row2Timestamp);
            stmt.execute();
            stmt.setInt(1, 3);
            stmt.setString(2, "$3.3");
            stmt.setString(3, "$3.3");
            row3Date = new Date(System.currentTimeMillis() - 100L);
            row3Time = new Time(System.currentTimeMillis() - 789L);
            row3Timestamp = new Timestamp(System.currentTimeMillis() + 78901L);
            stmt.setDate(4, row3Date);
            stmt.setTime(5, row3Time);
            stmt.setTimestamp(6, row3Timestamp);
            stmt.execute();
            conn.commit();
        }
    }

    @Test
    public void testKeyFilterWithIntegerValue() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_string) = 1";
        int expectedId = 1;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testKeyFilterWithDoubleValue() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_string) = 2.2";
        int expectedId = 2;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testNonKeyFilterWithIntegerValue() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(b_string) = 1";
        int expectedId = 1;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testNonKeyFilterWithDoubleValue() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(b_string) = 2.2";
        int expectedId = 2;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testKeyProjectionWithIntegerValue() throws Exception {
        String query = "select to_number(a_string) from " + TO_NUMBER_TABLE_NAME + " where a_id = 1";
        int expectedIntValue = 1;
        this.runOneRowQueryTest(query, expectedIntValue);
    }

    @Test
    public void testKeyProjectionWithDecimalValue() throws Exception {
        String query = "select to_number(a_string) from " + TO_NUMBER_TABLE_NAME + " where a_id = 2";
        BigDecimal expectedDecimalValue = (BigDecimal)PDecimal.INSTANCE.toObject("2.2");
        this.runOneRowQueryTest(query, expectedDecimalValue);
    }

    @Test
    public void testNonKeyProjectionWithIntegerValue() throws Exception {
        String query = "select to_number(b_string) from " + TO_NUMBER_TABLE_NAME + " where a_id = 1";
        int expectedIntValue = 1;
        this.runOneRowQueryTest(query, expectedIntValue);
    }

    @Test
    public void testNonKeyProjectionWithDecimalValue() throws Exception {
        String query = "select to_number(b_string) from " + TO_NUMBER_TABLE_NAME + " where a_id = 2";
        BigDecimal expectedDecimalValue = (BigDecimal)PDecimal.INSTANCE.toObject("2.2");
        this.runOneRowQueryTest(query, expectedDecimalValue);
    }

    @Test
    public void testKeyFilterWithPatternParam() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_string, '\u00a4###.####') = 3.3";
        int expectedId = 3;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testNonKeyFilterWithPatternParam() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(b_string, '\u00a4#.#') = 3.3";
        int expectedId = 3;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testDateFilter() throws Exception {
        String pattern = "yyyyMMddHHmmssZ";
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_date, '" + pattern + "') = " + row1Date.getTime();
        int expectedId = 1;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testTimeFilter() throws Exception {
        String pattern = "HH:mm:ss z";
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_time, '" + pattern + "') = " + row1Time.getTime();
        int expectedId = 1;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testDateFilterWithoutPattern() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_date) = " + row2Date.getTime();
        int expectedId = 2;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testTimeFilterWithoutPattern() throws Exception {
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_time) = " + row2Time.getTime();
        int expectedId = 2;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testTimeStampFilter() throws Exception {
        String pattern = "yyMMddHHmmssZ";
        String query = "SELECT a_id FROM " + TO_NUMBER_TABLE_NAME + " WHERE to_number(a_timestamp, '" + pattern + "') = " + row1Timestamp.getTime();
        int expectedId = 1;
        this.runOneRowQueryTest(query, expectedId);
    }

    @Test
    public void testDateProjection() throws Exception {
        String query = "select to_number(a_date) from " + TO_NUMBER_TABLE_NAME + " where a_id = 1";
        BigDecimal expectedDecimalValue = new BigDecimal(row1Date.getTime());
        this.runOneRowQueryTest(query, expectedDecimalValue);
    }

    @Test
    public void testTimeProjection() throws Exception {
        String query = "select to_number(a_time) from " + TO_NUMBER_TABLE_NAME + " where a_id = 2";
        BigDecimal expectedDecimalValue = new BigDecimal(row2Time.getTime());
        this.runOneRowQueryTest(query, expectedDecimalValue);
    }

    @Test
    public void testTimeStampProjection() throws Exception {
        String query = "select to_number(a_timestamp) from " + TO_NUMBER_TABLE_NAME + " where a_id = 3";
        BigDecimal expectedDecimalValue = new BigDecimal(row3Timestamp.getTime());
        this.runOneRowQueryTest(query, expectedDecimalValue);
    }

    private void runOneRowQueryTest(String oneRowQuery, BigDecimal expectedDecimalValue) throws Exception {
        this.runOneRowQueryTest(oneRowQuery, false, null, expectedDecimalValue);
    }

    private void runOneRowQueryTest(String oneRowQuery, int expectedIntValue) throws Exception {
        this.runOneRowQueryTest(oneRowQuery, true, expectedIntValue, null);
    }

    private void runOneRowQueryTest(String oneRowQuery, boolean isIntegerColumn, Integer expectedIntValue, BigDecimal expectedDecimalValue) throws Exception {
        try (Connection conn = DriverManager.getConnection(url);){
            PreparedStatement statement = conn.prepareStatement(oneRowQuery);
            ResultSet rs = statement.executeQuery();
            Assert.assertTrue((boolean)rs.next());
            if (isIntegerColumn) {
                Assert.assertEquals((long)expectedIntValue.intValue(), (long)rs.getInt(1));
            } else {
                Assert.assertTrue((expectedDecimalValue == rs.getBigDecimal(1) || expectedDecimalValue != null && expectedDecimalValue.compareTo(rs.getBigDecimal(1)) == 0 ? 1 : 0) != 0);
            }
            Assert.assertFalse((boolean)rs.next());
        }
    }

    static {
        TO_NUMBER_TABLE_NAME = ToNumberFunctionIT.generateUniqueName();
        TO_NUMBER_TABLE_DDL = "create table " + TO_NUMBER_TABLE_NAME + "(a_id integer not null, \na_string char(4) not null, \nb_string char(4), \na_date date, \na_time date, \na_timestamp timestamp \nCONSTRAINT my_pk PRIMARY KEY (a_id, a_string))";
    }
}

