/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.end2end;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.phoenix.coprocessor.TaskRegionObserver;
import org.apache.phoenix.end2end.BaseTenantSpecificTablesIT;
import org.apache.phoenix.end2end.ParallelStatsEnabledTest;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.schema.ColumnAlreadyExistsException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableAlreadyExistsException;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.PropertiesUtil;
import org.apache.phoenix.util.QueryUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.StringUtil;
import org.apache.phoenix.util.TestUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ParallelStatsEnabledTest.class})
public class TenantSpecificTablesDDLIT
extends BaseTenantSpecificTablesIT {
    @Test
    public void testCreateTenantSpecificTable() throws Exception {
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES));
        Admin admin = conn.unwrap(PhoenixConnection.class).getQueryServices().getAdmin();
        Assert.assertEquals((long)0L, (long)admin.listTableDescriptors(Pattern.compile(this.TENANT_TABLE_NAME)).size());
    }

    @Test
    public void testCreateTenantTableTwice() throws Exception {
        try {
            Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
            Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            conn.createStatement().execute(this.TENANT_TABLE_DDL);
            Assert.fail();
        }
        catch (TableAlreadyExistsException tableAlreadyExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateTenantViewFromNonMultiTenant() throws Exception {
        String tableName = TenantSpecificTablesDDLIT.generateUniqueName();
        TenantSpecificTablesDDLIT.createTestTable(TenantSpecificTablesDDLIT.getUrl(), "CREATE TABLE " + tableName + " (K VARCHAR PRIMARY KEY)");
        try {
            String viewName = TenantSpecificTablesDDLIT.generateUniqueName();
            TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + viewName + " (COL VARCHAR) AS SELECT * FROM " + tableName);
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testAlteringMultiTenancyForTableWithViewsNotAllowed() throws Exception {
        String viewName;
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        String multiTenantTable = "MT_" + TenantSpecificTablesDDLIT.generateUniqueName();
        String globalTable = "G_" + TenantSpecificTablesDDLIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            String ddl = "CREATE TABLE " + multiTenantTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) MULTI_TENANT = true ";
            conn.createStatement().execute(ddl);
            ddl = "CREATE TABLE " + globalTable + " (TENANT_ID VARCHAR NOT NULL, PK1 VARCHAR NOT NULL, V1 VARCHAR, V2 VARCHAR, V3 VARCHAR CONSTRAINT NAME_PK PRIMARY KEY(TENANT_ID, PK1)) ";
            conn.createStatement().execute(ddl);
        }
        String t1 = TenantSpecificTablesDDLIT.generateUniqueName();
        props.setProperty("TenantId", t1);
        try (Connection tenantConn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            viewName = "V_" + TenantSpecificTablesDDLIT.generateUniqueName();
            String viewDDL = "CREATE VIEW " + viewName + " AS SELECT * FROM " + multiTenantTable;
            tenantConn.createStatement().execute(viewDDL);
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        var6_6 = null;
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            viewName = "V_" + TenantSpecificTablesDDLIT.generateUniqueName();
            conn.createStatement().execute("CREATE VIEW " + viewName + " AS SELECT * FROM " + globalTable);
        }
        catch (Throwable viewName2) {
            var6_6 = viewName2;
            throw viewName2;
        }
        props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);
        var6_6 = null;
        try {
            try {
                conn.createStatement().execute("ALTER TABLE " + globalTable + " SET MULTI_TENANT = " + true);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
            try {
                conn.createStatement().execute("ALTER TABLE " + multiTenantTable + " SET MULTI_TENANT = " + false);
                Assert.fail();
            }
            catch (SQLException e) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_MUTATE_TABLE.getErrorCode(), (long)e.getErrorCode());
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    @Test(expected=TableNotFoundException.class)
    public void testDeletionOfParentTableFailsOnTenantSpecificConnection() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        props.setProperty("TenantId", this.TENANT_ID);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);
        conn.createStatement().execute("DROP TABLE " + this.PARENT_TABLE_NAME);
        conn.close();
    }

    public void testCreationOfParentTableFailsOnTenantSpecificConnection() throws Exception {
        try {
            TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE TABLE " + TenantSpecificTablesDDLIT.generateUniqueName() + "( \n                \"user\" VARCHAR ,\n                id INTEGER not null primary key desc\n                ) ");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((long)SQLExceptionCode.CANNOT_CREATE_TENANT_SPECIFIC_TABLE.getErrorCode(), (long)e.getErrorCode());
        }
    }

    @Test
    public void testTenantSpecificAndParentTablesMayBeInDifferentSchemas() throws SQLException {
        String fullTableName = "DIFFSCHEMA." + TenantSpecificTablesDDLIT.generateUniqueName();
        TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + fullTableName + " ( \n                tenant_col VARCHAR) AS SELECT * \n                FROM " + this.PARENT_TABLE_NAME + " WHERE tenant_type_id = 'aaa'");
        try {
            TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + fullTableName + "( \n                tenant_col VARCHAR) AS SELECT *\n                FROM DIFFSCHEMA." + this.PARENT_TABLE_NAME + " WHERE tenant_type_id = 'aaa'");
            Assert.fail();
        }
        catch (SQLException expected) {
            Assert.assertEquals((long)SQLExceptionCode.TABLE_UNDEFINED.getErrorCode(), (long)expected.getErrorCode());
        }
        String newDDL = "CREATE TABLE DIFFSCHEMA." + this.PARENT_TABLE_NAME + " ( \n                \"user\" VARCHAR ,\n                tenant_id VARCHAR(5) NOT NULL,\n                tenant_type_id VARCHAR(3) NOT NULL, \n                id INTEGER NOT NULL\n                CONSTRAINT pk PRIMARY KEY (tenant_id, tenant_type_id, id)) MULTI_TENANT=true";
        TenantSpecificTablesDDLIT.createTestTable(TenantSpecificTablesDDLIT.getUrl(), newDDL);
        TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + fullTableName + "( \n                tenant_col VARCHAR) AS SELECT *\n                FROM DIFFSCHEMA." + this.PARENT_TABLE_NAME + " WHERE tenant_type_id = 'aaa'");
    }

    @Test
    public void testTenantSpecificTableCanDeclarePK() throws SQLException {
        TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + TenantSpecificTablesDDLIT.generateUniqueName() + "( \n                tenant_col VARCHAR PRIMARY KEY) AS SELECT *\n                FROM " + this.PARENT_TABLE_NAME);
    }

    @Test(expected=ColumnAlreadyExistsException.class)
    public void testTenantSpecificTableCannotOverrideParentCol() throws SQLException {
        TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, "CREATE VIEW " + TenantSpecificTablesDDLIT.generateUniqueName() + " ( \n                \"user\" INTEGER) AS SELECT *\n                FROM " + this.PARENT_TABLE_NAME);
    }

    @Test
    public void testBaseTableWrongFormatWithTenantTypeId() throws Exception {
        try {
            TenantSpecificTablesDDLIT.createTestTable(TenantSpecificTablesDDLIT.getUrl(), "CREATE TABLE " + TenantSpecificTablesDDLIT.generateUniqueName() + "(TENANT_ID VARCHAR NOT NULL PRIMARY KEY, ID VARCHAR, A INTEGER) MULTI_TENANT=true");
            Assert.fail();
        }
        catch (SQLException expected) {
            Assert.assertEquals((long)SQLExceptionCode.INSUFFICIENT_MULTI_TENANT_COLUMNS.getErrorCode(), (long)expected.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddDropColumn() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        conn.setAutoCommit(true);
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);){
            conn.createStatement().execute("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col) values (1, 'Viva Las Vegas')");
            conn.createStatement().execute("alter view " + this.TENANT_TABLE_NAME + " add tenant_col2 char(1) null");
            conn.createStatement().execute("upsert into " + this.TENANT_TABLE_NAME + " (id, tenant_col2) values (2, 'a')");
            ResultSet rs = conn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME);
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            rs = conn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME + " where tenant_col2 = 'a'");
            rs.next();
            Assert.assertEquals((long)1L, (long)rs.getInt(1));
            conn.createStatement().execute("alter view " + this.TENANT_TABLE_NAME + " drop column tenant_col");
            rs = conn.createStatement().executeQuery("select count(*) from " + this.TENANT_TABLE_NAME + "");
            rs.next();
            Assert.assertEquals((long)2L, (long)rs.getInt(1));
            try {
                rs = conn.createStatement().executeQuery("select tenant_col from " + this.TENANT_TABLE_NAME);
                Assert.fail();
            }
            catch (ColumnNotFoundException columnNotFoundException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDropOfPKInTenantTablesNotAllowed() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);){
            try {
                conn.createStatement().execute("alter table " + this.TENANT_TABLE_NAME + " drop column id");
                Assert.fail();
            }
            catch (SQLException expected) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_PK.getErrorCode(), (long)expected.getErrorCode());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testColumnMutationInParentTableWithExistingTenantTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            try {
                conn.createStatement().execute("alter table " + this.PARENT_TABLE_NAME + " drop column id");
                Assert.fail();
            }
            catch (SQLException expected) {
                Assert.assertEquals((long)SQLExceptionCode.CANNOT_DROP_PK.getErrorCode(), (long)expected.getErrorCode());
            }
            try {
                conn.createStatement().execute("alter table " + this.PARENT_TABLE_NAME + " drop column \"user\"");
            }
            catch (SQLException expected) {
                Assert.fail((String)"We should be able to drop a non pk base table column");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDisallowDropParentTableWithExistingTenantTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            conn.createStatement().executeUpdate("drop table " + this.PARENT_TABLE_NAME);
            Assert.fail((String)"Should not have been allowed to drop a parent table to which tenant-specific tables still point.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllowDropParentTableWithCascadeAndSingleTenantTable() throws Exception {
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);
        Connection connTenant = null;
        try {
            conn.createStatement().executeUpdate("DROP TABLE " + this.PARENT_TABLE_NAME + " CASCADE");
            connTenant = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            this.validateTenantViewIsDropped(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (connTenant != null) {
                connTenant.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllDropParentTableWithCascadeWithMultipleTenantTablesAndIndexes() throws Exception {
        String tenantTable2 = "V_" + TenantSpecificTablesDDLIT.generateUniqueName();
        TenantSpecificTablesDDLIT.createTestTable(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL2, this.TENANT_TABLE_DDL.replace(this.TENANT_TABLE_NAME, tenantTable2));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = null;
        Connection connTenant1 = null;
        Connection connTenant2 = null;
        try {
            List<String> sortedCatalogs = Arrays.asList(this.TENANT_ID, this.TENANT_ID2);
            Collections.sort(sortedCatalogs);
            conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID, (Object)rs.getString("TABLE_CAT"));
            this.assertTableMetaData(rs, null, this.TENANT_TABLE_NAME, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)tenantTable2), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID2, (Object)rs.getString("TABLE_CAT"));
            this.assertTableMetaData(rs, null, tenantTable2, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID, (Object)rs.getString("TABLE_CAT"));
            this.assertTableMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
            conn.createStatement().executeUpdate("DROP TABLE " + this.PARENT_TABLE_NAME + " CASCADE");
            TaskRegionObserver.SelfHealingTask task = new TaskRegionObserver.SelfHealingTask(TaskRegionEnvironment, 1800000L);
            task.run();
            connTenant1 = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
            this.validateTenantViewIsDropped(connTenant1);
            connTenant2 = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL2, props);
            this.validateTenantViewIsDropped(connTenant2);
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)tenantTable2), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID, (Object)rs.getString("TABLE_CAT"));
            this.assertTableMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (conn != null) {
                conn.close();
            }
            if (connTenant1 != null) {
                connTenant1.close();
            }
            if (connTenant2 != null) {
                connTenant2.close();
            }
        }
    }

    private void validateTenantViewIsDropped(Connection connTenant) throws SQLException {
        try {
            connTenant.unwrap(PhoenixConnection.class).getTableNoCache(this.TENANT_TABLE_NAME);
            Assert.fail((String)("Tenant specific view " + this.TENANT_TABLE_NAME + " should have been dropped when parent was dropped"));
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        try {
            String ddl = "DROP VIEW " + this.TENANT_TABLE_NAME;
            connTenant.createStatement().execute(ddl);
            Assert.fail((String)("Tenant specific view " + this.TENANT_TABLE_NAME + " should have been dropped when parent was dropped"));
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testShowTablesMultiTenant() throws Exception {
        ResultSet rs;
        HashSet<String> tables;
        String tenantId2 = "T_" + TenantSpecificTablesDDLIT.generateUniqueName();
        String secondTenantConnectionURL = this.PHOENIX_JDBC_TENANT_SPECIFIC_URL.replace(this.TENANT_ID, tenantId2);
        String tenantTable2 = "V_" + TenantSpecificTablesDDLIT.generateUniqueName();
        TenantSpecificTablesDDLIT.createTestTable(secondTenantConnectionURL, this.TENANT_TABLE_DDL.replace(this.TENANT_TABLE_NAME, tenantTable2));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);){
            tables = new HashSet<String>();
            rs = conn.prepareStatement("show tables").executeQuery();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            Assert.assertTrue((boolean)tables.contains(this.PARENT_TABLE_NAME));
            Assert.assertTrue((boolean)tables.contains(this.TENANT_TABLE_NAME));
            Assert.assertTrue((boolean)tables.contains(tenantTable2));
        }
        conn = DriverManager.getConnection(secondTenantConnectionURL, props);
        var6_6 = null;
        try {
            tables = new HashSet();
            rs = conn.prepareStatement("show tables").executeQuery();
            while (rs.next()) {
                tables.add(rs.getString("TABLE_NAME"));
            }
            Assert.assertTrue((boolean)tables.contains(this.PARENT_TABLE_NAME));
            Assert.assertFalse((boolean)tables.contains(this.TENANT_TABLE_NAME));
            Assert.assertTrue((boolean)tables.contains(tenantTable2));
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (conn != null) {
                if (var6_6 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTableMetadataScan() throws Exception {
        ResultSet rs;
        DatabaseMetaData meta;
        String tenantId2 = "T_" + TenantSpecificTablesDDLIT.generateUniqueName();
        String secondTenantConnectionURL = this.PHOENIX_JDBC_TENANT_SPECIFIC_URL.replace(this.TENANT_ID, tenantId2);
        String tenantTable2 = "V_" + TenantSpecificTablesDDLIT.generateUniqueName();
        TenantSpecificTablesDDLIT.createTestTable(secondTenantConnectionURL, this.TENANT_TABLE_DDL.replace(this.TENANT_TABLE_NAME, tenantTable2));
        Properties props = PropertiesUtil.deepCopy((Properties)TestUtil.TEST_PROPERTIES);
        Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl(), props);
        try {
            meta = conn.getMetaData();
            rs = meta.getTables("", "", StringUtil.escapeLike((String)this.PARENT_TABLE_NAME), new String[]{PTableType.TABLE.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.PARENT_TABLE_NAME, PTableType.TABLE);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables("", "", StringUtil.escapeLike((String)this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID), new String[]{PTableType.TABLE.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID, PTableType.TABLE);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getColumns("", null, null, null);
            while (rs.next()) {
                Assert.assertNotEquals((Object)this.TENANT_TABLE_NAME, (Object)rs.getString("TABLE_NAME"));
                Assert.assertNotEquals((Object)tenantTable2, (Object)rs.getString("TABLE_NAME"));
            }
            List<String> sortedTableNames = Arrays.asList(this.TENANT_TABLE_NAME, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID);
            Collections.sort(sortedTableNames);
            List<String> sortedParentNames = sortedTableNames.get(0).equals(this.TENANT_TABLE_NAME) ? Arrays.asList(this.PARENT_TABLE_NAME, this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID) : Arrays.asList(this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID, this.PARENT_TABLE_NAME);
            rs = meta.getSuperTables(this.TENANT_ID, null, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)sortedTableNames.get(0), (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)sortedParentNames.get(0), (Object)rs.getString("SUPERTABLE_NAME"));
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)this.TENANT_ID, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)sortedTableNames.get(1), (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)sortedParentNames.get(1), (Object)rs.getString("SUPERTABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getSuperTables(tenantId2, null, null);
            Assert.assertTrue((boolean)rs.next());
            Assert.assertEquals((Object)tenantId2, (Object)rs.getString("TABLE_CAT"));
            Assert.assertEquals((Object)tenantTable2, (Object)rs.getString("TABLE_NAME"));
            Assert.assertEquals((Object)this.PARENT_TABLE_NAME, (Object)rs.getString("SUPERTABLE_NAME"));
            Assert.assertFalse((boolean)rs.next());
            HashSet<String> sortedCatalogs = new HashSet<String>(Arrays.asList(this.TENANT_ID, tenantId2));
            rs = conn.getMetaData().getCatalogs();
            while (rs.next()) {
                sortedCatalogs.remove(rs.getString("TABLE_CAT"));
            }
            Assert.assertTrue((String)"Should have found both tenant IDs", (boolean)sortedCatalogs.isEmpty());
        }
        finally {
            props.clear();
            conn.close();
        }
        conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL, props);
        try {
            meta = conn.getMetaData();
            rs = meta.getTables("", "SYSTEM", null, new String[]{PTableType.SYSTEM.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "CATALOG", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "CDC_STREAM", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "CDC_STREAM_STATUS", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "CHILD_LINK", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "FUNCTION", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "LOG", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "MUTEX", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "SEQUENCE", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "STATS", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "TASK", PTableType.SYSTEM);
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, "SYSTEM", "TRANSFORM", PTableType.SYSTEM);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)tenantTable2), new String[]{PTableType.TABLE.getValue().getString()});
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.PARENT_TABLE_NAME), new String[]{PTableType.TABLE.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.PARENT_TABLE_NAME, PTableType.TABLE);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID), new String[]{PTableType.TABLE.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.PARENT_TABLE_NAME_NO_TENANT_TYPE_ID, PTableType.TABLE);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.TENANT_TABLE_NAME, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getTables(null, "", StringUtil.escapeLike((String)this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID), new String[]{PTableType.VIEW.getValue().getString()});
            Assert.assertTrue((boolean)rs.next());
            this.assertTableMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, PTableType.VIEW);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getColumns(null, null, StringUtil.escapeLike((String)this.TENANT_TABLE_NAME), null);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME, "\"user\"", 1);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME, "tenant_type_id", 2);
            Assert.assertEquals((long)1L, (long)rs.getShort("KEY_SEQ"));
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME, "id", 3);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME, "tenant_col", 4);
            Assert.assertFalse((boolean)rs.next());
            rs = meta.getColumns(null, null, StringUtil.escapeLike((String)this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID), null);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, "\"user\"", 1);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, "id", 2);
            Assert.assertTrue((boolean)rs.next());
            this.assertColumnMetaData(rs, null, this.TENANT_TABLE_NAME_NO_TENANT_TYPE_ID, "tenant_col", 3);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            conn.close();
        }
    }

    @Test
    public void testIndexHintWithTenantView() throws Exception {
        Throwable throwable;
        Statement stmt;
        String schemaName = TenantSpecificTablesDDLIT.generateUniqueName();
        String dataTableName = TenantSpecificTablesDDLIT.generateUniqueName();
        String fullDataTableName = SchemaUtil.getTableName((String)schemaName, (String)dataTableName);
        String viewName = TenantSpecificTablesDDLIT.generateUniqueName();
        String fullViewName = SchemaUtil.getTableName((String)schemaName, (String)viewName);
        String viewIndexName = TenantSpecificTablesDDLIT.generateUniqueName();
        try (Connection conn = DriverManager.getConnection(TenantSpecificTablesDDLIT.getUrl());){
            stmt = conn.createStatement();
            throwable = null;
            try {
                String createDataTable = "create table " + fullDataTableName + " (orgid varchar(10) not null, id1 varchar(10) not null, id2 varchar(10) not null, id3 integer not null, val1 varchar(10), val2 varchar(10) CONSTRAINT PK PRIMARY KEY (orgid, id1, id2, id3)) MULTI_TENANT=true";
                stmt.execute(createDataTable);
                stmt.execute("create view " + fullViewName + " as select * from " + fullDataTableName);
                stmt.execute("create index " + viewIndexName + " on " + fullViewName + "(id3, id2, id1) include (val1, val2)");
            }
            catch (Throwable createDataTable) {
                throwable = createDataTable;
                throw createDataTable;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable createDataTable) {
                            throwable.addSuppressed(createDataTable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        conn = DriverManager.getConnection(this.PHOENIX_JDBC_TENANT_SPECIFIC_URL);
        var8_8 = null;
        try {
            stmt = conn.createStatement();
            throwable = null;
            try {
                String grandChildViewName = TenantSpecificTablesDDLIT.generateUniqueName();
                String fullGrandChildViewName = SchemaUtil.getTableName((String)schemaName, (String)grandChildViewName);
                stmt.execute("create view " + fullGrandChildViewName + " as select * from " + fullViewName);
                PhoenixConnection pconn = conn.unwrap(PhoenixConnection.class);
                pconn.getTableNoCache(pconn.getTenantId(), fullGrandChildViewName);
                stmt.execute("upsert into " + fullGrandChildViewName + " values ('a1', 'a2', 3, 'a4', 'a5')");
                conn.commit();
                stmt.execute("upsert into " + fullGrandChildViewName + " values ('b1', 'b2', 3, 'b4', 'b5')");
                conn.commit();
                String physicalViewIndexTableName = MetaDataUtil.getViewIndexPhysicalName((String)fullDataTableName);
                TableName viewIndexHBaseTable = TableName.valueOf((String)physicalViewIndexTableName);
                TestUtil.assertRawRowCount(conn, viewIndexHBaseTable, 2);
                String sql = "SELECT /*+ INDEX(" + fullGrandChildViewName + " " + viewIndexName + ")*/ val2, id2, val1, id3, id1 FROM " + fullGrandChildViewName + " WHERE id2 = 'a2' AND (id1 = 'a1' OR id1 = 'b1') AND id3 = 3";
                ResultSet rs = stmt.executeQuery("EXPLAIN " + sql);
                String actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertTrue((boolean)actualQueryPlan.contains("1-WAY POINT LOOKUP ON 2 KEYS OVER " + physicalViewIndexTableName));
                rs = stmt.executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertFalse((boolean)rs.next());
                sql = "SELECT val2, id2, val1, id3, id1 FROM " + fullGrandChildViewName + " WHERE id2 = 'a2' AND (id1 = 'a1' OR id1 = 'b1') AND id3 = 3";
                rs = stmt.executeQuery("EXPLAIN " + sql);
                actualQueryPlan = QueryUtil.getExplainPlan((ResultSet)rs);
                Assert.assertTrue((boolean)actualQueryPlan.contains("1-WAY POINT LOOKUP ON 2 KEYS OVER " + fullDataTableName));
                rs = stmt.executeQuery(sql);
                Assert.assertTrue((boolean)rs.next());
                Assert.assertFalse((boolean)rs.next());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            var8_8 = throwable4;
            throw throwable4;
        }
        finally {
            if (conn != null) {
                if (var8_8 != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable5) {
                        var8_8.addSuppressed(throwable5);
                    }
                } else {
                    conn.close();
                }
            }
        }
    }

    private void assertTableMetaData(ResultSet rs, String schema, String table, PTableType tableType) throws SQLException {
        Assert.assertEquals((Object)schema, (Object)rs.getString("TABLE_SCHEM"));
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)tableType.toString(), (Object)rs.getString("TABLE_TYPE"));
    }

    private void assertColumnMetaData(ResultSet rs, String schema, String table, String column) throws SQLException {
        Assert.assertEquals((Object)schema, (Object)rs.getString("TABLE_SCHEM"));
        Assert.assertEquals((Object)table, (Object)rs.getString("TABLE_NAME"));
        Assert.assertEquals((Object)SchemaUtil.normalizeIdentifier((String)column), (Object)rs.getString("COLUMN_NAME"));
    }

    private void assertColumnMetaData(ResultSet rs, String schema, String table, String column, int ordinalPosition) throws SQLException {
        this.assertColumnMetaData(rs, schema, table, column);
        Assert.assertEquals((long)ordinalPosition, (long)rs.getInt("ORDINAL_POSITION"));
    }
}

